// =====================================================================
//  $Id: TUnaliasCommand.cc,v 1.3 2003/10/06 17:02:37 goiwai Exp $
//  $Name: CLDAQ-1-12-00 $
//  $Log: TUnaliasCommand.cc,v $
//  Revision 1.3  2003/10/06 17:02:37  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:17:33  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TUnaliasCommand.hh"
#include "TRunManager.hh"
#include "TUserInterface.hh"
#include "TCommandSpecified.hh"

static const Tstring _name = "unalias";
static const Tstring _desc = "removes all aliases whose names match pattern.\n`unalias *' thus removes all aliases.";

TUnaliasCommand::TUnaliasCommand( TRunManager* manager )
  : TCommand( manager, _name, _desc )
{;}

TUnaliasCommand::~TUnaliasCommand()
{;}

Tvoid TUnaliasCommand::Execute( const TstringList& arguments )
{
  if ( arguments.size() != 1 ) {
    ShowCommandDetail();
    return;
  }

  TUserInterface* ui = theRunManager -> GetUserInterface();

  if ( ui ) {
    TCommandTable& table = ui -> GetCommandTable();
    if ( arguments[ 0 ] == "*" ) {
      for ( Tint i = 0; i < table.GetSize(); i ++ ) {
	if ( table[ i ].IsAliasedCommand() ) {
	  table.RemoveCommand( i );
	}
      }
    } else {
      Tstring abspath = ui -> ModifyPath( arguments[ 0 ] );
      for ( Tint i = 0; i < table.GetSize(); i ++ ) {
	if ( table[ i ].IsAliasedCommand() && table[ i ].GetFullName() == abspath ) {
	  table.RemoveCommand( i );
	  return;
	}
      }
    }
  }
  return;
}
