// =====================================================================
//  $Id: Bt00EventViewCommand.cc,v 1.3 2003/10/06 16:28:14 goiwai Exp $
//  $Name: CLDAQ-1-13-00 $
//  $Log: Bt00EventViewCommand.cc,v $
//  Revision 1.3  2003/10/06 16:28:14  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:13:49  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TRunManager.hh"
#include "TUserInterface.hh"
#include "TOutputObjectFile.hh"
#include "TEnvironmentVariableTable.hh"

#include "Bt00EventViewCommand.hh"
#include "Bt00RunAction.hh"

static const Tstring _name = "/local/bt00view";
static const Tstring _desc = "view histogram(ADC/Scaler).";

Bt00EventViewCommand::Bt00EventViewCommand()
  : TCommand( _name, _desc )
{;}

Bt00EventViewCommand::~Bt00EventViewCommand()
{;}

Tvoid Bt00EventViewCommand::Execute( const TstringList& arguments )
{
  const TEnvironmentVariableTable& envtable = 
    theRunManager -> GetEnvironmentVariableTable();
  Tstring bindir = envtable.GetEnvironmentValue( "BT00_BIN_DIR" );
  Tstring comname = bindir + Tslash + "bt00view";

  TUserInterface* ui = theRunManager -> GetUserInterface();
  Bt00RunAction* action = (Bt00RunAction*)( theRunManager -> GetRunAction() );
  Tstring filename = action -> GetOutputFile() -> GetFileName();
  Tstring com = "/system/shell";
  TstringList args;
  args.push_back( comname );
  args.push_back( filename );
  args.push_back( "&" );

  ui -> ExecuteCommand( com, args );

  return;
}
