// =====================================================================
//  $Id: st00.cc,v 1.3 2003/10/06 16:28:17 goiwai Exp $
//  $Name: CLDAQ-1-13-00 $
//  $Log: st00.cc,v $
//  Revision 1.3  2003/10/06 16:28:17  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:15:52  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TRunManager.hh"
#include "TEventManager.hh"
#include "TTerminalUserInterface.hh"
#include "TCrate.hh"

#include "St00RunAction.hh"
#include "St00EventAction.hh"
#include "St00CrateDefinition.hh"
#include "St00ReadoutBookDefinition.hh"
#include "St00PureEventViewCommand.hh"
#include "St00MinusHocEventViewCommand.hh"
#include "St00DarkRmsViewCommand.hh"

int main( int argc, char** argv, char** envv )
{
  TRunManager* manager = new TRunManager( new TTerminalUserInterface() );
  manager -> GetEventManager() -> SetStackSize( 4 );
  manager -> GetEnvironmentVariableTable().SetEnvironment( "setenvrc" );
  manager -> SetRunAction( new St00RunAction() );
  manager -> SetEventAction( new St00EventAction() );
  manager -> SetCrateDefinition( new St00CrateDefinition() );
  manager -> SetReadoutBookDefinition( new St00ReadoutBookDefinition() );

  manager -> SetUserCommand( new St00PureEventViewCommand() );
  manager -> SetUserCommand( new St00MinusHocEventViewCommand() );
  manager -> SetUserCommand( new St00DarkRmsViewCommand() );

  manager -> SessionStart();

  delete manager;

  return 0;
}
