// =====================================================================
//  $Id: St01EventAction.cc,v 1.5 2004/03/04 15:11:55 goiwai Exp $
//  $Name: CLDAQ-1-13-00 $
//  $Log: St01EventAction.cc,v $
//  Revision 1.5  2004/03/04 15:11:55  goiwai
//  ۤȤɤؿ̾ѹˤȤʤǤ
//
//  Revision 1.4  2003/10/06 16:28:18  goiwai
//  *** empty log message ***
//
//  Revision 1.3  2003/07/30 16:16:11  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TRunManager.hh"
#include "TOutputObjectFile.hh"
#include "TDataRecord.hh"
#include "TDataSection.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"
#include "TCrate.hh"
#include "TReadoutBook.hh"
#include "TVmeMpx201aModule.hh"
#include "TVmeRpv130Module.hh"

#include "St01EventAction.hh"
#include "St01RunAction.hh"
#include "St01RunSummary.hh"

St01EventAction::St01EventAction()
{;}

St01EventAction::~St01EventAction()
{;}

TReadoutList* St01EventAction::WaitTrigger()
{
  TVmeMpx201aModule* mpx201a =
    (TVmeMpx201aModule*)( theCrate -> GetModule( "mpx201a" ) );
  TVmeRpv130Module* rpv130 =
    (TVmeRpv130Module*)( theCrate -> GetModule( "rpv130" ) );
  const TEnvironmentVariableTable& envtable = 
    theRunManager -> GetEnvironmentVariableTable();
  Tint veto = envtable.GetIntegerValue( "ST01_RPV130_OUT_VETO" );
  Tint open = envtable.GetIntegerValue( "ST01_RPV130_OUT_OPEN" );
  Tint t = envtable.GetIntegerValue( "ST01_EVENTLOOP_USLEEP" );

  Tbool trigger = Tfalse;

  do {
    if ( mpx201a -> IsMemoryBlockFull() ) {
      trigger = Ttrue;
    } else {
      usleep( t );
      continue;
    }
  } while ( trigger == Tfalse );

  rpv130 -> LevelUp( veto );
  rpv130 -> Pulse( open );

  //mpx201a -> SetBufferOrientation( 1 );
  return theReadoutBook -> GetReadoutList( "EVENT" );
}

Tvoid St01EventAction::AtFirst( TEvent& anEvent )
{
  TVmeMpx201aModule* mpx201a =
    (TVmeMpx201aModule*)( theCrate -> GetModule( "mpx201a" ) );
  TVmeRpv130Module* rpv130 =
    (TVmeRpv130Module*)( theCrate -> GetModule( "rpv130" ) );

  const TEnvironmentVariableTable& envtable = 
    theRunManager -> GetEnvironmentVariableTable();
  Tint veto = envtable.GetIntegerValue( "ST01_RPV130_OUT_VETO" );

  mpx201a -> EnableAcquisition();

  rpv130 -> LevelDown( veto );

  return;
}

Tvoid St01EventAction::AtLast( TEvent& anEvent )
{
  St01RunAction* action =
    (St01RunAction*)( TRunManager::GetRunManager() -> GetRunAction() );
  TOutputObjectFile* ofile = action -> GetOutputFile();

  TVmeMpx201aModule* mpx201a =
    (TVmeMpx201aModule*)( theCrate -> GetModule( "mpx201a" ) );
  TVmeRpv130Module* rpv130 =
    (TVmeRpv130Module*)( theCrate -> GetModule( "rpv130" ) );


  TDataRecord record = anEvent.GetDataRecord();
  ofile -> Write( record );

  fillEventInformation( record );

  theCrate -> Update( "event" );


  const TEnvironmentVariableTable& envtable = 
    theRunManager -> GetEnvironmentVariableTable();
  Tint stop = envtable.GetIntegerValue( "ST01_RPV130_OUT_STOP" );

  mpx201a -> NextEventProcedure();
  rpv130 -> Pulse( stop );
  return;
}

Tvoid St01EventAction::fillEventInformation( const TDataRecord& record )
{
  St01RunAction* action = (St01RunAction*)( theRunManager -> GetRunAction() );
  St01RunSummary* summary = action -> GetRunSummary();
  Tint nevent = summary -> GetNumberOfEvents();
  summary -> SetNumberOfEvents( ++ nevent );

  return;
}
