// =====================================================================
//  $Id: St02SinglePixelInterface.hh,v 1.4 2004/01/19 21:10:29 goiwai Exp $
//  $Name: CLDAQ-1-13-00 $
//  $Log: St02SinglePixelInterface.hh,v $
//  Revision 1.4  2004/01/19 21:10:29  goiwai
//  ץץåƬCLDAQ__ѹޤ.
//
//  Revision 1.3  2003/10/06 16:28:19  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:16:35  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#ifndef CLDAQ__ST02SINGLEPIXELINTERFACE_HH
#define CLDAQ__ST02SINGLEPIXELINTERFACE_HH

#include "Tglobals.h"
#include "St02SinglePixelList.hh"
#include "TDataMultiplicity.hh"

class St02BadChannelMap;

class St02SinglePixelInterface
{

  private:
    St02SinglePixelList theSinglePixelList;
    St02BadChannelMap* theBadChannelMap;

  public:
    St02SinglePixelInterface( const Tstring& filename );
    St02SinglePixelInterface( const Tstring& dark, const Tstring& source );
    ~St02SinglePixelInterface();

  public:
    const St02SinglePixelList& GetSinglePixelList() const;
    St02SinglePixelList& GetSinglePixelList();
    St02BadChannelMap* GetBadChannelMap() const;

  private:
    Tbool isThisOverThreshold( const TDataMultiplicity& map, Tint row, Tint col ) const;
    Tbool isThisSinglePixel( const TDataMultiplicity& map, Tint row, Tint col ) const;
    Tbool isThereOverThresholdAroundHere( const TDataMultiplicity& map, Tint row, Tint col ) const;
    Tbool isThereBadChannelAroundHere( Tint row, Tint col ) const;
    Tbool isThisBadChannel( Tint row, Tint col ) const;

};

inline const St02SinglePixelList& St02SinglePixelInterface::GetSinglePixelList() const
{
  return theSinglePixelList;
}

inline St02SinglePixelList& St02SinglePixelInterface::GetSinglePixelList()
{
  return theSinglePixelList;
}

inline St02BadChannelMap* St02SinglePixelInterface::GetBadChannelMap() const
{
  return theBadChannelMap;
}

#endif
