// ============================================================================
//  $Id: TRecordAssociation.hh,v 1.2 2004/03/07 10:30:27 goiwai Exp $
//  $Name: CLDAQ-1-13-00 $
//  $Log: TRecordAssociation.hh,v $
//  Revision 1.2  2004/03/07 10:30:27  goiwai
//  ROOTȤߤिΤޤʤޥᤳߤޤ
//  Ƥˤƴư櫓ǤϤޤ
//
//  Revision 1.1  2004/03/01 02:36:25  goiwai
//  RecordDisplayѤΥ饹֤ޤ.
//  ¢ˤʤäƤΤ˼ľäΤǤ,
//  ޤԽʬߤޤ.˽ƤȻפޤ.
//  DataRecord֥Ȥɽ뤿Υġ뷲ʤΤRecordDisplayȸ
//  Ǥޤ,¿ʬ˥ե饤ǤǤ.
//  饤ˤΤEventDisplay(Eventɽ)Ȥƥߥå
//  ޤ.
//
// ============================================================================
#ifdef __CLDAQ_ROOT_USE
#ifndef CLDAQ__TRECORDASSOCIATION_HH
#define CLDAQ__TRECORDASSOCIATION_HH

class TRecordDisplayCanvas;
class TH1D;

#include <TH1.h>
#include "Tglobals.h"

class TRecordAssociation
{

  private:
    Tstring theRecordID;
    Tstring theSectionID;
    Tstring theSegmentID;
    Tstring theElementID;
    Tint theNumberOfBins;
    Tdouble theMinimumX;
    Tdouble theMaximumX;
    TRecordDisplayCanvas* theCanvas;
    TH1D* theHistogram;
    Tbool theValidAssociation;

    //! ҥȥμȥ
    //! ե륫顼餤ϤäƤ⤤

  public:
    TRecordAssociation( const Tstring& recid = "",
                        const Tstring& secid = "",
                        const Tstring& segid = "",
                        const Tstring& eleid = "",
                        Tint nbin = -1,
                        Tdouble xmin = DBL_MAX,
                        Tdouble xmax = DBL_MIN,
                        TRecordDisplayCanvas* cv = 0,
                        TH1D* h = 0
                        );
    TRecordAssociation( const TRecordAssociation& right );
    ~TRecordAssociation();

  public:
    const TRecordAssociation& operator=( const TRecordAssociation& right );
    Tbool operator==( const TRecordAssociation& right ) const;
    Tbool operator!=( const TRecordAssociation& right ) const;

  public:
    friend Tostream& operator<<( Tostream& tos, const TRecordAssociation& right );

  public:
    const Tstring& GetRecordID() const;
    const Tstring& GetSectionID() const;
    const Tstring& GetSegmentID() const;
    const Tstring& GetElementID() const;
    Tint GetNumberOfBins() const;
    Tdouble GetMinimumX() const;
    Tdouble GetMaximumX() const;
    TRecordDisplayCanvas* GetCanvas() const;
    TH1D* GetHistogram() const;
    Tvoid SetRecordID( const Tstring& id );
    Tvoid SetSectionID( const Tstring& id );
    Tvoid SetSegmentID( const Tstring& id );
    Tvoid SetElementID( const Tstring& id );
    Tvoid SetNumberOfBins( Tint nbin );
    Tvoid SetMinimumX( Tdouble xmin );
    Tvoid SetMaximumX( Tdouble xmax );
    Tvoid SetCanvas( TRecordDisplayCanvas* cv );
    Tvoid SetHistogram( TH1D* h );
    Tbool IsValid() const;

  private:
    Tvoid checkValid();

#ifdef __CLDAQ_ROOT_DLL
    ClassDef(TRecordAssociation,0)
#endif

};

inline const Tstring& TRecordAssociation::GetRecordID() const
{
  return theRecordID;
}

inline const Tstring& TRecordAssociation::GetSectionID() const
{
  return theSectionID;
}

inline const Tstring& TRecordAssociation::GetSegmentID() const
{
  return theSegmentID;
}

inline const Tstring& TRecordAssociation::GetElementID() const
{
  return theElementID;
}

inline Tint TRecordAssociation::GetNumberOfBins() const
{
  return theNumberOfBins;
}

inline Tdouble TRecordAssociation::GetMinimumX() const
{
  return theMinimumX;
}

inline Tdouble TRecordAssociation::GetMaximumX() const
{
  return theMaximumX;
}

inline TRecordDisplayCanvas* TRecordAssociation::GetCanvas() const
{
  return theCanvas;
}

inline TH1D* TRecordAssociation::GetHistogram() const
{
  return theHistogram;
}

inline Tvoid TRecordAssociation::SetRecordID( const Tstring& id )
{
  theRecordID = id;
  checkValid();
  return;
}

inline Tvoid TRecordAssociation::SetSectionID( const Tstring& id )
{
  theSectionID = id;
  checkValid();
  return;
}

inline Tvoid TRecordAssociation::SetSegmentID( const Tstring& id )
{
  theSegmentID = id;
  checkValid();
  return;
}

inline Tvoid TRecordAssociation::SetElementID( const Tstring& id )
{
  theElementID = id;  
  checkValid();
  return;
}

inline Tvoid TRecordAssociation::SetNumberOfBins( Tint nbin )
{
  theNumberOfBins = nbin;
  checkValid();
  return;
}

inline Tvoid TRecordAssociation::SetMinimumX( Tdouble xmin )
{
  theMinimumX = xmin;
  checkValid();
  return;
}

inline Tvoid TRecordAssociation::SetMaximumX( Tdouble xmax )
{
  theMaximumX = xmax;
  checkValid();
  return;
}

inline Tvoid TRecordAssociation::SetCanvas( TRecordDisplayCanvas* cv )
{
  theCanvas = cv;
  checkValid();
  return;
}

inline Tvoid TRecordAssociation::SetHistogram( TH1D* h )
{
  theHistogram = h;
  checkValid();
  return;
}

inline Tbool TRecordAssociation::IsValid() const
{
  return theValidAssociation;
}

#endif
#endif
