// =====================================================================
/*!
//
//  \file TTerminalUserInterface.hh
//  \brief This file contains the TTerminalUserInterface class.
//  \author Go IWAI <goiwai@users.sourceforge.jp>
//
//  $Id: TTerminalUserInterface.hh,v 1.7 2004/03/07 10:30:31 goiwai Exp $
//  $Name: CLDAQ-1-13-00 $
//  $Log: TTerminalUserInterface.hh,v $
//  Revision 1.7  2004/03/07 10:30:31  goiwai
//  ROOTȤߤिΤޤʤޥᤳߤޤ
//  Ƥˤƴư櫓ǤϤޤ
//
//  Revision 1.6  2004/01/19 21:09:40  goiwai
//  ץץåƬCLDAQ__ѹޤ.
//
//  Revision 1.5  2003/11/03 08:35:12  goiwai
//  DoxygenѤΥȥȤ򤦤Ǥߤ򳫻Ϥޤ.
//
//  Revision 1.4  2003/10/06 17:02:40  goiwai
//  *** empty log message ***
//
//  Revision 1.3  2003/07/30 16:18:52  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
*/
// =====================================================================
#ifndef CLDAQ__TTERMINALUSERINTERFACE_HH
#define CLDAQ__TTERMINALUSERINTERFACE_HH

#include "Tglobals.h"
#include "TUserInterface.hh"


/*!
// \example
//
// If example code exists.
//
*/

/*!
// \class TTerminalUserInterface
// \brief This is the TTerminalUserInterface class.
// \author Go IWAI <goiwai@users.sourceforge.jp>
//
// The TTerminalUserInterface class detail description.
// Write it down ASAP!
//
// \todo None?
// \bug None?
// \ingroup InterfacesCategory
*/
class TTerminalUserInterface
  : public TUserInterface
{

  private:
    Tint theCommandHistoryIndex;
    Tint theCursorPosition;
    Tstring thePrompt;
    Tstring theAcceptString;
    Tstring theStringBuffer;
    Tstring theCommandBuffer;
    struct termios theTerminal;

  public:
    TTerminalUserInterface( const Tstring& prompt = Tprompt, 
                            const Tstring& history = Tproject + ".last" );
    ~TTerminalUserInterface();

  public:
    Tbool AcceptCommand();
    const Tstring& GetInputCommand();
    Tvoid NotFoundCommand( const Tstring& commandname ) const;

  public:
    Tint GetCommandHistoryIndex() const;
    Tint GetCursorPosition() const;
    const Tstring& GetPrompt() const;
    const Tstring& GetAcceptString() const;
    const Tstring& GetStringBuffer() const;
    const Tstring& GetCommandBuffer() const;
    Tvoid SetCursorPosition( Tint position );
    Tvoid SetPrompt( const Tstring& prompt );
    Tvoid SetAcceptString( const Tstring& accept );
    Tvoid SetStringBuffer( const Tstring& buffer );
    Tvoid SetCommandBuffer( const Tstring& buffer );
    Tvoid SetCommandHistoryIndex( Tint index );

  protected:
    const Tstring& readLine();
    Tvoid initializeCommandLine();
    Tvoid insertCharacter( Tchar cc );
    Tvoid backspaceCharacter();
    Tvoid deleteCharacter();
    Tvoid clearLine();
    Tvoid clearScreen();
    Tvoid clearAfterCursor();
    Tvoid forwardCursor();
    Tvoid backwardCursor();
    Tvoid moveCursorTop();
    Tvoid moveCursorEnd();
    Tvoid nextCommand();
    Tvoid previousCommand();
    Tvoid completeCommand();
    Tvoid complete();
    Tvoid complete( const Tstring& input );
    Tvoid complete( const TstringList& inputs );
    Tvoid completeDirectory();
    Tvoid completeDirectory( const Tstring& input );
    Tvoid cutCharacter();
    Tvoid pasteCharacter();
    Tvoid suspendTerminal() const;
    Tvoid setTerminalInputMode();
    Tvoid resetTerminal();
    Tbool isCursorEnd() const;
    Tbool isCursorTop() const;
    TstringList divide( const Tstring& input ) const;

#ifdef __CLDAQ_ROOT_DLL
    ClassDef(TTerminalUserInterface,0)
#endif

};

inline Tint TTerminalUserInterface::GetCommandHistoryIndex() const
{
  return theCommandHistoryIndex;
}

inline Tvoid TTerminalUserInterface::SetCommandHistoryIndex( Tint index )
{
  theCommandHistoryIndex = index;
  return;
}

inline Tint TTerminalUserInterface::GetCursorPosition() const
{
  return theCursorPosition;
}

inline const Tstring& TTerminalUserInterface::GetPrompt() const
{
  return thePrompt;
}

inline const Tstring& TTerminalUserInterface::GetAcceptString() const
{
  return theAcceptString;
}

inline const Tstring& TTerminalUserInterface::GetStringBuffer() const
{
  return theStringBuffer;
}

inline const Tstring& TTerminalUserInterface::GetCommandBuffer() const
{
  return theCommandBuffer;
}

inline Tvoid TTerminalUserInterface::SetCursorPosition( Tint position )
{
  theCursorPosition = position;
  return;
}

inline Tvoid TTerminalUserInterface::SetPrompt( const Tstring& prompt )
{
  thePrompt = prompt;
  return;
}

inline Tvoid TTerminalUserInterface::SetAcceptString( const Tstring& accept )
{
  theAcceptString = accept;
  return;
}

inline Tvoid TTerminalUserInterface::SetStringBuffer( const Tstring& buffer )
{
  theStringBuffer = buffer;
  return;
}

inline Tvoid TTerminalUserInterface::SetCommandBuffer( const Tstring& buffer )
{
  theCommandBuffer = buffer;
  return;
}

inline Tbool TTerminalUserInterface::isCursorEnd() const
{
  return ( theCursorPosition == (Tint)( theAcceptString.size() ) ) ? Ttrue : Tfalse;
}

inline Tbool TTerminalUserInterface::isCursorTop() const
{
  return ( theCursorPosition == 0 ) ? Ttrue : Tfalse;
}

#endif
