// =====================================================================
/*!
//
//  \file TDataDeflation.hh
//  \brief This file contains the TDataDeflation class.
//  \author Go IWAI <goiwai@users.sourceforge.jp>
//
//  $Id: TDataDeflation.hh,v 1.7 2004/03/07 16:56:04 goiwai Exp $
//  $Name: CLDAQ-1-13-00 $
//  $Log: TDataDeflation.hh,v $
//  Revision 1.7  2004/03/07 16:56:04  goiwai
//  *** empty log message ***
//
//  Revision 1.6  2004/03/07 10:30:34  goiwai
//  ROOTȤߤिΤޤʤޥᤳߤޤ
//  Ƥˤƴư櫓ǤϤޤ
//
//  Revision 1.5  2004/01/19 21:09:43  goiwai
//  ץץåƬCLDAQ__ѹޤ.
//
//  Revision 1.4  2003/11/03 08:35:15  goiwai
//  DoxygenѤΥȥȤ򤦤Ǥߤ򳫻Ϥޤ.
//
//  Revision 1.3  2003/10/06 16:37:49  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:21:20  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
*/
// =====================================================================
#ifdef __CLDAQ_ZLIB_USE
#ifndef CLDAQ__TDATADEFLATION_HH
#define CLDAQ__TDATADEFLATION_HH

#include "Tglobals.h"

// Z_NO_COMPRESSION         0
// Z_BEST_SPEED             1
// Z_BEST_COMPRESSION       9
// Z_DEFAULT_COMPRESSION  (-1)


/*!
// \example
//
// If example code exists.
//
*/

/*!
// \class TDataDeflation
// \brief This is the TDataDeflation class.
// \author Go IWAI <goiwai@users.sourceforge.jp>
//
// The TDataDeflation class detail description.
// Write it down ASAP!
//
// \todo None?
// \bug None?
// \ingroup SystemCategory
*/
class TDataDeflation
{

  private:
    enum { tDefaultBufferSize = 1024 * 1024 };

  private:
    Tzstream theDeflationStream;
    Tint theCompressionLevel;
    Tint theStatus;
    Tbyte* theOutputBuffer;
    Tint theSizeOfOutputBuffer;
    Tvoid* theDeflatedData;
    Tint theSizeOfDeflatedData;

  public:
    TDataDeflation( Tint bufsize = tDefaultBufferSize, Tint level = Z_DEFAULT_COMPRESSION );
    TDataDeflation( const TDataDeflation& right );
    ~TDataDeflation();

  public:
    const TDataDeflation& operator=( const TDataDeflation& right );

  public:
    Tvoid Compress( Tvoid* input, Tint nbyte, Tbool islast = Tfalse );

  public:
    const Tzstream& GetDeflationStream() const;
    Tzstream& GetDeflationStream();
    Tint GetCompressionLevel() const;
    Tint GetStatus() const;
    Tint GetSizeOfOutputBuffer() const;
    Tvoid* GetDeflatedData() const;
    Tint GetSizeOfDeflatedData() const;
    Tvoid SetCompressionLevel( Tint level );
    Tvoid SetOutputBuffer( Tint bufsize );

#ifdef __CLDAQ_ROOT_DLL
    ClassDef(TDataDeflation,0)
#endif

};

inline const Tzstream& TDataDeflation::GetDeflationStream() const
{
  return theDeflationStream;
}

inline Tzstream& TDataDeflation::GetDeflationStream()
{
  return theDeflationStream;
}

inline Tint TDataDeflation::GetCompressionLevel() const
{
  return theCompressionLevel;
}

inline Tint TDataDeflation::GetStatus() const
{
  return theStatus;
}

inline Tint TDataDeflation::GetSizeOfOutputBuffer() const
{
  return theSizeOfOutputBuffer;
}

inline Tvoid* TDataDeflation::GetDeflatedData() const
{
  return theDeflatedData;
}

inline Tint TDataDeflation::GetSizeOfDeflatedData() const
{
  return theSizeOfDeflatedData;
}

#endif
#endif
