package jp.ac.osaka_u.ist.sel.y_yuuki.cn;

import java.io.File;
import java.io.IOException;

import jp.ac.osaka_u.ist.sel.y_yuuki.cn.analyze.AnalyzeManager;
import jp.ac.osaka_u.ist.sel.y_yuuki.cn.data.Project;
import jp.ac.osaka_u.ist.sel.y_yuuki.cn.generate.OutputGenerator;
import jp.ac.osaka_u.ist.sel.y_yuuki.cn.mail.MailSender;


/**
 * <p>Clone Notifier CNX</p>
 * @author y-yuuki
 */

public class Main {
	
	/**
	 * <p>C\bh</p?
	 * @param args
	 */
	public static void main(String[] args) {
		
		//Ot@C
		try {
			Logger.init();
		} catch (IOException e) {
			System.out.println("Error: Can't generate Log File.");
			System.exit(1);
		}				
		
		//ԃt@CfBNg
		if(!(new File("file")).exists())
			(new File("file")).mkdirs();
		
		int argnum=1;		
		for(String arg: args){		
			
			Logger.write("--- Analyze Project" + Integer.toString(argnum++) +"---");
			Project project = new Project();	
			
			//ݒt@CǍ
			if(SettingFileLoader.loadSettingFile(arg,project)){				
								
				Logger.write("Success: Load setting file.");
				boolean okFlg = true;
				
				if(project.isCheckout()){
					if(!(okFlg = VCSController.checkoutProject(project))) {
						Logger.finish("Error: Can't checkout project.");
						okFlg = false;
					}else 
						Logger.write("Success: Checkout new version of " + project.getName() +".");
				}
				
				if(okFlg){
				
					//R[hN[̎擾
					if(AnalyzeManager.getCloneInf(project)){
						Logger.write("Success: Execute CCFinder.");
											
						//R[hN[̕
						if(AnalyzeManager.categorizeClone(project)){
						
							Logger.write("Success: Categorize code clones.");
					
							//ތʂ̏o
							OutputGenerator generator = new OutputGenerator(project);
					
							//eLXg
							if(project.isGenerateText()){
								generator.generateTextFile();
								MailSender.sendMail(project);
							}
					
							//CSV
							if(project.isGenerateCSV())
								generator.generateCSVFile();
					
							//HTML
							if(project.isGenerateHtml())
								generator.generateHTMLFile();
						}				
					}
				}				
			}else{
				Logger.finish("Error: Can't load setting file.");
			}		
		}
		
		Logger.finish("End");
		
		
	}

}
