package jp.ac.osaka_u.ist.sel.y_yuuki.cn;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

import jp.ac.osaka_u.ist.sel.y_yuuki.cn.data.Project;

/**
 * <p>ݒt@Cǂݍ݃NX</p>
 */
public class SettingFileLoader{	

	/**
	 * <p>ݒt@C̓ǂݍ</p>
	 * @param settingFile ݒt@C
	 * @param project ProjectIuWFNg
	 * @return <ul>
	 * 				<li>̏ꍇ - true</li>
	 *				<li>s̏ꍇ - false</li>
	 * 		@@  </ul>
	 */
	public static boolean loadSettingFile(String settingFile, Project project){
		BufferedReader reader = null; 	
		try {				
			reader = new BufferedReader(new FileReader(settingFile));
			String line;
			while((line=reader.readLine())!=null){
				if( line.length()>0 && line.charAt(0) != '%'){
					
					//vWFNg擾
					if(line.contains("PROJECT_NAME:"))
						project.setName(removeSpace(line.replace("PROJECT_NAME:","")));
					
					//ݒ
					if(line.contains("LANGUAGE:")){
						project.setLang(removeSpace(line.replace("LANGUAGE:","")));	
						if(!(project.getLang().equals("cpp") || project.getLang().equals("java") || project.getLang().equals("cobol") ||
								project.getLang().equals("csharp") ||project.getLang().equals("visualbasic") || project.getLang().equals("plaintext"))){
							return false;						
						}
					}						
					
					//`FbNAEgݒ
					if(line.contains("CHECKOUT:")){
						if(removeSpace(line.replace("CHECKOUT:","")).equals("AUTO")) project.setCheckout(true);
						else if(removeSpace(line.replace("CHECKOUT:","")).equals("MANUAL")) project.setCheckout(false);
					}
					
					//`FbNAEgpR}h擾
					if(project.isCheckout() && line.contains("CHECKOUT_CMD:")){
					    project.setCheckoutCmd(line.replace("CHECKOUT_CMD:",""));
					    project.setOldDir("old"+"\\"+project.getName());
					}
					
					//`FbNAEgfBNg
					if(project.isCheckout() && line.contains("CHECKOUT_DIR:")){
					    project.setNewDir(removeSpace(line.replace("CHECKOUT_DIR:","")));
					}
					
					//ŐVo[W`FbNAEgfBNgݒ
					if(!project.isCheckout() && line.contains("NEW_VERSION:")){
						project.setNewDir(removeSpace(line.replace("NEW_VERSION:","")));
						if(!(new File(project.getNewDir())).exists()){
							Logger.write("Error: Can't found new version directory.");
							return false;
						}
						if(!(new File(project.getNewDir()+"\\src")).exists()){
							Logger.write("Error: Can't found src directory.");
							return false;
						}
					}
							
					//o[W`FbNAEgfBNgݒ
					if(!project.isCheckout() && line.contains("OLD_VERSION:")){
						project.setOldDir(removeSpace(line.replace("OLD_VERSION:","")));
						if(!(new File(project.getOldDir())).exists()){
							Logger.write("Error: Can't found old version directory."); 
							return false;
						}
						if(!(new File(project.getOldDir()+"\\src")).exists()){
							Logger.write("Error: Can't found src directory.");
							return false;
						}
					}		
					
					//g[N臒l
					if(line.contains("TOKEN:"))
						project.setTokenTh(Integer.parseInt(removeSpace(line.replace("TOKEN:",""))));
					
					//OVERLAPPING臒l
					if(line.contains("OVERLAPPING:")){
						if(removeSpace(line.replace("OVERLAPPING:","")).equals("true")) project.setOlFilter(true);
						else project.setOlFilter(false);
					}
					
					//eLXgt@Co͗pfBNgݒ
					if(line.contains("TEXT_DIR:")){
						project.setGenerateTextDir(removeSpace(line.replace("TEXT_DIR:","")));
						project.setGenerateText(true);
					}
					
					//HTMLt@Co͗pfBNgݒ
					if(line.contains("HTML_DIR:")){
						project.setGenerateHTMLDir(removeSpace(line.replace("HTML_DIR:","")));
						project.setGenerateHtml(true);
					}	
					
					//CSVt@Co͗pfBNgݒ
					if(line.contains("CSV_DIR:")){
						project.setGenerateCSVDir(removeSpace(line.replace("CSV_DIR:","")));
						project.setGenerateCSV(true);
					}
					
					//AJEgt@C
					if(line.contains("ACCOUNT_FILE:"))
						project.setAccountFile(removeSpace(line.replace("ACCOUNT_FILE:","")));
						
					//AJEgt@C
					if(line.contains("KEY_FILE:"))
						project.setKeyFile(removeSpace(line.replace("KEY_FILE:","")));
					
					//zXg
					if(line.contains("HOST:"))
						project.setHost(removeSpace(line.replace("HOST:","")));
					
					//|[g
					if(line.contains("PORT:"))
						project.setPort(Integer.valueOf(removeSpace(line.replace("PORT:",""))));
					
					//茳
					if(line.contains("FROM:"))
						project.setFrom(removeSpace(line.replace("FROM:","")));
					
					//
					if(line.contains("TO1:"))
						project.getToList().add(line.replace("TO1:",""));
					
					//
					if(line.contains("TO2:"))
						project.getToList().add(line.replace("TO2:",""));
					
					//
					if(line.contains("TO3:"))
						project.getToList().add(line.replace("TO3:",""));
					
					//
					if(line.contains("SSL:")){
						if( removeSpace(line.replace("SSL:","")).equals("SSL/TLS")) project.setSsl(1);
						else if( removeSpace(line.replace("SSL:","")).equals("STARTTLS")) project.setSsl(2);
					}					
				}					
			}
		}catch(Exception e){
			return false;			
		}finally{
			if(reader!=null){
				try {
					reader.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
			}		
		}
		return true;	
	}
	
	/**
	 * <p>Xy[X<p>
	 * @param str 
	 * @return Xy[X̕
	 */
	private static String removeSpace(String str){
		while(str.startsWith(" ") || str.startsWith("\t"))
			str = str.substring(1);
		return str;
	}
}
