package jp.ac.osaka_u.ist.sel.y_yuuki.cn.analyze;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.regex.Pattern;

import jp.ac.osaka_u.ist.sel.y_yuuki.cn.Def;
import jp.ac.osaka_u.ist.sel.y_yuuki.cn.data.Clone;
import jp.ac.osaka_u.ist.sel.y_yuuki.cn.data.CloneSet;
import jp.ac.osaka_u.ist.sel.y_yuuki.cn.data.Project;
import jp.ac.osaka_u.ist.sel.y_yuuki.cn.data.SourceFile;

/**
 * <p>CCFinderX̃Rg[NX</p>
 */

public class CCFXController {		
	
	private Project project = null;
	
	/**
	 * <p>RXgN^</p>
	 * @param project Project IuWFNg
	 */	
	public CCFXController(Project project){
		this.project = project;		
	}
	
	/**
	 * <p>CCFinderXs</p>
	 * @return	<ul>
	 * 				<li>̏ꍇ - true</li>
	 *				<li>s̏ꍇ - false</li>
	 * 			</ul>
	 */
	public boolean execute(){
		
		//CCFinderXspR}h
		String[] cmdArray1= { 
			Def.CCFX_PATH, "d", project.getLang(),
				"-b", Integer.toString(project.getTokenTh()),
				"-dn", project.getNewDir()+"\\src", "-is",
				"-dn", project.getOldDir()+"\\src" //, "-w", "w-f-g+"
		};
		
		//CCFinderXeLXg\pR}h
		String[] cmdArray2={ 
			Def.CCFX_PATH, "p", "a.ccfxd", "-o", Def.RESULT_TXT
		};
		
		//CCFinderXgNXvpR}h
		String[] cmdArray3={ 
			Def.CCFX_PATH, "m", "a.ccfxd", "-c", "-o", Def.METRICS_TXT
		};
		
		Runtime rt = Runtime.getRuntime();
		
		try {
			rt.exec(cmdArray1).waitFor();
			rt.exec(cmdArray2).waitFor();
			rt.exec(cmdArray3).waitFor();
		} catch (InterruptedException e) {			
			return false;
		} catch (IOException e) {			
			return false;		
		}
		
		if(!(new File("a.ccfxd").exists()))
			return false;
		
		return true;		
	}
	
	/**
	 * <p>CCFinderXɂďo͂ꂽN[f[^t@C̓Ǎ</p>
	 * @return <ul>
	 * 				<li>̏ꍇ - true</li>
	 *				<li>s̏ꍇ - false</li>
	 * 			</ul>
	 */
	public boolean readCloneDataFile(){
		
		BufferedReader readFile = null;
		String line = null;
		int boundary = getFileNum(new File(project.getNewDir()+"\\src\\.ccfxprepdir"));
		ArrayList<SourceFile> fileList = new ArrayList<SourceFile>();
		ArrayList<CloneSet> cloneSetList = new ArrayList<CloneSet>(); 
		ArrayList<String> newFileList = new ArrayList<String>();
    	ArrayList<String> oldFileList = new ArrayList<String>();

		try {			

			/*
			 * O擾
			 */			
			readFile = new BufferedReader(new InputStreamReader(new FileInputStream(Def.RESULT_TXT)));
		    		
	       	while(!(line=readFile.readLine()).equals("source_files {"))		
				;
			
	    	//VEt@CXg
			while(!(line=readFile.readLine()).equals("}")){
				String str[] = line.split("\t");				
				if(Integer.valueOf(str[0])<=boundary){
					newFileList.add(str[1].substring(project.getNewDir().length()+1));	
				}else{
					oldFileList.add(str[1].substring(project.getOldDir().length()+1));
				}
			}
			readFile.close();
			
			/*
			 * \[Xt@C̎擾
			 */
			readFile = new BufferedReader(new InputStreamReader(new FileInputStream(Def.RESULT_TXT)));
			
			while(!readFile.readLine().equals("source_files {"))		
				;				
			
			
			int fileId = 0;
			while(!(line=readFile.readLine()).equals("}")){
				String str[] = line.split("\t");
				String fileName;
				if(Integer.valueOf(str[0])<=boundary){
					fileName = str[1].substring(project.getNewDir().length()+1);	
				}else{
					fileName = str[1].substring(project.getOldDir().length()+1);
				}
				SourceFile file = new SourceFile();
				file.setName(fileName);
				file.setNewPath(project.getNewDir()+"\\"+fileName);
				file.setOldPath(project.getOldDir()+"\\"+fileName);
				
				if(Integer.valueOf(str[0])<=boundary){
					file.setId(fileId++);
					if(oldFileList.contains(fileName)) file.setState(SourceFile.NORMAL);
					else file.setState(SourceFile.ADDED);
					fileList.add(file);		
				}else if(!newFileList.contains(fileName)){
					file.setId(fileId++);
					file.setState(SourceFile.DELETED);
					fileList.add(file);				
				}					
			}
			
			/*
			 * N[̎擾 
			 */			
			while(!readFile.readLine().equals("clone_pairs {")){		
				;			
			}
			
			int cloneId = 0;
			while(!(line=readFile.readLine()).equals("}")){
				
				String[] str = (Pattern.compile("[\t|.|-]")).split(line);				

				//CloneSetIuWFNg̗p
				CloneSet cloneSet = null;
				for(CloneSet pCloneSet: cloneSetList){
					if(pCloneSet.getId()==(Integer.valueOf(str[0])))
							cloneSet = pCloneSet;						
				}				
				if(cloneSet==null){
					cloneSet = new CloneSet();
					cloneSet.setId(Integer.valueOf(str[0]));
					cloneSetList.add(cloneSet);
				}	
			
				//N[1
				Clone clone = new Clone();
				clone.setCloneSet(cloneSet);
				clone.setStartToken(Integer.valueOf(str[2]));
				clone.setEndToken(Integer.valueOf(str[3]));
				clone.setId(cloneId++);
				if(Integer.valueOf(str[1])<=boundary){
					clone.setFile(Project.getFileObj(fileList, newFileList.get(Integer.valueOf(str[1])-1)));
					if(!addClone(cloneSet.getNewCloneList(),clone)) cloneId--;
				}else{
					clone.setFile(Project.getFileObj(fileList, oldFileList.get(Integer.valueOf(str[1])-1-boundary)));
					if(!addClone(cloneSet.getOldCloneList(),clone)) cloneId--;
				}				
				
				//N[2
				clone = new Clone();
				clone.setCloneSet(cloneSet);
				clone.setStartToken(Integer.valueOf(str[5]));
				clone.setEndToken(Integer.valueOf(str[6]));
				clone.setId(cloneId++);
				if(Integer.valueOf(str[4])<=boundary){
					clone.setFile(Project.getFileObj(fileList, newFileList.get(Integer.valueOf(str[4])-1)));
					if(!addClone(cloneSet.getNewCloneList(),clone)) cloneId--;
				}else{
					clone.setFile(Project.getFileObj(fileList, oldFileList.get(Integer.valueOf(str[4])-1-boundary)));
					if(!addClone(cloneSet.getOldCloneList(),clone)) cloneId--;
				}		
				
			}			
	    } catch (FileNotFoundException e) {
			return false;
		} catch (IOException e) {
			return false;
		} finally{			
			if(readFile != null){
				try {
					readFile.close();
				}catch (IOException e) {
					e.printStackTrace();
				}
			}			
		}
	
		//댟ȍ
		@SuppressWarnings("unchecked")
		ArrayList<CloneSet> tmpCloneSetList = (ArrayList<CloneSet>)cloneSetList.clone();
		for(CloneSet cloneSet: tmpCloneSetList){
			if(cloneSet.getNewCloneList().size()==1)
				cloneSet.getNewCloneList().remove(0);
			if(cloneSet.getOldCloneList().size()==1)
				cloneSet.getOldCloneList().remove(0);
			if(cloneSet.getNewCloneList().isEmpty() && cloneSet.getOldCloneList().isEmpty())
				cloneSetList.remove(cloneSet);
			if(project.isOlFilter() && (isOverlapping(cloneSet.getNewCloneList()) || isOverlapping(cloneSet.getOldCloneList())))
				cloneSetList.remove(cloneSet);
		}
		
		//\[Xt@CɃN[̒ǉ
		for(CloneSet cloneSet: cloneSetList){
			for(Clone clone: cloneSet.getNewCloneList()){
				clone.getFile().getNewCloneList().add(clone);
			}
			for(Clone clone: cloneSet.getOldCloneList()){
				clone.getFile().getOldCloneList().add(clone);
			}
		}
		
		//N[Xg̐
		for(SourceFile file:fileList)
			file.sortCloneListbyToken();
			
		project.getCloneSetList().addAll(cloneSetList);
		project.getFileList().addAll(fileList);
		
		return true;
		
	}
	
	/**
	 * fBNg̃t@C
	 * @param string
	 * @return
	 */
	private int getFileNum(File dir) {
		if(!dir.exists())
			return 0;
		File[] fileList = dir.listFiles();
		int count=0;
		for(File f:fileList){
			if(f.isDirectory()) count += getFileNum(f);
			if(f.isFile()) count++;
		}
		return count;
	}

	/**
	 * <p>CCFinderX̃vvZXt@C̓Ǎ</p>
	 * @return@<ul>
	 * 				<li>̏ꍇ - true</li>
	 *				<li>s̏ꍇ - false</li>
	 * 		   </ul>
	 */
	public boolean readPrepFile() throws Exception{
		
		BufferedReader readFile = null;
		
		for(SourceFile file:project.getFileList()){
			
			if(file.getState()!=SourceFile.DELETED){			
			
				//Prept@C̎擾
				String prepFile = null;
				String prepDir = project.getNewDir() + "\\src\\.ccfxprepdir\\";
				
				if(!(new File(file.getNewPath())).getParentFile().getAbsolutePath().equals(project.getNewDir()+"\\src"))
					prepDir = prepDir + (new File(file.getNewPath())).getParentFile().getAbsolutePath().substring(new File(project.getNewDir()+"\\src").getAbsolutePath().length()+1);
				
				if(!(new File(prepDir)).exists())
					return false;
				
				File[] prepList = (new File(prepDir)).listFiles();
				for(int i=0; i<prepList.length; i++){					
					if(prepList[i].getName().startsWith((new File(file.getNewPath())).getName())){
						prepFile = prepList[i].getAbsolutePath();
						break;
					}			
				}				
				
				if(prepFile!=null){
					
					//sԍEԍ̓Ǎ
					ArrayList<Integer> lines = new ArrayList<Integer>();
					ArrayList<Integer> columns = new ArrayList<Integer>();
					
					try {
						
						readFile = new BufferedReader(new InputStreamReader(new FileInputStream(prepFile)));
						String line;
						while((line=readFile.readLine())!=null){
							String[] str = Pattern.compile("[\t|.]").split(line);
							lines.add(Integer.decode("0x"+str[0]).intValue());
							columns.add(Integer.decode("0x"+str[1]).intValue());
							
						}					
						for(Clone clone: file.getNewCloneList()){
							clone.setStartLine(lines.get(clone.getStartToken()));
							clone.setStartColumn(columns.get(clone.getStartToken()));
							clone.setEndLine(lines.get(clone.getEndToken()));
							clone.setEndColumn(columns.get(clone.getEndToken()));
						}
						
					} catch (FileNotFoundException e) {
						return false;
					} catch (IOException e) {
						return false;
					} finally{			
						if(readFile != null){
							try {
								readFile.close();
							}catch (IOException e) {
								e.printStackTrace();
							}
						}			
					}	
				}
			}	
			
			if(file.getState()!=SourceFile.ADDED){			
				
				//Prept@C̎擾
				String prepFile = null;
				String prepDir = project.getOldDir() + "\\src\\.ccfxprepdir\\";
				
				if(!(new File(file.getOldPath())).getParentFile().getAbsolutePath().equals(project.getOldDir()+"\\src"))
					prepDir=prepDir+((new File(file.getOldPath())).getParentFile().getAbsolutePath()).substring((new File(project.getOldDir()+"\\src")).getAbsolutePath().length()+1);
				

				if(!(new File(prepDir)).exists())
					return false;
				
				File[] prepList = (new File(prepDir)).listFiles();
				for(int i=0; i<prepList.length; i++){					
					if(prepList[i].getName().startsWith((new File(file.getOldPath())).getName())){
						prepFile = prepList[i].getAbsolutePath();
						break;
					}			
				}				
				
				if(prepFile!=null){
					
					//sԍEԍ̓Ǎ
					ArrayList<Integer> lines = new ArrayList<Integer>();
					ArrayList<Integer> columns = new ArrayList<Integer>();
					
					try {
						
						readFile = new BufferedReader(new InputStreamReader(new FileInputStream(prepFile)));
						String line;
						while((line=readFile.readLine())!=null){
							String[] str = Pattern.compile("[\t|.]").split(line);
							lines.add(Integer.decode("0x"+str[0]).intValue());
							columns.add(Integer.decode("0x"+str[1]).intValue());
						}
						
						for(Clone clone: file.getOldCloneList()){
							clone.setStartLine(lines.get(clone.getStartToken()));
							clone.setStartColumn(columns.get(clone.getStartToken()));
							clone.setEndLine(lines.get(clone.getEndToken()));
							clone.setEndColumn(columns.get(clone.getEndToken()));
						}
						
					} catch (FileNotFoundException e) {
						return false;
					} catch (IOException e) {
						return false;
					} finally{			
						if(readFile != null){
							try {
								readFile.close();
							}catch (IOException e) {
								e.printStackTrace();
							}
						}			
					}	
				}
			}	
		}		
		return true;
	}
	
	/**
	 * <p>CCFinderX̃gNXo</p>
	 * @return@<ul>
	 * 				<li>̏ꍇ - true</li>
	 *				<li>s̏ꍇ - false</li>
	 * 		   </ul>
	 */
	public boolean getCloneMetrics(){
		BufferedReader readFile =null;
		try {
			readFile = new BufferedReader(new InputStreamReader(new FileInputStream(Def.METRICS_TXT)));
			String line=null;
			
			readFile.readLine();
	    	while((line=readFile.readLine())!=null){
	    		String[] str = line.split("\t");	    		
	    		for(CloneSet cloneSet:project.getCloneSetList()){	    			
	    			if(str.length==10 && cloneSet.getId()==Integer.valueOf(str[0])){
	    				cloneSet.setLEN(Integer.valueOf(str[1]));
	    				cloneSet.setPOP(Integer.valueOf(str[2]));
	    				cloneSet.setNIF(Integer.valueOf(str[3]));
	    				cloneSet.setRAD(Integer.valueOf(str[4]));
	    				cloneSet.setRNR(Double.valueOf(str[5]));
	    				cloneSet.setTKS(Integer.valueOf(str[6]));
	    				cloneSet.setLOOP(Integer.valueOf(str[7]));
	    				cloneSet.setCOND(Integer.valueOf(str[8]));
	    				cloneSet.setMcCabe(Integer.valueOf(str[9]));	    				
	    			}	    			
	    		}	    		
	    	}
		} catch (FileNotFoundException e) {
			return false;
		} catch (IOException e) {
			return false;
		} finally{			
			if(readFile != null){
				try {
					readFile.close();
				}catch (IOException e) {
					e.printStackTrace();
				}
			}			
		}
	   		
		return true;		
	}
	
	/**
	 * <p>N[XgɃN[ǉ</p>
	 * @param cloneList N[Xg
	 * @param clone ǉN[
	 * @return@<ul>
	 * 				<li>̏ꍇ - true</li>
	 *				<li>s̏ꍇ - false</li>
	 * 		   </ul>
	 */
	private boolean addClone(ArrayList<Clone> cloneList, Clone clone) {
		for(Clone pClone: cloneList){
			if(clone.equals(pClone)) return false;
		}
		cloneList.add(clone);
		return true;
	}

	
	/**
	 * <p>I[obsO̔</p>
	 * @param cloneList N[Xg
	 * @return<ul>
	 * 				<li>I[obvĂꍇ - true</li>
	 *				<li>I[obvĂȂꍇ - false</li>
	 * 		   </ul>
	 */
	private boolean isOverlapping(ArrayList<Clone> cloneList) {
		Clone clone1,clone2;
		for(int i=0; cloneList.size()>i ; i++){
			for(int j=i+1; cloneList.size()>j ; j++){
				if((clone1=cloneList.get(i)).getFile().getId()==(clone2=cloneList.get(j)).getFile().getId()){
					if( (clone1.getStartToken()<clone2.getStartToken() && clone1.getEndToken()>clone2.getStartToken()) ||
						(clone2.getStartToken()<clone1.getStartToken() && clone2.getEndToken()>clone1.getStartToken())){
						return true;									
					}
				}				
			}			
		}
		return false;
	}
}
