package jp.ac.osaka_u.ist.sel.y_yuuki.cn.analyze;

import java.util.ArrayList;

import jp.ac.osaka_u.ist.sel.y_yuuki.cn.data.Clone;
import jp.ac.osaka_u.ist.sel.y_yuuki.cn.data.SourceFile;

/**
 * <p>R[hN[̕ύX𕪗ރNX</p>
 */

public class CloneCategorizer {
	
	/**
	 * <p>R[hN[̕</p>	
	 * @param fileList \[Xt@CXg
	 */
	public static void categorizeClone(ArrayList<SourceFile> fileList){

		for(SourceFile file:fileList){
			if(file.getState()==SourceFile.NORMAL){
				categorizeStableModified(file);
				categorizeMoved(file);				
			}			
			categorizeAddedDeleted(file);
		}
	}
	
	/**
	 * <p>Stable/ModifiedN[̕</p>
	 * @param file
	 */
	private static void categorizeStableModified(SourceFile file){
			
		for(Clone cloneA: file.getNewCloneList()){
			
			int addedLineStart = 0;
			int addedLineEnd = 0;		
			
			//R[hN[̊Jns/Is܂ł̒ǉšvZ
			for(int line: file.getAddedCodeList()){
				if(line<cloneA.getStartLine()) addedLineStart++;
				if(line<=cloneA.getEndLine()) addedLineEnd++;
				else break;
			}
			
			for(Clone cloneB: file.getOldCloneList()){			
				
				if(cloneB.getCategory() == Clone.NULL){
				
					int deletedLineStart = 0;
					int deletedLineEnd = 0;
					
					//R[hN[̊Jns/Is܂ł̍폜švZ
					for(int line: file.getDeletedCodeList()){
						if(line<cloneB.getStartLine()) deletedLineStart++;
						if(line<=cloneB.getEndLine()) deletedLineEnd++;
						else break;
					}
				
					//eq֌W݂邩
					if(cloneA.getStartLine()-addedLineStart == cloneB.getStartLine()-deletedLineStart && 
						cloneA.getEndLine()-addedLineEnd == cloneB.getEndLine()-deletedLineEnd &&
						cloneA.getCloneSet() == cloneB.getCloneSet()){
					
						//StableN[̏ꍇ
						if(addedLineStart==addedLineEnd && deletedLineStart==deletedLineEnd){
							cloneA.setCategory(Clone.STABLE);
							cloneB.setCategory(Clone.STABLE);
						//ModifiedN[̏ꍇ
						}else{
							cloneA.setCategory(Clone.MODIFIED);
							cloneB.setCategory(Clone.MODIFIED);
						}
						
						cloneA.setParentClone(cloneB);	
						cloneB.setChildClone(cloneA);

						break;
					}
				}				
			}			
		}	
	}
	
	/**
	 * <p>MovedN[̕</p?
	 * @param file
	 */
	private static void categorizeMoved(SourceFile file){
		
		for(Clone cloneA: file.getNewCloneList()){
			
			int addedLineStart = 0;
			int addedLineEnd = 0;		
			
			//R[hN[̊Jns/Is܂ł̒ǉšvZ
			for(int line: file.getAddedCodeList()){
				if(line<cloneA.getStartLine()) addedLineStart++;
				if(line<=cloneA.getEndLine()) addedLineEnd++;
				else break;
			}
			
			for(Clone cloneB: file.getOldCloneList()){			
				
				if(cloneB.getCategory() == Clone.NULL){
				
					int deletedLineStart = 0;
					int deletedLineEnd = 0;
					
					//R[hN[̊Jns/Is܂ł̍폜švZ
					for(int line: file.getDeletedCodeList()){
						if(line<cloneB.getStartLine()) deletedLineStart++;
						if(line<=cloneB.getEndLine()) deletedLineEnd++;
						else break;
					}
				
					//eq֌W݂邩
					if(cloneA.getStartLine()-addedLineStart == cloneB.getStartLine()-deletedLineStart && 
						cloneA.getEndLine()-addedLineEnd == cloneB.getEndLine()-deletedLineEnd){
						cloneA.setCategory(Clone.MOVED);
						cloneB.setCategory(Clone.MOVED);
						cloneA.setParentClone(cloneB);	
						cloneB.setChildClone(cloneA);
						break;
					}
				}				
			}			
		}
	}
	
	/**
	 * <p>Added/DeletedN[̕</p>
	 * @param file
	 */
	private static void categorizeAddedDeleted(SourceFile file){
		
		//AddedN[̕
		for(Clone clone: file.getNewCloneList()){
			if(clone.getCategory()==Clone.NULL)
				clone.setCategory(Clone.ADDED);
		}
		
		//DeletedN[̕
		for(Clone clone: file.getOldCloneList()){
			if(clone.getCategory()==Clone.NULL)
				clone.setCategory(Clone.DELETED);
		}		
	}

}
