package jp.ac.osaka_u.ist.sel.y_yuuki.cn.analyze;

import java.util.ArrayList;

import jp.ac.osaka_u.ist.sel.y_yuuki.cn.data.Clone;
import jp.ac.osaka_u.ist.sel.y_yuuki.cn.data.CloneSet;

/**
 * <p>N[Zbg̕ύX𕪗ރNX</p>
 */

public class CloneSetCategorizer {
	
	/**
	 * <p>N[Zbg̕</p>	
	 * @param fileList N[ZbgXg
	 */
	public static void categorizeClone(ArrayList<CloneSet> cloneSetList){

		for(CloneSet cloneSet:cloneSetList){
			if(cloneSet.getNewCloneList().isEmpty())
				cloneSet.setCategory(CloneSet.DELETED);
			else if(cloneSet.getOldCloneList().isEmpty())
				cloneSet.setCategory(CloneSet.NEW);
			else{
				boolean changedFlg = false;
				cloneSet.setPOP(cloneSet.getPOP()/2);
				for(Clone clone:cloneSet.getNewCloneList()){
					if(clone.getCategory()!=Clone.STABLE){
						changedFlg = true;
						break;
					}
				}
				for(Clone clone:cloneSet.getOldCloneList()){
					if(clone.getCategory()!=Clone.STABLE){
						changedFlg = true;
						break;
					}
				}				
				if(changedFlg) cloneSet.setCategory(CloneSet.CHANGED);
				else cloneSet.setCategory(CloneSet.STABLE);
			}
		}
	}

}
