package jp.ac.osaka_u.ist.sel.y_yuuki.cn.generate;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.channels.FileChannel;
import java.util.ArrayList;

import jp.ac.osaka_u.ist.sel.y_yuuki.cn.Def;
import jp.ac.osaka_u.ist.sel.y_yuuki.cn.Logger;
import jp.ac.osaka_u.ist.sel.y_yuuki.cn.data.Clone;
import jp.ac.osaka_u.ist.sel.y_yuuki.cn.data.CloneSet;
import jp.ac.osaka_u.ist.sel.y_yuuki.cn.data.Project;
import jp.ac.osaka_u.ist.sel.y_yuuki.cn.data.SourceFile;

/**
 * <p>HTMLo̓NX</p>
 * @author y-yuuki
 */
public class HTMLFileGenerater {	
	
	private final static String SCRIPT = "script.js";
	private final static String INDEX_PAGE = "index.html";
	private final static String CLONESETLIST_PAGE= "cloneset.html";
	private final static String PACKAGELIST_PAGE = "packagelist.html";
	private final static int STACK = 100;
	
	/**
	 * <p>HTMLt@C</p>
	 * @param g	OutputGeneratorIuWFNg
	 * @param project ProjectIuWFNg
	 * @return	<ul>
	 * 				<li>̏ꍇ - true</li>
	 *				<li>s̏ꍇ - false</li>
	 * 			</ul>
	 */
	public static boolean generateHTMLFile(OutputGenerator g, Project project) {
		
		//摜t@C̃Rs[		
		if(!copyImageFiles(project.getGenerateHTMLDir()))
			return false;		
		
		//XNvg
		if(!generateScript(project.getGenerateHTMLDir()))
			return false;

		//vWFNgfBNg̐
		File dir = new File(project.getGenerateHTMLDir()+"\\"+g.getYear()+g.getMonth()+g.getDay());
		dir.mkdirs();	
		
		//vWFNgz[t@C̏o
		if(!generateProjectPage(g, dir.getAbsolutePath(),project))	
			return false;
		
		//N[Zbgt@C̏o
		if(!generateCloneSetListPage(g,dir.toString(),project)) 
			return false;
		
		//pbP[Wꗗt@C̏o
		if(!generatePackageListPage(g,dir.getAbsolutePath(),project))
			return false;
		
		//\[Xt@Cꗗt@C̏o
		File tmp = new File(dir.toString()+"\\src");
		if(tmp.exists()){
			if(!generateFileListPage(g,new File(dir.getAbsolutePath()+"\\"+"src"),1, dir.getAbsolutePath(), project))
				return false;
			return generateDateListPage(project);
		}else{ 
			return true;
		}		
	}
	
	/**
	 * <p>摜t@C̃Rs[</p>
	 * @param generateHTMLDir  o̓fBNg
	 * @return <ul>
	 * 				<li>̏ꍇ - true</li>
	 *				<li>s̏ꍇ - false</li>
	 * 			</ul>
	 */
	private static boolean copyImageFiles(String generateHTMLDir) {
		File dir = new File(generateHTMLDir +"\\"+Def.IMAGE);
		
		if(dir.exists())
			return true;
		
		dir.mkdirs();		
		String[] images = {"asc.gif","desc.gif","sort.gif"};
		for(String image:images){
			try {
				FileInputStream src = new FileInputStream(Def.IMAGE + "/" +image);
				FileOutputStream dest = new FileOutputStream(dir.toString() + "/" +image);
				FileChannel srcChannel = src.getChannel();
				FileChannel destChannel = dest.getChannel();
				try {
					srcChannel.transferTo(0,srcChannel.size(),destChannel);
				} catch (IOException e) {
					return false;
				} finally {
					try {
						srcChannel.close();
						destChannel.close();
						src.close();
						dest.close();
					} catch (IOException e) {
						return false;
					}			
				}
			} catch (FileNotFoundException e) {
				Logger.write("Error: Can't find image files.");
				return false;
			}
		}
		return true;
	}

	/**
	 * <p>JavaScript̐</p>
	 * @param dir o̓fBNg
	 * @return <ul>
	 * 				<li>̏ꍇ - true</li>
	 *				<li>s̏ꍇ - false</li>
	 * 			</ul>
	 */
	private static boolean generateScript(String dir){
		try {			
			if(!new File(dir+"\\"+SCRIPT).exists()){
				PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(dir+"\\"+SCRIPT)));
				writer.println("var table=function(){");
				writer.println("\tfunction sorter(n){");
				writer.println("\t\tthis.n=n; this.t; this.b; this.r; this.d; this.p; this.w; this.a=[]; this.l=0");
				writer.println("\t}");
				writer.println("\tsorter.prototype.init=function(t,f){");
				writer.println("\t\tthis.t=document.getElementById(t);");
				writer.println("\t\tthis.b=this.t.getElementsByTagName('tbody')[0];");
				writer.println("\t\tthis.r=this.b.rows; var l=this.r.length;");
				writer.println("\t\tfor(var i=0;i<l;i++){");
				writer.println("\t\t\tif(i==0){");
				writer.println("\t\t\t\tvar c=this.r[i].cells; this.w=c.length;");
				writer.println("\t\t\t\tfor(var x=0;x<this.w;x++){");
				writer.println("\t\t\t\t\tif(c[x].className!='nosort'){");
				writer.println("\t\t\t\t\t\tc[x].className='head';");
				writer.println("\t\t\t\t\t\tc[x].onclick=new Function(this.n+'.work(this.cellIndex)')");
				writer.println("\t\t\t\t\t}");
				writer.println("\t\t\t\t}");
				writer.println("\t\t\t}else{");
				writer.println("\t\t\t\tthis.a[i-1]={}; this.l++;");
				writer.println("\t\t\t}");
				writer.println("\t\t}");
				writer.println("\t\tif(f!=null){");
				writer.println("\t\t\tvar a=new Function(this.n+'.work('+f+')'); a()");
				writer.println("\t\t}");
				writer.println("\t}");
				writer.println("\tsorter.prototype.work=function(y){");
				writer.println("\t\tthis.b=this.t.getElementsByTagName('tbody')[0]; this.r=this.b.rows;");
				writer.println("\t\tvar x=this.r[0].cells[y],i;");
				writer.println("\t\tfor(i=0;i<this.l;i++){");
				writer.println("\t\t\tthis.a[i].o=i+1; var v=this.r[i+1].cells[y].firstChild;");
				writer.println("\t\t\tthis.a[i].value=(v!=null)?v.nodeValue:''");
				writer.println("\t\t}");
				writer.println("\t\tfor(i=0;i<this.w;i++){");
				writer.println("\t\t\tvar c=this.r[0].cells[i];");
				writer.println("\t\t\tif(c.className!='nosort'){c.className='head'}");
				writer.println("\t\t}");
				writer.println("\t\tif(this.p==y){");
				writer.println("\t\t\tthis.a.reverse(); x.className=(this.d)?'asc':'desc';");
				writer.println("\t\t\tthis.d=(this.d)?false:true");
				writer.println("\t\t}else{");
				writer.println("\t\t\tthis.p=y; this.a.sort(compare); x.className='asc'; this.d=false");
				writer.println("\t\t}");
				writer.println("\t\tvar n=document.createElement('tbody');");
				writer.println("\t\tn.appendChild(this.r[0]);");
				writer.println("\t\tfor(i=0;i<this.l;i++){");
				writer.println("\t\t\tvar r=this.r[this.a[i].o-1].cloneNode(true);");
				writer.println("\t\t\tn.appendChild(r); r.className=(i%2==0)?'even':'odd'");
				writer.println("\t\t}");
				writer.println("\t\tthis.t.replaceChild(n,this.b)");
				writer.println("\t}");
				writer.println("\tfunction compare(f,c){");
				writer.println("\t\tf=f.value,c=c.value;");
				writer.println("\t\tvar i=parseFloat(f.replace(/(\\$|\\,)/g,'')),n=parseFloat(c.replace(/(\\$|\\,)/g,''));");
				writer.println("\t\tif(!isNaN(i)&&!isNaN(n)){f=i,c=n}");
				writer.println("\t\treturn (f>c?1:(f<c?-1:0))");
				writer.println("\t}");
				writer.println("\treturn{sorter:sorter}");
				writer.println("}();");
				writer.close();
			}
			return true;
		} catch (IOException e) {
			return false;
		}
		
		
	}
	
	/**
	 * <p>vWFNgy[W</p>
	 * @param g	OutputGeneratorIuWFNg
	 * @param dir@o̓fBNg
	 * @param project ProjectIuWFNg
	 * @return	<ul>
	 * 				<li>̏ꍇ - true</li>
	 *				<li>s̏ꍇ - false</li>
	 * 			</ul>
	 */
	private static boolean generateProjectPage(OutputGenerator g, String dir, Project project) {
		try {			
			
			PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(dir+"\\"+INDEX_PAGE)));
			
			//wb_o
			outputHtmlHead(writer,project.getName());			
			
			//^Cgo
			writer.printf("<a href=\"../%s\">%sN%s%s</a>\r\n",INDEX_PAGE,g.getYear(),g.getMonth(),g.getDay());
			writer.printf("<h1> vWFNgF %s </h1>\r\n",project.getName());				
			writer.printf("<hr>\r\n");			
			writer.printf("<center>\r\n");
						
			writer.printf("<h2><a href=\"%s\">N[Zbgꗗ</a></h2>\r\n",CLONESETLIST_PAGE);
			writer.printf("<hr>\r\n");
			writer.printf("<h2><a href=\"%s\">fBNgipbP[Wjꗗ</a></h2>\r\n",PACKAGELIST_PAGE);
			writer.printf("<hr>\r\n");			
		
			//vWFNg̏o
			writer.printf("<table border=\"1\">\r\n");
			writer.printf("<tr><th bgcolor=\"lightgrey\" colspan=\"2\">vWFNg</th></tr>\r\n");
			
			//t@Co			
			writer.printf("<tr bgcolor=\"#D1D168\"><th colspan=\"2\">\[Xt@C</th></tr>\r\n");			
			writer.printf("<tr><th width=\"400\">t@C</th><td width=\"200\">%d</td></tr>\r\n",g.getFileNum());
			writer.printf("<tr><th width=\"400\">ǉt@C</th><td width=\"200\">%d</td></tr>\r\n",g.getAddedFileNum());
			writer.printf("<tr><th width=\"400\">폜t@C</th><td width=\"200\">%d</td></tr>\r\n",g.getDeletedFileNum());
			writer.printf("<tr><th width=\"400\">N[܂ރt@C</th><td width=\"200\">%d</td></tr>\r\n",g.getCloneFileNum());
			
			//N[Zbgꗗ
			writer.printf("<tr bgcolor=\"#D1D168\"><th colspan=\"2\">N[Zbgޏ</th></tr>\r\n");	
			writer.printf("<tr><th width=\"400\">N[Zbg</th><td width=\"200\">%d</td></tr>\r\n",g.getCloneSetNum());
			writer.printf("<tr><th width=\"400\"><a href=\"%s#stable\">STABLEN[Zbg</a></th><td width=\"200\">%d</td></tr>\r\n",CLONESETLIST_PAGE,g.getStableCloneSetNum());
			writer.printf("<tr><th width=\"400\"><a href=\"%s#changed\">CHANGEDN[Zbg</a></th><td width=\"200\">%d</td></tr>\r\n",CLONESETLIST_PAGE,g.getChangedCloneSetNum());
			writer.printf("<tr><th width=\"400\"><a href=\"%s#new\">NEWN[Zbg</a></th><td width=\"200\">%d</td></tr>\r\n",CLONESETLIST_PAGE,g.getNewCloneSetNum());
			writer.printf("<tr><th width=\"400\"><a href=\"%s#deleted\">DELETEDN[Zbg</a></th><td width=\"200\">%d</td></tr>\r\n",CLONESETLIST_PAGE,g.getDeletedCloneNum());
			
			//N[ꗗ
			writer.printf("<tr bgcolor=\"D1D168\"><th colspan=\"2\">R[hN[ޏ</th></tr>\r\n");	
			writer.printf("<tr><th width=\"400\">R[hN[</th><td width=\"200\">%d</td></tr>\r\n",g.getCloneNum());
			writer.printf("<tr><th width=\"400\">STABLEN[</th><td width=\"200\">%d</td></tr>\r\n",g.getStableCloneNum());
			writer.printf("<tr><th width=\"400\">MODIFIEDN[</th><td width=\"200\">%d</td></tr>\r\n",g.getModifiedCloneNum());
			writer.printf("<tr><th width=\"400\">MOVEDN[</th><td width=\"200\">%d</td></tr>\r\n",g.getMovedCloneNum());
			writer.printf("<tr><th width=\"400\">ADDEDN[</th><td width=\"200\">%d</td></tr>\r\n",g.getAddedCloneNum());
			writer.printf("<tr><th width=\"400\">DELETEDN[</th><td width=\"200\">%d</td></tr>\r\n",g.getDeletedCloneNum());
								
			writer.printf("</table>\n");			
			writer.printf("</body>\n");
			writer.printf("</html>\n");	
			
			writer.flush();
			writer.close();

		} catch (IOException e) {
			return false;
		}	
		
		return true;
		
	}

	
	/**
	 * </p>N[Zbgꗗy[W</p>
	 * @param g	OutputGeneratorIuWFNg
	 * @param dir o̓fBNg
	 * @param project@ProjectIuWFNg
	 * @return	<ul>
	 * 				<li>̏ꍇ - true</li>
	 *				<li>s̏ꍇ - false</li>
	 * 			</ul>
	 */
	private static boolean generateCloneSetListPage(OutputGenerator g, String dir, Project project) {
		try {
			PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(dir+"\\"+CLONESETLIST_PAGE)));
			
			//wb_o
			outputHtmlHead(writer,project.getName()+"-N[Zbgꗗ");
			
			//^Cgo
			writer.printf("<a href=\"../%s\">%sN%s%s</a>\r\n", INDEX_PAGE, g.getYear(), g.getMonth(), g.getDay());
			writer.printf("<h1>vWFNgF<a href=\"%s\">%s</a></h1>\r\n",INDEX_PAGE,project.getName());
			
			writer.printf("<h2>N[ZbgXg</h2>\r\n");
			writer.printf("<center>\r\n");			
			
			
			
			
			if(project.getCloneSetList().isEmpty()){
				writer.printf("<hr>\r\n");
				writer.printf("N[Zbg݂͑܂\r\n ");					
			}else{			
				
				writer.printf("<hr>\r\n");
				
				//N[Zbgꗗ
				writer.printf("<table border=\"1\" class=\"sortable\" id=\"sorter\">\r\n");
				writer.printf("<tr>\r\n");
				writer.printf("<th bgcolor=\"gainsboro\" class=\"nosort\">ID</th>\r\n");
				writer.printf("<th ></th>\r\n");
				writer.printf("<th >LEN</th>\r\n");
				writer.printf("<th>POP</th>\r\n");
				writer.printf("<th>NIF</th>\r\n");
				writer.printf("<th>RAD</th>\r\n");
				writer.printf("<th>RNR</th>\r\n");
				writer.printf("<th>TKS</th>\r\n");
				writer.printf("<th>LOOP</th>\r\n");
				writer.printf("<th>COND</th>\r\n");
				writer.printf("<th>McCabe</th>\r\n");
				writer.printf("</tr>\r\n");
				for(CloneSet cloneSet: project.getCloneSetList()){
					writer.printf("<tr bgcolor=\"%s\">\r\n",getCloneSetColor(cloneSet));
					writer.printf("<td><a href=\"cloneset.html#cloneset%d\">%d</a></td>\r\n",cloneSet.getOutputId(),cloneSet.getOutputId());
					writer.printf("<td>%s</td>\r\n",cloneSet.getCategoryString());
					writer.printf("<td>%d</td>\r\n",cloneSet.getLEN());
					writer.printf("<td>%d</td>\r\n",cloneSet.getPOP());
					writer.printf("<td>%d</td>\r\n",cloneSet.getNIF());
					writer.printf("<td>%d</td>\r\n",cloneSet.getRAD());
					writer.printf("<td>%f</td>\r\n",cloneSet.getRNR());
					writer.printf("<td>%d</td>\r\n",cloneSet.getTKS());
					writer.printf("<td>%d</td>\r\n",cloneSet.getLOOP());
					writer.printf("<td>%d</td>\r\n",cloneSet.getCOND());
					writer.printf("<td>%d</td>\r\n",cloneSet.getMcCabe());
					writer.printf("</tr>\r\n");					
				}
				writer.printf("</table>\r\n");
				writer.printf("<hr>\r\n");
				
				
				writer.printf("<h2 id=\"new\">New Clone Set</h2>\r\n");
				if(g.getNewCloneSetNum()==0){
					writer.printf("New Clone Set ݂͑܂\r\n ");										
				}else{
					for(CloneSet cloneSet: project.getCloneSetList()){	
						if(cloneSet.getCategory()==CloneSet.NEW)
							outputCloneSet(writer,project,cloneSet);
					}				
				}
				
				writer.printf("<hr>\r\n");
				writer.printf("<h2 id=\"changed\">Changed Clone Set</h2>\r\n");
				if(g.getChangedCloneSetNum()==0){
					writer.printf("Changed Clone Set ݂͑܂\r\n ");										
				}else{
					for(CloneSet cloneSet: project.getCloneSetList()){	
						if(cloneSet.getCategory()==CloneSet.CHANGED)
							outputCloneSet(writer,project,cloneSet);
					}				
				}
				
				writer.printf("<hr>\r\n");
				writer.printf("<h2 id=\"deleted\">Deleted Clone Set</h2>\r\n");
				if(g.getDeletedCloneSetNum()==0){
					writer.printf("Deleted Clone Set  ݂͑܂\r\n ");										
				}else{
					for(CloneSet cloneSet: project.getCloneSetList()){	
						if(cloneSet.getCategory()==CloneSet.DELETED)
							outputCloneSet(writer,project,cloneSet);
					}				
				}
				
				writer.printf("<hr>\r\n");
				writer.printf("<h2 id=\"stable\">Stable Clone Set</h2>\r\n");
				if(g.getStableCloneSetNum()==0){
					writer.printf("Stable Clone Set݂͑܂\r\n ");										
				}else{
					for(CloneSet cloneSet: project.getCloneSetList()){	
						if(cloneSet.getCategory()==CloneSet.STABLE)
							outputCloneSet(writer,project,cloneSet);
					}				
				}			
			}
			
			writer.printf("\t <script type=\"text/javascript\"> \r\n");
			writer.printf("\t var sorter=new table.sorter(\"sorter\");\r\n");
			writer.printf("\t sorter.init(\"sorter\",1); \r\n");
			writer.printf("\t </script> \r\n");
			writer.printf("</body>\r\n");
			writer.printf("</html>\r\n");	
			
			writer.flush();
			writer.close();			
			
			return true;
		} catch (IOException e) {
			return false;
		}
		
	}
	
	/**
	 * <p>N[Zbg̃R[hN[ꗗo</p>
	 * @param writer	PrintWriterIuWFNg
	 * @param project	ProjectIuWFNg
	 * @param cloneSet	CloneSetIuWFNg
	 */
	private static void outputCloneSet(PrintWriter writer, Project project, CloneSet cloneSet) {
		
		//N[ꗗ^O̕\
		writer.printf("<hr>\r\n");
		writer.printf("<table id=\"cloneset%d\" border=\"1\">\r\n",cloneSet.getOutputId());
		writer.printf("<tr><th bgcolor=\"%s\" colspan=\"4\">N[ZbgID:%d</th></tr>\r\n",getCloneSetColor(cloneSet),cloneSet.getOutputId());
		writer.printf("<tr bgcolor=\"lightgrey\">\r\n");
		writer.printf("<th width=\"50\">ID</th>\r\n");
		writer.printf("<th width=\"100\"></th>\r\n");
		writer.printf("<th width=\"720\">t@C</th>\r\n");
		writer.printf("<th width=\"120\">ʒu</th>\r\n");
		writer.printf("</tr>\r\n");
		
		//N[ꗗo
		for(Clone clone: cloneSet.getNewCloneList()){
			writer.printf("<tr bgcolor=\"%s\">\r\n",getCloneColor(clone));
			writer.printf("<td><a href=\"%s#clone%d\">%d.%d</a></td>\r\n",
					clone.getFile().getName().replace("\\","/")+".html",clone.getId(),cloneSet.getOutputId(),clone.getOutputId());
			writer.printf("<td>%s</td>\r\n",clone.getCategoryString());
			writer.printf("<td>%s</td>\r\n",clone.getFile().getName());
			writer.printf("<td>%d.%d-%d.%d</td>\n",clone.getStartLine(),clone.getStartColumn(),clone.getEndLine(),clone.getEndColumn ());
			writer.printf("</tr>\n");		
		}		

	
		if(cloneSet.containsOldClone())
			writer.printf("<tr><th colspan=\"4\">Oo[W̃R[hN[</th></tr>\r\n");
		
		//N[o
		for(Clone clone: cloneSet.getOldCloneList()){			
			if(clone.getCategory()==Clone.DELETED || clone.getCategory()==Clone.MOVED){
				if(clone.getCategory()==Clone.MOVED)
					clone=clone.getChildClone();					
				writer.printf("<tr bgcolor=\"%s\">\r\n",getCloneColor(clone));
				writer.printf("<td><a href=\"%s#clone%d\">%d.%d</a></td>\r\n",
						clone.getFile().getName().replace("\\","/")+".html",clone.getId(),cloneSet.getOutputId(),clone.getOutputId());
				writer.printf("<td>%s</td>\r\n",clone.getCategoryString());
				writer.printf("<td>%s</td>\r\n",clone.getFile().getName());
				writer.printf("<td>%d.%d-%d.%d</td>\n",clone.getStartLine(),clone.getStartColumn(),clone.getEndLine(),clone.getEndColumn ());
				writer.printf("</tr>\n");	
			}
		}
		writer.printf("</table>\n");
		
	}


	/**
	 * <p>pbP[WXg̐</p>
	 * @param g	OutputGeneratorIuWFNg
	 * @param dir@o̓fBNg
	 * @param project@ProjectIuWFNg
	 * @return	<ul>
	 * 				<li>̏ꍇ - true</li>
	 *				<li>s̏ꍇ - false</li>
	 * 			</ul>
	 */
	private static boolean generatePackageListPage(OutputGenerator g, String dir, Project project) {
		
		try {
			PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(dir+"/"+PACKAGELIST_PAGE)));
		
			//wb_o
			outputHtmlHead(writer,project.getName() + "-fBNgipbP[Wjꗗ");
			
			//^Cgo
			writer.printf("<a href=\"../%s\">%sN%s%s</a>\r\n",INDEX_PAGE,g.getYear(),g.getMonth(),g.getDay());
			writer.printf("<h1>vWFNgF<a href=\"%s\">%s</a></h1>\r\n",INDEX_PAGE,project.getName());
			writer.printf("<h2>fBNgipbP[Wjꗗ</h2>\r\n");			
			writer.printf("<hr>\r\n");
			writer.printf("<center>\r\n");
			
			//pbP[Wꗗ
			writer.printf("<table border=\"1\" width=\"500\">\n");
			writer.printf("<tr><th bgcolor=\"greenyellow\">fBNgipbP[Wjꗗ</th></tr>\n");
			
			ArrayList<String> packageList = new ArrayList<String>();
			boolean flag = false;
			for(SourceFile file: project.getFileList()){				
				if(!file.getNewCloneList().isEmpty() || !file.getOldCloneList().isEmpty()){						
					
					flag = true;
				
					String fileName;
					if(file.getState() != SourceFile.DELETED) fileName = (new File(file.getNewPath())).getName();
					else fileName = (new File(file.getOldPath())).getName();
					
					//fBNg
					String packageDirPath = dir + "\\"+file.getName();
					packageDirPath = packageDirPath.replace("\\"+fileName,"");
					File packageDir = new File(packageDirPath);
					if(!packageList.contains(packageDirPath.toString())){
						packageList.add(packageDirPath.toString());
						packageDir.mkdirs();
						writer.printf("<tr><td><a href=\"%s\">%s</a></td></tr>\r\n",
								packageDirPath.replace(dir,"").replace("\\","/").substring(1)+"/"+INDEX_PAGE,
								packageDirPath.replace(dir,"").substring(1));
					}
				
					
					
					//\[XR[h̐
					if(file.getState()==SourceFile.ADDED)
						generateAddedSourceFile(g,file, packageDirPath+"\\"+fileName+".html",project.getName());
					else if(file.getState()==SourceFile.NORMAL)
						generateNormalSourceFile(g,file,packageDirPath+"\\"+fileName+".html",project.getName());
					else if(file.getState()==SourceFile.DELETED)
						generateDeletedSourceFile(g,file, packageDirPath+"\\"+fileName+".html",project.getName());
					
				}			
			}
			
			//t@C݂Ȃꍇ
			if(!flag)
				writer.printf("<tr><td>N[܂ރfBNgipbP[W݂͑܂j</td></tr>\r\n");
								
			writer.printf("</table>\r\n");			
			writer.printf("</body>\r\n");
			writer.printf("</html>\r\n");	
			
			writer.flush();
			writer.close();
			
			return true;
		} catch (IOException e) {
			return false;
		}			
	}
	
	/**
	 * <p>\[Xt@C̐</p>
	 * @param g	OutputGeneratorIuWFNg
	 * @param file o͑Ώۃ\[Xt@C
	 * @param fileName o̓t@C
	 * @param projectName vWFNg
	 * @return	<ul>
	 * 				<li>̏ꍇ - true</li>
	 *				<li>s̏ꍇ - false</li>
	 * 			</ul>
	 */
	private static boolean generateNormalSourceFile(OutputGenerator g, SourceFile file, String fileName, String projectName) {
		
		BufferedReader readerA = null,readerB=null;
		try{
			readerA = new BufferedReader(new InputStreamReader(new FileInputStream(file.getNewPath())));
			readerB = new BufferedReader(new InputStreamReader(new FileInputStream(file.getOldPath())));
			PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));
			
			String lineA,lineB;
			int countClone=0;
			int lineNumA=0,lineNumB=0;
			int addCodeId=0,deleteCodeId=0;
			
			//wb_o
			String cloneSetFile = outputHtmlHead(g,writer,file,projectName);
			
			//\[XR[ho
			writer.printf("<table cellpadding=\"0\">\r\n");
			writer.printf("<tr><td width=\"50\"></td><td width=\"50\"></td><td></td></tr>\r\n");
			while(true){
				if((lineA = readerA.readLine())!=null)	lineNumA++;
				if((lineB = readerB.readLine())!=null)	lineNumB++;
				
				//ǉR[h̏ꍇ
				while(addCodeId<file.getAddedCodeList().size() &&lineNumA == file.getAddedCodeList().get(addCodeId)){
					addCodeId++;				
					countClone = countClone + outputCloneStartSign(writer,file.getNewCloneList(),lineNumA,false,cloneSetFile);		
					writeCodeLine(writer,Integer.toString(lineNumA),"+",lineA,countClone);
					countClone = countClone - writeCloneEndSign(writer,file.getNewCloneList(),lineNumA,false);			
					if((lineA = readerA.readLine())!=null)
						lineNumA++;										
				}
				
				//폜R[h̏ꍇ
				while(deleteCodeId<file.getDeletedCodeList().size()&& lineNumB == file.getDeletedCodeList().get(deleteCodeId)){
					deleteCodeId++;
					countClone = countClone + outputCloneStartSign(writer,file.getOldCloneList(),lineNumB,true,cloneSetFile);						
					writeCodeLine(writer,"","-",lineB,countClone);
					countClone = countClone - writeCloneEndSign(writer,file.getOldCloneList(),lineNumB,true);				
					if((lineB = readerB.readLine())!=null)
						lineNumB++;					
				}	
				
				if(lineA==null && lineB==null){
					break;
				}else{
					countClone = countClone + outputCloneStartSign(writer,file.getNewCloneList(),lineNumA,false,cloneSetFile);	
					countClone = countClone + outputCloneStartSign(writer,file.getOldCloneList(),lineNumB,true,cloneSetFile);	
					writeCodeLine(writer,Integer.toString(lineNumA),"",lineA,countClone);
					countClone = countClone - writeCloneEndSign(writer,file.getNewCloneList(),lineNumA,false);	
					countClone = countClone - writeCloneEndSign(writer,file.getOldCloneList(),lineNumB,true);	
				}
			}
			
			writer.printf("</table>\n");			
			writer.printf("</body>\n");
			writer.printf("</html>\n");	
			
			writer.flush();
			writer.close();
			
			if(readerA!=null)	readerA.close();
			if(readerB!=null)	readerB.close();
			
			return true;
		}catch (IOException e) {			
			return false;
		}
		
	}
	
	/**
	 * <p>ǉ\[Xt@C̐</p>
	 * @param g	OutputGeneratorIuWFNg
	 * @param file o͑Ώۃ\[Xt@C
	 * @param fileName o̓t@C
	 * @param projectName vWFNg
	 * @return	<ul>
	 * 				<li>̏ꍇ - true</li>
	 *				<li>s̏ꍇ - false</li>
	 * 			</ul>
	 */
	private static boolean generateAddedSourceFile(OutputGenerator g, SourceFile file, String fileName, String projectName) {
		try {
			
			BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file.getNewPath())));
			PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));
			
			int countClone=0;
			String line;
			int lineNum=0;
			
			//wb_o
			String cloneSetFile = outputHtmlHead(g,writer,file,projectName);

			//\[XR[ho
			writer.printf("<table cellpadding=\"0\">\r\n");
			writer.printf("<tr><td width=\"50\"></td><td width=\"50\"></td><td></td></tr>\r\n");
			while((line=reader.readLine())!=null){
				lineNum++;
				countClone = outputCloneStartSign(writer,file.getNewCloneList(),lineNum,false,cloneSetFile)+countClone;						
				writeCodeLine(writer,Integer.toString(lineNum),"+",line,countClone);
				countClone = countClone-writeCloneEndSign(writer,file.getNewCloneList(),lineNum,false);			
			}
			writer.printf("</table>\r\n");			
			writer.printf("</body>\r\n");
			writer.printf("</html>\r\n");	
			
			writer.flush();
			writer.close();
			if(reader!=null)	reader.close();
			
			return true;
		} catch (IOException e) {			
			return false;
		}	
	}
	
	/**
	 * <p>폜\[Xt@C̐</p>
	 * @param g	OutputGeneratorIuWFNg
	 * @param file o͑Ώۃ\[Xt@C
	 * @param fileName o̓t@C
	 * @param projectName vWFNg
	 * @return	<ul>
	 * 				<li>̏ꍇ - true</li>
	 *				<li>s̏ꍇ - false</li>
	 * 			</ul>
	 */
	private static boolean generateDeletedSourceFile(OutputGenerator g, SourceFile file, String fileName, String projectName) {
		try {
			
			BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file.getOldPath())));
			PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));
			
			String line;
			int lineNum=0;
			int countClone=0;
			
			//wb_o
			String cloneSetFile = outputHtmlHead(g,writer,file,projectName);
								
			//\[XR[ho
			writer.printf("<table cellpadding=\"0\">\r\n");
			writer.printf("<tr><td width=\"50\"></td><td width=\"50\"></td><td></td></tr>\r\n");
			while((line=reader.readLine())!=null){
				lineNum++;
				//\[XR[hPso
				countClone = countClone + outputCloneStartSign(writer,file.getOldCloneList(),lineNum,true,cloneSetFile);						
				writeCodeLine(writer,Integer.toString(lineNum),"-",line,countClone);
				countClone = countClone - writeCloneEndSign(writer,file.getOldCloneList(),lineNum,true);			
			}
			writer.printf("</table>\r\n");			
			writer.printf("</body>\r\n");
			writer.printf("</html>\r\n");	
			
			writer.flush();
			writer.close();
			if(reader!=null)	reader.close();
			
			return true;
		} catch (IOException e) {			
			return false;
		}	
	}
	
	
	/**
	 * <p>Indexy[W̐</p>
	 * @param project ProjectIuWFNg
	 * @return	<ul>
	 * 				<li>̏ꍇ - true</li>
	 *				<li>s̏ꍇ - false</li>
	 * 			</ul>
	 */
	private static boolean generateDateListPage(Project project){
		
		//index.html̍폜
		File index = new File(project.getGenerateHTMLDir()+"\\"+INDEX_PAGE);
		if(index.exists())
			index.delete();		

		//indext@C
		try{
			
			PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(project.getGenerateHTMLDir()+"\\"+INDEX_PAGE)));
			File[] dateList = (new File(project.getGenerateHTMLDir())).listFiles();
			
			//^Cgo
			outputHtmlHead(writer,"R[hN[ύXǗVXe");
			writer.println("<h1>R[hN[ύXǗVXe</h1>");
			writer.println("<h1>̓vWFNgF"+project.getName()+"</h1>");
			writer.println("<hr>");
			writer.println("<center>");
			
			//͓ꗗ
			writer.println("<table border=\"1\">");
			writer.println("<tr bgcolor=\"greenyellow\"><th>͓ꗗ</th></tr>");			
			for(int i=0; i<dateList.length; i++){	
				String date = dateList[i].getName();
				if(dateList[i].isDirectory() && i < STACK && date.length()==8){					
					writer.printf("<tr><td><a href = \"%s\">%c%c%c%cN%c%c%c%c</a></td></tr>\n",
							date+"/"+INDEX_PAGE, date.charAt(0),date.charAt(1),date.charAt(2),date.charAt(3),date.charAt(4),date.charAt(5),date.charAt(6),date.charAt(7));	
				}else{
					if(!dateList[i].getName().equals(SCRIPT) && !dateList[i].getName().equals(Def.IMAGE))
						deleteDir(dateList[i].toString());	
				}
			}	
			writer.println("</table>");
			writer.println("</html>");
			
			writer.flush();
			writer.close();
		}catch (IOException e) {
			return false;
		}
		return true;
	}
	
	
	/**
	 * <p>\[Xt@Cy[Wꗗ</p>
	 * @param g	OutputGeneratorIuWFNg
	 * @param dir o̓fBNg
	 * @param node m[h
	 * @param indexDir index.html̑Έʒu 
	 * @param project ProjectIuWFNg
	 * @return	<ul>
	 * 				<li>̏ꍇ - true</li>
	 *				<li>s̏ꍇ - false</li>
	 * 			</ul>
	 */
	private static boolean generateFileListPage(OutputGenerator g, File dir, int node, String indexDir, Project project) {
		
		File[] files = dir.listFiles();
		
		//\[Xt@C݂邩
		boolean flag = false;
		for(File file: files){
			if(file.isFile())	flag = true;
			else if(file.isDirectory())	generateFileListPage(g,file,node+1,indexDir,project);
		}	
		
		if(flag){
			try {
				PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(dir+"/"+INDEX_PAGE)));
			
				//wb_o
				outputHtmlHead(writer,project.getName()+"-"
						+dir.toString().replace(indexDir,"")+"-\[Xt@Cꗗ");
				
			
				//^Cg̏o
				String projectFile=INDEX_PAGE;
				String projectListFile="../"+INDEX_PAGE;
				for(int i=0; i<node; i++){
					projectFile="../"+projectFile; projectListFile="../"+projectListFile;
				}
				
				writer.printf("<a href=\"%s\">%sN%s%s</a>\r\n",projectListFile,g.getYear(),g.getMonth(),g.getDay());
				writer.printf("<h1>vWFNgF<a href=\"%s\">%s</a></h1>\r\n",projectFile,project.getName());
				writer.printf("<h2>fBNgipbP[WjF%s</h2>\r\n",dir.toString().replace(indexDir,"").substring(1));
				writer.printf("<hr>\r\n");			
				writer.printf("<center>\r\n");
						
				//\[Xt@C̏o
				writer.printf("<table width=\"650\" border=\"1\">\r\n");
				writer.printf("<tr><th bgcolor=\"greenyellow\" colspan=\"3\">N[܂ރ\[Xt@Cꗗ</th></tr>\r\n");
				writer.printf("<tr bgcolor=\"lightgrey\">\r\n");
				writer.printf("<th width=\"400\">t@C</th>\r\n");
				writer.printf("<th width=\"100\">N[</th>\r\n");
				writer.printf("<th width=\"150\">l</th>\r\n");
				writer.printf("</tr>\r\n");
			
				
				for(int i=0; i < files.length; i++){
					if(files[i].isFile() && !files[i].getName().equals(INDEX_PAGE)){	
						SourceFile file = null;					
						for(SourceFile tmpFile:project.getFileList()){	
							if(tmpFile.getName().equals(files[i].toString().replace(indexDir,"").replace(".html","").substring(1))){
								file=tmpFile; break;
							}
						}
						if(file!=null){
							writer.printf("<tr bgcolor=\"%s\">\r\n",getSourceFileColor(file));
							writer.printf("<td><a href=\"%s\">%s</a></td>\r\n",files[i].getName(),files[i].getName().replace(".html",""));
							writer.printf("<td>%d</td>\r\n", file.getNewCloneList().size());
							writer.printf("<td>%s</td>\r\n", getFileState(file));
							writer.println("</tr>\n");
						}
					}
				}
						
				writer.printf("</table>\n");			
				writer.printf("</body>\n");
				writer.printf("</html>\n");
			
				writer.flush();
				writer.close();
			
			} catch (IOException e) {
				return false;
			}	
		}
		return true;
	}
	
	/**
	 * <p>N[JnTC̏o</p>
	 * @param writer
	 * @param cloneList
	 * @param line
	 * @param oldCloneFlag
	 * @param cloneSetFile
	 * @return	<ul>
	 * 				<li>̏ꍇ - true</li>
	 *				<li>s̏ꍇ - false</li>
	 * 			</ul>
	 */
	private static int outputCloneStartSign(PrintWriter writer, ArrayList<Clone> cloneList, int line, boolean oldCloneFlag,String cloneSetFile) {
		int count = 0;
		for(Clone clone:cloneList){
			if((oldCloneFlag && clone.getCategory()==Clone.DELETED) || !oldCloneFlag){
				if(clone.getStartLine()==line && clone.getOutputId()!=Clone.NULL){
					writer.printf("<tr id=\"clone%d\" ><th></th><th></th>",clone.getId());
					writer.printf("<th align=\"left\">[START CLONE:<a href=\"%s#cloneset%d\">%d.%d(%sN[)</a>]</th></tr>",
							cloneSetFile,clone.getCloneSet().getOutputId(),clone.getCloneSet().getOutputId(),clone.getOutputId(),clone.getCategoryString());
					writer.println();	
					count++;
				}
			}
		}
		return count;
	}

	/**
	 * <p>N[ITC̏o</p>
	 * @param writer
	 * @param cloneList
	 * @param line
	 * @param oldCloneFlag
	 * @return	<ul>
	 * 				<li>̏ꍇ - true</li>
	 *				<li>s̏ꍇ - false</li>
	 * 			</ul>
	 */
	private static int writeCloneEndSign(PrintWriter writer, ArrayList<Clone> cloneList, int line, boolean oldCloneFlag) {
		int count = 0;
		for(Clone clone:cloneList){
			if(!oldCloneFlag || (oldCloneFlag && clone.getCategory() ==Clone.DELETED)){
				if(clone.getEndLine()==line && clone.getOutputId()!=Clone.NULL){
					writer.printf("<tr><th></th><th></th>");
					writer.printf("<th  align=\"left\">[END ID:%d.%d]</th></tr>",clone.getCloneSet().getOutputId(),clone.getOutputId());
					writer.println();
					count++;
				}
			}
		}			
		return count;
	}	
	
	/**
	 * <p>\[XR[h1so</p>
	 * @param writer
	 * @param lineNum
	 * @param state
	 * @param line
	 */
	private static void writeCodeLine(PrintWriter writer,String lineNum, String state, String line,int count) {
		writer.printf("<tr>\r\n");
		writer.printf("<th align=\"left\">%s</th>\r\n",lineNum);
		writer.printf("<th align=\"left\">%s</th>\r\n",state);
		if(count>0 && state.equals("-"))
			writer.printf("<td bgcolor=\"F2D500\"><xmp>%s</xmp></td>\r\n",line);
		else if(count>0)
			writer.printf("<td bgcolor=\"yellow\"><xmp>%s</xmp></td>\r\n",line);
		else if(state.equals("-"))
			writer.printf("<td bgcolor=\"tan\"><xmp>%s</xmp></td>\r\n",line);
		else
			writer.printf("<td><xmp>%s</xmp></td>\r\n",line);
		writer.println("</tr>");		
	}
	
	/**
	 * <p>fBNg폜</p>
	 * @param dir
	 */
	private static void deleteDir(String dir){
		File file = new File(dir);
		if(file.exists()){
			if(file.isDirectory()){
				File[] f=file.listFiles();
				for(int i=0; i<f.length; i++)
					deleteDir(f[i].toString());			
			}
			file.delete();
		}			
	}
	
	/**
	 * <p>N[ZbgJ[̎擾</p>
	 * @param cloneSet
	 * @return N[ZbgJ[
	 */
	private static String getCloneSetColor(CloneSet cloneSet) {
		switch(cloneSet.getCategory()){
			case CloneSet.NEW: return "orange";
			case CloneSet.CHANGED: return "greenyellow";
			case CloneSet.DELETED: return "tan";
			default: return "white";
		}					
	}
	
	/**
	 * <p>N[J[̎擾</p>
	 * @param clone
	 * @return N[J[
	 */
	private static String getCloneColor(Clone clone) {
		switch(clone.getCategory()){
			case Clone.ADDED: return "#FFCCE5";
			case Clone.DELETED: return "#DBC7AC";
			case Clone.MOVED: return "#EFEFA7";
			case Clone.MODIFIED: return "#B2D6FF";
			default: return "white";
		}					
	}
	
	/**
	 * <p>\[Xt@CJ[̎擾</p>
	 * @param file
	 * @return \[Xt@CJ[
	 */
	private static String getSourceFileColor(SourceFile file) {
		switch(file.getState()){
			case SourceFile.ADDED: return "orange";
			case SourceFile.DELETED: return "tan";
			default: return "white";
		}			
	}

	/**
	 * \[Xt@C̎擾
	 * @param file
	 * @return - \[Xt@C
	 */
	private static String getFileState(SourceFile file) {
		switch(file.getState()){
			case SourceFile.ADDED: return "ǉt@C";
			case SourceFile.DELETED: return "폜t@C";
			default: return " ";
		}	
	}
		
	 /**
	 * <p>HTMLwb_o</p>
	 * @param writer
	 * @param title
	 */	
	private static void outputHtmlHead(PrintWriter writer, String title){
		writer.println("<html>");
		writer.println("<head>");
		writer.println("\t<title>"+title+"</title>");
		writer.printf("\t<style type=\"text/css\">\r\n");
		writer.printf("\t\t.sortable .head {background:gainsboro url(../image/sort.gif) 6px  center no-repeat; cursor:pointer; padding-left:18px}\r\n");
		writer.printf("\t\t.sortable .desc {background:darkgray url(../image/desc.gif) 6px   center no-repeat; cursor:pointer; padding-left:18px}\r\n");
		writer.printf("\t\t.sortable .asc {background:darkgray  url(../image/asc.gif) 6px  center no-repeat; cursor:pointer; padding-left:18px}\r\n");
		writer.printf("\t\t.sortable .head:hover, .sortable .desc:hover, .sortable .asc:hover {color:white}\r\n");
		writer.printf("\t</style>\r\n");
		writer.println("<script type=\"text/javascript\" src=\"../script.js\"></script>");
		writer.println("</head>");
		writer.println("<body>");		
	}

	/**
	 * <p>HTMLwb_o(\[Xt@C̏ꍇ)</p>
	 * @param writer
	 * @param file
	 * @return N[ZbgꗗHTMLt@C
	 */
	private static String outputHtmlHead(OutputGenerator g,PrintWriter writer, SourceFile file, String projectName){
		writer.printf("<html>\r\n");
		writer.printf("<head>\n");
		writer.printf("\t<title>%s-%s</title>\r\n",projectName,file.getName());
		writer.printf("\t<style type=\"text/css\">\r\n");
		writer.println("\t\t td,th {font-size:12px}");
		writer.printf("\t\t td xmp {margin:0}\r\n");
		writer.printf("\t</style>\r\n");
		writer.printf("</head>\r\n");
		writer.printf("<body>\r\n");		
		
		String projectListFile="../"+INDEX_PAGE;
		String projectFile=INDEX_PAGE;
		String cloneSetFile=CLONESETLIST_PAGE;
		
		//Kw̌vZ
		String[] tmp = file.getName().split("\\\\");
		for(int i=0; i<tmp.length-1; i++){
			projectFile="../"+projectFile;
			cloneSetFile="../"+cloneSetFile; 
			projectListFile="../"+projectListFile;				
		}
		
		//^Cgo
		writer.printf("<a href=\"%s\">%sN%s%s</a>\r\n",projectListFile,g.getYear(),g.getMonth(),g.getDay());	
		writer.printf("<h1>vWFNgF<a href=\"%s\">%s</a></h1>\r\n",projectFile,projectName);
		writer.printf("<h2>\[Xt@CF%s</h2>\r\n",file.getName());
		writer.printf("<h4><a href=\"%s\">\[Xt@Cꗗ֖߂</a></h4>\r\n",INDEX_PAGE);
		writer.printf("<hr>\r\n");
		
		return cloneSetFile;
	
	}
}
