%% -------------------------------------------------------------------
%%
%% Copyright (c) 2014-15 Basho Technologies, Inc.  All Rights Reserved.
%%
%%   This Source Code Form is subject to the terms of the Mozilla Public
%%   License, v. 2.0. If a copy of the MPL was not distributed with this
%%   file, You can obtain one at http://mozilla.org/MPL/2.0/.
%%
%% -------------------------------------------------------------------

%% @private
-module(cloudi_x_exometer_core_sup).

-behaviour(supervisor).

%% API
-export([start_link/0]).

%% Supervisor callbacks
-export([init/1]).

%% Helper macro for declaring children of supervisor
-define(CHILD(I, Type), {I, {I, start_link, []}, permanent, 5000, Type, [I]}).

%% ===================================================================
%% API functions
%% ===================================================================

start_link() ->
    supervisor:start_link({local, ?MODULE}, ?MODULE, []).

%% ===================================================================
%% Supervisor callbacks
%% ===================================================================

init([]) ->
    Children0 = [
		 ?CHILD(cloudi_x_exometer_admin, worker),
		 ?CHILD(cloudi_x_exometer_cache, worker),
		 ?CHILD(cloudi_x_exometer_report, worker),
		 ?CHILD(cloudi_x_exometer_report_logger_sup, supervisor),
		 ?CHILD(cloudi_x_exometer_folsom_monitor, worker),
		 ?CHILD(cloudi_x_exometer_alias, worker)
		],
    {ok, {{one_for_one, 5, 10}, Children0}}.
