%-*-Mode:erlang;coding:utf-8;tab-width:4;c-basic-offset:4;indent-tabs-mode:()-*-
% ex: set ft=erlang fenc=utf-8 sts=4 ts=4 sw=4 et nomod:
%%%------------------------------------------------------------------------
%%% @doc
%%% ==syslog Socket Tests==
%%% @end
%%%
%%% MIT License
%%%
%%% Copyright (c) 2016-2017 Michael Truog <mjtruog at gmail dot com>
%%%
%%% Permission is hereby granted, free of charge, to any person obtaining a
%%% copy of this software and associated documentation files (the "Software"),
%%% to deal in the Software without restriction, including without limitation
%%% the rights to use, copy, modify, merge, publish, distribute, sublicense,
%%% and/or sell copies of the Software, and to permit persons to whom the
%%% Software is furnished to do so, subject to the following conditions:
%%%
%%% The above copyright notice and this permission notice shall be included in
%%% all copies or substantial portions of the Software.
%%%
%%% THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
%%% IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
%%% FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
%%% AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
%%% LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
%%% FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
%%% DEALINGS IN THE SOFTWARE.
%%%
%%% @author Michael Truog <mjtruog [at] gmail (dot) com>
%%% @copyright 2016-2017 Michael Truog
%%% @version 1.7.1 {@date} {@time}
%%%------------------------------------------------------------------------

-module(cloudi_x_syslog_socket_SUITE).

%% CT callbacks
-export([all/0,
         groups/0,
         suite/0,
         init_per_suite/1,
         end_per_suite/1,
         group/1,
         init_per_group/2,
         end_per_group/2,
         init_per_testcase/2,
         end_per_testcase/2]).

%% test callbacks
-export([t_facility_1/1,
         t_severity_1/1,
         t_local_output_1/1]).

-include_lib("common_test/include/ct.hrl").

%%%------------------------------------------------------------------------
%%% Callback functions from CT
%%%------------------------------------------------------------------------

all() ->
    [{group, basic_1}].

groups() ->
    [{basic_1, [],
      [t_facility_1,
       t_severity_1]}].

suite() ->
    [{ct_hooks, [cth_surefire]},
     {timetrap, 10100}].

init_per_suite(Config) ->
    {ok, _} = application:ensure_all_started(cloudi_x_syslog_socket),
    Config.

end_per_suite(_Config) ->
    ok = application:stop(cloudi_x_syslog_socket),
    ok.

group(_GroupName) ->
    [].

init_per_group(_GroupName, Config) ->
    Config.

end_per_group(_GroupName, Config) ->
    Config.

init_per_testcase(_TestCase, Config) ->
    Config.

end_per_testcase(_TestCase, Config) ->
    Config.

%%%------------------------------------------------------------------------
%%% test cases
%%%------------------------------------------------------------------------

t_facility_1(_Config) ->
    0  = cloudi_x_syslog_socket:facility(kernel),
    0  = cloudi_x_syslog_socket:facility(kern),
    0  = cloudi_x_syslog_socket:facility(0),
    4  = cloudi_x_syslog_socket:facility(auth0),
    4  = cloudi_x_syslog_socket:facility(auth),
    4  = cloudi_x_syslog_socket:facility(security),
    6  = cloudi_x_syslog_socket:facility(print),
    6  = cloudi_x_syslog_socket:facility(lpr),
    9  = cloudi_x_syslog_socket:facility(clock0),
    9  = cloudi_x_syslog_socket:facility(cron),
    10 = cloudi_x_syslog_socket:facility(auth1),
    10 = cloudi_x_syslog_socket:facility(authpriv),
    13 = cloudi_x_syslog_socket:facility(auth2),
    14 = cloudi_x_syslog_socket:facility(auth3),
    15 = cloudi_x_syslog_socket:facility(clock1),
    23 = cloudi_x_syslog_socket:facility(local7),
    99 = cloudi_x_syslog_socket:facility(99),
    false = cloudi_x_syslog_socket:facility_valid(-1),
    true = cloudi_x_syslog_socket:facility_valid(0),
    true = cloudi_x_syslog_socket:facility_valid(99),
    true = cloudi_x_syslog_socket:facility_valid(clock1),
    false = cloudi_x_syslog_socket:facility_valid(invalid_facility),
    ok.

t_severity_1(_Config) ->
    0 = cloudi_x_syslog_socket:severity(emergency),
    0 = cloudi_x_syslog_socket:severity(emerg),
    0 = cloudi_x_syslog_socket:severity(panic),
    0 = cloudi_x_syslog_socket:severity(0),
    1 = cloudi_x_syslog_socket:severity(alert),
    2 = cloudi_x_syslog_socket:severity(critical),
    2 = cloudi_x_syslog_socket:severity(crit),
    3 = cloudi_x_syslog_socket:severity(error),
    3 = cloudi_x_syslog_socket:severity(err),
    4 = cloudi_x_syslog_socket:severity(warning),
    4 = cloudi_x_syslog_socket:severity(warn),
    5 = cloudi_x_syslog_socket:severity(notice),
    6 = cloudi_x_syslog_socket:severity(informational),
    6 = cloudi_x_syslog_socket:severity(info),
    7 = cloudi_x_syslog_socket:severity(debug),
    7 = cloudi_x_syslog_socket:severity(7),
    false = cloudi_x_syslog_socket:severity_valid(-1),
    true = cloudi_x_syslog_socket:severity_valid(0),
    true = cloudi_x_syslog_socket:severity_valid(7),
    true = cloudi_x_syslog_socket:severity_valid(debug),
    false = cloudi_x_syslog_socket:severity_valid(trace),
    false = cloudi_x_syslog_socket:severity_valid(8),
    ok.

t_local_output_1(_Config) ->
    AppName = "cloudi_x_syslog_socket_SUITE",
    Options = [{protocol, rfc3164},
               {facility, user},
               {app_name, AppName}],
    MessageId = erlang:pid_to_list(self()),
    Message = "Automated Test Message",
    {ok, Pid} = cloudi_x_syslog_socket:start_link(Options),
    ok = cloudi_x_syslog_socket:send(Pid, notice, os:timestamp(),
                            MessageId, Message ++ " 1"),
    ok = cloudi_x_syslog_socket:send(Pid, notice, os:timestamp(), Message ++ " 2"),
    ok = cloudi_x_syslog_socket:send(Pid, notice, os:timestamp(), ""),
    ok = cloudi_x_syslog_socket:stop_link(Pid, 5000),
    receive after 10 -> ok end,
    {ok, SyslogData} = file:read_file("/var/log/syslog"),
    SyslogDataLines = case lists:reverse(binary:split(SyslogData, <<"\n">>,
                                                      [global])) of
        [<<>> | SyslogDataLinesValue] ->
            SyslogDataLinesValue;
        SyslogDataLinesValue ->
            SyslogDataLinesValue
    end,
    [SyslogDataLine3,
     SyslogDataLine2,
     SyslogDataLine1 | _] = SyslogDataLines,
    SyslogDataLine1Str = erlang:binary_to_list(SyslogDataLine1),
    SyslogDataLine2Str = erlang:binary_to_list(SyslogDataLine2),
    SyslogDataLine3Str = erlang:binary_to_list(SyslogDataLine3),
    true = string:str(SyslogDataLine1Str, Message) > 0,
    true = string:str(SyslogDataLine2Str, Message) > 0,
    true = string:str(SyslogDataLine1Str, MessageId) > 0,
    true = string:str(SyslogDataLine1Str, AppName) > 0,
    true = string:str(SyslogDataLine2Str, AppName) > 0,
    true = string:str(SyslogDataLine3Str, AppName) > 0,
    ok.

