%%% @author Andreas Hasselberg <andreas.hasselberg@gmail.com>
%%%
%%% @doc Helper for calling your Elli callback in unit tests.
%%% Only the callback specified is actually run. Elli's response handling is not
%%% used, so the headers will for example not include a content length and the
%%% return format is not standardized.
%%% The unit tests below test `cloudi_x_elli_example_callback'.

-module(cloudi_x_elli_test).

-include("cloudi_x_elli.hrl").

-export([call/5]).

-spec call(Method, Path, Headers, Body, Opts) -> cloudi_x_elli_handler:result() when
      Method  :: cloudi_x_elli:http_method(),
      Path    :: binary(),
      Headers :: cloudi_x_elli:headers(),
      Body    :: cloudi_x_elli:body(),
      Opts    :: proplists:proplist().
call(Method, Path, Headers, Body, Opts) ->
    Callback     = proplists:get_value(callback, Opts),
    CallbackArgs = proplists:get_value(callback_args, Opts),
    Req = cloudi_x_elli_http:mk_req(Method, {abs_path, Path}, Headers,
                           Body, {1, 1}, undefined, {Callback, CallbackArgs}),
    ok  = Callback:handle_event(elli_startup, [], CallbackArgs),
    Callback:handle(Req, CallbackArgs).

-ifdef(TEST).
-include_lib("eunit/include/eunit.hrl").

hello_world_test() ->
    ?assertMatch({ok, [], <<"Hello World!">>},
                 cloudi_x_elli_test:call('GET', <<"/hello/world/">>, [], <<>>,
                                ?EXAMPLE_CONF)),
    ?assertMatch({ok, [], <<"Hello Test1">>},
                 cloudi_x_elli_test:call('GET', <<"/hello/?name=Test1">>, [], <<>>,
                                ?EXAMPLE_CONF)),
    ?assertMatch({ok,
                  [{<<"Content-type">>,
                    <<"application/json; charset=ISO-8859-1">>}],
                  <<"{\"name\" : \"Test2\"}">>},
                 cloudi_x_elli_test:call('GET', <<"/type?name=Test2">>,
                                [{<<"Accept">>, <<"application/json">>}], <<>>,
                                ?EXAMPLE_CONF)).

-endif. %% TEST
