%% Feel free to use, reuse and abuse the code in this file.

%% @private
-module(websocket_app).
-behaviour(application).

%% API.
-export([start/2]).
-export([stop/1]).

%% API.
start(_Type, _Args) ->
	Dispatch = cowboy1_router:compile([
		{'_', [
			{"/", cowboy1_static, {priv_file, websocket, "index.html"}},
			{"/websocket", ws_handler, []},
			{"/static/[...]", cowboy1_static, {priv_dir, websocket, "static"}}
		]}
	]),
	{ok, _} = cowboy1:start_http(http, 100, [{port, 8080}],
		[{env, [{dispatch, Dispatch}]}]),
	websocket_sup:start_link().

stop(_State) ->
	ok.
