-module(cloudi_x_elli_handler).

-optional_callbacks([init/2, preprocess/2, postprocess/3]).

-export_type([callback/0, callback_mod/0, callback_args/0, event/0, result/0]).

%% @type callback(). A tuple of a {@type callback_mod()} and {@type
%% callback_args()}.
-type callback() :: {callback_mod(), callback_args()}.

%% @type callback_mod(). A callback module.
-type callback_mod()  :: module().

%% @type callback_args(). Arguments to pass to a {@type callback_mod()}.
-type callback_args() :: list().

%% @type event(). Fired throughout processing a request.
%% See {@link cloudi_x_elli_example_callback:handle_event/3} for descriptions.
-type event() :: elli_startup
               | bad_request    | file_error
               | chunk_complete | request_complete
               | request_throw  | request_error       | request_exit
               | request_closed | request_parse_error
               | client_closed  | client_timeout
               | invalid_return.

-type result() :: {cloudi_x_elli:response_code() | ok,
                   cloudi_x_elli:headers(),
                   {file, file:name_all()}
                   | {file, file:name_all(), cloudi_x_elli_util:range()}}
                | {cloudi_x_elli:response_code() | ok, cloudi_x_elli:headers(), cloudi_x_elli:body()}
                | {cloudi_x_elli:response_code() | ok, cloudi_x_elli:body()}
                | {chunk, cloudi_x_elli:headers()}
                | {chunk, cloudi_x_elli:headers(), cloudi_x_elli:body()}
                | ignore.

-callback handle(Req :: cloudi_x_elli:req(), callback_args()) -> result().

-callback handle_event(Event, Args, Config) -> ok when
      Event  :: event(),
      Args   :: callback_args(),
      Config :: [tuple()].

-callback init(Req, Args) -> {ok, standard | handover} when
      Req  :: cloudi_x_elli:req(),
      Args :: callback_args().

-callback preprocess(Req1, Args) -> Req2 when
      Req1 :: cloudi_x_elli:req(),
      Args :: callback_args(),
      Req2 :: cloudi_x_elli:req().

-callback postprocess(Req, Res1, Args) -> Res2 when
      Req  :: cloudi_x_elli:req(),
      Res1 :: result(),
      Args :: callback_args(),
      Res2 :: result().
