/* ------------------------------------------------------------------------- */
/*
 *  win32/thread_data.h
 *
 *  Copyright (c) 2004 - 2008, clown. All rights reserved.
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *    - Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *    - Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 *    - No names of its contributors may be used to endorse or promote
 *      products derived from this software without specific prior written
 *      permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 *  TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 *  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 *  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 *  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  Last-modified: Tue 12 Aug 2008 04:10:23 JST
 */
/* ------------------------------------------------------------------------- */
#ifndef CLX_WIN32_THREAD_DATA_H
#define CLX_WIN32_THREAD_DATA_H

#ifdef CLX_USE_BOOST
#include <boost/shared_ptr.hpp>
namespace clx {
	using boost::shared_ptr;
};
#else
#include <tr1/memory>
namespace clx {
	using std::tr1::shared_ptr;
};
#endif // CLX_USE_BOOST

#include <windows.h>
#include "mutex.h"

namespace clx {
	namespace detail {
		class thread_data;
		typedef shared_ptr<thread_data> thread_data_ptr;
		
		class thread_data {
		public:
			HANDLE handle;
			clx::mutex data_mutex;
			bool joined;
			bool active;
			
			thread_data() : handle(), data_mutex(), joined(false), active(false) {}
			virtual ~thread_data() {}
			virtual void run() = 0;
		};
	};
}

#endif // CLX_WIN32_THREAD_DATA_H
