/* ------------------------------------------------------------------------- */
/*
 *  cstring.h
 *
 *  Copyright (c) 2004 - 2008, clown. All rights reserved.
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *    - Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *    - Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 *    - No names of its contributors may be used to endorse or promote
 *      products derived from this software without specific prior written
 *      permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 *  TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 *  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 *  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 *  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  Last-modified: Tue 07 Oct 2008 11:09:00 JST
 */
/* ------------------------------------------------------------------------- */
#ifndef CLX_CSTRING_H
#define CLX_CSTRING_H

#include <cstring>
#include <cstdlib>
#ifdef CLX_USE_WCHAR
#include <cwchar>
#endif // CLX_USE_WCHAR

namespace clx {
	/* --------------------------------------------------------------------- */
	//  strlen
	/* --------------------------------------------------------------------- */
	template <class CharT>
	inline size_t strlen(const CharT* str) {
		return std::strlen(str);
	}
	
	/* --------------------------------------------------------------------- */
	//  strcmp
	/* --------------------------------------------------------------------- */
	template <class CharT>
	inline int strcmp(const CharT* s1, const CharT* s2) {
		return std::strcmp(s1, s2);
	}
	
	/* --------------------------------------------------------------------- */
	//  strncmp
	/* --------------------------------------------------------------------- */
	template <class CharT>
	inline int strncmp(const CharT* s1, const CharT* s2, size_t n) {
		return std::strncmp(s1, s2, n);
	}
	
	/* --------------------------------------------------------------------- */
	//  strcoll
	/* --------------------------------------------------------------------- */
	template <class CharT>
	inline int strcoll(const CharT* s1, const CharT* s2) {
		return std::strcoll(s1, s2);
	}
	
	/* --------------------------------------------------------------------- */
	//  strcpy
	/* --------------------------------------------------------------------- */
	template <class CharT>
	inline CharT* strcpy(CharT* dest, const CharT* src) {
		return std::strcpy(dest, src);
	}
	
	/* --------------------------------------------------------------------- */
	//  strncpy
	/* --------------------------------------------------------------------- */
	template <class CharT>
	inline CharT* strncpy(CharT* dest, const CharT* src, size_t n) {
		return std::strncpy(dest, src, n);
	}
	
	/* --------------------------------------------------------------------- */
	//  strcat
	/* --------------------------------------------------------------------- */
	template <class CharT>
	inline CharT* strcat(CharT* dest, const CharT* src) {
		return std::strcat(dest, src);
	}
	
	/* --------------------------------------------------------------------- */
	//  strncat
	/* --------------------------------------------------------------------- */
	template <class CharT>
	inline CharT* strncat(CharT* dest, const CharT* src, size_t n) {
		return std::strncat(dest, src, n);
	}
	
	/* --------------------------------------------------------------------- */
	//  strchr
	/* --------------------------------------------------------------------- */
	template <class CharT>
	inline const CharT* strchr(const CharT* str, CharT c) {
		return std::strchr(str, c);
	}
	
	template <class CharT>
	inline CharT* strchr(CharT* str, CharT c) {
		return std::strchr(str, c);
	}
	
	/* --------------------------------------------------------------------- */
	//  strrchr
	/* --------------------------------------------------------------------- */
	template <class CharT>
	inline const CharT* strrchr(const CharT* str, CharT c) {
		return std::strrchr(str, c);
	}
	
	template <class CharT>
	inline CharT* strrchr(CharT* str, CharT c) {
		return std::strrchr(str, c);
	}
	
	/* --------------------------------------------------------------------- */
	//  strstr
	/* --------------------------------------------------------------------- */
	template <class CharT>
	inline const CharT* strstr(const CharT* str, const CharT* substr) {
		return std::strstr(str, substr);
	}
	
	template <class CharT>
	inline CharT* strstr(CharT* str, const CharT* substr) {
		return std::strstr(str, substr);
	}
	
	/* --------------------------------------------------------------------- */
	//  strspn
	/* --------------------------------------------------------------------- */
	template <class CharT>
	inline size_t strspn(const CharT* str, const CharT* spanset) {
		return std::strspn(str, spanset);
	}
	
	/* --------------------------------------------------------------------- */
	//  strcspn
	/* --------------------------------------------------------------------- */
	template <class CharT>
	inline size_t strcspn(const CharT* src, const CharT* spanset) {
		return std::strcspn(src, spanset);
	}
	
	/* --------------------------------------------------------------------- */
	//  strpbrk
	/* --------------------------------------------------------------------- */
	template <class CharT>
	inline const CharT* strpbrk(const CharT* str, const CharT* spanset) {
		return std::strpbrk(str, spanset);
	}
	
	template <class CharT>
	inline CharT* strpbrk(CharT* str, const CharT* spanset) {
		return std::strpbrk(str, spanset);
	}
	
	/* --------------------------------------------------------------------- */
	//  strtok
	/* --------------------------------------------------------------------- */
	template <class CharT>
	inline CharT* strtok(CharT* str, const CharT* delimset, CharT** ptr) {
		return std::strtok(str, delimset, ptr);
	}
	
	/* --------------------------------------------------------------------- */
	//  strtol
	/* --------------------------------------------------------------------- */
	template <class CharT>
	inline long int strtol(const CharT* str, CharT** end) {
		return std::strtol(str, end);
	}
	
	/* --------------------------------------------------------------------- */
	//  strtoul
	/* --------------------------------------------------------------------- */
	template <class CharT>
	inline unsigned long int strtoul(const CharT* str, CharT** end) {
		return std::strtoul(str, end);
	}
	
	/* --------------------------------------------------------------------- */
	//  strtod
	/* --------------------------------------------------------------------- */
	template <class CharT>
	inline double strtod(const CharT* str, CharT** end) {
		return std::strtod(str, end);
	}
	
	/* --------------------------------------------------------------------- */
	//  strftime
	/* --------------------------------------------------------------------- */
	template <class CharT>
	inline size_t strftime(CharT* str, size_t n, const CharT* fmt, const tm* tmptr) {
		return std::strftime(str, n, fmt, tmptr);
	}
	
	/* --------------------------------------------------------------------- */
	//  strxfrm
	/* --------------------------------------------------------------------- */
	template <class CharT>
	inline size_t strxfrm(CharT* dest, const CharT* src, size_t n) {
		return std::strxfrm(dest, src, n);
	}
	
	/* --------------------------------------------------------------------- */
	//  memchr
	/* --------------------------------------------------------------------- */
	template <class DataT>
	inline const DataT* memchr(const DataT* mem, DataT c, size_t n) {
		return std::memchr(reinterpret_cast<void*>(mem), static_cast<int>(c), n);
	}
	
	template <class DataT>
	inline DataT* memchr(DataT* mem, DataT c, size_t n) {
		return std::memchr(reinterpret_cast<void*>(mem), static_cast<int>(c), n);
	}
	
	/* --------------------------------------------------------------------- */
	//  memcmp
	/* --------------------------------------------------------------------- */
	template <class DataT>
	inline int memcmp(const DataT* s1, const DataT* s2, size_t n) {
		return std::memcmp(reinterpret_cast<void*>(s1), reinterpret_cast<void*>(s2), n);
	}
	
	/* --------------------------------------------------------------------- */
	//  memcpy
	/* --------------------------------------------------------------------- */
	template <class DataT>
	inline DataT* memcpy(DataT* dest, const DataT* src, size_t n) {
		std::memcpy(reinterpret_cast<void*>(dest), reinterpret_cast<void*>(src), n);
		return dest;
	}
	
	/* --------------------------------------------------------------------- */
	//  memmove
	/* --------------------------------------------------------------------- */
	template <class DataT>
	inline DataT* memmove(DataT* dest, const DataT* src, size_t n) {
		std::memmove(reinterpret_cast<void*>(dest), reinterpret_cast<void*>(src), n);
		return dest;
	}
	
	/* --------------------------------------------------------------------- */
	//  memset
	/* --------------------------------------------------------------------- */
	template <class DataT>
	inline DataT* memset(DataT* str, DataT c, size_t n) {
		std::memset(reinterpret_cast<void*>(str), static_cast<int>(c), n);
		return str;
	}
	
#ifdef CLX_USE_WCHAR
	/* --------------------------------------------------------------------- */
	//  strlen
	/* --------------------------------------------------------------------- */
	template <>
	inline size_t strlen<wchar_t>(const wchar_t* str) {
		return std::wcslen(str);
	}
	
	/* --------------------------------------------------------------------- */
	//  strcmp
	/* --------------------------------------------------------------------- */
	template <>
	inline int strcmp<wchar_t>(const wchar_t* s1, const wchar_t* s2) {
		return std::wcscmp(s1, s2);
	}
	
	/* --------------------------------------------------------------------- */
	//  strncmp
	/* --------------------------------------------------------------------- */
	template <>
	inline int strncmp<wchar_t>(const wchar_t* s1, const wchar_t* s2, size_t n) {
		return std::wcsncmp(s1, s2, n);
	}
	
	/* --------------------------------------------------------------------- */
	//  strcoll
	/* --------------------------------------------------------------------- */
	template <>
	inline int strcoll<wchar_t>(const wchar_t* s1, const wchar_t* s2) {
		return std::wcscoll(s1, s2);
	}
	
	/* --------------------------------------------------------------------- */
	//  strcpy
	/* --------------------------------------------------------------------- */
	template <>
	inline wchar_t* strcpy<wchar_t>(wchar_t* dest, const wchar_t* src) {
		return std::wcscpy(dest, src);
	}
	
	/* --------------------------------------------------------------------- */
	//  strncpy
	/* --------------------------------------------------------------------- */
	template <>
	inline wchar_t* strncpy<wchar_t>(wchar_t* dest, const wchar_t* src, size_t n) {
		return std::wcsncpy(dest, src, n);
	}
	
	/* --------------------------------------------------------------------- */
	//  strcat
	/* --------------------------------------------------------------------- */
	template <>
	inline wchar_t* strcat<wchar_t>(wchar_t* dest, const wchar_t* src) {
		return std::wcscat(dest, src);
	}
	
	/* --------------------------------------------------------------------- */
	//  strncat
	/* --------------------------------------------------------------------- */
	template <>
	inline wchar_t* strncat<wchar_t>(wchar_t* dest, const wchar_t* src, size_t n) {
		return std::wcsncat(dest, src, n);
	}
	
	/* --------------------------------------------------------------------- */
	//  strchr
	/* --------------------------------------------------------------------- */
	template <>
	inline const wchar_t* strchr<wchar_t>(const wchar_t* str, wchar_t c) {
		return std::wcschr(str, c);
	}
	
	template <>
	inline wchar_t* strchr<wchar_t>(wchar_t* str, wchar_t c) {
		return std::wcschr(str, c);
	}
	
	/* --------------------------------------------------------------------- */
	//  strrchr
	/* --------------------------------------------------------------------- */
	template <>
	inline const wchar_t* strrchr<wchar_t>(const wchar_t* str, wchar_t c) {
		return std::wcsrchr(str, c);
	}
	
	template <>
	inline wchar_t* strrchr<wchar_t>(wchar_t* str, wchar_t c) {
		return std::wcsrchr(str, c);
	}
	
	/* --------------------------------------------------------------------- */
	//  strstr
	/* --------------------------------------------------------------------- */
	template <>
	inline const wchar_t* strstr<wchar_t>(const wchar_t* str, const wchar_t* substr) {
		return std::wcsstr(str, substr);
	}
	
	template <>
	inline wchar_t* strstr<wchar_t>(wchar_t* str, const wchar_t* substr) {
		return std::wcsstr(str, substr);
	}
	
	/* --------------------------------------------------------------------- */
	//  strspn
	/* --------------------------------------------------------------------- */
	template <>
	inline size_t strspn<wchar_t>(const wchar_t* str, const wchar_t* spanset) {
		return std::wcsspn(str, spanset);
	}
	
	/* --------------------------------------------------------------------- */
	//  strcspn
	/* --------------------------------------------------------------------- */
	template <>
	inline size_t strcspn<wchar_t>(const wchar_t* src, const wchar_t* spanset) {
		return std::wcscspn(src, spanset);
	}
	
	/* --------------------------------------------------------------------- */
	//  strpbrk
	/* --------------------------------------------------------------------- */
	template <>
	inline const wchar_t* strpbrk<wchar_t>(const wchar_t* str, const wchar_t* spanset) {
		return std::wcspbrk(str, spanset);
	}
	
	template <>
	inline wchar_t* strpbrk<wchar_t>(wchar_t* str, const wchar_t* spanset) {
		return std::wcspbrk(str, spanset);
	}
	
	/* --------------------------------------------------------------------- */
	//  strtok
	/* --------------------------------------------------------------------- */
	template <>
	inline wchar_t* strtok<wchar_t>(wchar_t* str, const wchar_t* delimset, wchar_t** ptr) {
		return std::wcstok(str, delimset, ptr);
	}
	
	/* --------------------------------------------------------------------- */
	//  strtol
	/* --------------------------------------------------------------------- */
	template <>
	inline long int wcstol<wchar_t>(const wchar_t* str, wchar_t** end) {
		return std::wcstol(str, end);
	}
	
	/* --------------------------------------------------------------------- */
	//  strtoul
	/* --------------------------------------------------------------------- */
	template <>
	inline unsigned long int strtoul<wchar_t>(const wchar_t* str, wchar_t** end) {
		return std::wcstoul(str, end);
	}
	
	/* --------------------------------------------------------------------- */
	//  strtod
	/* --------------------------------------------------------------------- */
	template <>
	inline double strtod<wchar_t>(const wchar_t* str, wchar_t** end) {
		return std::wcstod(str, end);
	}
	
	/* --------------------------------------------------------------------- */
	//  strftime
	/* --------------------------------------------------------------------- */
	template <>
	inline size_t strftime<wchar_t>(wchar_t* str, size_t n, const wchar_t* fmt, const tm* tmptr) {
		return std::wcsftime(str, n, fmt, tmptr);
	}
	
	/* --------------------------------------------------------------------- */
	//  strxfrm
	/* --------------------------------------------------------------------- */
	template <>
	inline size_t strxfrm<wchar_t>(wchar_t* dest, const wchar_t* src, size_t n) {
		return std::wcsxfrm(dest, src, n);
	}
	
	/* --------------------------------------------------------------------- */
	//  memchr
	/* --------------------------------------------------------------------- */
	template <>
	inline const wchar_t* memchr<wchar_t>(const wchar_t* mem, wchar_t c, size_t n) {
		return std::wmemchr(mem, c, n);
	}
	
	template <>
	inline wchar_t* memchr<wchar_t>(wchar_t* mem, wchar_t c, size_t n) {
		return std::wmemchr(mem, c, n);
	}
	
	/* --------------------------------------------------------------------- */
	//  memcmp
	/* --------------------------------------------------------------------- */
	template <>
	inline int memcmp<wchar_t>(const wchar_t* s1, const wchar_t* s2, size_t n) {
		return std::wmemcmp(s1, s2, n);
	}
	
	/* --------------------------------------------------------------------- */
	//  memcpy
	/* --------------------------------------------------------------------- */
	template <>
	inline wchar_t* memcpy<wchar_t>(wchar_t* dest, const wchar_t* src, size_t n) {
		return std::wmemcpy(dest, src, n);
	}
	
	/* --------------------------------------------------------------------- */
	//  memmove
	/* --------------------------------------------------------------------- */
	template <>
	inline wchar_t* memmove<wchar_t>(wchar_t* dest, const wchar_t* src, size_t n) {
		return std::wmemmove(dest, src, n);
	}
	
	/* --------------------------------------------------------------------- */
	//  memset
	/* --------------------------------------------------------------------- */
	template <>
	inline wchar_t* memset<wchar_t>(wchar_t* str, wchar_t c, size_t n) {
		return std::wmemset(str, c, n);
	}
#endif // CLX_USE_WCHAR
}

#endif // CLX_CSTRING_H
