#include <iostream>
#include "clx/logger.h"

int main(int argc, char* argv[]) {
    clx::logger::configure(std::cout, clx::loglevel::trace);
    
    clx::logger::trace(TRACEF("Hoge"));
    clx::logger::debug(DEBUGF("Hello, world!"));
    clx::logger::info(INFOF("Trivial info."));
    clx::logger::warn(WARNF("Warning! Warning!"));
    clx::logger::error(ERRORF("Debug life is dead!"));
    clx::logger::fatal(FATALF("Mou DaMePo..."));
    clx::logger::error(ERRORF("%d/%02d/%02dT%02d:%02d:%02d", 2010, 1, 15, 3, 43, 0));
    
    /*
     * t@CɏóD
     * o͂̒O open() Co͂I close() ꍇD
     * vZXśCƃt@CEI[v̏Ԃŗǂꍇ́C
     * file_appender ł͂Ȃ std::ofstream Ɏw肷D
     */
    clx::file_appender fapp("sample.log", 1000);
    clx::logger::configure(fapp, clx::loglevel::warn);
    
    clx::logger::trace(DEBUGF("Hoge"));
    clx::logger::debug(DEBUGF("Hello, world!"));
    clx::logger::info(DEBUGF("Trivial info."));
    clx::logger::warn(DEBUGF("Warning! Warning!"));
    clx::logger::error(DEBUGF("Debug life is dead!"));
    clx::logger::fatal(DEBUGF("Mou DaMePo..."));
    
    return 0;
}
