#include <iostream>
#include "clx/sha1.h"
#include "clx/base64.h"
#include "clx/hexdump.h"

int main(int argc, char* argv[]) {
	clx::sha1 digest;
	
	try {
		digest.reset();
		std::cout << clx::base64::encode(std::string((char*)digest.code())) << std::endl;
		digest.update(NULL, 0);
		digest.finish();
		
		std::cout << digest.to_string() << std::endl;
		std::cout << clx::base64::encode((char*)(digest.code()), digest.size()) << std::endl;
		std::cout << clx::base64::encode(NULL, 0) << std::endl;
		std::cout << clx::base64::encode(std::string()) << std::endl;
		std::cout << clx::base64::encode(std::string((char*)digest.code())) << std::endl;
		std::cout << clx::base64::encode(std::string(NULL, 0)) << std::endl;
		std::cout << clx::base64::encode(std::string(NULL)) << std::endl;
	}
	catch (std::exception& e) {
		std::cerr << e.what() << std::endl;
		std::exit(-1);
	}
	catch (...) {
		std::cerr << "unknown error." << std::endl;
		std::exit(-1);
	}
	
	return 0;
}
