#include <iostream>
#include <iomanip>
#include <string>
#include "clx/utf8.h"

void roundtrip(std::size_t c) {
	char32_t u32 = clx::utf8::decode(c);
	clx::utf8_t u8 = clx::utf8::encode(u32);
	std::cout << std::hex << "<" << c << ">"
		<< " -> <" << u32 << ">"
		<< " -> <" << u8  << ">"
		<< " (" << clx::utf8::convert(u8) << ")"
	<< std::endl;
}

int main(int argc, char* argv[]) {
	std::string s("ハローワールド！");
	std::string::iterator pos = s.begin();
	while (pos != s.end()) {
		clx::utf8_t c = clx::utf8::get(pos, s.end());
		roundtrip(c);
	}
	return 0;
}
