;;; cmail-bbdb.el --- use bbdb from cmail

;; Author: Takeshi Morishima (tm@onepost.net)
;; Keywords: mail
;; Created at: Sat Feb 26 15:39:56 JST 2000

;; This file is part of cmail (a mail utility for GNU Emacs)

;; This program is free software; you can redistribute it and/or
;; modify it under the terms of the GNU General Public License as
;; published by the Free Software Foundation; either version 2, or (at
;; your option) any later version.

;; This program is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program; see the file COPYING.  If not, write to
;; the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;;; Commentary:

;; This is a cmail option feature module for bbdb.

;;; Code:

(if (module-installed-p 'bbdb)
    (let (major minor)
      (require 'bbdb)
      (if (string-match "^\\([0-9]+\\)\.\\([0-9]+\\)$" bbdb-version)
	  (progn
	    (setq major (string-to-int (match-string 1 bbdb-version)))
	    (setq minor (string-to-int (match-string 2 bbdb-version)))
	    (if (or (> major 2) (and (= major 2) (>= minor 34)))
		(require 'cmail-bbdb-curver)
	      (require 'cmail-bbdb-pre2_34))))))

(provide 'cmail-bbdb)
