/*
MySQL Data Transfer
Source Host: 192.168.5.222
Source Database: CMSF
Target Host: 192.168.5.222
Target Database: CMSF
Date: 2009/07/13 14:43:18
*/

SET FOREIGN_KEY_CHECKS=0;
-- ----------------------------
-- Table structure for ms_samples
-- ----------------------------
CREATE TABLE IF NOT EXISTS `ms_samples` (
  `id` int(11) NOT NULL auto_increment,
  `created_by` varchar(20) default NULL,
  `created_at` timestamp NULL default NULL,
  `updated_by` varchar(20) default NULL,
  `updated_at` timestamp NULL default NULL on update CURRENT_TIMESTAMP,
  `name` varchar(255) default NULL,
  `sample_attribute1` varchar(255) default NULL,
  `sample_attribute2` varchar(255) default NULL,
  PRIMARY KEY  (`id`)
) DEFAULT CHARSET=utf8;

-- ----------------------------
-- Function structure for CMSF_FUNC_GET_MASTER
-- ----------------------------
DROP FUNCTION IF EXISTS `CMSF_FUNC_GET_MASTER`;
DELIMITER ;;
CREATE FUNCTION `CMSF_FUNC_GET_MASTER`(p_csv_text text, p_master_tbl varchar(255)) RETURNS text CHARSET utf8
BEGIN
/**
 * CSVデータを分割して、マスタデータを取得する関数
 *
 * @package     CMSF
 * @category    CMSF_FUNC_GET_MASTER
 * @param       text         p_csv_text      CSVデータ
 * @param       varchar(255) p_master_tbl    テーブル名
 * @return      text                         CSVデータ
 * @example
 * @license     LGPL version 3 - http://www.gnu.org/licenses/lgpl.html
 * @copyright   2009 Yuusuke takagi <nya.takasan@gmail.com>
 * @link        http://sourceforge.jp/projects/cmsf/
 * @author      Yuusuke takagi <nya.takasan@gmail.com>
 * @version     $Revision: 0.0.1 2009/07/13 初期リリース Yuusuke takagi <nya.takasan@gmail.com>$
 * @since
 * @see         CMSF_FUNC_GET_MS_SAMPLES
 * @require     MYSQL 5.0.0 or higther
 */
 /*------------------------------------------------------
    変数定義
 -------------------------------------------------------*/
 declare w_result                       text            default '';             /*  変換文字列 */

 /* ログ関連 */
 declare w_log_result                   varchar(255)    default '';             /* Log 結果 */
 declare w_log_query                    varchar(2000)   default '';             /*  Query Log */

 /* ユーザー定義変数 */
 declare w_loop_maxnum                   int;                                /*  Loop最大回数 */
 declare w_master_tbl                    varchar(255)       default '';      /*  テーブル名 */

 declare w_csv_text                      varchar(65550)    default '';      /*  CSVワークデータ */
 declare w_loop_num                      int               default 1;       /*  Loop最大回数 */
 declare w_key                           varchar(255)      default '';      /*  KEYデータ */
 declare w_name                          varchar(65550)    default '';      /*  KEYデータ */
 declare w_sql                           varchar(65550)    default '';      /*  KEYデータ */
 declare w_csv_result                    text              default '';      /*  KEYデータ */

 /*------------------------------------------------------
    ユーザ例外定義
  -------------------------------------------------------*/

 /*------------------------------------------------------
    定数定義
 -------------------------------------------------------*/
 declare s_empty_string                 varchar(255)    default '';             /*  空文字 */
 declare s_true                         varchar(255)    default 1;              /*  TRUE  FLG*/
 declare s_false                        varchar(255)    default 0;              /*  FALSE FLG */

 /* ログ関連 */
 declare s_log_flg                      int(1)          default 0;              /*  エラー処理フラグ ON:1 OFF:0 */

/*
 ログ出力サンプル SQLログ

 SET w_log_query = CONCAT(
 "    SQL"
 );

 SET w_log_result = CMSF_FUNC_PUT_LOG( s_log_created_by , s_log_prj_name , s_log_apps_name , s_log_mod_name , s_log_prg_var , s_log_type_text
                                     , '処理名称' , w_log_query , 'ログ1' , 'ログ2' , 'ログ3' , 'ログ4' , 'ログ5' );

 ログ出力サンプル テキストログ

 SET w_log_result = CMSF_FUNC_PUT_LOG( s_log_created_by , s_log_prj_name , s_log_apps_name , s_log_mod_name , s_log_prg_var , s_log_type_text
                                     , '処理名称' , s_empty_string  , 'ログ1' , 'ログ2' , 'ログ3' , 'ログ4' , 'ログ5' );
*/
 declare s_log_prj_name                 varchar(255)    default 'CMSF';                       /*  プロジェクト名 */
 declare s_log_apps_name                varchar(255)    default 'CMSF_FUNC_PHP_SERIALIZE2CSV';/*  アプリケーション名 */
 declare s_log_mod_name                 varchar(255)    default 'CMSF_FUNC_GET_MASTER';       /*  モジュール名 */
 declare s_log_prg_var                  varchar(255)    default '0.0.1';                      /*  モジュールバージョン */

 declare s_log_created_by               varchar(255)    default 'SYSTEM';               /*  ログ作成者 */

 declare s_log_type_insert              varchar(255)    default 'INSERT';               /*  ログタイプ:INSERT  */
 declare s_log_type_select              varchar(255)    default 'SELECT';               /*  ログタイプ:SELECT  */
 declare s_log_type_update              varchar(255)    default 'UPDATE';               /*  ログタイプ:UPDATE */
 declare s_log_type_delete              varchar(255)    default 'DELETE';               /*  ログタイプ:DELETE */

 declare s_log_type_text                varchar(255)    default 'TEXT';                 /*  ログタイプ:TEXT */

 declare s_log_type_error               varchar(255)    default 'ERROR';                /*  ログタイプ:ERROR */

 declare s_log_type_tmp                 varchar(255)    default 'TEMPORARY';            /*  ログタイプ:TEMPORARY */

 /* ユーザー定義定数 */


 /*------------------------------------------------------
    カーソル定義
 -------------------------------------------------------*/
  /*--------------------------------------------
   カーソル説明
  ---------------------------------------------*/

 /*----------------------------------------------------------
   処理定義
 -----------------------------------------------------------*/
 /* 1.0 初期処理*/
 SET w_csv_text      = p_csv_text;
 SET w_master_tbl    = p_master_tbl;
 SET w_loop_maxnum   = LENGTH( w_csv_text ) - LENGTH( REPLACE( w_csv_text , ',' ,'') ) + 1; /* Loop最大回数初期化 */


 /*  ログ出力*/
 IF( s_log_flg = 1 ) THEN
        SET w_log_result =  CMSF_FUNC_PUT_LOG( s_log_created_by , s_log_prj_name , s_log_apps_name , s_log_mod_name , s_log_prg_var , s_log_type_text
                                             , CONCAT( '1.0 初期処理 パラメータ:', p_csv_text  , ',' , p_master_tbl  ) , s_empty_string , s_empty_string , s_empty_string , s_empty_string , s_empty_string , s_empty_string );
  END IF;

/* 2.1.1 CSV展開処理 */
 IF( w_csv_text is not null and w_csv_text != '' ) then
  WHILE w_loop_maxnum >= w_loop_num do

   /* CSVデータ取得 */
   IF( w_loop_maxnum = w_loop_num ) then
    SET w_key = w_csv_text;
   ELSE
    SET w_key = SUBSTRING( COALESCE( w_csv_text , '' ) , 1 , INSTR( w_csv_text , ',' ) - 1 );
   END IF;

   /* 1.2 マスタデータ取得処理 */
   IF( p_master_tbl  = 'ms_samples' ) then
    SET w_name = CMSF_FUNC_GET_MS_SAMPLES( w_key );            /* 経験分野 */
   ELSE
    SET w_name = '未対応';                                    /*  未対応データ*/
   END IF;

   /* 1.3 CSVデータ連結処理 */
    IF( w_loop_num = 1 ) then
      SET w_result = w_name;                                           /* 一つ目の項目取得 */
    ELSE
      SET w_result = CONCAT( w_result , ',' , w_name ); /* 二つ目以降の項目取得 */
    END IF;

   /* 1.4 LOOP準備処理*/
   SET w_csv_text        = CMSF_FUNC_SUBSTRING( w_csv_text, INSTR( w_csv_text , ',' ) + 1 , LENGTH( w_csv_text ) );
   SET w_loop_num        = w_loop_num + 1;

   /*  ログ出力*/
   IF( s_log_flg = 1 ) THEN
     /* ログ出力サンプル テキストログの場合 */
     SET w_log_result = CMSF_FUNC_PUT_LOG( s_log_created_by , s_log_prj_name , s_log_apps_name , s_log_mod_name , s_log_prg_var , s_log_type_text
                                         , '2.1.1 CSV展開処理 ' , s_empty_string  , w_result , w_key , w_name , s_empty_string , s_empty_string );
   END IF;

  END WHILE;

 END IF;

 /*  ログ出力処理  */
 IF( s_log_flg = 1 ) THEN
        SET w_log_result =  CMSF_FUNC_PUT_LOG( s_log_created_by , s_log_prj_name , s_log_apps_name , s_log_mod_name , s_log_prg_var , s_log_type_text
                                             , CONCAT( '9.9.9 処理完了 :' , w_result  ) , s_empty_string , s_empty_string , s_empty_string , s_empty_string , s_empty_string , s_empty_string );
 END IF;

 return w_result;

END;;
DELIMITER ;

-- ----------------------------
-- Function structure for CMSF_FUNC_GET_MS_SAMPLES
-- ----------------------------
DROP FUNCTION IF EXISTS `CMSF_FUNC_GET_MS_SAMPLES`;
DELIMITER ;;
CREATE FUNCTION `CMSF_FUNC_GET_MS_SAMPLES`(p_key int(18)) RETURNS text CHARSET utf8
BEGIN
/**
 * CSVデータを分割して、マスタデータを取得する関数
 *
 * @package     CMSF
 * @category    CMSF_FUNC_GET_MS_SAMPLES
 * @param       int(18)           p_key      primary_key
 * @return      text                         name
 * @example
 * @license     LGPL version 3 - http://www.gnu.org/licenses/lgpl.html
 * @copyright   2009 Yuusuke takagi <nya.takasan@gmail.com>
 * @link        http://sourceforge.jp/projects/cmsf/
 * @author      Yuusuke takagi <nya.takasan@gmail.com>
 * @version     $Revision: 0.0.1 初期リリース Yuusuke takagi <nya.takasan@gmail.com>$
 * @since
 * @see         CMSF_FUNC_GET_MASTER
 * @require     MYSQL 5.0.0 or higther
 */
 /*------------------------------------------------------
    変数定義
 -------------------------------------------------------*/
 declare w_result                       text            default '';             /*  変換文字列 */

 /* ログ関連 */
 declare w_log_result                   varchar(255)    default '';             /* Log 結果 */
 declare w_log_query                    varchar(2000)   default '';             /*  Query Log */

 /* ユーザー定義変数 */
 declare w_key                          int(18)          default NULL;           /*  文字列 */

 /*------------------------------------------------------
    ユーザ例外定義
  -------------------------------------------------------*/

 /*------------------------------------------------------
    定数定義
 -------------------------------------------------------*/
 declare s_empty_string                 varchar(255)    default '';             /*  空文字 */
 declare s_true                         varchar(255)    default 1;              /*  TRUE  FLG*/
 declare s_false                        varchar(255)    default 0;              /*  FALSE FLG */

 /* ログ関連 */
 declare s_log_flg                      int(1)          default 0;              /*  エラー処理フラグ ON:1 OFF:0 */

/*
 ログ出力サンプル SQLログ

 SET w_log_query = CONCAT(
 "    SQL"
 );

 SET w_log_result = CMSF_FUNC_PUT_LOG( s_log_created_by , s_log_prj_name , s_log_apps_name , s_log_mod_name , s_log_prg_var , s_log_type_text
                                     , '処理名称' , w_log_query , 'ログ1' , 'ログ2' , 'ログ3' , 'ログ4' , 'ログ5' );

 ログ出力サンプル テキストログ

 SET w_log_result = CMSF_FUNC_PUT_LOG( s_log_created_by , s_log_prj_name , s_log_apps_name , s_log_mod_name , s_log_prg_var , s_log_type_text
                                     , '処理名称' , s_empty_string  , 'ログ1' , 'ログ2' , 'ログ3' , 'ログ4' , 'ログ5' );
*/
 declare s_log_prj_name                 varchar(255)    default 'CMSF';                       /*  プロジェクト名 */
 declare s_log_apps_name                varchar(255)    default 'CMSF_FUNC_PHP_SERIALIZE2CSV';/*  アプリケーション名 */
 declare s_log_mod_name                 varchar(255)    default 'CMSF_FUNC_GET_MS_SAMPLES';   /*  モジュール名 */
 declare s_log_prg_var                  varchar(255)    default '0.0.1';                      /*  モジュールバージョン */

 declare s_log_created_by               varchar(255)    default 'SYSTEM';               /*  ログ作成者 */

 declare s_log_type_insert              varchar(255)    default 'INSERT';               /*  ログタイプ:INSERT  */
 declare s_log_type_select              varchar(255)    default 'SELECT';               /*  ログタイプ:SELECT  */
 declare s_log_type_update              varchar(255)    default 'UPDATE';               /*  ログタイプ:UPDATE */
 declare s_log_type_delete              varchar(255)    default 'DELETE';               /*  ログタイプ:DELETE */

 declare s_log_type_text                varchar(255)    default 'TEXT';                 /*  ログタイプ:TEXT */

 declare s_log_type_error               varchar(255)    default 'ERROR';                /*  ログタイプ:ERROR */

 declare s_log_type_tmp                 varchar(255)    default 'TEMPORARY';            /*  ログタイプ:TEMPORARY */

 /* ユーザー定義定数 */


 /*------------------------------------------------------
    カーソル定義
 -------------------------------------------------------*/
  /*--------------------------------------------
   カーソル説明
  ---------------------------------------------*/

 /*----------------------------------------------------------
   処理定義
 -----------------------------------------------------------*/
 /* 1.0 初期処理*/
 SET w_key            = p_key;   /* 取得文字列 */

 /*  ログ出力*/
 IF( s_log_flg = 1 ) THEN
        SET w_log_result =  CMSF_FUNC_PUT_LOG( s_log_created_by , s_log_prj_name , s_log_apps_name , s_log_mod_name , s_log_prg_var , s_log_type_text
                                             , CONCAT( '1.0 初期処理 パラメータ:', CAST( p_key  AS CHAR)  ) , s_empty_string , s_empty_string , s_empty_string , s_empty_string , s_empty_string , s_empty_string );
  END IF;

/* 2.1.1 ms_sampleマスタデータ抽出処理 */
 SELECT name
   INTO w_result
   FROM ms_samples
  WHERE id = w_key
  LIMIT 1;      /* エラー対策用 */

 /*  ログ出力*/
 IF( s_log_flg = 1 ) THEN

 SET w_log_query = CONCAT(
 ' SELECT name'
,'   INTO w_result'
,'   FROM ms_samples'
,'  WHERE id = ' ,  w_key
,'  LIMIT 1;'
 );

   SET w_log_result = CMSF_FUNC_PUT_LOG( s_log_created_by , s_log_prj_name , s_log_apps_name , s_log_mod_name , s_log_prg_var , s_log_type_select
                                       , '2.1.1 ms_sampleマスタデータ抽出処理 ' , w_log_query  , s_empty_string , s_empty_string , s_empty_string , s_empty_string , s_empty_string );
 END IF;

 /*  ログ出力処理  */
 IF( s_log_flg = 1 ) THEN
        SET w_log_result =  CMSF_FUNC_PUT_LOG( s_log_created_by , s_log_prj_name , s_log_apps_name , s_log_mod_name , s_log_prg_var , s_log_type_text
                                             , CONCAT( '9.9.9 処理完了 :' , w_result  ) , s_empty_string , s_empty_string , s_empty_string , s_empty_string , s_empty_string , s_empty_string );
 END IF;

 return w_result;

END;;
DELIMITER ;

-- ----------------------------
-- Function structure for CMSF_FUNC_SUBSTRING
-- ----------------------------
DROP FUNCTION IF EXISTS `CMSF_FUNC_SUBSTRING`;
DELIMITER ;;
CREATE FUNCTION `CMSF_FUNC_SUBSTRING`(p_text text , p_start int , p_count int) RETURNS text CHARSET utf8
    NO SQL
BEGIN
/**
 * MYSQL5.0のバグ回避用のSUBSTRING関数のラッピング関数
 *
 * @package     CMSF
 * @category    CMSF_FUNC_SUBSTRING
 * @param       varchar(255) p_text          分割元データ
 * @param       varchar(255) p_start         文字分割開始位置
 * @param       varchar(255) p_count         文字数
 * @return      text                         分割済みデータ
 * @example
 * @license     LGPL version 3 - http://www.gnu.org/licenses/lgpl.html
 * @copyright   2009 Yuusuke takagi <nya.takasan@gmail.com>
 * @link        http://sourceforge.jp/projects/cmsf/
 * @author      Yuusuke takagi <nya.takasan@gmail.com>
 * @version     $Revision: 0.0.1 初期リリース Yuusuke takagi <nya.takasan@gmail.com>$
 * @since
 * @see         CMSF_FUNC_GET_MASTER
 * @require     MYSQL 5.0.0 or higther
 */
 /*------------------------------------------------------
    変数定義
 -------------------------------------------------------*/
 declare w_result                       text            default '';             /*  変換文字列 */

 /* ログ関連 */
 declare w_log_result                   varchar(255)    default '';             /* Log 結果 */
 declare w_log_query                    varchar(2000)   default '';             /*  Query Log */

 /* ユーザー定義変数 */
 declare w_text                      varchar(255)    default NULL;           /*  文字列 */
 declare w_start                     int(18)         default NULL;           /*  数字 */
 declare w_count                     int(18)         default NULL;           /*  数字 */

 /*------------------------------------------------------
    ユーザ例外定義
  -------------------------------------------------------*/

 /*------------------------------------------------------
    定数定義
 -------------------------------------------------------*/
 declare s_empty_string                 varchar(255)    default '';             /*  空文字 */
 declare s_true                         varchar(255)    default 1;              /*  TRUE  FLG*/
 declare s_false                        varchar(255)    default 0;              /*  FALSE FLG */

 /* ログ関連 */
 declare s_log_flg                      int(1)          default 0;              /*  エラー処理フラグ ON:1 OFF:0 */

/*
 ログ出力サンプル SQLログ

 SET w_log_query = CONCAT(
 "    SQL"
 );

 SET w_log_result = CMSF_FUNC_PUT_LOG( s_log_created_by , s_log_prj_name , s_log_apps_name , s_log_mod_name , s_log_prg_var , s_log_type_text
                                     , '処理名称' , w_log_query , 'ログ1' , 'ログ2' , 'ログ3' , 'ログ4' , 'ログ5' );

 ログ出力サンプル テキストログ

 SET w_log_result = CMSF_FUNC_PUT_LOG( s_log_created_by , s_log_prj_name , s_log_apps_name , s_log_mod_name , s_log_prg_var , s_log_type_text
                                     , '処理名称' , s_empty_string  , 'ログ1' , 'ログ2' , 'ログ3' , 'ログ4' , 'ログ5' );
*/
 declare s_log_prj_name                 varchar(255)    default 'CMSF';                       /*  プロジェクト名 */
 declare s_log_apps_name                varchar(255)    default 'CMSF_FUNC_PHP_SERIALIZE2CSV';/*  アプリケーション名 */
 declare s_log_mod_name                 varchar(255)    default 'CMSF_FUNC_SUBSTRING';        /*  モジュール名 */
 declare s_log_prg_var                  varchar(255)    default '0.0.1';                      /*  モジュールバージョン */

 declare s_log_created_by               varchar(255)    default 'SYSTEM';               /*  ログ作成者 */

 declare s_log_type_insert              varchar(255)    default 'INSERT';               /*  ログタイプ:INSERT  */
 declare s_log_type_select              varchar(255)    default 'SELECT';               /*  ログタイプ:SELECT  */
 declare s_log_type_update              varchar(255)    default 'UPDATE';               /*  ログタイプ:UPDATE */
 declare s_log_type_delete              varchar(255)    default 'DELETE';               /*  ログタイプ:DELETE */

 declare s_log_type_text                varchar(255)    default 'TEXT';                 /*  ログタイプ:TEXT */

 declare s_log_type_error               varchar(255)    default 'ERROR';                /*  ログタイプ:ERROR */

 declare s_log_type_tmp                 varchar(255)    default 'TEMPORARY';            /*  ログタイプ:TEMPORARY */

 /* ユーザー定義定数 */


 /*------------------------------------------------------
    カーソル定義
 -------------------------------------------------------*/
  /*--------------------------------------------
   カーソル説明
  ---------------------------------------------*/

 /*----------------------------------------------------------
   処理定義
 -----------------------------------------------------------*/
 /* 1.0 初期処理*/
 SET w_text           = p_text;   /* 取得文字列 */
 SET w_start          = p_start;  /* 開始位置 */
 SET w_count          = p_count;  /* 文字数 */

 /*  ログ出力*/
 IF( s_log_flg = 1 ) THEN
        SET w_log_result =  CMSF_FUNC_PUT_LOG( s_log_created_by , s_log_prj_name , s_log_apps_name , s_log_mod_name , s_log_prg_var , s_log_type_text
                                             , CONCAT( '1.0 初期処理 パラメータ:' , p_text , ',' , CAST( p_start AS CHAR)  , ',' , CAST( p_count AS CHAR) ) , s_empty_string , s_empty_string , s_empty_string , s_empty_string , s_empty_string , s_empty_string );
  END IF;

/* 2.1.1 文字列抽出処理 */
 SET w_result        = SUBSTRING( w_text , w_start , w_count );

 /*  ログ出力*/
 IF( s_log_flg = 1 ) THEN
   /* ログ出力サンプル テキストログの場合 */
   SET w_log_result = CMSF_FUNC_PUT_LOG( s_log_created_by , s_log_prj_name , s_log_apps_name , s_log_mod_name , s_log_prg_var , s_log_type_text
                                       , '2.1.1 文字列抽出処理' , s_empty_string  , s_empty_string , s_empty_string , s_empty_string , s_empty_string , s_empty_string );
 END IF;

 /*  ログ出力処理  */
 IF( s_log_flg = 1 ) THEN
        SET w_log_result =  CMSF_FUNC_PUT_LOG( s_log_created_by , s_log_prj_name , s_log_apps_name , s_log_mod_name , s_log_prg_var , s_log_type_text
                                             , CONCAT( '9.9.9 処理完了 :' , w_result  ) , s_empty_string , s_empty_string , s_empty_string , s_empty_string , s_empty_string , s_empty_string );
 END IF;

 return w_result;

END;;
DELIMITER ;

-- ----------------------------
-- Records 
-- ----------------------------
INSERT INTO `ms_samples` VALUES ('1', 'SYSTEM', '2009-07-11 22:45:03', 'SYSTEM', '2009-07-11 22:45:37', 'sample1', 'attribute1-1', 'attribute2-1');
INSERT INTO `ms_samples` VALUES ('2', 'SYSTEM', '2009-07-11 22:45:03', 'SYSTEM', '2009-07-11 22:45:37', 'sample2', 'attribute1-2', 'attribute2-2');
INSERT INTO `ms_samples` VALUES ('3', 'SYSTEM', '2009-07-11 22:45:03', 'SYSTEM', '2009-07-11 22:45:38', 'sample3', 'attribute1-3', 'attribute2-3');
