/*
MySQL Data Transfer
Source Host: 192.168.5.222
Source Database: CMSF
Target Host: 192.168.5.222
Target Database: CMSF
Date: 2009/07/13 14:42:17
*/

SET FOREIGN_KEY_CHECKS=0;
-- ----------------------------
-- Function structure for CMSF_FUNC_PHP_SERIALIZE2CSV
-- ----------------------------
DROP FUNCTION IF EXISTS `CMSF_FUNC_PHP_SERIALIZE2CSV`;
DELIMITER ;;
CREATE FUNCTION `CMSF_FUNC_PHP_SERIALIZE2CSV`(p_serialize_text text) RETURNS text CHARSET utf8
BEGIN
/**
 * PHPのSERIALIZE関数で処理したデータをCSV形式に変換する関数
 *
 * @package     CMSF
 * @category    CMSF_FUNC_PHP_SERIALIZE2CSV
 * @param       text              p_serialize_text シリアライズされたテキスト
 * @return      text                               CSV
 * @example
 * @license     LGPL version 3 - http://www.gnu.org/licenses/lgpl.html
 * @copyright   2009 Yuusuke takagi <nya.takasan@gmail.com>
 * @link        http://sourceforge.jp/projects/cmsf/
 * @author      Yuusuke takagi <nya.takasan@gmail.com>
 * @version     $Revision: 0.0.1 2009/07/13 初期リリース Yuusuke takagi <nya.takasan@gmail.com>$
 * @since
 * @see         CMSF_FUNC_GET_MASTER
 * @require     MYSQL 5.0.0 or higther
 */
 /*------------------------------------------------------
    変数定義
 -------------------------------------------------------*/
 declare w_result                       text            default '';             /*  変換文字列 */

 /* ログ関連 */
 declare w_log_result                   varchar(255)    default '';             /* Log 結果 */
 declare w_log_query                    varchar(2000)   default '';             /*  Query Log */

 /* ユーザー定義変数 */
 declare w_serialize_text               text            default '';             /*  シリアライズデータ */
 declare w_unserialize_text             text            default '';             /*  シリアライズ解除データ */
 declare w_loop_num                     int             default 1;              /*  Loop最大回数 */
 declare w_loop_maxnum                  int             default 0;              /*  Loop最大回数 */


 /*------------------------------------------------------
    ユーザ例外定義
  -------------------------------------------------------*/

 /*------------------------------------------------------
    定数定義
 -------------------------------------------------------*/
 declare s_empty_string                 varchar(255)    default '';             /*  空文字 */
 declare s_true                         varchar(255)    default 1;              /*  TRUE  FLG*/
 declare s_false                        varchar(255)    default 0;              /*  FALSE FLG */

 /* ログ関連 */
 declare s_log_flg                      int(1)          default 0;              /*  エラー処理フラグ ON:1 OFF:0 */

/*
 ログ出力サンプル SQLログ

 SET w_log_query = CONCAT(
 "    SQL"
 );

 SET w_log_result = CMSF_FUNC_PUT_LOG( s_log_created_by , s_log_prj_name , s_log_apps_name , s_log_mod_name , s_log_prg_var , s_log_type_text
                                     , '処理名称' , w_log_query , 'ログ1' , 'ログ2' , 'ログ3' , 'ログ4' , 'ログ5' );

 ログ出力サンプル テキストログ

 SET w_log_result = CMSF_FUNC_PUT_LOG( s_log_created_by , s_log_prj_name , s_log_apps_name , s_log_mod_name , s_log_prg_var , s_log_type_text
                                     , '処理名称' , s_empty_string  , 'ログ1' , 'ログ2' , 'ログ3' , 'ログ4' , 'ログ5' );
*/
 declare s_log_prj_name                 varchar(255)    default 'CMSF';                        /*  プロジェクト名 */
 declare s_log_apps_name                varchar(255)    default 'CMSF_FUNC_PHP_SERIALIZE2CSV'; /*  アプリケーション名 */
 declare s_log_mod_name                 varchar(255)    default 'CMSF_FUNC_PHP_SERIALIZE2CSV'; /*  モジュール名 */
 declare s_log_prg_var                  varchar(255)    default '0.0.1';                       /*  モジュールバージョン */

 declare s_log_created_by               varchar(255)    default 'SYSTEM';               /*  ログ作成者 */

 declare s_log_type_insert              varchar(255)    default 'INSERT';               /*  ログタイプ:INSERT  */
 declare s_log_type_select              varchar(255)    default 'SELECT';               /*  ログタイプ:SELECT  */
 declare s_log_type_update              varchar(255)    default 'UPDATE';               /*  ログタイプ:UPDATE */
 declare s_log_type_delete              varchar(255)    default 'DELETE';               /*  ログタイプ:DELETE */

 declare s_log_type_text                varchar(255)    default 'TEXT';                 /*  ログタイプ:TEXT */

 declare s_log_type_error               varchar(255)    default 'ERROR';                /*  ログタイプ:ERROR */

 declare s_log_type_tmp                 varchar(255)    default 'TEMPORARY';            /*  ログタイプ:TEMPORARY */

 /* ユーザー定義定数 */


 /*------------------------------------------------------
    カーソル定義
 -------------------------------------------------------*/
  /*--------------------------------------------
   カーソル説明
  ---------------------------------------------*/

 /*----------------------------------------------------------
   処理定義
 -----------------------------------------------------------*/
 /* 1.0 初期処理*/
 SET w_serialize_text = p_serialize_text; /* シリアライズデータ 初期化*/
 SET w_loop_maxnum    = SUBSTRING( w_serialize_text , INSTR( w_serialize_text,'a') + 2 , INSTR( SUBSTRING( w_serialize_text, INSTR( w_serialize_text,':' ) +1 ) , ':') ); /*  Loop最大回数初期化 */
 SET w_serialize_text = REPLACE( w_serialize_text , '}' , '' );

 /*  ログ出力*/
 IF( s_log_flg = 1 ) THEN
        SET w_log_result =  CMSF_FUNC_PUT_LOG( s_log_created_by , s_log_prj_name , s_log_apps_name , s_log_mod_name , s_log_prg_var , s_log_type_text
                                             , CONCAT( '1.0 初期処理 パラメータ:' , p_serialize_text ) , s_empty_string , s_empty_string , s_empty_string , s_empty_string , s_empty_string , s_empty_string );
  END IF;

/* 2.1.1 アンシリアライズ処理 */
 IF( w_serialize_text is not null OR w_serialize_text != s_empty_string ) then

  WHILE w_loop_maxnum >= w_loop_num do

    IF( w_loop_num = 1 ) then

      SET w_result = SUBSTRING( w_serialize_text, INSTR( w_serialize_text,'"') + 1  , INSTR( SUBSTRING( w_serialize_text, INSTR( w_serialize_text ,'"') + 1 ) ,'"') - 1 ); /* 一つ目の項目取得 */

    ELSE

      SET w_result = CONCAT( w_result , ',' , SUBSTRING( w_serialize_text, INSTR( w_serialize_text,'"') + 1  , INSTR( SUBSTRING( w_serialize_text, INSTR( w_serialize_text ,'"') + 1 ) ,'"') - 1 )); /* 一つ目の項目取得 */

    END IF;

    SET w_serialize_text    = SUBSTRING( w_serialize_text , INSTR( w_serialize_text,'"') + INSTR( SUBSTRING( w_serialize_text, INSTR( w_serialize_text ,'"') + 1 ) ,';') + 1 );      /*  2つ目の以降のアンシリアイズデータ */

    SET w_loop_num        = w_loop_num + 1;

    /*  ログ出力*/
    IF( s_log_flg = 1 ) THEN

      SET w_log_result = CMSF_FUNC_PUT_LOG( s_log_created_by , s_log_prj_name , s_log_apps_name , s_log_mod_name , s_log_prg_var , s_log_type_text
                                          ,  '2.1.1 アンシリアライズ処理:' , ''  , w_result , s_empty_string , s_empty_string , s_empty_string , s_empty_string );
    END IF;

  END WHILE;

 END IF;

 /*  ログ出力処理  */
 IF( s_log_flg = 1 ) THEN
        SET w_log_result =  CMSF_FUNC_PUT_LOG( s_log_created_by , s_log_prj_name , s_log_apps_name , s_log_mod_name , s_log_prg_var , s_log_type_text
                                             , CONCAT( '9.9.9 処理完了 :' , w_result  ) , s_empty_string , s_empty_string , s_empty_string , s_empty_string , s_empty_string , s_empty_string );
 END IF;

 return w_result;

END;;
DELIMITER ;

-- ----------------------------
-- Records 
-- ----------------------------
