/*
MySQL Data Transfer
Source Host: 192.168.5.222
Source Database: CMSF
Target Host: 192.168.5.222
Target Database: CMSF
Date: 2009/09/05 9:03:44
*/

SET FOREIGN_KEY_CHECKS=0;
-- ----------------------------
-- Function structure for CMSF_FUNC_DATA_NORMALIZE
-- ----------------------------
DROP FUNCTION IF EXISTS `CMSF_FUNC_DATA_NORMALIZE`;
DELIMITER ;;
CREATE FUNCTION `CMSF_FUNC_DATA_NORMALIZE`(p_data longtext , p_type_flg varchar(50)) RETURNS text CHARSET utf8
BEGIN
/**
 * 受け取ったデータをパターン別に正規化する関数
 *
 * SYMBOL_HALF                  … 全角の記号を半角に変換
 * SYMBOL_FULL                  … 半角の記号を全角に変換
 * SYMBOL_STRIP                 … 記号全て削除
 * SYMBOL_STRIP_FOR_TORITONN    … "(",")" ,"+","-"以外の記号を削除
 * NUMBER_HALF                  … 全角の数字を半角に変換
 * NUMBER_FULL                  … 半角の数字を全角に変換
 * KANJI2NUMBER                 … 漢数字を半角の数字に変換
 * NUMBER2KANJI                 … 半角の数字を漢数字に変換             (未実装)
 * ALPHABET_HALF                … 全角のアルファベットを半角に変換
 * ALPHABET_FULL                … 半角のアルファベットを全角に変換
 * HIRAGANA2KATAKANA_HALF       … ひらがなから半角カタカナへ変換
 * HIRAGANA2KATAKANA_FULL       … ひらがなから全角カタカナへ変換
 * KATAKANA_HALF2HIRAGANA       … 半角カタカナからひらがなへ変換
 * HIRAGANA2HEPBURN             … ひらがなからヘボン式のローマ字へ変換
 * HIRAGANA2KUNREI              … ひらがなから訓令式のローマ字へ変換
 * KATAKANA_FULL2HIRAGANA       … 全角カタカナからひらがなへ変換
 * KATAKANA_FULL2KATAKANA_HALF  … 全角カタカナから半角カタカナへ変換
 * KATAKANA_HALF2KATAKANA_FULL  … 全角カタカナから全角カタカナへ変換
 * KATAKANA2HEPBURN             … カタカナからヘボン式のローマ字へ変換
 * KATAKANA2KUNREI              … カタカナから訓令式のローマ字へ変換
 * UPPER_KATAKANA_FULL          … 全角カタカナの拗音・促音(ァィゥェォャュョッ)を直音(アイウエオヤユヨツ)へ変換
 * UPPER_KATAKANA_HALF          … 半角カタカナの拗音・促音(ｧｨｩｪｫｬｭｮｯ)を直音(ｱｲｳｴｵﾔﾕﾖﾂ)へ変換
 * CORPORATE_TYPE_NORMALIZE     … 法人格を統一
 * CORPORATE_TYPE_STRIP         … 法人格を削除
 * ITAI_DOUJIBETUTAI            … 異体字や同字別体を正規化
 * SPACE_HALF                   … 全角スペースを半角スペースに変換
 * SPACE_FULL                   … 半角スペースを全角スペースに変換
 * TRIM                         … 全角/半角スペースを両側から削除
 *
 * @package     CMSF
 * @category    CMSF_FUNC_DATA_NORMALIZE
 * @param       varchar(255) p_data     正規化対象データ
 * @param       varchar(10)  p_type_flg 正規化タイプ
 * @return      text         正規化済みデータ
 * @example
 * @license     LGPL version 3 - http://www.gnu.org/licenses/lgpl.html
 * @copyright   2009 Yuusuke takagi <nya.takasan@gmail.com>
 * @link        http://sourceforge.jp/projects/cmsf/
 * @author      Yuusuke takagi <nya.takasan@gmail.com>
 * @version     $Revision: 0.0.1 2009/07/15 初期リリース Yuusuke takagi <nya.takasan@gmail.com>$
 * @version     $Revision: 0.0.2 2009/07/16 長音、半角カタカナの拗音・促音、直音変換対応追加 Yuusuke takagi <nya.takasan@gmail.com>$
 * @version     $Revision: 0.0.3 2009/07/17 ヴ変換対応追加・バグ修正 Yuusuke takagi <nya.takasan@gmail.com>$
 * @version     $Revision: 0.0.4 2009/08/29 片仮名の場合に長音をーに統一 Yuusuke takagi <nya.takasan@gmail.com>$
 * @version     $Revision: 0.0.5 2009/08/29 TORITONN用に"(",")" ,"+","-"以外の文字を削除する機能を追加 Yuusuke takagi <nya.takasan@gmail.com>$
 * @since
 * @see
 * @require     MYSQL 5.0.0 or higther
 */
 /*------------------------------------------------------
    変数定義
 -------------------------------------------------------*/
 declare w_result                       text                default '';             /*  変換文字列 */

 /* ログ関連 */
 declare w_log_result                   text                default '';             /* Log 結果 */
 declare w_log_query                    varchar(2000)       default '';             /* Query Log */

 /* ユーザー定義変数 */
 declare w_data                         longtext        default NULL;           /* 文字列 */
 declare w_type_flg                     varchar(50)         default NULL;           /* 文字列 */

 declare w_loop_maxcount                int(18)             default NULL;
 declare w_total_amount                 bigint(20) UNSIGNED default 0;
 declare w_1000_less_data               varchar(20)         default NULL;
 declare w_sub_amount                   int(18)             default 0;
 declare w_sub_data                     varchar(10)         default NULL;
 declare w_sub_result                   bigint(20) UNSIGNED default 0;

 declare w_big_figures                  bigint(20) UNSIGNED default 0;
 declare w_figures                      bigint(20) UNSIGNED default 0;

 declare w_tmp                          text                default '';          /*  漢数字処理用一時退避 */
 declare w_front_tmp                    text                default '';          /*  漢数字処理用一時退避 前データ */
 declare w_back_tmp                     text                default '';          /*  漢数字処理用一時退避 後データ */

 /*------------------------------------------------------
    ユーザ例外定義
  -------------------------------------------------------*/

 /*------------------------------------------------------
    定数定義
 -------------------------------------------------------*/
 declare s_empty_string                 varchar(255)    default '';             /*  空文字 */
 declare s_true                         varchar(255)    default 1;              /*  TRUE  FLG*/
 declare s_false                        varchar(255)    default 0;              /*  FALSE FLG */

 /* ログ関連 */
 declare s_log_flg                      int(1)          default 0;              /*  エラー処理フラグ ON:1 OFF:0 */

/*
 ログ出力サンプル SQLログ

 SET w_log_query = CONCAT(
 "    SQL"
 );

 SET w_log_result = CMSF_FUNC_PUT_LOG( s_log_created_by , s_log_prj_name , s_log_apps_name , s_log_mod_name , s_log_prg_var , s_log_type_text
                                     , '処理名称' , w_log_query , 'ログ1' , 'ログ2' , 'ログ3' , 'ログ4' , 'ログ5' );

 ログ出力サンプル テキストログ

 SET w_log_result = CMSF_FUNC_PUT_LOG( s_log_created_by , s_log_prj_name , s_log_apps_name , s_log_mod_name , s_log_prg_var , s_log_type_text
                                     , '処理名称' , s_empty_string  , 'ログ1' , 'ログ2' , 'ログ3' , 'ログ4' , 'ログ5' );
*/
 declare s_log_prj_name                 varchar(255)    default 'CMSF';                                 /*  プロジェクト名 */
 declare s_log_apps_name                varchar(255)    default 'CMSF_FUNC_PHP_MB_CONVERT_KANA';             /*  アプリケーション名 */
 declare s_log_mod_name                 varchar(255)    default 'CMSF_FUNC_DATA_NORMALIZE';             /*  モジュール名 */
 declare s_log_prg_var                  varchar(255)    default '0.0.2';                                /*  モジュールバージョン */

 declare s_log_created_by               varchar(255)    default 'SYSTEM';               /*  ログ作成者 */

 declare s_log_type_insert              varchar(255)    default 'INSERT';               /*  ログタイプ:INSERT  */
 declare s_log_type_select              varchar(255)    default 'SELECT';               /*  ログタイプ:SELECT  */
 declare s_log_type_update              varchar(255)    default 'UPDATE';               /*  ログタイプ:UPDATE */
 declare s_log_type_delete              varchar(255)    default 'DELETE';               /*  ログタイプ:DELETE */

 declare s_log_type_text                varchar(255)    default 'TEXT';                 /*  ログタイプ:TEXT */

 declare s_log_type_error               varchar(255)    default 'ERROR';                /*  ログタイプ:ERROR */

 declare s_log_type_tmp                 varchar(255)    default 'TEMPORARY';            /*  ログタイプ:TEMPORARY */

 /* ユーザー定義定数 */
 declare s_kabushiki_kaisya             varchar(255)    default '株式会社';             /*  株式会社 */
 declare s_yuugen_kaisya                varchar(255)    default '有限会社';             /*  有限会社 */
 declare s_goushi_kaisya                varchar(255)    default '合資会社';             /*  合資会社 */
 declare s_goumei_kaisya                varchar(255)    default '合名会社';             /*  合名会社 */
 declare s_goudou_kaisya                varchar(255)    default '合同会社';             /*  合同会社 */
 declare s_zaidan_hojin                 varchar(255)    default '財団法人';             /*  財団法人 */
 declare s_iryou_hojon                  varchar(255)    default '医療法人';             /*  医療法人 */
 declare s_syukyou_hojin                varchar(255)    default '宗教法人';             /*  宗教法人 */

 declare s_dummy                        varchar(1)      default '∀';                   /*  漢数字処理用一時退避フラグ */

 /*------------------------------------------------------
    カーソル定義
 -------------------------------------------------------*/
  /*--------------------------------------------
   カーソル説明
  ---------------------------------------------*/

 /*----------------------------------------------------------
   処理定義
 -----------------------------------------------------------*/
 /* 1.0 初期処理*/
 SET w_data              = p_data;        /*  正規化対象データ */
 SET w_type_flg          = p_type_flg;                                /*  正規化タイプ */

 /*  ログ出力*/
 IF( s_log_flg = 1 ) THEN
        SET w_log_result =  CMSF_FUNC_PUT_LOG( s_log_created_by , s_log_prj_name , s_log_apps_name , s_log_mod_name , s_log_prg_var , s_log_type_text
                                             , CONCAT( '1.0 初期処理 パラメータ:' , p_data , ',' , p_type_flg ) , s_empty_string , s_empty_string , s_empty_string , s_empty_string , s_empty_string , s_empty_string );
 END IF;

/* 2.1.1 データ変換前処理 */
IF( w_data IN('','？','?','フメイ','ﾌﾒｲ','不明') )THEN

  SET w_result = NULL;

ELSE

 /* 2.1.1.1.1 データ正規化処理 */
 IF( w_type_flg = 'SYMBOL_HALF' ) THEN

   SET w_result            = REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE( w_data
                           ,'、','､'),'。','｡'),'，','，'),'．','.'),'・','･'),'：',':'),'；',';'),'！','!'),'＾','^'),'￣','~'),'＿','_'),'-','ｰ'),'ー','ｰ'),'―','ｰ'),'‐','ｰ'),'－','ｰ'),'ｰ','ｰ'),'／','/'),'｜','|'),'”','"'),'（','('),'）',')'),'〔','['),'〕',']'),'［','['),'］',']'),'｛','{'),'｝','}'),'〈','<'),'〉','>'),'「','｢'),'」','｣'),'＋','+'),'＝','='),'＜','<'),'＞','>'),'％','%'),'＃','#'),'＆','&'),'＊','*'),'＠','@');

   /*  ログ出力*/
   IF( s_log_flg = 1 ) THEN

    SET w_log_result = CMSF_FUNC_PUT_LOG( s_log_created_by , s_log_prj_name , s_log_apps_name , s_log_mod_name , s_log_prg_var , s_log_type_text
                                        , '2.1.1.1.1 データ正規化処理' , s_empty_string  , w_data , w_result , s_empty_string , 'SYMBOL_HALF' , s_empty_string );

   END IF;

 /* 2.1.1.1.2 データ正規化処理 */
 ELSEIF( w_type_flg = 'SYMBOL_FULL' ) THEN

   SET w_result            = REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE( w_data
                           ,'､','、'),'｡','。'),'，','，'),'.','．'),'･','・'),':','：'),';','；'),'!','！'),'^','＾'),'~','￣'),'_','＿'),'-','ー'),'-','ー'),'―','ー'),'‐','ー'),'－','ー'),'ｰ','ー'),'/','／'),'|','｜'),'"','”'),'(','（'),')','）'),'[','〔'),']','〕'),'[','［'),']','］'),'{','｛'),'}','｝'),'<','〈'),'>','〉'),'｢','「'),'｣','」'),'+','＋'),'=','＝'),'<','＜'),'>','＞'),'%','％'),'#','＃'),'&','＆'),'*','＊'),'@','＠');

   /*  ログ出力*/
   IF( s_log_flg = 1 ) THEN

    SET w_log_result = CMSF_FUNC_PUT_LOG( s_log_created_by , s_log_prj_name , s_log_apps_name , s_log_mod_name , s_log_prg_var , s_log_type_text
                                        , '2.1.1.1.2 データ正規化処理' , s_empty_string  , w_data , w_result , s_empty_string , 'SYMBOL_FULL' , s_empty_string );

   END IF;

 /* 2.1.1.1.3 データ正規化処理 */
 ELSEIF( w_type_flg = 'SYMBOL_STRIP' ) THEN

   SET w_result            = REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                             REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                             REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                             REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                             REPLACE(REPLACE(REPLACE(REPLACE(REPLACE( w_data
                            ,'､',''),'、',''),'｡',''),'。',''),'，',''),'，',''),'.',''),'．',''),'･',''),'・',''),':',''),'：',''),';',''),'；',''),'!',''),'！',''),'^','')
                            ,'＾',''),'~',''),'￣',''),'_',''),'＿',''),'-',''),'―',''),'-',''),'‐',''),'-',''),'/',''),'／',''),'|',''),'｜',''),'"',''),'”','')
                            ,'(',''),'（',''),')',''),'）',''),'[',''),'〔',''),']',''),'〕',''),'[',''),'［',''),']',''),'］',''),'{',''),'｛',''),'}',''),'｝',''),'<','')
                            ,'〈',''),'>',''),'〉',''),'｢',''),'「',''),'｣',''),'」',''),'+',''),'＋',''),'－',''),'-',''),'=',''),'＝',''),'<',''),'＜',''),'>',''),'＞','')
                            ,'%',''),'％',''),'#',''),'＃',''),'&',''),'＆',''),'*',''),'＊',''),'@',''),'＠','');

   /*  ログ出力*/
   IF( s_log_flg = 1 ) THEN

    SET w_log_result = CMSF_FUNC_PUT_LOG( s_log_created_by , s_log_prj_name , s_log_apps_name , s_log_mod_name , s_log_prg_var , s_log_type_text
                                        , '2.1.1.1.3 データ正規化処理' , s_empty_string  , w_data , w_result , s_empty_string , 'SYMBOL_STRIP' , s_empty_string );

   END IF;

 /* 2.1.1.1.4 データ正規化処理 */
 ELSEIF( w_type_flg = 'SYMBOL_STRIP_FOR_TORITONN' ) THEN

   SET w_result            = REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                             REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                             REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                             REPLACE(REPLACE(REPLACE(REPLACE( w_data
                            ,'､',''),'、',''),'｡',''),'。',''),'，',''),'，',''),'.',''),'．',''),'･',''),'・',''),':',''),'：',''),';',''),'；',''),'!',''),'！',''),'^','')
                            ,'＾',''),'~',''),'￣',''),'_',''),'＿',''),'/',''),'／',''),'|',''),'｜',''),'"',''),'”',''),'[',''),'〔',''),']',''),'〕',''),'[',''),'［','')
                            ,']',''),'］',''),'{',''),'｛',''),'}',''),'｝',''),'〈',''),'〉',''),'｢',''),'「',''),'｣',''),'」',''),'=',''),'＝',''),'%',''),'％',''),'#','')
                            ,'＃',''),'&',''),'＆',''),'*',''),'＊',''),'@',''),'＠','');

   /*  ログ出力*/
   IF( s_log_flg = 1 ) THEN

    SET w_log_result = CMSF_FUNC_PUT_LOG( s_log_created_by , s_log_prj_name , s_log_apps_name , s_log_mod_name , s_log_prg_var , s_log_type_text
                                        , '2.1.1.1.3 データ正規化処理' , s_empty_string  , w_data , w_result , s_empty_string , 'SYMBOL_STRIP' , s_empty_string );

   END IF;


 /* 2.1.1.2.1 データ正規化処理 */
 ELSEIF( w_type_flg = 'NUMBER_HALF' ) THEN

   SET w_result            = REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE( w_data
                            ,'１','1'),'２','2'),'３','3'),'４','4'),'５','5'),'６','6'),'７','7'),'８','8'),'９','9'),'０','0');

   /*  ログ出力*/
   IF( s_log_flg = 1 ) THEN

    SET w_log_result = CMSF_FUNC_PUT_LOG( s_log_created_by , s_log_prj_name , s_log_apps_name , s_log_mod_name , s_log_prg_var , s_log_type_text
                                        , '2.1.1.2.1 データ正規化処理' , s_empty_string  , w_data , w_result , s_empty_string , 'NUMBER_HALF' , s_empty_string );

   END IF;

 /* 2.1.1.2.2 データ正規化処理 */
 ELSEIF( w_type_flg = 'NUMBER_FULL' ) THEN

   SET w_result            = REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE( w_data
                            ,'1','１'),'2','２'),'3','３'),'4','４'),'5','５'),'6','６'),'7','７'),'8','８'),'9','９'),'0','０');

   /*  ログ出力*/
   IF( s_log_flg = 1 ) THEN

    SET w_log_result = CMSF_FUNC_PUT_LOG( s_log_created_by , s_log_prj_name , s_log_apps_name , s_log_mod_name , s_log_prg_var , s_log_type_text
                                        , '2.1.1.2.2 データ正規化処理' , s_empty_string  , w_data , w_result , s_empty_string , 'NUMBER_FULL' , s_empty_string );

   END IF;

 /* 2.1.1.3 データ正規化処理・漢数字変換処理 */
 ELSEIF( w_type_flg = 'KANJI2NUMBER' ) THEN

   /* 2.1.1.3.1.1  漢数字とそれ以外のデータを分離 */
   SET w_tmp = REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
               REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
               REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
               REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
               REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
               w_data
               ,'１','1'),'２','2'),'３','3'),'４','4'),'５','5'),'６','6'),'７','7'),'８','8'),'９','9'),'０','0')
               ,'1' ,s_dummy ),'2' ,s_dummy ),'3' ,s_dummy ),'4' ,s_dummy ),'5' ,s_dummy ),'6' ,s_dummy ),'7' ,s_dummy ),'8' ,s_dummy ),'9' ,s_dummy ),'0' ,s_dummy )
               ,'一',s_dummy ),'二',s_dummy ),'三',s_dummy ),'四',s_dummy ),'五',s_dummy ),'六',s_dummy ),'七',s_dummy ),'八',s_dummy ),'九',s_dummy ),'零',s_dummy ),'〇',s_dummy )
               ,'壱',s_dummy ),'弐',s_dummy ),'参',s_dummy ),'肆',s_dummy ),'伍',s_dummy ),'陸',s_dummy ),'質',s_dummy ),'捌',s_dummy ),'玖',s_dummy )
               ,'十',s_dummy ),'拾',s_dummy ),'百',s_dummy ),'千',s_dummy ),'万',s_dummy ),'億',s_dummy ),'兆',s_dummy ),'京',s_dummy );

  SET w_front_tmp = SUBSTRING( w_tmp , 1 , INSTR( w_tmp , s_dummy ) - 1 );

  SET w_back_tmp  = SUBSTRING( w_data , CHAR_LENGTH( w_data ) - CHAR_LENGTH( TRIM( LEADING s_dummy FROM SUBSTRING( w_tmp , INSTR( w_tmp , s_dummy ) + 1 ) ) ) + 1 );

  SET w_data      = TRIM( TRAILING w_back_tmp FROM TRIM( LEADING w_front_tmp FROM w_data ) );

    /*  ログ出力*/
    IF( s_log_flg = 1 ) THEN

      SET w_log_result = CMSF_FUNC_PUT_LOG( s_log_created_by , s_log_prj_name , s_log_apps_name , s_log_mod_name , s_log_prg_var , s_log_type_text
                                          , '2.1.1.3.1.1  漢数字とそれ以外のデータを分離' , s_empty_string  , w_data , w_front_tmp , w_back_tmp , 'KANJI2NUMBER' , s_empty_string );

    END IF;

   /* 2.1.1.3.2 データ正規化処理・1桁数字変換処理 */
   SET w_data              = REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                             REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                             w_data
                            ,'一','1'),'二','2'),'三','3'),'四','4'),'五','5'),'六','6'),'七','7'),'八','8'),'九','9'),'零','0'),'〇','0')
                            ,'壱','1'),'弐','2'),'参','3'),'肆','4'),'伍','5'),'陸','6'),'質','7'),'捌','8'),'玖','9');

    /*  ログ出力*/
    IF( s_log_flg = 1 ) THEN

      SET w_log_result = CMSF_FUNC_PUT_LOG( s_log_created_by , s_log_prj_name , s_log_apps_name , s_log_mod_name , s_log_prg_var , s_log_type_text
                                          , '2.1.1.3.1.2 データ正規化処理・1桁数字変換処理' , s_empty_string  , w_data , s_empty_string , s_empty_string , 'KANJI2NUMBER' , s_empty_string );

    END IF;

   IF( INSTR( w_data , '十') > 0 OR INSTR( w_data , '拾') > 0 OR INSTR( w_data , '百') > 0 OR INSTR( w_data , '千') > 0
    OR INSTR( w_data , '万') > 0 OR INSTR( w_data , '億') > 0 OR INSTR( w_data , '兆') > 0 OR INSTR( w_data , '京') > 0) THEN

      WHILE CHAR_LENGTH( w_data ) > 0 DO

        SET w_1000_less_data   = NULL;
        SET w_big_figures      = NULL;
        SET w_sub_result       = 0;

        /* 2.1.1.3.3 データ正規化処理・万以上漢数字変換処理 */
        CASE
          WHEN INSTR( w_data , '京') > 0 THEN
            SET w_1000_less_data = SUBSTRING( w_data , 1 , INSTR( w_data , '京') - 1 );
            SET w_data           = SUBSTRING( w_data , INSTR( w_data , '京') + 1 , CHAR_LENGTH( w_data ) - 1 );
            SET w_big_figures  = 10000 * 10000 * 10000 * 10000;
          WHEN INSTR( w_data , '兆') > 0 THEN
            SET w_1000_less_data = SUBSTRING( w_data , 1 , INSTR( w_data , '兆') - 1 );
            SET w_data           = SUBSTRING( w_data , INSTR( w_data , '兆') + 1 , CHAR_LENGTH( w_data ) - 1 );
            SET w_big_figures  = 10000 * 10000 * 10000;
          WHEN INSTR( w_data , '億') > 0 THEN
            SET w_1000_less_data = SUBSTRING( w_data , 1 , INSTR( w_data , '億') - 1 );
            SET w_data           = SUBSTRING( w_data , INSTR( w_data , '億') + 1 , CHAR_LENGTH( w_data ) - 1 );
            SET w_big_figures  = 10000 * 10000;
          WHEN INSTR( w_data , '万') > 0 THEN
            SET w_1000_less_data = SUBSTRING( w_data , 1 , INSTR( w_data , '万') - 1 );
            SET w_data           = SUBSTRING( w_data , INSTR( w_data , '万') + 1 , CHAR_LENGTH( w_data ) - 1 );
            SET w_big_figures   = 10000;
          ELSE
            SET w_1000_less_data = w_data;
            SET w_data = '';
            SET w_big_figures   = 1;
        END CASE;

        /*  ログ出力*/
        IF( s_log_flg = 1 ) THEN

          SET w_log_result = CMSF_FUNC_PUT_LOG( s_log_created_by , s_log_prj_name , s_log_apps_name , s_log_mod_name , s_log_prg_var , s_log_type_text
                                              , '2.1.1.3.1.3 データ正規化処理・万以上漢数字変換処理  ' , s_empty_string  , w_1000_less_data , w_sub_result , s_empty_string , 'KANJI2NUMBER' , s_empty_string );

        END IF;

        /* 2.1.1.3.4 データ正規化処理・千以下漢数字変換処理 */
        WHILE CHAR_LENGTH( w_1000_less_data ) > 0 DO

          SET w_sub_data   = NULL;
          SET w_sub_amount = 0;

          CASE
            WHEN INSTR( w_1000_less_data , '千') > 0 THEN
              SET w_sub_data        = SUBSTRING( w_1000_less_data , 1 , INSTR( w_1000_less_data , '千') - 1 );
              SET w_1000_less_data  = SUBSTRING( w_1000_less_data , INSTR( w_1000_less_data , '千') + 1 , CHAR_LENGTH( w_1000_less_data ) - 1 );
              SET w_figures         = 1000;
              IF( w_sub_data = '' )THEN SET w_sub_data = 1; END IF;
              SET w_sub_amount      = w_sub_data * w_figures;
            WHEN INSTR( w_1000_less_data , '百') > 0 THEN
              SET w_sub_data        = SUBSTRING( w_1000_less_data , 1 , INSTR( w_1000_less_data , '百') - 1 );
              SET w_1000_less_data  = SUBSTRING( w_1000_less_data , INSTR( w_1000_less_data , '百') + 1 , CHAR_LENGTH( w_1000_less_data ) - 1);
              SET w_figures         = 100;
              IF( w_sub_data = '' )THEN SET w_sub_data = 1; END IF;
              SET w_sub_amount      = w_sub_data * w_figures;
            WHEN INSTR( w_1000_less_data , '十') > 0 THEN
              SET w_sub_data        = SUBSTRING( w_1000_less_data , 1 , INSTR( w_1000_less_data , '十') - 1 );
              SET w_1000_less_data  = SUBSTRING( w_1000_less_data , INSTR( w_1000_less_data , '十') + 1 , CHAR_LENGTH( w_1000_less_data ) - 1);
              SET w_figures         = 10;
              IF( w_sub_data = '' )THEN SET w_sub_data = 1; END IF;
              SET w_sub_amount      = w_sub_data * w_figures;
            WHEN INSTR( w_1000_less_data , '拾') > 0 THEN
              SET w_sub_data        = SUBSTRING( w_1000_less_data , 1 , INSTR( w_1000_less_data , '拾') - 1 );
              SET w_1000_less_data  = SUBSTRING( w_1000_less_data , INSTR( w_1000_less_data , '拾') + 1 , CHAR_LENGTH( w_1000_less_data ) - 1);
              SET w_figures         = 10;
              IF( w_sub_data = '' )THEN SET w_sub_data = 1; END IF;
              SET w_sub_amount      = w_sub_data * w_figures;
            ELSE
              SET w_sub_amount      = w_1000_less_data;
              SET w_1000_less_data  = '';
          END CASE;

          SET w_sub_result = w_sub_result + w_sub_amount;

          /*  ログ出力*/
          IF( s_log_flg = 1 ) THEN

            SET w_log_result = CMSF_FUNC_PUT_LOG( s_log_created_by , s_log_prj_name , s_log_apps_name , s_log_mod_name , s_log_prg_var , s_log_type_text
                                                , '2.1.1.3.1.4 データ正規化処理・千以下漢数字変換処理 ' , s_empty_string  , w_1000_less_data , w_sub_result , s_empty_string , 'KANJI2NUMBER' , s_empty_string );

          END IF;

        END WHILE;

      SET w_result = w_result + w_sub_result * w_big_figures;

      END WHILE;

   ELSE

     SET w_result = w_data;

   END IF;

   SET w_result = CONCAT( w_front_tmp , w_result , w_back_tmp );

   /*  ログ出力*/
   IF( s_log_flg = 1 ) THEN

    SET w_log_result = CMSF_FUNC_PUT_LOG( s_log_created_by , s_log_prj_name , s_log_apps_name , s_log_mod_name , s_log_prg_var , s_log_type_text
                                        , '2.1.1.3.1.5 データ正規化処理' , s_empty_string  , w_data , w_result , s_empty_string , 'KANJI2NUMBER' , s_empty_string );

   END IF;

 /* 2.1.1.3.2 データ正規化処理 */
 ELSEIF( w_type_flg = 'NUMBER2KANJI' ) THEN

   SET w_result             = '未実装';

   /*  ログ出力*/
   IF( s_log_flg = 1 ) THEN

    SET w_log_result = CMSF_FUNC_PUT_LOG( s_log_created_by , s_log_prj_name , s_log_apps_name , s_log_mod_name , s_log_prg_var , s_log_type_text
                                        , '2.1.1.3.2 データ正規化処理' , s_empty_string  , w_data , w_result , s_empty_string , 'NUMBER2KANJI' , s_empty_string );

   END IF;

 /* 2.1.1.4.1 データ正規化処理 */
 ELSEIF( w_type_flg = 'ALPHABET_HALF' ) THEN

   SET w_result             = REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE( w_data
                            ,'Ａ','A'),'Ｂ','B'),'Ｃ','C'),'Ｄ','D'),'Ｅ','E'),'Ｆ','F'),'Ｇ','G'),'Ｈ','H'),'Ｉ','I'),'Ｊ','J'),'Ｋ','K'),'Ｌ','L'),'Ｍ','M'),'Ｎ','N'),'Ｏ','O'),'Ｐ','P'),'Ｑ','Q'),'Ｒ','R'),'Ｓ','S'),'Ｔ','T'),'Ｕ','U'),'Ｖ','V'),'Ｗ','W'),'Ｘ','X'),'Ｙ','Y'),'Ｚ','Z'),'ａ','a'),'ｂ','b'),'ｃ','c'),'ｄ','d'),'ｅ','e'),'ｆ','f'),'ｇ','g'),'ｈ','h'),'ｉ','i'),'ｊ','j'),'ｋ','k'),'ｌ','l'),'ｍ','m'),'ｎ','n'),'ｏ','o'),'ｐ','p'),'ｑ','q'),'ｒ','r'),'ｓ','s'),'ｔ','t'),'ｕ','u'),'ｖ','v'),'ｗ','w'),'ｘ','x'),'ｙ','y'),'ｚ','z');

   /*  ログ出力*/
   IF( s_log_flg = 1 ) THEN

    SET w_log_result = CMSF_FUNC_PUT_LOG( s_log_created_by , s_log_prj_name , s_log_apps_name , s_log_mod_name , s_log_prg_var , s_log_type_text
                                        , '2.1.1.4.1 データ正規化処理' , s_empty_string  , w_data , w_result , s_empty_string , 'ALPHABET_HALF' , s_empty_string );

   END IF;

 /* 2.1.1.4.2 データ正規化処理 */
 ELSEIF( w_type_flg = 'ALPHABET_FULL' ) THEN

   SET w_result            = REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE( w_data
                            ,'A','Ａ'),'B','Ｂ'),'C','Ｃ'),'D','Ｄ'),'E','Ｅ'),'F','Ｆ'),'G','Ｇ'),'H','Ｈ'),'I','Ｉ'),'J','Ｊ'),'K','Ｋ'),'L','Ｌ'),'M','Ｍ'),'N','Ｎ'),'O','Ｏ'),'P','Ｐ'),'Q','Ｑ'),'R','Ｒ'),'S','Ｓ'),'T','Ｔ'),'U','Ｕ'),'V','Ｖ'),'W','Ｗ'),'X','Ｘ'),'Y','Ｙ'),'Z','Ｚ'),'a','ａ'),'b','ｂ'),'c','ｃ'),'d','ｄ'),'e','ｅ'),'f','ｆ'),'g','ｇ'),'h','ｈ'),'i','ｉ'),'j','ｊ'),'k','ｋ'),'l','ｌ'),'m','ｍ'),'n','ｎ'),'o','ｏ'),'p','ｐ'),'q','ｑ'),'r','ｒ'),'s','ｓ'),'t','ｔ'),'u','ｕ'),'v','ｖ'),'w','ｗ'),'x','ｘ'),'y','ｙ'),'z','ｚ');

   /*  ログ出力*/
   IF( s_log_flg = 1 ) THEN

    SET w_log_result = CMSF_FUNC_PUT_LOG( s_log_created_by , s_log_prj_name , s_log_apps_name , s_log_mod_name , s_log_prg_var , s_log_type_text
                                        , '2.1.1.4.2 データ正規化処理' , s_empty_string  , w_data , w_result , s_empty_string , 'ALPHABET_FULL' , s_empty_string );

   END IF;

 /* 2.1.1.5.1 データ正規化処理 */
 ELSEIF( w_type_flg = 'HIRAGANA2KATAKANA_HALF' ) THEN

  SET w_result = REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 w_data
                ,'きゃ','ｷｬ'),'きゅ','ｷｭ'),'きょ','ｷｮ'),'しゃ','ｼｬ'),'しゅ','ｼｭ'),'しょ','ｼｮ'),'ちゃ','ﾁｬ'),'ちゅ','ﾁｭ'),'ちょ','ﾁｮ')
                ,'にゃ','ﾆｬ'),'にゅ','ﾆｭ'),'にょ','ﾆｮ'),'ひゃ','ﾋｬ'),'ひゅ','ﾋｭ'),'ひょ','ﾋｮ'),'みゃ','ﾐｬ'),'みゅ','ﾐｭ'),'みょ','ﾐｮ')
                ,'りゃ','ﾘｬ'),'りゅ','ﾘｭ'),'りょ','ﾘｮ')
                ,'ぎゃ','ｷﾞｬ'),'ぎゅ','ｷﾞｭ'),'ぎょ','ｷﾞｮ'),'じゃ','ｼﾞｬ'),'じゅ','ｼﾞｭ'),'じょ','ｼﾞｮ'),'ぢゃ','ﾁﾞｬ'),'ぢゅ','ﾁﾞｭ'),'ぢょ','ﾁﾞｮ')
                ,'びゃ','ﾋﾞｬ'),'びゅ','ﾋﾞｭ'),'びょ','ﾋﾞｮ')
                ,'ぴゃ','ﾋﾟｬ'),'ぴゅ','ﾋﾟｭ'),'ぴょ','ﾋﾟｮ')
                ,'が','ｶﾞ'),'ぎ','ｷﾞ'),'ぐ','ｸﾞ'),'げ','ｹﾞ'),'ご','ｺﾞ'),'ざ','ｻﾞ'),'じ','ｼﾞ'),'ず','ｽﾞ'),'ぜ','ｾﾞ'),'ぞ','ｿﾞ')
                ,'だ','ﾀﾞ'),'ぢ','ﾁﾞ'),'づ','ﾂﾞ'),'で','ﾃﾞ'),'ど','ﾄﾞ'),'ば','ﾊﾞ'),'び','ﾋﾞ'),'ぶ','ﾌﾞ'),'べ','ﾍﾞ'),'ぼ','ﾎﾞ')
                ,'ぱ','ﾊﾟ'),'ぴ','ﾋﾟ'),'ぷ','ﾌﾟ'),'ぺ','ﾍﾟ'),'ぽ','ﾎﾟ')
                ,'あ','ｱ'),'い','ｲ'),'う','ｳ'),'え','ｴ'),'お','ｵ'),'か','ｶ'),'き','ｷ'),'く','ｸ'),'け','ｹ'),'こ','ｺ')
                ,'さ','ｻ'),'し','ｼ'),'す','ｽ'),'せ','ｾ'),'そ','ｿ'),'た','ﾀ'),'ち','ﾁ'),'つ','ﾂ'),'て','ﾃ'),'と','ﾄ')
                ,'な','ﾅ'),'に','ﾆ'),'ぬ','ﾇ'),'ね','ﾈ'),'の','ﾉ'),'は','ﾊ'),'ひ','ﾋ'),'ふ','ﾌ'),'へ','ﾍ'),'ほ','ﾎ')
                ,'ま','ﾏ'),'み','ﾐ'),'む','ﾑ'),'め','ﾒ'),'も','ﾓ'),'や','ﾔ'),'ゐ','ヰ'),'ゆ','ﾕ'),'ゑ','ヱ'),'よ','ﾖ')
                ,'ら','ﾗ'),'り','ﾘ'),'る','ﾙ'),'れ','ﾚ'),'ろ','ﾛ'),'わ','ﾜ'),'を','ｦ'),'ん','ﾝ')
                ,'ぁ','ｧ'),'ぃ','ｨ'),'ぅ','ｩ'),'ぇ','ｪ'),'ぉ','ｫ'),'っ','ｯ'),'ゃ','ｬ'),'ゅ','ｭ'),'ょ','ｮ');

   /* 長音対応(半角) */
   SET w_result            = REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE( w_result ,'-','ｰ'),'ー','ｰ'),'―','ｰ'),'‐','ｰ'),'－','ｰ'),'ｰ','ｰ');

   /*  ログ出力*/
   IF( s_log_flg = 1 ) THEN

    SET w_log_result = CMSF_FUNC_PUT_LOG( s_log_created_by , s_log_prj_name , s_log_apps_name , s_log_mod_name , s_log_prg_var , s_log_type_text
                                        , '2.1.1.5 データ正規化処理' , s_empty_string  , w_data , w_result , s_empty_string , 'HIRAGANA2KATAKANA_HALF' , s_empty_string );

   END IF;

 /* 2.1.1.5.2 データ正規化処理 */
 ELSEIF( w_type_flg = 'HIRAGANA2KATAKANA_FULL' ) THEN

  SET w_result = REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 w_data
                 ,'きゃ','キャ'),'きゅ','キュ'),'きょ','キョ'),'しゃ','シャ'),'しゅ','シュ'),'しょ','ショ'),'ちゃ','チャ'),'ちゅ','チュ'),'ちょ','チョ')
                 ,'にゃ','ニャ'),'にゅ','ニュ'),'にょ','ニョ'),'ひゃ','ヒャ'),'ひゅ','ヒュ'),'ひょ','ヒョ'),'みゃ','ミャ'),'みゅ','ミュ'),'みょ','ミョ')
                 ,'りゃ','リャ'),'りゅ','リュ'),'りょ','リョ')
                 ,'ぎゃ','ギャ'),'ぎゅ','ギュ'),'ぎょ','ギョ'),'じゃ','ジャ'),'じゅ','ジュ'),'じょ','ジョ'),'ぢゃ','ヂャ'),'ぢゅ','ヂュ'),'ぢょ','ヂョ')
                 ,'びゃ','ビャ'),'びゅ','ビュ'),'びょ','ビョ')
                 ,'ぴゃ','ピャ'),'ぴゅ','ピュ'),'ぴょ','ピョ')
                 ,'が','ガ'),'ぎ','ギ'),'ぐ','グ'),'げ','ゲ'),'ご','ゴ'),'ざ','ザ'),'じ','ジ'),'ず','ズ'),'ぜ','ゼ'),'ぞ','ゾ')
                 ,'だ','ダ'),'ぢ','ヂ'),'づ','ヅ'),'で','デ'),'ど','ド'),'ば','バ'),'び','ビ'),'ぶ','ブ'),'べ','ベ'),'ぼ','ボ')
                 ,'ぱ','パ'),'ぴ','ピ'),'ぷ','プ'),'ぺ','ペ'),'ぽ','ポ')
                 ,'あ','ア'),'い','イ'),'う','ウ'),'え','エ'),'お','オ'),'か','カ'),'き','キ'),'く','ク'),'け','ケ'),'こ','コ')
                 ,'さ','サ'),'し','シ'),'す','ス'),'せ','セ'),'そ','ソ'),'た','タ'),'ち','チ'),'つ','ツ'),'て','テ'),'と','ト')
                 ,'な','ナ'),'に','ニ'),'ぬ','ヌ'),'ね','ネ'),'の','ノ'),'は','ハ'),'ひ','ヒ'),'ふ','フ'),'へ','ヘ'),'ほ','ホ')
                 ,'ま','マ'),'み','ミ'),'む','ム'),'め','メ'),'も','モ'),'や','ヤ'),'ゐ','ヰ'),'ゆ','ユ'),'ゑ','ヱ'),'よ','ヨ')
                 ,'ら','ラ'),'り','リ'),'る','ル'),'れ','レ'),'ろ','ロ'),'わ','ワ'),'を','ヲ'),'ん','ン')
                 ,'ぁ','ァ'),'ぃ','ィ'),'ぅ','ゥ'),'ぇ','ェ'),'ぉ','ォ'),'っ','ッ'),'ゃ','ャ'),'ゅ','ュ'),'ょ','ョ');


   /* 長音対応(全角) */
   SET w_result            = REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE( w_result ,'-','ー'),'ー','ー'),'―','ー'),'‐','ー'),'－','ー'),'ｰ','ー');

   /*  ログ出力*/
   IF( s_log_flg = 1 ) THEN

    SET w_log_result = CMSF_FUNC_PUT_LOG( s_log_created_by , s_log_prj_name , s_log_apps_name , s_log_mod_name , s_log_prg_var , s_log_type_text
                                        , '2.1.1.5.2 データ正規化処理' , s_empty_string  , w_data , w_result , s_empty_string , 'HIRAGANA2KATAKANA_FULL' , s_empty_string );

   END IF;

 /* 2.1.1.5.3 データ正規化処理 */
 ELSEIF( w_type_flg = 'KATAKANA_HALF2HIRAGANA' ) THEN

  SET w_result = REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 w_data
                ,'ｶﾞ','が'),'ｷﾞ','ぎ'),'ｸﾞ','ぐ'),'ｹﾞ','げ'),'ｺﾞ','ご'),'ｻﾞ','ざ'),'ｼﾞ','じ'),'ｽﾞ','ず'),'ｾﾞ','ぜ'),'ｿﾞ','ぞ')
                ,'ﾀﾞ','だ'),'ﾁﾞ','ぢ'),'ﾂﾞ','づ'),'ﾃﾞ','で'),'ﾄﾞ','ど'),'ﾊﾞ','ば'),'ﾋﾞ','び'),'ﾌﾞ','ぶ'),'ﾍﾞ','べ'),'ﾎﾞ','ぼ')
                ,'ﾊﾟ','ぱ'),'ﾋﾟ','ぴ'),'ﾌﾟ','ぷ'),'ﾍﾟ','ぺ'),'ﾎﾟ','ぽ')

                ,'ｱ','あ'),'ｲ','い'),'ｳ','う'),'ｴ','え'),'ｵ','お'),'ｶ','か'),'ｷ','き'),'ｸ','く'),'ｹ','け'),'ｺ','こ')
                ,'ｻ','さ'),'ｼ','し'),'ｽ','す'),'ｾ','せ'),'ｿ','そ'),'ﾀ','た'),'ﾁ','ち'),'ﾂ','つ'),'ﾃ','て'),'ﾄ','と')
                ,'ﾅ','な'),'ﾆ','に'),'ﾇ','ぬ'),'ﾈ','ね'),'ﾉ','の'),'ﾊ','は'),'ﾋ','ひ'),'ﾌ','ふ'),'ﾍ','へ'),'ﾎ','ほ')
                ,'ﾏ','ま'),'ﾐ','み'),'ﾑ','む'),'ﾒ','め'),'ﾓ','も'),'ﾔ','や'),'ヰ','ゐ'),'ﾕ','ゆ'),'ヱ','ゑ'),'ﾖ','よ')
                ,'ﾗ','ら'),'ﾘ','り'),'ﾙ','る'),'ﾚ','れ'),'ﾛ','ろ'),'ﾜ','わ'),'ｦ','を'),'ﾝ','ん')
                ,'ｧ','ぁ'),'ｨ','ぃ'),'ｩ','ぅ'),'ｪ','ぇ'),'ｫ','ぉ'),'ｯ','っ'),'ｬ','ゃ'),'ｭ','ゅ'),'ｮ','ょ');


   /* 長音対応(全角) */
   SET w_result            = REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE( w_result ,'-','ー'),'ー','ー'),'―','ー'),'‐','ー'),'－','ー'),'ｰ','ー');


   /*  ログ出力*/
   IF( s_log_flg = 1 ) THEN

    SET w_log_result = CMSF_FUNC_PUT_LOG( s_log_created_by , s_log_prj_name , s_log_apps_name , s_log_mod_name , s_log_prg_var , s_log_type_text
                                        , '2.1.1.5.3 データ正規化処理' , s_empty_string  , w_data , w_result , s_empty_string , 'KATAKANA_HALF2HIRAGANA' , s_empty_string );

   END IF;

 /* 2.1.1.6 データ正規化処理 */
 ELSEIF( w_type_flg = 'HIRAGANA2HEPBURN' ) THEN

  SET w_result = REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 w_data
                ,'きゃ','KYA'),'きゅ','KYU'),'きょ','KYO'),'しゃ','SHA'),'しゅ','SHU'),'しょ','SHO'),'ちゃ','CHA'),'ちゅ','CHU'),'ちょ','CHO')
                ,'にゃ','NYA'),'にゅ','NYU'),'にょ','NYO'),'ひゃ','HYA'),'ひゅ','HYU'),'ひょ','HYO'),'みゃ','MYA'),'みゅ','MYU'),'みょ','MYO')
                ,'りゃ','RYA'),'りゅ','RYU'),'りょ','RYO')
                ,'ぎゃ','GYA'),'ぎゅ','GYU'),'ぎょ','GYO'),'じゃ','JA'),'じゅ','JU'),'じょ','JO'),'ぢゃ','JA'),'ぢゅ','JU'),'ぢょ','JO')
                ,'びゃ','BYA'),'びゅ','BYU'),'びょ','BYO')
                ,'ぴゃ','PYA'),'ぴゅ','PYU'),'ぴょ','PYO')
                ,'が','GA'),'ぎ','GI'),'ぐ','GU'),'げ','GE'),'ご','GO'),'ざ','ZA'),'じ','JI'),'ず','ZU'),'ぜ','ZE'),'ぞ','ZO')
                ,'だ','DA'),'ぢ','JI'),'づ','ZU'),'で','DE'),'ど','DO'),'ば','BA'),'び','BI'),'ぶ','BU'),'べ','BE'),'ぼ','BO')
                ,'ぱ','PA'),'ぴ','PI'),'ぷ','PU'),'ぺ','PE'),'ぽ','PO')
                ,'あ','A'),'い','I'),'う','U'),'え','E'),'お','O'),'か','KA'),'き','KI'),'く','KU'),'け','KE'),'こ','KO')
                ,'さ','SA'),'し','SHI'),'す','SU'),'せ','SE'),'そ','SO'),'た','TA'),'ち','CHI'),'つ','TSU'),'て','TE'),'と','TO')
                ,'な','NA'),'に','NI'),'ぬ','NU'),'ね','NE'),'の','NO'),'は','HA'),'ひ','HI'),'ふ','FU'),'へ','HE'),'ほ','HO')
                ,'ま','MA'),'み','MI'),'む','MU'),'め','ME'),'も','MO'),'や','YA'),'ゐ','I'),'ゆ','YU'),'ゑ','E'),'よ','YO')
                ,'ら','RA'),'り','RI'),'る','RU'),'れ','RE'),'ろ','RO'),'わ','WA'),'を','O'),'ん','N')
                ,'ぁ','A'),'ぃ','I'),'ぅ','U'),'ぇ','E'),'ぉ','O'),'っ','TSU'),'ゃ','YA'),'ゅ','YU'),'ょ','YO');

   /* ヘボン式の場合、P、M、Nの前にあるNはMと表記する */
   SET w_result = REPLACE(REPLACE(REPLACE( w_result ,'NP','MP'),'NM','MM'),'NN','MN');

   /* アルファベットの場合、長音は^と表記する */
   SET w_result            = REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE( w_result ,'-','^'),'ー','^'),'―','^'),'‐','^'),'－','^'),'ｰ','^');

   /*  ログ出力*/
   IF( s_log_flg = 1 ) THEN

    SET w_log_result = CMSF_FUNC_PUT_LOG( s_log_created_by , s_log_prj_name , s_log_apps_name , s_log_mod_name , s_log_prg_var , s_log_type_text
                                        , '2.1.1.6 データ正規化処理' , s_empty_string  , w_data , w_result , s_empty_string , 'HIRAGANA2HEPBURN' , s_empty_string );

   END IF;

 /* 2.1.1.7 データ正規化処理 */
 ELSEIF( w_type_flg = 'HIRAGANA2KUNREI' ) THEN

  SET w_result = REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(                 w_data
                 ,'きゃ','KYA'),'きゅ','KYU'),'きょ','KYO'),'しゃ','SYA'),'しゅ','SYU'),'しょ','SYO'),'ちゃ','TYA'),'ちゅ','TYU'),'ちょ','TYO')
                 ,'にゃ','NYA'),'にゅ','NYU'),'にょ','NYO'),'ひゃ','HYA'),'ひゅ','HYU'),'ひょ','HYO'),'みゃ','MYA'),'みゅ','MYU'),'みょ','MYO')
                 ,'りゃ','RYA'),'りゅ','RYU'),'りょ','RYO')
                 ,'ぎゃ','GYA'),'ぎゅ','GYU'),'ぎょ','GYO'),'じゃ','ZYA'),'じゅ','ZYU'),'じょ','ZYO'),'ぢゃ','DYA'),'ぢゅ','DYU'),'ぢょ','DYO')
                 ,'びゃ','BYA'),'びゅ','BYU'),'びょ','BYO')
                 ,'ぴゃ','PYA'),'ぴゅ','PYU'),'ぴょ','PYO')
                 ,'が','GA'),'ぎ','GI'),'ぐ','GU'),'げ','GE'),'ご','GO'),'ざ','ZA'),'じ','ZI'),'ず','ZU'),'ぜ','ZE'),'ぞ','ZO')
                 ,'だ','DA'),'ぢ','ZI'),'づ','ZU'),'で','DE'),'ど','DO'),'ば','BA'),'び','BI'),'ぶ','BU'),'べ','BE'),'ぼ','BO')
                 ,'ぱ','PA'),'ぴ','PI'),'ぷ','PU'),'ぺ','PE'),'ぽ','PO')
                 ,'あ','A'),'い','I'),'う','U'),'え','E'),'お','O'),'か','KA'),'き','KI'),'く','KU'),'け','KE'),'こ','KO')
                 ,'さ','SA'),'し','SI'),'す','SU'),'せ','SE'),'そ','SO'),'た','TA'),'ち','TI'),'つ','TU'),'て','TE'),'と','TO')
                 ,'な','NA'),'に','NI'),'ぬ','NU'),'ね','NE'),'の','NO'),'は','HA'),'ひ','HI'),'ふ','HU'),'へ','HE'),'ほ','HO')
                 ,'ま','MA'),'み','MI'),'む','MU'),'め','ME'),'も','MO'),'や','YA'),'ゐ','I'),'ゆ','YU'),'ゑ','E'),'よ','YO')
                 ,'ら','RA'),'り','RI'),'る','RU'),'れ','RE'),'ろ','RO'),'わ','WA')  ,'を','WO'),'ん','N')
                 ,'ぁ','A'),'ぃ','I'),'ぅ','U'),'ぇ','E'),'ぉ','O'),'っ','TU'),'ゃ','YA'),'ゅ','YU'),'ょ','YO');

   /* アルファベットの場合、長音は^と表記する */
   SET w_result            = REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE( w_result ,'-','^'),'ー','^'),'―','^'),'‐','^'),'－','^'),'ｰ','^');


   /*  ログ出力*/
   IF( s_log_flg = 1 ) THEN

    SET w_log_result = CMSF_FUNC_PUT_LOG( s_log_created_by , s_log_prj_name , s_log_apps_name , s_log_mod_name , s_log_prg_var , s_log_type_text
                                        , '2.1.1.7 データ正規化処理' , s_empty_string  , w_data , w_result , s_empty_string , 'HIRAGANA2KUNREI' , s_empty_string );

   END IF;

 /* 2.1.1.8.2 データ正規化処理 */
 ELSEIF( w_type_flg = 'KATAKANA_FULL2HIRAGANA' ) THEN

  SET w_result = REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 w_data
                ,'キャ','きゃ'),'キュ','きゅ'),'キョ','きょ'),'シャ','しゃ'),'シュ','しゅ'),'ショ','しょ'),'チャ','ちゃ'),'チュ','ちゅ'),'チョ','ちょ')
                ,'ニャ','にゃ'),'ニュ','にゅ'),'ニョ','にょ'),'ヒャ','ひゃ'),'ヒュ','ひゅ'),'ヒョ','ひょ'),'ミャ','みゃ'),'ミュ','みゅ'),'ミョ','みょ')
                ,'リャ','りゃ'),'リュ','りゅ'),'リョ','りょ')
                ,'ギャ','ぎゃ'),'ギュ','ぎゅ'),'ギョ','ぎょ'),'ジャ','じゃ'),'ジュ','じゅ'),'ジョ','じょ'),'ヂャ','ぢゃ'),'ヂュ','ぢゅ'),'ヂョ','ぢょ')
                ,'ビャ','びゃ'),'ビュ','びゅ'),'ビョ','びょ')
                ,'ピャ','ぴゃ'),'ピュ','ぴゅ'),'ピョ','ぴょ')
                ,'ガ','が'),'ギ','ぎ'),'グ','ぐ'),'ゲ','げ'),'ゴ','ご'),'ザ','ざ'),'ジ','じ'),'ズ','ず'),'ゼ','ぜ'),'ゾ','ぞ')
                ,'ダ','だ'),'ヂ','ぢ'),'ヅ','づ'),'デ','で'),'ド','ど'),'バ','ば'),'ビ','び'),'ブ','ぶ'),'ベ','べ'),'ボ','ぼ')
                ,'パ','ぱ'),'ピ','ぴ'),'プ','ぷ'),'ペ','ぺ'),'ポ','ぽ')
                ,'ア','あ'),'イ','い'),'ウ','う'),'エ','え'),'オ','お'),'カ','か'),'キ','き'),'ク','く'),'ケ','け'),'コ','こ')
                ,'サ','さ'),'シ','し'),'ス','す'),'セ','せ'),'ソ','そ'),'タ','た'),'チ','ち'),'ツ','つ'),'テ','て'),'ト','と')
                ,'ナ','な'),'ニ','に'),'ヌ','ぬ'),'ネ','ね'),'ノ','の'),'ハ','は'),'ヒ','ひ'),'フ','ふ'),'ヘ','へ'),'ホ','ほ')
                ,'マ','ま'),'ミ','み'),'ム','む'),'メ','め'),'モ','も'),'ヤ','や'),'ヰ','ゐ'),'ユ','ゆ'),'ヱ','ゑ'),'ヨ','よ')
                ,'ラ','ら'),'リ','り'),'ル','る'),'レ','れ'),'ロ','ろ'),'ワ','わ'),'ヲ','を'),'ン','ん')
                ,'ァ','ぁ'),'ィ','ぃ'),'ゥ','ぅ'),'ェ','ぇ'),'ォ','ぉ'),'ッ','っ'),'ャ','ゃ'),'ュ','ゅ'),'ョ','ょ');

   /* 長音対応(全角) */
   SET w_result            = REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE( w_result ,'-','ー'),'ー','ー'),'―','ー'),'‐','ー'),'－','ー'),'ｰ','ー');

   /*  ログ出力*/
   IF( s_log_flg = 1 ) THEN

    SET w_log_result = CMSF_FUNC_PUT_LOG( s_log_created_by , s_log_prj_name , s_log_apps_name , s_log_mod_name , s_log_prg_var , s_log_type_text
                                        , '2.1.1.8 データ正規化処理' , s_empty_string  , w_data , w_result , s_empty_string , 'KATAKANA_FULL2HIRAGANA' , s_empty_string );

   END IF;

 /* 2.1.1.8.2.1 データ正規化処理 */
 ELSEIF( w_type_flg = 'KATAKANA_FULL2KATAKANA_HALF' ) THEN

  SET w_result = REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 w_data
                 ,'キャ','ｷｬ'),'キュ','ｷｭ'),'キョ','ｷｮ'),'シャ','ｼｬ'),'シュ','ｼｭ'),'ショ','ｼｮ'),'チャ','ﾁｬ'),'チュ','ﾁｭ'),'チョ','ﾁｮ')
                 ,'ニャ','ﾆｬ'),'ニュ','ﾆｭ'),'ニョ','ﾆｮ'),'ヒャ','ﾋｬ'),'ヒュ','ﾋｭ'),'ヒョ','ﾋｮ'),'ミャ','ﾐｬ'),'ミュ','ﾐｭ'),'ミョ','ﾐｮ')
                 ,'リャ','ﾘｬ'),'リュ','ﾘｭ'),'リョ','ﾘｮ')
                 ,'ギャ','ｷﾞｬ'),'ギュ','ｷﾞｭ'),'ギョ','ｷﾞｮ'),'ジャ','ｼﾞｬ'),'ジュ','ｼﾞｭ'),'ジョ','ｼﾞｮ'),'ヂャ','ﾁﾞｬ'),'ヂュ','ﾁﾞｭ'),'ヂョ','ﾁﾞｮ')
                 ,'ビャ','ﾋﾞｬ'),'ビュ','ﾋﾞｭ'),'ビョ','ﾋﾞｮ')
                 ,'ピャ','ﾋﾟｬ'),'ピュ','ﾋﾟｭ'),'ピョ','ﾋﾟｮ')
                 ,'ガ','ｶﾞ'),'ギ','ｷﾞ'),'グ','ｸﾞ'),'ゲ','ｹﾞ'),'ゴ','ｺﾞ'),'ザ','ｻﾞ'),'ジ','ｼﾞ'),'ズ','ｽﾞ'),'ゼ','ｾﾞ'),'ゾ','ｿﾞ')
                 ,'ダ','ﾀﾞ'),'ヂ','ﾁﾞ'),'ヅ','ﾂﾞ'),'デ','ﾃﾞ'),'ド','ﾄﾞ'),'バ','ﾊﾞ'),'ビ','ﾋﾞ'),'ブ','ﾌﾞ'),'ベ','ﾍﾞ'),'ボ','ﾎﾞ')
                 ,'パ','ﾊﾟ'),'ピ','ﾋﾟ'),'プ','ﾌﾟ'),'ペ','ﾍﾟ'),'ポ','ﾎﾟ')
                 ,'ア','ｱ'),'イ','ｲ'),'ウ','ｳ'),'エ','ｴ'),'オ','ｵ'),'カ','ｶ'),'キ','ｷ'),'ク','ｸ'),'ケ','ｹ'),'コ','ｺ')
                 ,'サ','ｻ'),'シ','ｼ'),'ス','ｽ'),'セ','ｾ'),'ソ','ｿ'),'タ','ﾀ'),'チ','ﾁ'),'ツ','ﾂ'),'テ','ﾃ'),'ト','ﾄ')
                 ,'ナ','ﾅ'),'ニ','ﾆ'),'ヌ','ﾇ'),'ネ','ﾈ'),'ノ','ﾉ'),'ハ','ﾊ'),'ヒ','ﾋ'),'フ','ﾌ'),'ヘ','ﾍ'),'ホ','ﾎ')
                 ,'マ','ﾏ'),'ミ','ﾐ'),'ム','ﾑ'),'メ','ﾒ'),'モ','ﾓ'),'ヤ','ﾔ'),'ヰ','ヰ'),'ユ','ﾕ'),'ヱ','ヱ'),'ヨ','ﾖ')
                 ,'ラ','ﾗ'),'リ','ﾘ'),'ル','ﾙ'),'レ','ﾚ'),'ロ','ﾛ'),'ワ','ﾜ'),'ヲ','ｦ'),'ン','ﾝ')
                 ,'ァ','ｧ'),'ィ','ｨ'),'ゥ','ｩ'),'ェ','ｪ'),'ォ','ｫ'),'ッ','ｯ'),'ャ','ｬ'),'ュ','ｭ'),'ョ','ｮ');

   /* 『ヴ』ロジック対応(長音) */
   SET w_result            = REPLACE( w_result ,'ヴ','ｳﾞ');

   /* 長音対応(半角) */
   SET w_result            = REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE( w_result ,'-','ｰ'),'ー','ｰ'),'―','ｰ'),'‐','ｰ'),'－','ｰ'),'ｰ','ｰ');


   /*  ログ出力*/
   IF( s_log_flg = 1 ) THEN

    SET w_log_result = CMSF_FUNC_PUT_LOG( s_log_created_by , s_log_prj_name , s_log_apps_name , s_log_mod_name , s_log_prg_var , s_log_type_text
                                        , '2.1.1.8.2.1 データ正規化処理' , s_empty_string  , w_data , w_result , s_empty_string , 'KATAKANA_FULL2KATAKANA_HALF' , s_empty_string );

   END IF;

 /* 2.1.1.8.2.2 データ正規化処理 */
 ELSEIF( w_type_flg = 'KATAKANA_HALF2KATAKANA_FULL' ) THEN

  SET w_result = REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 w_data
                ,'ｷｬ','キャ'),'ｷｭ','キュ'),'ｷｮ','キョ'),'ｼｬ','シャ'),'ｼｭ','シュ'),'ｼｮ','ショ'),'ﾁｬ','チャ'),'ﾁｭ','チュ'),'ﾁｮ','チョ')
                ,'ﾆｬ','ニャ'),'ﾆｭ','ニュ'),'ﾆｮ','ニョ'),'ﾋｬ','ヒャ'),'ﾋｭ','ヒュ'),'ﾋｮ','ヒョ'),'ﾐｬ','ミャ'),'ﾐｭ','ミュ'),'ﾐｮ','ミョ')
                ,'ﾘｬ','リャ'),'ﾘｭ','リュ'),'ﾘｮ','リョ')
                ,'ｷﾞｬ','ギャ'),'ｷﾞｭ','ギュ'),'ｷﾞｮ','ギョ'),'ｼﾞｬ','ジャ'),'ｼﾞｭ','ジュ'),'ｼﾞｮ','ジョ'),'ﾁﾞｬ','ヂャ'),'ﾁﾞｭ','ヂュ'),'ﾁﾞｮ','ヂョ')
                ,'ﾋﾞｬ','ビャ'),'ﾋﾞｭ','ビュ'),'ﾋﾞｮ','ビョ')
                ,'ﾋﾟｬ','ピャ'),'ﾋﾟｭ','ピュ'),'ﾋﾟｮ','ピョ')
                ,'ｶﾞ','ガ'),'ｷﾞ','ギ'),'ｸﾞ','グ'),'ｹﾞ','ゲ'),'ｺﾞ','ゴ'),'ｻﾞ','ザ'),'ｼﾞ','ジ'),'ｽﾞ','ズ'),'ｾﾞ','ゼ'),'ｿﾞ','ゾ')
                ,'ﾀﾞ','ダ'),'ﾁﾞ','ヂ'),'ﾂﾞ','ヅ'),'ﾃﾞ','デ'),'ﾄﾞ','ド'),'ﾊﾞ','バ'),'ﾋﾞ','ビ'),'ﾌﾞ','ブ'),'ﾍﾞ','ベ'),'ﾎﾞ','ボ')
                ,'ﾊﾟ','パ'),'ﾋﾟ','ピ'),'ﾌﾟ','プ'),'ﾍﾟ','ペ'),'ﾎﾟ','ポ')
                ,'ｱ','ア'),'ｲ','イ'),'ｳ','ウ'),'ｴ','エ'),'ｵ','オ'),'ｶ','カ'),'ｷ','キ'),'ｸ','ク'),'ｹ','ケ'),'ｺ','コ')
                ,'ｻ','サ'),'ｼ','シ'),'ｽ','ス'),'ｾ','セ'),'ｿ','ソ'),'ﾀ','タ'),'ﾁ','チ'),'ﾂ','ツ'),'ﾃ','テ'),'ﾄ','ト')
                ,'ﾅ','ナ'),'ﾆ','ニ'),'ﾇ','ヌ'),'ﾈ','ネ'),'ﾉ','ノ'),'ﾊ','ハ'),'ﾋ','ヒ'),'ﾌ','フ'),'ﾍ','ヘ'),'ﾎ','ホ')
                ,'ﾏ','マ'),'ﾐ','ミ'),'ﾑ','ム'),'ﾒ','メ'),'ﾓ','モ'),'ﾔ','ヤ'),'ヰ','ヰ'),'ﾕ','ユ'),'ヱ','ヱ'),'ﾖ','ヨ')
                 ,'ﾗ','ラ'),'ﾘ','リ'),'ﾙ','ル'),'ﾚ','レ'),'ﾛ','ロ'),'ﾜ','ワ'),'ｦ','ヲ'),'ﾝ','ン')
                 ,'ｧ','ァ'),'ｨ','ィ'),'ｩ','ゥ'),'ｪ','ェ'),'ｫ','ォ'),'ｯ','ッ'),'ｬ','ャ'),'ｭ','ュ'),'ｮ','ョ');

   /* 『ヴ』ロジック対応(長音) */
   SET w_result            = REPLACE( w_result ,'ｳﾞ','ヴ');

   /* 長音対応(全角) */
   SET w_result            = REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE( w_result ,'-','ー'),'ー','ー'),'―','ー'),'‐','ー'),'－','ー'),'ｰ','ー');


   /*  ログ出力*/
   IF( s_log_flg = 1 ) THEN

    SET w_log_result = CMSF_FUNC_PUT_LOG( s_log_created_by , s_log_prj_name , s_log_apps_name , s_log_mod_name , s_log_prg_var , s_log_type_text
                                        , '2.1.1.8.2.2 データ正規化処理' , s_empty_string  , w_data , w_result , s_empty_string , 'KATAKANA_HALF2KATAKANA_FULL' , s_empty_string );

   END IF;

 /* 2.1.1.9 データ正規化処理 */
 ELSEIF( w_type_flg = 'KATAKANA2HEPBURN' ) THEN

   /* 『ヴ』ロジック対応(長音) */
   SET w_result            = REPLACE(REPLACE(REPLACE(REPLACE(
                             REPLACE(REPLACE(REPLACE(
                             REPLACE(
                             w_result
                             ,'ヴァ','VA'),'ヴィ','VI'),'ヴェ','VE'),'ヴォ','VO')
                             ,'ヴュ','VHU'),'ヴュ','VHI'),'ヴェ','VHE')
                             ,'ヴ','VU');

  SET w_result = REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 w_data
                 ,'キャ','KYA'),'キュ','KYU'),'キョ','KYO'),'シャ','SHA'),'シュ','SHU'),'ショ','SHO'),'チャ','CHA'),'チュ','CHU'),'チョ','CHO')
                 ,'ニャ','NYA'),'ニュ','NYU'),'ニョ','NYO'),'ヒャ','HYA'),'ヒュ','HYU'),'ヒョ','HYO'),'ミャ','MYA'),'ミュ','MYU'),'ミョ','MYO')
                 ,'リャ','RYA'),'リュ','RYU'),'リョ','RYO')
                 ,'ギャ','GYA'),'ギュ','GYU'),'ギョ','GYO'),'ジャ','JA'),'ジュ','JU'),'ジョ','JO'),'ヂャ','JA'),'ヂュ','JU'),'ヂョ','JO')
                 ,'ビャ','BYA'),'ビュ','BYU'),'ビョ','BYO')
                 ,'ピャ','PYA'),'ピュ','PYU'),'ピョ','PYO')
                 ,'ガ','GA'),'ギ','GI'),'グ','GU'),'ゲ','GE'),'ゴ','GO'),'ザ','ZA'),'ジ','JI'),'ズ','ZU'),'ゼ','ZE'),'ゾ','ZO')
                 ,'ダ','DA'),'ヂ','JI'),'ヅ','ZU'),'デ','DE'),'ド','DO'),'バ','BA'),'ビ','BI'),'ブ','BU'),'ベ','BE'),'ボ','BO')
                 ,'パ','PA'),'ピ','PI'),'プ','PU'),'ペ','PE'),'ポ','PO')
                 ,'ア','A'),'イ','I'),'ウ','U'),'エ','E'),'オ','O'),'カ','KA'),'キ','KI'),'ク','KU'),'ケ','KE'),'コ','KO')
                 ,'サ','SA'),'シ','SHI'),'ス','SU'),'セ','SE'),'ソ','SO'),'タ','TA'),'チ','CHI'),'ツ','TSU'),'テ','TE'),'ト','TO')
                 ,'ナ','NA'),'ニ','NI'),'ヌ','NU'),'ネ','NE'),'ノ','NO'),'ハ','HA'),'ヒ','HI'),'フ','FU'),'ヘ','HE'),'ホ','HO')
                 ,'マ','MA'),'ミ','MI'),'ム','MU'),'メ','ME'),'モ','MO'),'ヤ','YA'),'ヰ','I'),'ユ','YU'),'ヱ','E'),'ヨ','YO')
                 ,'ラ','RA'),'リ','RI'),'ル','RU'),'レ','RE'),'ロ','RO'),'ワ','WA'),'ヲ','O'),'ン','N')
                 ,'ァ','A'),'ィ','I'),'ゥ','U'),'ェ','E'),'ォ','O'),'ッ','TSU'),'ャ','YA'),'ュ','YU'),'ョ','YO');

   /* ヘボン式の場合、P、M、Nの前にあるNはMと表記する */
   SET w_result = REPLACE(REPLACE(REPLACE( w_result ,'NP','MP'),'NM','MM'),'NN','MN');

   /* アルファベットの場合、長音は^と表記する */
   SET w_result            = REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE( w_result ,'-','^'),'ー','^'),'―','^'),'‐','^'),'－','^'),'ｰ','^');


   /*  ログ出力*/
   IF( s_log_flg = 1 ) THEN

    SET w_log_result = CMSF_FUNC_PUT_LOG( s_log_created_by , s_log_prj_name , s_log_apps_name , s_log_mod_name , s_log_prg_var , s_log_type_text
                                        , '2.1.1.9 データ正規化処理' , s_empty_string  , w_data , w_result , s_empty_string , 'KATAKANA2HEPBURN' , s_empty_string );

   END IF;

 /* 2.1.1.10 データ正規化処理 */
 ELSEIF( w_type_flg = 'KATAKANA2KUNREI' ) THEN

   /* 『ヴ』ロジック対応(長音) */
   SET w_result            = REPLACE(REPLACE(REPLACE(REPLACE(
                             REPLACE(REPLACE(REPLACE(
                             REPLACE(
                             w_result
                            ,'ヴァ','VA'),'ヴィ','VI'),'ヴェ','VE'),'ヴォ','VO')
                            ,'ヴュ','VYU'),'ヴュ','VYI'),'ヴェ','VYE')
                            ,'ヴ','VU');

  SET w_result = REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 w_data
                ,'キャ','KYA'),'キュ','KYU'),'キョ','KYO'),'シャ','SYA'),'シュ','SYU'),'ショ','SYO'),'チャ','TYA'),'チュ','TYU'),'チョ','TYO')
                ,'ニャ','NYA'),'ニュ','NYU'),'ニョ','NYO'),'ヒャ','HYA'),'ヒュ','HYU'),'ヒョ','HYO'),'ミャ','MYA'),'ミュ','MYU'),'ミョ','MYO')
                ,'リャ','RYA'),'リュ','RYU'),'リョ','RYO')
                ,'ギャ','GYA'),'ギュ','GYU'),'ギョ','GYO'),'ジャ','ZYA'),'ジュ','ZYU'),'ジョ','ZYO'),'ヂャ','DYA'),'ヂュ','DYU'),'ヂョ','DYO')
                ,'ビャ','BYA'),'ビュ','BYU'),'ビョ','BYO')
                ,'ピャ','PYA'),'ピュ','PYU'),'ピョ','PYO')
                ,'ガ','GA'),'ギ','GI'),'グ','GU'),'ゲ','GE'),'ゴ','GO'),'ザ','ZA'),'ジ','ZI'),'ズ','ZU'),'ゼ','ZE'),'ゾ','ZO')
                ,'ダ','DA'),'ヂ','ZI'),'ヅ','ZU'),'デ','DE'),'ド','DO'),'バ','BA'),'ビ','BI'),'ブ','BU'),'ベ','BE'),'ボ','BO')
                ,'パ','PA'),'ピ','PI'),'プ','PU'),'ペ','PE'),'ポ','PO')
                ,'ア','A'),'イ','I'),'ウ','U'),'エ','E'),'オ','O'),'カ','KA'),'キ','KI'),'ク','KU'),'ケ','KE'),'コ','KO')
                ,'サ','SA'),'シ','SI'),'ス','SU'),'セ','SE'),'ソ','SO'),'タ','TA'),'チ','TI'),'ツ','TU'),'テ','TE'),'ト','TO')
                ,'ナ','NA'),'ニ','NI'),'ヌ','NU'),'ネ','NE'),'ノ','NO'),'ハ','HA'),'ヒ','HI'),'フ','HU'),'ヘ','HE'),'ホ','HO')
                ,'マ','MA'),'ミ','MI'),'ム','MU'),'メ','ME'),'モ','MO'),'ヤ','YA'),'ヰ','I'),'ユ','YU'),'ヱ','E'),'ヨ','YO')
                ,'ラ','RA'),'リ','RI'),'ル','RU'),'レ','RE'),'ロ','RO'),'ワ','WA'),'ヲ','WO'),'ン','N')
                ,'ァ','A'),'ィ','I'),'ゥ','U'),'ェ','E'),'ォ','O'),'ッ','TU'),'ャ','YA'),'ュ','YU'),'ョ','YO');

   /* アルファベットの場合、長音は^と表記する */
   SET w_result            = REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE( w_result ,'-','^'),'ー','^'),'―','^'),'‐','^'),'－','^'),'ｰ','^');



   /*  ログ出力*/
   IF( s_log_flg = 1 ) THEN

    SET w_log_result = CMSF_FUNC_PUT_LOG( s_log_created_by , s_log_prj_name , s_log_apps_name , s_log_mod_name , s_log_prg_var , s_log_type_text
                                        , '2.1.1.10 データ正規化処理' , s_empty_string  , w_data , w_result , s_empty_string , 'KATAKANA2KUNREI' , s_empty_string );

   END IF;

 /* 2.1.1.10.1 データ正規化処理 */
 ELSEIF( w_type_flg = 'UPPER_KATAKANA_FULL' ) THEN

  SET w_result = REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(
                 REPLACE(
                 w_data
                ,'ァ' , 'ア') , 'ィ' , 'イ') , 'ゥ' , 'ウ') , 'ェ' , 'エ') , 'ォ' , 'オ' )
                ,'ャ' , 'ヤ') , 'ュ' , 'ユ') , 'ョ' , 'ヨ')
                ,'ッ' , 'ツ');

   /*  ログ出力*/
   IF( s_log_flg = 1 ) THEN

    SET w_log_result = CMSF_FUNC_PUT_LOG( s_log_created_by , s_log_prj_name , s_log_apps_name , s_log_mod_name , s_log_prg_var , s_log_type_text
                                        , '2.1.1.10 データ正規化処理' , s_empty_string  , w_data , w_result , s_empty_string , 'UPPER_KATAKANA_FULL' , s_empty_string );

   END IF;

 /* 2.1.1.10.2 データ正規化処理 */
 ELSEIF( w_type_flg = 'UPPER_KATAKANA_HALF' ) THEN

  SET w_result = REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(
                 REPLACE(
                 w_data
                ,'ｧ' , 'ｱ') , 'ｨ' , 'ｲ') , 'ｩ' , 'ｳ') , 'ｪ' , 'ｴ') , 'ｫ' , 'ｵ' )
                ,'ｬ' , 'ﾔ') , 'ｭ' , 'ﾕ') , 'ｮ' , 'ﾖ')
                ,'ｯ' , 'ﾂ');

   /*  ログ出力*/
   IF( s_log_flg = 1 ) THEN

    SET w_log_result = CMSF_FUNC_PUT_LOG( s_log_created_by , s_log_prj_name , s_log_apps_name , s_log_mod_name , s_log_prg_var , s_log_type_text
                                        , '2.1.1.10 データ正規化処理' , s_empty_string  , w_data , w_result , s_empty_string , 'UPPER_KATAKANA_HALF' , s_empty_string );

   END IF;

 /* 2.1.1.11 データ正規化処理 */
 ELSEIF( w_type_flg = 'CORPORATE_TYPE_NORMALIZE' ) THEN

  SET w_data   = REPLACE(REPLACE( w_data , '（' ,'(' ) , '）' ,')');

  SET w_result = REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 w_data
                ,'(株式会社)',s_kabushiki_kaisya ),'株式会社',s_kabushiki_kaisya),'(株)',s_kabushiki_kaisya),'株)',s_kabushiki_kaisya),'㈱',s_kabushiki_kaisya),'カブシキカイシャ',s_kabushiki_kaisya),'カブ)',s_kabushiki_kaisya)
                ,'(有限会社)',s_yuugen_kaisya),'有限会社',s_yuugen_kaisya),'(有)',s_yuugen_kaisya),'有)',s_yuugen_kaisya),'㈲',s_yuugen_kaisya),'ユウゲンカイシャ',s_yuugen_kaisya),'ユウ)',s_yuugen_kaisya)
                ,'(合資会社)',s_goushi_kaisya),'合資会社',s_goushi_kaisya),'(資)',s_goushi_kaisya),'資)',s_goushi_kaisya),'ゴウシカイシャ',s_goushi_kaisya),'シ)',s_goushi_kaisya)
                ,'(合名会社)',s_goumei_kaisya),'合名会社',s_goumei_kaisya),'(名)',s_goumei_kaisya),'名)',s_goumei_kaisya),'ゴウメイカイシャ',s_goumei_kaisya),'メイ)',s_goumei_kaisya)
                ,'(合同会社)',s_goudou_kaisya),'合同会社',s_goudou_kaisya),'(同)',s_goudou_kaisya),'同)',s_goudou_kaisya),'ユウドウカイシャ',s_goudou_kaisya),'ドウ)',s_goudou_kaisya)
                ,'(財団法人)',s_zaidan_hojin),'財団法人',s_zaidan_hojin),'(財団)',s_zaidan_hojin),'財団)',s_zaidan_hojin),'(財)',s_zaidan_hojin),'財)',s_zaidan_hojin),'ザイダンホウジン',s_zaidan_hojin),'ザイ)',s_zaidan_hojin)
                ,'(医療法人)',s_iryou_hojon),'医療法人',s_iryou_hojon),'(医療)',s_iryou_hojon),'医療)',s_iryou_hojon),'(医)',s_iryou_hojon),'医)',s_iryou_hojon),'イリョウホウジン',s_iryou_hojon),'イ)',s_iryou_hojon)
                ,'(宗教法人)',s_syukyou_hojin),'宗教法人',s_syukyou_hojin),'(宗教)',s_syukyou_hojin),'宗教)',s_syukyou_hojin),'(宗)',s_syukyou_hojin),'宗)',s_syukyou_hojin),'シュウキョウホウジン',s_syukyou_hojin),'シュウ)',s_syukyou_hojin);

   /*  ログ出力*/
   IF( s_log_flg = 1 ) THEN

    SET w_log_result = CMSF_FUNC_PUT_LOG( s_log_created_by , s_log_prj_name , s_log_apps_name , s_log_mod_name , s_log_prg_var , s_log_type_text
                                        , '2.1.1.11 データ正規化処理' , s_empty_string  , w_data , w_result , s_empty_string , 'CORPORATE_TYPE_NORMALIZE' , s_empty_string );

   END IF;

 /* 2.1.1.12 データ正規化処理 */
 ELSEIF( w_type_flg = 'CORPORATE_TYPE_STRIP' ) THEN

  SET w_data   = REPLACE(REPLACE( w_data , '（' ,'(' ) , '）' ,')');

  SET w_result = REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 w_data
                ,'(株式会社)',''),'株式会社',''),'(株)',''),'株)',''),'㈱',''),'カブシキカイシャ',''),'カブ)','')
                ,'(有限会社)',''),'有限会社',''),'(有)',''),'有)',''),'㈲',''),'ユウゲンカイシャ)',''),'ユウ)','')
                ,'(合資会社)',''),'合資会社',''),'(資)',''),'資)',''),'ゴウシカイシャ)',''),'シ)','')
                ,'(合名会社)',''),'合名会社',''),'(名)',''),'名)',''),'ゴウメイカイシャ)',''),'メイ)','')
                ,'(合同会社)',''),'合同会社',''),'(同)',''),'同)',''),'ユウドウカイシャ)',''),'ドウ)','')
                ,'(財団法人)',''),'財団法人',''),'(財団)',''),'財団)',''),'(財)',''),'財)',''),'ザイダンホウジン)',''),'ザイ)','')
                ,'(医療法人)',''),'医療法人',''),'(医療)',''),'医療)',''),'(医)',''),'医)',''),'イリョウホウジン)',''),'イ)','')
                ,'(宗教法人)',''),'宗教法人',''),'(宗教)',''),'宗教)',''),'(宗)',''),'宗)',''),'シュウキョウホウジン)',''),'シュウ)','');

   /*  ログ出力*/
   IF( s_log_flg = 1 ) THEN

    SET w_log_result = CMSF_FUNC_PUT_LOG( s_log_created_by , s_log_prj_name , s_log_apps_name , s_log_mod_name , s_log_prg_var , s_log_type_text
                                        , '2.1.1.12 データ正規化処理' , s_empty_string  , w_data , w_result , s_empty_string , 'CORPORATE_TYPE_STRIP' , s_empty_string );

   END IF;

 /* 2.1.1.13 データ正規化処理 */
 ELSEIF( w_type_flg = 'ITAI_DOUJIBETUTAI' ) THEN

  SET w_result = REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                 REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                w_data
               ,'頴','穎'),'薗','園'),'叶','協'),'栢','柏'),'苅','刈'),'舘','館'),'衿','襟'),'駈','駆'),'珪','圭'),'瑳','磋'),'阪','坂'),'堺','界'),'宍','肉'),'准','準')
               ,'藷','薯'),'栖','棲'),'蹟','跡'),'曽','曾'),'瀧','滝'),'吊','弔'),'嶋','島'),'燈','灯'),'祢','禰'),'盃','杯'),'楳','梅'),'斌','彬'),'冨','富'),'鋪','舗')
               ,'峯','峰'),'耶','邪'),'涌','湧'),'裡','裏'),'龍','竜'),'碗','椀'),'弌','一'),'乘','乗'),'亂','乱'),'豫','予'),'亊','事'),'弍','二'),'亞','亜'),'亰','京')
               ,'仭','仞'),'佛','仏'),'來','来'),'儘','侭'),'伜','倅'),'假','仮'),'會','会'),'做','作'),'傳','伝'),'僞','偽'),'價','価'),'儉','倹'),'兒','児'),'兔','兎')
               ,'竸','競'),'兩','両'),'册','冊'),'冦','寇'),'冩','写'),'决','決'),'冲','沖'),'冰','氷'),'况','況'),'凉','涼'),'凛','凜'),'處','処'),'凾','函'),'刄','刃')
               ,'刧','劫'),'剩','剰'),'劍','剣'),'劔','剣'),'劒','剣'),'剱','剣'),'劑','剤'),'辨','弁'),'辧','弁'),'勞','労'),'勳','勲'),'勵','励'),'勸','勧'),'區','区')
               ,'丗','世'),'凖','準'),'夘','卯'),'卻','却'),'卷','巻'),'厰','廠'),'參','参'),'雙','双'),'咒','呪'),'哥','歌'),'啣','銜'),'單','単'),'噐','器'),'營','営')
               ,'嚏','嚔'),'嚴','厳'),'囑','嘱'),'囓','齧'),'圀','国'),'圈','圏'),'國','国'),'圍','囲'),'圓','円'),'團','団'),'圖','図'),'埀','垂'),'埓','埒'),'塲','場')
               ,'壞','壊'),'墻','牆'),'墮','堕'),'壓','圧'),'壘','塁'),'壥','廛'),'壤','壌'),'壯','壮'),'壺','壷'),'壹','一'),'壽','寿'),'夛','多'),'梦','夢'),'竒','奇')
               ,'奧','奥'),'奬','奨'),'奩','匳'),'侫','佞'),'姙','妊'),'嫻','嫺'),'嬾','懶'),'孃','嬢'),'學','学'),'斈','学'),'寃','冤'),'寉','鶴'),'實','実'),'寢','寝')
               ,'寫','写'),'寶','宝'),'寳','宝'),'尅','剋'),'將','将'),'專','専'),'對','対'),'尓','爾'),'屆','届'),'屬','属'),'峩','峨'),'峽','峡'),'嶌','島'),'崕','崖')
               ,'崗','岡'),'嵜','崎'),'崘','崙'),'嵳','嵯'),'嶽','岳'),'巖','巌'),'巛','川'),'巵','卮'),'帋','紙'),'帶','帯'),'幤','幣'),'幵','刊'),'廐','厩'),'廏','厩')
               ,'廣','広'),'廚','厨'),'廢','廃'),'廳','庁'),'廰','庁'),'廸','迪'),'弃','棄'),'弉','奘'),'彈','弾'),'彌','弥'),'弯','湾'),'徃','往'),'徑','径'),'從','従')
               ,'徠','来'),'悳','徳'),'恠','怪'),'恆','恒'),'悋','吝'),'惡','悪'),'惠','恵'),'忰','悴'),'愡','怱'),'惱','悩'),'愼','慎'),'愽','博'),'慘','惨'),'慚','慙')
               ,'憇','憩'),'應','応'),'懷','懐'),'懴','懺'),'戀','恋'),'戞','戛'),'戰','戦'),'戲','戯'),'抂','狂'),'拔','抜'),'抻','伸'),'拏','拿'),'擔','担'),'拜','拝')
               ,'拂','払'),'挾','挟'),'搜','捜'),'插','挿'),'搖','揺'),'攝','摂'),'搗','擣'),'攪','撹'),'據','拠'),'擇','択'),'擧','挙'),'舉','挙'),'擴','拡'),'攜','携')
               ,'收','収'),'效','効'),'敕','勅'),'敍','叙'),'敘','叙'),'數','数'),'變','変'),'斷','断'),'旙','旛'),'晄','晃'),'晉','晋'),'晝','昼'),'晧','皓'),'暎','映')
               ,'曉','暁'),'暼','瞥'),'暸','瞭'),'昿','曠'),'曵','曳'),'朖','朗'),'朞','期'),'霸','覇'),'杤','栃'),'杰','傑'),'枩','松'),'枦','櫨'),'枡','桝'),'檜','桧')
               ,'桿','杆'),'條','条'),'檮','梼'),'棊','棋'),'棧','桟'),'椶','棕'),'榮','栄'),'槨','椁'),'樂','楽'),'權','権'),'樞','枢'),'櫁','樒'),'樣','様'),'樓','楼')
               ,'橢','楕'),'檢','検'),'蘗','檗'),'檳','梹'),'櫑','罍'),'檪','櫟'),'櫻','桜'),'鬱','欝'),'盜','盗'),'飮','飲'),'歐','欧'),'歡','歓'),'歸','帰'),'殘','残')
               ,'殱','殲'),'殼','殻'),'毆','殴'),'毓','育'),'氣','気'),'沒','没'),'泝','遡'),'泪','涙'),'濤','涛'),'渕','淵'),'渊','渕'),'淨','浄'),'淺','浅'),'滿','満')
               ,'游','遊'),'溪','渓'),'溯','遡'),'灌','潅'),'滯','滞'),'澁','渋'),'澀','渋'),'潛','潜'),'濳','潜'),'澂','澄'),'澑','溜'),'澤','沢'),'濟','済'),'濕','湿')
               ,'濱','浜'),'潴','瀦'),'灣','湾'),'烱','炯'),'烟','煙'),'煕','熙'),'熈','煕'),'燻','熏'),'燒','焼'),'燿','耀'),'爍','鑠'),'爐','炉'),'爭','争'),'爲','為')
               ,'爼','俎'),'牋','箋'),'犁','犂'),'犧','犠'),'犲','豺'),'狹','狭'),'獎','奨'),'獏','貘'),'默','黙'),'獨','独'),'獸','獣'),'獵','猟'),'獻','献'),'珎','珍')
               ,'珮','佩'),'璢','瑠'),'瑯','琅'),'珱','瓔'),'瓣','弁'),'甞','嘗'),'甼','町'),'畄','留'),'畍','界'),'畊','耕'),'畆','畝'),'畧','略'),'畫','画'),'當','当')
               ,'畴','疇'),'疊','畳'),'疉','畳'),'疂','畳'),'瘉','癒'),'癡','痴'),'發','発'),'皃','貌'),'皈','帰'),'皋','皐'),'皰','疱'),'皹','皸'),'盖','蓋'),'盡','尽')
               ,'蘯','盪'),'眤','睇'),'眞','真'),'眦','眥'),'睿','叡'),'瞹','曖'),'礦','鉱'),'礪','砺'),'碎','砕'),'磚','甎'),'礙','碍'),'祕','秘'),'祿','禄'),'齋','斎')
               ,'禪','禅'),'禮','礼'),'稱','称'),'稻','稲'),'稾','稿'),'穗','穂'),'穩','穏'),'龝','秋'),'穰','穣'),'窗','窓'),'竈','竃'),'窰','窯'),'竊','窃'),'竚','佇')
               ,'竝','並'),'笶','矢'),'筺','筐'),'笋','筍'),'筱','篠'),'箟','箘'),'筝','箏'),'篏','嵌'),'簑','蓑'),'簔','蓑'),'篦','箆'),'籠','篭'),'簷','檐'),'籏','旗')
               ,'籘','籐'),'籖','籤'),'粃','秕'),'粮','糧'),'粹','粋'),'糢','模'),'糺','糾'),'絲','糸'),'絏','紲'),'經','経'),'綉','繍'),'綫','線'),'總','総'),'緜','綿')
               ,'緤','紲'),'縣','県'),'縱','縦'),'繪','絵'),'繩','縄'),'繼','継'),'緕','纃'),'繿','襤'),'續','続'),'纒','纏'),'纖','繊'),'纎','繊'),'罎','壜'),'罸','罰')
               ,'羃','冪'),'羣','群'),'羮','羹'),'譱','善'),'翆','翠'),'翦','剪'),'飜','翻'),'耻','恥'),'聟','婿'),'聨','連'),'聲','声'),'聰','聡'),'聽','聴'),'肅','粛')
               ,'冐','冒'),'肬','疣'),'脉','脈'),'腦','脳'),'腟','膣'),'膓','腸'),'膸','髄'),'膽','胆'),'臈','臘'),'臺','台'),'與','与'),'舍','舎'),'舖','舗'),'舩','船')
               ,'艢','檣'),'艪','櫓'),'舮','艫'),'艷','艶'),'莓','苺'),'莖','茎'),'莊','荘'),'荳','豆'),'菷','帚'),'萠','萌'),'蔆','菱'),'蕚','萼'),'蒭','芻'),'蒂','蔕')
               ,'萬','万'),'葢','蓋'),'蘂','蕊'),'蕋','蕊'),'薀','蘊'),'藪','薮'),'藝','芸'),'藥','薬'),'蘓','蘇'),'蘆','芦'),'乕','虎'),'號','号'),'虱','蝨'),'蠣','蛎')
               ,'蝟','彙'),'蠅','蝿'),'螢','蛍'),'蟆','蟇'),'蟲','虫'),'蠏','蟹'),'蠎','蟒'),'蠶','蚕'),'蠧','蠹'),'蠻','蛮'),'衂','衄'),'衞','衛'),'袵','衽'),'裝','装')
               ,'襃','褒'),'褝','襌'),'覊','羈'),'覩','睹'),'覺','覚'),'覽','覧'),'觀','観'),'觧','解'),'觸','触'),'諫','諌'),'謚','諡'),'謠','謡'),'譁','嘩'),'譌','訛')
               ,'證','証'),'譛','譖'),'譯','訳'),'譽','誉'),'讀','読'),'讎','讐'),'讓','譲'),'讚','讃'),'豎','竪'),'豐','豊'),'豬','猪'),'貍','狸'),'豼','貔'),'戝','財')
               ,'貭','質'),'貳','二'),'貮','二'),'賤','賎'),'賣','売'),'贊','賛'),'賍','贓'),'跖','蹠'),'踈','疎'),'踐','践'),'踴','踊'),'踪','蹤'),'躙','躪'),'躰','体')
               ,'軆','体'),'軅','軈'),'軣','轟'),'輕','軽'),'輙','輒'),'輌','両'),'轉','転'),'辭','辞'),'辯','弁'),'迯','逃'),'邇','迩'),'迴','廻'),'迹','跡'),'迺','廼')
               ,'逕','径'),'逹','達'),'逎','遒'),'遘','逅'),'遞','逓'),'隨','随'),'遲','遅'),'邊','辺'),'邉','辺'),'邨','村'),'鄰','隣'),'醉','酔'),'醫','医'),'釀','醸')
               ,'釋','釈'),'釖','刀'),'釡','釜'),'釼','剣'),'鈬','鐸'),'鉤','鈎'),'銕','鉄'),'錢','銭'),'鍼','針'),'鎭','鎮'),'鎔','熔'),'鏥','銹'),'鐵','鉄'),'鐡','鉄')
               ,'鑒','鑑'),'鑛','鉱'),'鈩','鑪'),'鑚','鑽'),'閇','閉'),'閙','鬧'),'閠','閏'),'閧','鬨'),'濶','闊'),'關','関'),'阯','址'),'陂','坡'),'陷','陥'),'陜','峡')
               ,'險','険'),'隱','陰'),'隸','隷'),'襍','雑'),'雜','雑'),'靈','霊'),'靜','静'),'靱','靭'),'韭','韮'),'韲','齏'),'韵','韻'),'頸','頚'),'顏','顔'),'顋','腮')
               ,'顯','顕'),'飃','飄'),'餘','余'),'餝','飾'),'餠','餅'),'馗','逵'),'騷','騒'),'驅','駆'),'驛','駅'),'驗','験'),'髓','髄'),'體','体'),'髮','髪'),'鬪','闘')
               ,'鰺','鯵'),'鰛','鰮'),'鱠','膾'),'鳬','鳧'),'鴈','雁'),'鳫','雁'),'鶯','鴬'),'鵄','鴟'),'鵞','鵝'),'鷄','鶏'),'鷏','鷆'),'鹽','塩'),'麸','麩'),'麪','麺')
               ,'黏','粘'),'點','点'),'黨','党'),'皷','鼓'),'齊','斎'),'齒','歯'),'齡','齢'),'龜','亀'),'堯','尭'),'槇','槙'),'遙','遥'),'瑤','瑶'),'砿','鉱'),'籔','薮')
               ,'凜','凛'),'熙','煕'),'仝','々'),'ヽ','々'),'ヾ','々'),'ゝ','々'),'ゞ','々'),'〃','々'),'菴','庵'),'壱','一'),'婬','淫'),'蔭','陰'),'咏','詠'),'謌','歌')
               ,'劃','画'),'囘','回'),'鬻','粥'),'罐','缶'),'舊','旧'),'亟','極'),'谿','渓'),'缺','欠'),'劵','券'),'云','言'),'曰','言'),'藁','稿'),'斉','斎'),'冱','冴')
               ,'沍','冴'),'笑','咲'),'埼','崎'),'碕','崎'),'穐','秋'),'輯','集'),'鈔','抄'),'脣','唇'),'靫','靭'),'醋','酢'),'淒','凄'),'鼡','鼠'),'赱','走'),'臟','臓')
               ,'藏','蔵'),'卆','卒'),'舵','柁'),'穉','稚'),'註','注'),'鑄','鋳'),'菟','兎'),'莵','兎'),'楝','棟'),'蹈','踏'),'仂','働'),'弐','二'),'麥','麦'),'附','付')
               ,'淵','渕'),'篇','編'),'歿','没'),'夲','本'),'壻','婿'),'聯','連'),'亙','亘'),'彎','湾'),'仞','仭'),'倅','伜'),'僭','僣'),'寇','冦'),'洌','冽'),'涸','凅')
               ,'箚','剳'),'廁','厠'),'廈','厦'),'廝','厮'),'咯','喀'),'譟','噪'),'嚔','嚏'),'齧','囓'),'埒','埓'),'嫐','嬲'),'迪','廸'),'彜','彝'),'髴','彿'),'扨','扠')
               ,'擡','抬'),'旛','旙'),'曠','昿'),'樒','櫁'),'櫟','檪'),'殲','殱'),'徇','洵'),'醺','熏'),'豺','犲'),'貉','狢'),'貎','猊'),'貘','獏'),'碯','瑙'),'瓔','珱')
               ,'籤','籖'),'纃','緕'),'羇','羈'),'羹','羮'),'蝨','虱'),'蟒','蠎'),'諡','謚'),'躪','躙'),'鬧','閙'),'鰮','鰛'),'鶫','鶇'),'髙','高'),'閒','間');

   /*  ログ出力*/
   IF( s_log_flg = 1 ) THEN

    SET w_log_result = CMSF_FUNC_PUT_LOG( s_log_created_by , s_log_prj_name , s_log_apps_name , s_log_mod_name , s_log_prg_var , s_log_type_text
                                        , '2.1.1.13 データ正規化処理' , s_empty_string  , w_data , w_result , s_empty_string , 'ITAI_DOUGIBETUTAI' , s_empty_string );

   END IF;

 /* 2.1.1.14.1 データ正規化処理 */
 ELSEIF( w_type_flg = 'SPACE_HALF' ) THEN

  SET w_result = REPLACE( w_data , '　',' ');

   /*  ログ出力*/
   IF( s_log_flg = 1 ) THEN

    SET w_log_result = CMSF_FUNC_PUT_LOG( s_log_created_by , s_log_prj_name , s_log_apps_name , s_log_mod_name , s_log_prg_var , s_log_type_text
                                        , '2.1.1.14.1 データ正規化処理' , s_empty_string  , w_data , w_result , s_empty_string , 'SPACE_HALF' , s_empty_string );

   END IF;

 /* 2.1.1.14.2 データ正規化処理 */
 ELSEIF( w_type_flg = 'SPACE_FULL' ) THEN

  SET w_result = REPLACE( w_data , ' ','　');

   /*  ログ出力*/
   IF( s_log_flg = 1 ) THEN

    SET w_log_result = CMSF_FUNC_PUT_LOG( s_log_created_by , s_log_prj_name , s_log_apps_name , s_log_mod_name , s_log_prg_var , s_log_type_text
                                        , '2.1.1.14.1 データ正規化処理' , s_empty_string  , w_data , w_result , s_empty_string , 'SPACE_FULL' , s_empty_string );

   END IF;

 /* 2.1.1.15 データ正規化処理 */
 ELSEIF( w_type_flg = 'TRIM' ) THEN

  SET w_result = TRIM( REPLACE( REPLACE( REPLACE( w_data , '	',' ') , '
',' ') , '　',' ') );

   /*  ログ出力*/
   IF( s_log_flg = 1 ) THEN

    SET w_log_result = CMSF_FUNC_PUT_LOG( s_log_created_by , s_log_prj_name , s_log_apps_name , s_log_mod_name , s_log_prg_var , s_log_type_text
                                        , '2.1.1.15 データ正規化処理' , s_empty_string  , w_data , w_result , s_empty_string , 'TRIM' , s_empty_string );

   END IF;

 ELSE

  SET w_result = '未対応';

 END IF;

END IF;

 /*  ログ出力*/
 IF( s_log_flg = 1 ) THEN

  SET w_log_result = CMSF_FUNC_PUT_LOG( s_log_created_by , s_log_prj_name , s_log_apps_name , s_log_mod_name , s_log_prg_var , s_log_type_text
                                      , '2.1.1 データ変換処理' , s_empty_string  , s_empty_string , s_empty_string , s_empty_string , s_empty_string , s_empty_string );

 END IF;



 /*  ログ出力処理  */
 IF( s_log_flg = 1 ) THEN
        SET w_log_result =  CMSF_FUNC_PUT_LOG( s_log_created_by , s_log_prj_name , s_log_apps_name , s_log_mod_name , s_log_prg_var , s_log_type_text
                                             , CONCAT( '9.9.9 処理完了 :' , w_result  ) , s_empty_string , s_empty_string , s_empty_string , s_empty_string , s_empty_string , s_empty_string );
 END IF;

 return w_result;

END;;
DELIMITER ;

-- ----------------------------
-- Function structure for CMSF_FUNC_PHP_MB_CONVERT_KANA
-- ----------------------------
DROP FUNCTION IF EXISTS `CMSF_FUNC_PHP_MB_CONVERT_KANA`;
DELIMITER ;;
CREATE FUNCTION `CMSF_FUNC_PHP_MB_CONVERT_KANA`(p_data text , p_type_flg varchar(50) binary) RETURNS text CHARSET utf8
BEGIN
/**
 * 受け取ったデータをパターン別に正規化する関数
 *
 * r  … 「全角」英字を「半角(ﾊﾝｶｸ)」に変換
 * R  … 「半角(ﾊﾝｶｸ)」英字を「全角」に変換
 * n  … 「全角」数字を「半角(ﾊﾝｶｸ)」に変換
 * N  … 「半角(ﾊﾝｶｸ)」数字を「全角」に変換
 * a  … 「全角」英数字を「半角(ﾊﾝｶｸ)」に変換
 * A  … 「半角(ﾊﾝｶｸ)」英数字を「全角」に変換
 * s  … 「全角」スペースを「半角(ﾊﾝｶｸ)」に変換
 * S  … 「半角(ﾊﾝｶｸ)」スペースを「全角」に変換
 * k  … 「全角片仮名」を「半角(ﾊﾝｶｸ)片仮名」に変換
 * K  … 「半角(ﾊﾝｶｸ)片仮名」を「全角片仮名」に変換
 * h  … 「全角ひら仮名」を「半角(ﾊﾝｶｸ)片仮名」に変換
 * H  … 「半角(ﾊﾝｶｸ)片仮名」を「全角ひら仮名」に変換
 * c  … 「全角かた仮名」を「全角ひら仮名」に変換
 * C  … 「全角ひら仮名」を「全角かた仮名」に変換
 * V  … 濁点付きの文字を一文字に変換。"K","H"と共に使用します。(未実装)
 * b  … (独自実装) 全角の記号を半角に変換
 * B  … (独自実装) 半角の記号を全角に変換
 * v  … (独自実装) 記号を削除
 * t  … (独自実装) "(",")" ,"(",")" ,"+","-"以外の記号を削除
 * j  … (独自実装) 漢数字を半角の数字に変換
 * J  … (独自実装) 半角の数字を漢数字に変換                    (未実装)
 * Y  … (独自実装) 全角カタカナの拗音・促音(ｧｨｩｪｫｬｭｮ)を直音(ｱｲｳｴｵﾔﾕﾖ)へ変換
 * y  … (独自実装) 半角カタカナの拗音・促音(ｧｨｩｪｫｬｭｮ)を直音(ｱｲｳｴｵﾔﾕﾖ)へ変換
 * T  … (独自実装) 全角/半角スペースを両側から削除
 * I  … (独自実装) 同意体/同字別体を正規化
 * P  … (独自実装) 法人格を統一
 * p  … (独自実装) 法人格を削除
 *
 * @package     CMSF
 * @category    CMSF_FUNC_PHP_MB_CONVERT_KANA
 * @param       text         p_data     変換対象データ
 * @param       varchar(10)  p_type_flg 変換タイプ
 * @return      text         変換済みデータ
 * @example
 * @license     LGPL version 3 - http://www.gnu.org/licenses/lgpl.html
 * @copyright   2009 Yuusuke takagi <nya.takasan@gmail.com>
 * @link        http://sourceforge.jp/projects/cmsf/
 * @author      Yuusuke takagi <nya.takasan@gmail.com>
 * @version     $Revision: 0.0.1 2009/07/15 初期リリース Yuusuke takagi <nya.takasan@gmail.com>$
 * @version     $Revision: 0.0.2 2009/07/16 拗音・促音、直音変換対応追加 Yuusuke takagi <nya.takasan@gmail.com>$
 * @version     $Revision: 0.0.3 2009/07/17 ヴ変換対応追加・バグ修正 Yuusuke takagi <nya.takasan@gmail.com>$
 * @version     $Revision: 0.0.4 2009/08/29 片仮名の場合に長音をーに統一 Yuusuke takagi <nya.takasan@gmail.com>$
 * @version     $Revision: 0.0.5 2009/08/29 TORITONN用に"(",")" ,"+","-"以外の文字を削除する機能を追加 Yuusuke takagi <nya.takasan@gmail.com>$
 * @since
 * @see         CMSF_FUNC_DATA_NORMALIZE
 * @require     MYSQL 5.0.0 or higther
 */
 /*------------------------------------------------------
    変数定義
 -------------------------------------------------------*/
 declare w_result                       text                default '';             /*  変換文字列 */

 /* ログ関連 */
 declare w_log_result                   varchar(255)        default '';             /* Log 結果 */
 declare w_log_query                    varchar(2000)       default '';             /* Query Log */

 /* ユーザー定義変数 */
 declare w_data                         longtext            default NULL;           /* 文字列 */
 declare w_type_flg                     varchar(50) binary  default NULL;           /* 文字列 */

 declare w_flg                          varchar(2)  binary  default NULL;           /* 文字列 */
 declare w_loop_count                   int(5)              default 1;              /* 数字 */
 declare w_loop_maxcount                int(5)              default 0;              /* 数字 */

 /*------------------------------------------------------
    ユーザ例外定義
  -------------------------------------------------------*/

 /*------------------------------------------------------
    定数定義
 -------------------------------------------------------*/
 declare s_empty_string                 varchar(255)    default '';             /*  空文字 */
 declare s_true                         varchar(255)    default 1;              /*  TRUE  FLG*/
 declare s_false                        varchar(255)    default 0;              /*  FALSE FLG */

 /* ログ関連 */
 declare s_log_flg                      int(1)          default 0;              /*  エラー処理フラグ ON:1 OFF:0 */

/*
 ログ出力サンプル SQLログ

 SET w_log_query = CONCAT(
 "    SQL"
 );

 SET w_log_result = CMSF_FUNC_PUT_LOG( s_log_created_by , s_log_prj_name , s_log_apps_name , s_log_mod_name , s_log_prg_var , s_log_type_text
                                     , '処理名称' , w_log_query , 'ログ1' , 'ログ2' , 'ログ3' , 'ログ4' , 'ログ5' );

 ログ出力サンプル テキストログ

 SET w_log_result = CMSF_FUNC_PUT_LOG( s_log_created_by , s_log_prj_name , s_log_apps_name , s_log_mod_name , s_log_prg_var , s_log_type_text
                                     , '処理名称' , s_empty_string  , 'ログ1' , 'ログ2' , 'ログ3' , 'ログ4' , 'ログ5' );
*/
 declare s_log_prj_name                 varchar(255)    default 'CMSF';                                 /*  プロジェクト名 */
 declare s_log_apps_name                varchar(255)    default 'CMSF_FUNC_PHP_MB_CONVERT_KANA';             /*  アプリケーション名 */
 declare s_log_mod_name                 varchar(255)    default 'CMSF_FUNC_PHP_MB_CONVERT_KANA';             /*  モジュール名 */
 declare s_log_prg_var                  varchar(255)    default '0.0.1';                                /*  モジュールバージョン */

 declare s_log_created_by               varchar(255)    default 'SYSTEM';               /*  ログ作成者 */

 declare s_log_type_insert              varchar(255)    default 'INSERT';               /*  ログタイプ:INSERT  */
 declare s_log_type_select              varchar(255)    default 'SELECT';               /*  ログタイプ:SELECT  */
 declare s_log_type_update              varchar(255)    default 'UPDATE';               /*  ログタイプ:UPDATE */
 declare s_log_type_delete              varchar(255)    default 'DELETE';               /*  ログタイプ:DELETE */

 declare s_log_type_text                varchar(255)    default 'TEXT';                 /*  ログタイプ:TEXT */

 declare s_log_type_error               varchar(255)    default 'ERROR';                /*  ログタイプ:ERROR */

 declare s_log_type_tmp                 varchar(255)    default 'TEMPORARY';            /*  ログタイプ:TEMPORARY */

 /* ユーザー定義定数 */

 /*------------------------------------------------------
    カーソル定義
 -------------------------------------------------------*/
  /*--------------------------------------------
   カーソル説明
  ---------------------------------------------*/

 /*----------------------------------------------------------
   処理定義
 -----------------------------------------------------------*/
 /* 1.0 初期処理*/
 SET w_data              = p_data;                                    /*  正規化対象データ */
 SET w_type_flg          = p_type_flg;         /*  正規化タイプ */
 SET w_loop_maxcount     = CHAR_LENGTH( p_type_flg );                 /*  最大LOOP回数 */

 /*  ログ出力*/
 IF( s_log_flg = 1 ) THEN
        SET w_log_result =  CMSF_FUNC_PUT_LOG( s_log_created_by , s_log_prj_name , s_log_apps_name , s_log_mod_name , s_log_prg_var , s_log_type_text
                                             , CONCAT( '1.0 初期処理 パラメータ:' , p_data , ',' , p_type_flg ) , s_empty_string , s_empty_string , s_empty_string , s_empty_string , s_empty_string , s_empty_string );
 END IF;

 /* 2.1.1 データ変換処理 */
 WHILE w_loop_maxcount >= w_loop_count DO

   SET w_flg = SUBSTRING( w_type_flg , w_loop_count , 1 );


   /*  ログ出力*/
   IF( s_log_flg = 1 ) THEN

    SET w_log_result = CMSF_FUNC_PUT_LOG( s_log_created_by , s_log_prj_name , s_log_apps_name , s_log_mod_name , s_log_prg_var , s_log_type_text
                                        , '2.1.1 データ変換処理' , s_empty_string  , w_loop_maxcount , w_loop_count , w_flg , w_data , s_empty_string );

   END IF;

   /* r  … 「全角」英字を「半角(ﾊﾝｶｸ)」に変換 */
   IF( w_flg = binary 'r') THEN

     SET w_data = CMSF_FUNC_DATA_NORMALIZE( w_data , 'ALPHABET_HALF' );

   /* R  … 「半角(ﾊﾝｶｸ)」英字を「全角」に変換 */
   ELSEIF( w_flg = binary 'R') THEN

     SET w_data = CMSF_FUNC_DATA_NORMALIZE( w_data , 'ALPHABET_FULL' );

   /* n  … 「全角」数字を「半角(ﾊﾝｶｸ)」に変換 */
   ELSEIF( w_flg = binary 'n') THEN

     SET w_data = CMSF_FUNC_DATA_NORMALIZE( w_data , 'NUMBER_HALF' );

   /* N  … 「半角(ﾊﾝｶｸ)」数字を「全角」に変換 */
   ELSEIF( w_flg = binary 'N') THEN

     SET w_data = CMSF_FUNC_DATA_NORMALIZE( w_data , 'NUMBER_FULL' );

   /* a  … 「全角」英数字を「半角(ﾊﾝｶｸ)」に変換 */
   ELSEIF( w_flg = binary 'a') THEN

     SET w_data = CMSF_FUNC_DATA_NORMALIZE( w_data , 'ALPHABET_HALF' );
     SET w_data = CMSF_FUNC_DATA_NORMALIZE( w_data , 'NUMBER_HALF' );

   /* A  … 「半角(ﾊﾝｶｸ)」英数字を「全角」に変換 */
   ELSEIF( w_flg = binary 'A' ) THEN

     SET w_data = CMSF_FUNC_DATA_NORMALIZE( w_data , 'ALPHABET_FULL' );
     SET w_data = CMSF_FUNC_DATA_NORMALIZE( w_data , 'NUMBER_FULL' );

   /* s  … 「全角」スペースを「半角(ﾊﾝｶｸ)」に変換 */
   ELSEIF( w_flg = binary 's') THEN

     SET w_data = CMSF_FUNC_DATA_NORMALIZE( w_data , 'SPACE_HALF' );

   /* S  … 「半角(ﾊﾝｶｸ)」スペースを「全角」に変換 */
   ELSEIF( w_flg = binary 'S') THEN

     SET w_data = CMSF_FUNC_DATA_NORMALIZE( w_data , 'SPACE_FULL' );

   /* k  … 「全角片仮名」を「半角(ﾊﾝｶｸ)片仮名」に変換 */
   ELSEIF( w_flg = binary 'k') THEN

     SET w_data = CMSF_FUNC_DATA_NORMALIZE( w_data , 'KATAKANA_FULL2KATAKANA_HALF' );

   /* K  … 「半角(ﾊﾝｶｸ)片仮名」を「全角片仮名」に変換 */
   ELSEIF( w_flg = binary 'K') THEN

     SET w_data = CMSF_FUNC_DATA_NORMALIZE( w_data , 'KATAKANA_HALF2KATAKANA_FULL' );

   /* h  … 「全角ひら仮名」を「半角(ﾊﾝｶｸ)片仮名」に変換 */
   ELSEIF( w_flg = binary 'h') THEN

     SET w_data = CMSF_FUNC_DATA_NORMALIZE( w_data , 'HIRAGANA2KATAKANA_HALF' );

   /* H  … 「半角(ﾊﾝｶｸ)片仮名」を「全角ひら仮名」に変換 */
   ELSEIF( w_flg = binary 'H') THEN

     SET w_data = CMSF_FUNC_DATA_NORMALIZE( w_data , 'KATAKANA_HALF2HIRAGANA' );

   /* c  … 「全角かた仮名」を「全角ひら仮名」に変換 */
   ELSEIF( w_flg = binary 'c') THEN

     SET w_data = CMSF_FUNC_DATA_NORMALIZE( w_data , 'KATAKANA_FULL2HIRAGANA' );

   /* C  … 「全角ひら仮名」を「全角かた仮名」に変換 */
   ELSEIF( w_flg = binary 'C') THEN

     SET w_data = CMSF_FUNC_DATA_NORMALIZE( w_data , 'HIRAGANA2KATAKANA_FULL' );

   /* V  … 濁点付きの文字を一文字に変換。"K","H"と共に使用します。 */
   ELSEIF( w_flg = binary 'V') THEN

     SET w_data = '未実装';

   /* これより独自実装 */
   /* B  … (独自実装) 全角の記号を半角に変換 */
   ELSEIF( w_flg = binary 'b') THEN

     SET w_data = CMSF_FUNC_DATA_NORMALIZE( w_data , 'SYMBOL_HALF' );

   /* b  … (独自実装) 半角の記号を全角に変換 */
   ELSEIF( w_flg = binary 'B') THEN

     SET w_data = CMSF_FUNC_DATA_NORMALIZE( w_data , 'SYMBOL_FULL' );

   /* v  … 独自実装) 記号を削除 */
   ELSEIF( w_flg = binary 'v') THEN

     SET w_data = CMSF_FUNC_DATA_NORMALIZE( w_data , 'SYMBOL_STRIP' );

   /* t  … 独自実装) "(",")" ,"(",")" ,"+","-"以外の記号を削除 */
   ELSEIF( w_flg = binary 't') THEN

     SET w_data = CMSF_FUNC_DATA_NORMALIZE( w_data , 'SYMBOL_STRIP_FOR_TORITONN' );

   /* J  … (独自実装) 漢数字を半角の数字に変換 */
   ELSEIF( w_flg = binary 'j') THEN

     SET w_data = CMSF_FUNC_DATA_NORMALIZE( w_data , 'KANJI2NUMBER' );

   /* j  … (独自実装) 半角の数字を漢数字に変換 */
   ELSEIF( w_flg = binary 'J') THEN

     SET w_data = CMSF_FUNC_DATA_NORMALIZE( w_data , 'NUMBER2KANJI' );

   /* Y  … 全角カタカナの拗音・促音(ァィゥェォャュョッ)を直音(アイウエオヤユヨツ)へ変換 */
   ELSEIF( w_flg = binary 'Y') THEN

     SET w_data = CMSF_FUNC_DATA_NORMALIZE( w_data , 'UPPER_KATAKANA_FULL' );

   /* y  … (独自実装) 半角カタカナの拗音・促音(ｧｨｩｪｫｬｭｮ)を直音(ｱｲｳｴｵﾔﾕﾖ)へ変換 */
   ELSEIF( w_flg = binary 'y') THEN

     SET w_data = CMSF_FUNC_DATA_NORMALIZE( w_data , 'UPPER_KATAKANA_HALF' );

   /* T  … (独自実装) 全角/半角スペースを両側から削除 */
   ELSEIF( w_flg = binary 'T') THEN

     SET w_data = CMSF_FUNC_DATA_NORMALIZE( w_data , 'TRIM' );

   /* I  … (独自実装) 同意体/同字別体を正規化 */
   ELSEIF( w_flg = binary 'I') THEN

     SET w_data = CMSF_FUNC_DATA_NORMALIZE( w_data , 'ITAI_DOUJIBETUTAI' );

   /* P  … (独自実装) 法人格を統一 */
   ELSEIF( w_flg = binary 'P') THEN

     SET w_data = CMSF_FUNC_DATA_NORMALIZE( w_data , 'CORPORATE_TYPE_NORMALIZE' );

   /* p  … (独自実装) 法人格を削除 */
   ELSEIF( w_flg = binary 'p') THEN

     SET w_data = CMSF_FUNC_DATA_NORMALIZE( w_data , 'CORPORATE_TYPE_STRIP' );

   ELSE

     SET w_data = '未実装';

   END IF;

   SET w_loop_count = w_loop_count + 1;

   /*  ログ出力*/
   IF( s_log_flg = 1 ) THEN

    SET w_log_result = CMSF_FUNC_PUT_LOG( s_log_created_by , s_log_prj_name , s_log_apps_name , s_log_mod_name , s_log_prg_var , s_log_type_text
                                        , '2.1.1 データ変換処理' , s_empty_string  , w_loop_maxcount , w_loop_count , w_flg , w_data , s_empty_string );

   END IF;

 END WHILE;

 SET w_result = w_data;

 /*  ログ出力処理  */
 IF( s_log_flg = 1 ) THEN
        SET w_log_result =  CMSF_FUNC_PUT_LOG( s_log_created_by , s_log_prj_name , s_log_apps_name , s_log_mod_name , s_log_prg_var , s_log_type_text
                                             , CONCAT( '9.9.9 処理完了 :' , w_result  ) , s_empty_string , s_empty_string , s_empty_string , s_empty_string , s_empty_string , s_empty_string );
 END IF;

 return w_result;

END;;
DELIMITER ;

-- ----------------------------
-- Records 
-- ----------------------------
