/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.amusaj.sp;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Transmitter;
import jp.crestmuse.cmx.amusaj.sp.MidiEventWithTicktime;
import jp.crestmuse.cmx.amusaj.sp.SPModule;
import jp.crestmuse.cmx.amusaj.sp.TimeSeriesCompatible;
import jp.crestmuse.cmx.sound.TickTimer;

public class MidiInputModule
extends SPModule
implements Receiver {
    private TickTimer tt;
    private Transmitter tm;
    private MidiDevice input_device;
    private BlockingQueue<MidiEventWithTicktime> src_queue = new LinkedBlockingQueue<MidiEventWithTicktime>();

    public MidiInputModule(MidiDevice midiDevice) throws MidiUnavailableException {
        this(null, midiDevice);
    }

    public MidiInputModule(TickTimer tickTimer, MidiDevice midiDevice) throws MidiUnavailableException {
        this.tt = tickTimer;
        this.input_device = midiDevice;
        this.input_device.open();
        this.tm = this.input_device.getTransmitter();
        this.tm.setReceiver(this);
    }

    public void setTickTimer(TickTimer tickTimer) {
        this.tt = tickTimer;
    }

    public void close() {
        this.tm.close();
        this.input_device.close();
    }

    public void send(MidiMessage midiMessage, long l) {
        long l2 = -1L;
        if (this.tt != null) {
            l2 = this.tt.getTickPosition();
        }
        MidiEventWithTicktime midiEventWithTicktime = new MidiEventWithTicktime(midiMessage, l, l2);
        this.src_queue.add(midiEventWithTicktime);
    }

    public void execute(Object[] objectArray, TimeSeriesCompatible[] timeSeriesCompatibleArray) throws InterruptedException {
        timeSeriesCompatibleArray[0].add(this.src_queue.take());
    }

    public Class[] getInputClasses() {
        return new Class[0];
    }

    public Class[] getOutputClasses() {
        return new Class[]{MidiEventWithTicktime.class};
    }
}

