/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.amusaj.sp;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import jp.crestmuse.cmx.amusaj.sp.MidiEventWithTicktime;
import jp.crestmuse.cmx.amusaj.sp.SPModule;
import jp.crestmuse.cmx.amusaj.sp.TimeSeriesCompatible;

public class MidiSequenceSender
extends SPModule {
    private final Sequencer sequencer;
    private final BlockingQueue<MidiEvent> queue = new LinkedBlockingQueue<MidiEvent>();

    public MidiSequenceSender(String string) throws MidiUnavailableException, InvalidMidiDataException, IOException {
        this(MidiSystem.getSequence(new File(string)));
    }

    public MidiSequenceSender(InputStream inputStream) throws MidiUnavailableException, InvalidMidiDataException, IOException {
        this(MidiSystem.getSequence(inputStream));
    }

    private MidiSequenceSender(Sequence sequence) throws MidiUnavailableException, InvalidMidiDataException {
        this.sequencer = MidiSystem.getSequencer();
        this.getSequencer().getTransmitter().setReceiver(new Receiver(){

            public void send(MidiMessage midiMessage, long l) {
                MidiSequenceSender.this.queue.add(new MidiEventWithTicktime(midiMessage, l, l));
            }

            public void close() {
            }
        });
        this.getSequencer().setSequence(sequence);
        this.getSequencer().open();
    }

    public void execute(Object[] objectArray, TimeSeriesCompatible[] timeSeriesCompatibleArray) throws InterruptedException {
        timeSeriesCompatibleArray[0].add(this.queue.take());
    }

    public Class[] getInputClasses() {
        return new Class[0];
    }

    public Class[] getOutputClasses() {
        return new Class[]{MidiEventWithTicktime.class};
    }

    public void start() {
        this.getSequencer().start();
    }

    public Sequencer getSequencer() {
        return this.sequencer;
    }
}

