/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.amusaj.sp;

import java.io.IOException;
import jp.crestmuse.cmx.amusaj.sp.AmusaParameterSet;
import jp.crestmuse.cmx.amusaj.sp.DoubleArrayWithTicktime;
import jp.crestmuse.cmx.amusaj.sp.SPException;
import jp.crestmuse.cmx.amusaj.sp.SPModule;
import jp.crestmuse.cmx.amusaj.sp.SPTerminator;
import jp.crestmuse.cmx.amusaj.sp.TimeSeriesCompatible;
import jp.crestmuse.cmx.math.DoubleArray;
import jp.crestmuse.cmx.math.DoubleArrayFactory;
import jp.crestmuse.cmx.math.Operations;
import jp.crestmuse.cmx.sound.AudioDataCompatible;
import jp.crestmuse.cmx.sound.TickTimer;
import jp.crestmuse.cmx.sound.Utils;

public class WindowSlider
extends SPModule {
    int winsize = 0;
    private double shift = Double.NaN;
    private int shift_;
    int[] chTarget = null;
    private double[] buff;
    private int fs;
    AudioDataCompatible audiodata;
    TickTimer ticktimer = null;
    private static final DoubleArrayFactory factory = DoubleArrayFactory.getFactory();

    public WindowSlider(boolean bl) {
        this.chTarget = bl ? new int[]{-2, 0, 1} : new int[]{-2};
    }

    public WindowSlider(int[] nArray) {
        this.chTarget = nArray;
    }

    protected String getParamCategory() {
        return "fft";
    }

    protected String[] getUsedParamNames() {
        return new String[]{"WINDOW_SIZE", "SHIFT"};
    }

    public void setInputData(AudioDataCompatible audioDataCompatible, int n, int n2) {
        long l = audioDataCompatible.sampleRate();
        this.setInputData(Utils.excerpt(audioDataCompatible, (int)((long)n * l / 1000L), (int)((long)n2 * l / 1000L)));
    }

    public AudioDataCompatible getTargetWaveform() {
        return this.audiodata;
    }

    public void setTickTimer(TickTimer tickTimer) {
        this.ticktimer = tickTimer;
    }

    public void setInputData(AudioDataCompatible audioDataCompatible) {
        AmusaParameterSet amusaParameterSet = AmusaParameterSet.getInstance();
        this.winsize = amusaParameterSet.getParamInt("fft", "WINDOW_SIZE");
        int n = audioDataCompatible.channels();
        amusaParameterSet.setParam("fft", "CHANNELS", n);
        this.fs = audioDataCompatible.sampleRate();
        amusaParameterSet.setParam("fft", "SAMPLE_RATE", this.fs);
        this.shift = amusaParameterSet.getParamDouble("fft", "SHIFT");
        if (this.shift < 1.0) {
            this.shift *= (double)this.fs;
        }
        this.shift_ = (int)this.shift;
        this.audiodata = audioDataCompatible;
    }

    public int getTimeUnit() {
        return 1000 * this.shift_ / this.fs;
    }

    public void execute(Object[] objectArray, TimeSeriesCompatible[] timeSeriesCompatibleArray) throws InterruptedException {
        long l;
        long l2 = l = this.ticktimer != null ? this.ticktimer.getTickPosition() : -1L;
        if (this.audiodata.hasNext(this.winsize)) {
            try {
                DoubleArray[] doubleArrayArray = this.audiodata.readNext(this.winsize, this.winsize - this.shift_);
                for (int i = 0; i < this.chTarget.length; ++i) {
                    DoubleArrayWithTicktime doubleArrayWithTicktime = this.chTarget[i] == -2 ? new DoubleArrayWithTicktime(Operations.mean(doubleArrayArray), l) : new DoubleArrayWithTicktime(doubleArrayArray[this.chTarget[i]], l);
                    timeSeriesCompatibleArray[i].add(doubleArrayWithTicktime);
                }
            }
            catch (IOException iOException) {
                throw new SPException(iOException);
            }
        } else {
            for (int i = 0; i < this.chTarget.length; ++i) {
                timeSeriesCompatibleArray[i].add(SPTerminator.getInstance());
            }
        }
    }

    public Class[] getInputClasses() {
        return new Class[0];
    }

    public Class[] getOutputClasses() {
        Class[] classArray = new Class[this.chTarget.length];
        for (int i = 0; i < classArray.length; ++i) {
            classArray[i] = DoubleArray.class;
        }
        return classArray;
    }
}

