/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.commands;

import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import jp.crestmuse.cmx.commands.CMXCommand;
import jp.crestmuse.cmx.filewrappers.CSVWrapper;
import jp.crestmuse.cmx.filewrappers.DeviationInstanceWrapper;
import jp.crestmuse.cmx.filewrappers.InvalidFileTypeException;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dev2CSV
extends CMXCommand<DeviationInstanceWrapper, CSVWrapper> {
    private int devisionPerMeasure = 4;
    private int windowPerMeasure = 4;

    @Override
    protected boolean setOptionsLocal(String string, String string2) {
        if (string.equals("-dpm")) {
            this.devisionPerMeasure = Integer.parseInt(string2);
            return true;
        }
        if (string.equals("-wpm")) {
            this.windowPerMeasure = Integer.parseInt(string2);
            return true;
        }
        if (string.equals("-targetdir")) {
            DeviationInstanceWrapper.changeDefaultMusicXMLDirName(string2);
            return true;
        }
        return false;
    }

    @Override
    protected CSVWrapper run(DeviationInstanceWrapper deviationInstanceWrapper) throws IOException, ParserConfigurationException, SAXException, TransformerException, InvalidFileTypeException {
        return deviationInstanceWrapper.toCSV(this.devisionPerMeasure, this.windowPerMeasure);
    }

    public static void main(String[] stringArray) {
        Dev2CSV dev2CSV = new Dev2CSV();
        try {
            dev2CSV.start(stringArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static {
        Dev2CSV.addOptionHelpMessage("-dpm <value>", "devisions per measure");
        Dev2CSV.addOptionHelpMessage("-wpm <value>", "window per measure");
        Dev2CSV.addOptionHelpMessage("-targetdir <dir>", "directory including target MusicXML file");
    }
}

