/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.filewrappers;

import groovy.lang.Closure;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import jp.crestmuse.cmx.filewrappers.CMXFileWrapper;
import jp.crestmuse.cmx.filewrappers.DeviationInstanceWrapper;
import jp.crestmuse.cmx.filewrappers.InvalidElementException;
import jp.crestmuse.cmx.filewrappers.NodeInterface;
import jp.crestmuse.cmx.filewrappers.SCCXMLWrapper;
import jp.crestmuse.cmx.handlers.CommonNoteHandler;
import jp.crestmuse.cmx.handlers.NoteHandlerPartwise;
import jp.crestmuse.cmx.misc.MultiHashMap;
import jp.crestmuse.cmx.misc.MultiMap;
import jp.crestmuse.cmx.misc.NoteCompatible;
import jp.crestmuse.cmx.misc.Ordered;
import jp.crestmuse.cmx.misc.PianoRollCompatible;
import jp.crestmuse.cmx.misc.SimpleNoteList;
import jp.crestmuse.cmx.misc.TreeView;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MusicXMLWrapper
extends CMXFileWrapper
implements PianoRollCompatible {
    private List<TreeView<Note>> partwiseNoteView = null;
    private TreeView<Note> timewiseNoteView = null;
    private SlurredNoteViewList slurredNoteView = null;
    private Part[] partlist = null;
    private List<Long> cumulativeTicksList = new MyArrayList();
    private List<Long> cumulativeTicksList2 = new MyArrayList();
    private String movementTitle = null;
    private boolean startsWithZerothMeasure;
    private boolean zerothMeasureChecked = false;
    static final int INTERNAL_TICKS_PER_BEAT = 10080;
    private int lastDivisions = 1;

    public void processNotePartwise(NoteHandlerPartwise noteHandlerPartwise) {
        Part[] partArray;
        for (Part part : partArray = this.getPartList()) {
            Measure[] measureArray;
            noteHandlerPartwise.beginPart(part, this);
            for (Measure measure : measureArray = part.getMeasureList()) {
                MusicData[] musicDataArray;
                noteHandlerPartwise.beginMeasure(measure, this);
                for (MusicData musicData : musicDataArray = measure.getMusicDataList()) {
                    noteHandlerPartwise.processMusicData(musicData, this);
                }
                noteHandlerPartwise.endMeasure(measure, this);
            }
            noteHandlerPartwise.endPart(part, this);
        }
    }

    @Override
    public void processNotes(CommonNoteHandler commonNoteHandler) {
        Part[] partArray;
        for (Part part : partArray = this.getPartList()) {
            Measure[] measureArray;
            commonNoteHandler.beginPart(part.id(), this);
            for (Measure measure : measureArray = part.getMeasureList()) {
                MusicData[] musicDataArray;
                for (MusicData musicData : musicDataArray = measure.getMusicDataList()) {
                    Note note;
                    if (!(musicData instanceof Note) || (note = (Note)musicData).rest()) continue;
                    commonNoteHandler.processNote(note, this);
                }
            }
            commonNoteHandler.endPart(part.id(), this);
        }
    }

    public void eachpart(Closure closure) throws TransformerException {
        Part[] partArray;
        for (Part part : partArray = this.getPartList()) {
            closure.call(new Object[]{part});
        }
    }

    public void eachnote(Closure closure) throws TransformerException {
        Part[] partArray;
        for (Part part : partArray = this.getPartList()) {
            Measure[] measureArray;
            for (Measure measure : measureArray = part.getMeasureList()) {
                MusicData[] musicDataArray;
                for (MusicData musicData : musicDataArray = measure.getMusicDataList()) {
                    Note note;
                    if (!(musicData instanceof Note) || (note = (Note)musicData).rest()) continue;
                    closure.call(new Object[]{note});
                }
            }
        }
    }

    public Part[] getPartList() {
        this.checkFinalized();
        if (this.partlist == null) {
            Node node = this.selectSingleNode("/score-partwise/part-list");
            NodeList nodeList = this.selectNodeList("/score-partwise/part");
            int n = nodeList.getLength();
            this.partlist = new Part[n];
            for (int i = 0; i < n; ++i) {
                this.partlist[i] = new Part(nodeList.item(i), node);
            }
        }
        return this.partlist;
    }

    public SCCXMLWrapper makeDeadpanSCCXML(int n) throws IOException {
        SCCXMLWrapper sCCXMLWrapper = (SCCXMLWrapper)CMXFileWrapper.createDocument("scc");
        this.makeDeadpanSCCXML(sCCXMLWrapper, n);
        return sCCXMLWrapper;
    }

    public void makeDeadpanSCCXML(SCCXMLWrapper sCCXMLWrapper, int n) throws IOException {
        DeviationInstanceWrapper deviationInstanceWrapper = DeviationInstanceWrapper.createDeviationInstanceFor(this);
        deviationInstanceWrapper.finalizeDocument();
        deviationInstanceWrapper.toSCCXML(sCCXMLWrapper, n);
        sCCXMLWrapper.finalizeDocument();
    }

    public List<TreeView<Note>> getPartwiseNoteView() throws TransformerException {
        if (this.partwiseNoteView == null) {
            this.createNoteView();
        }
        return this.partwiseNoteView;
    }

    public TreeView<Note> getTimewiseNoteView() throws TransformerException {
        if (this.timewiseNoteView == null) {
            this.createTimewiseNoteView();
        }
        return this.timewiseNoteView;
    }

    private SlurredNoteViewList getSlurredNoteView() throws TransformerException {
        if (this.slurredNoteView == null) {
            this.createNoteView();
        }
        return this.slurredNoteView;
    }

    public XPathView getXPathView() {
        return new XPathView();
    }

    public List<Attributes> getMeasureAttributesList(int n) {
        Measure[] measureArray = this.getPartList()[n].getMeasureList();
        ArrayList<Attributes> arrayList = new ArrayList<Attributes>();
        for (int i = 0; i < measureArray.length; ++i) {
            Attributes attributes = measureArray[i].getAttributesNodeInterface();
            if (attributes == null) continue;
            arrayList.add(attributes);
        }
        return arrayList;
    }

    public String getMovementTitle() {
        if (this.movementTitle != null) {
            return this.movementTitle;
        }
        if (this.hasMovementTitle()) {
            return this.movementTitle;
        }
        return null;
    }

    public boolean hasMovementTitle() {
        Node node = this.selectSingleNode("/score-partwise/movement-title");
        if (node != null) {
            this.movementTitle = node.getTextContent();
            return true;
        }
        return false;
    }

    private long getCumulativeTicksLocal(int n, int n2) {
        if (n2 == 10080) {
            return this.cumulativeTicksList.get(n);
        }
        return this.cumulativeTicksList.get(n) * (long)n2 / 10080L;
    }

    private long getCumulativeTicksLocal2(int n, int n2) {
        if (n2 == 10080) {
            return this.cumulativeTicksList2.get(n);
        }
        return this.cumulativeTicksList2.get(n);
    }

    public int getCumulativeTicks(int n, boolean bl, int n2) {
        if (bl) {
            return (int)this.getCumulativeTicksLocal2(n, n2);
        }
        return (int)this.getCumulativeTicksLocal(n, n2);
    }

    public int getCumulativeTicks(int n, int n2) {
        return this.getCumulativeTicks(n, false, n2);
    }

    @Override
    public List<SimpleNoteList> getPartwiseNoteList(final int n) throws TransformerException {
        final ArrayList<SimpleNoteList> arrayList = new ArrayList<SimpleNoteList>();
        this.processNotePartwise(new NoteHandlerPartwise(){
            private int serial = 0;
            private SimpleNoteList nl;

            public void beginPart(Part part, MusicXMLWrapper musicXMLWrapper) {
                this.nl = new SimpleNoteList(++this.serial, part.id(), n);
            }

            public void endPart(Part part, MusicXMLWrapper musicXMLWrapper) {
                arrayList.add(this.nl);
            }

            public void beginMeasure(Measure measure, MusicXMLWrapper musicXMLWrapper) {
            }

            public void endMeasure(Measure measure, MusicXMLWrapper musicXMLWrapper) {
            }

            public void processMusicData(MusicData musicData, MusicXMLWrapper musicXMLWrapper) {
                Note note;
                if (musicData instanceof Note && !(note = (Note)musicData).rest()) {
                    this.nl.add((Note)musicData);
                }
            }
        });
        return arrayList;
    }

    @Override
    public InputStream getMIDIInputStream() throws IOException, TransformerException, SAXException, ParserConfigurationException {
        return this.makeDeadpanSCCXML(10080).toMIDIXML().getMIDIInputStream();
    }

    @Override
    protected void analyze() {
        this.createTimewiseNoteView();
    }

    private void createTimewiseNoteView() {
        this.timewiseNoteView = new TreeView("all");
        this.processNotePartwise(new NoteHandlerPartwise(){

            public void beginPart(Part part, MusicXMLWrapper musicXMLWrapper) {
            }

            public void endPart(Part part, MusicXMLWrapper musicXMLWrapper) {
            }

            public void beginMeasure(Measure measure, MusicXMLWrapper musicXMLWrapper) {
            }

            public void endMeasure(Measure measure, MusicXMLWrapper musicXMLWrapper) {
            }

            public void processMusicData(MusicData musicData, MusicXMLWrapper musicXMLWrapper) {
                if (musicData instanceof Note) {
                    Note note = (Note)musicData;
                    MusicXMLWrapper.this.timewiseNoteView.add(note, "");
                }
            }
        });
    }

    private void createNoteView() {
        this.partwiseNoteView = new ArrayList<TreeView<Note>>();
        this.slurredNoteView = new SlurredNoteViewList();
        this.processNotePartwise(new NoteHandlerPartwise(){
            private TreeView<Note> noteview;

            public void beginPart(Part part, MusicXMLWrapper musicXMLWrapper) {
                this.noteview = new TreeView(part.id());
            }

            public void endPart(Part part, MusicXMLWrapper musicXMLWrapper) {
                MusicXMLWrapper.this.partwiseNoteView.add(this.noteview);
            }

            public void beginMeasure(Measure measure, MusicXMLWrapper musicXMLWrapper) {
            }

            public void endMeasure(Measure measure, MusicXMLWrapper musicXMLWrapper) {
            }

            public void processMusicData(MusicData musicData, MusicXMLWrapper musicXMLWrapper) {
                if (musicData instanceof Note) {
                    List<StartStopElement> list;
                    Note note = (Note)musicData;
                    this.noteview.add(note, (byte)note.voice(), "");
                    Notations notations = note.getFirstNotations();
                    if (notations != null && (list = notations.getSlurList()) != null) {
                        for (StartStopElement startStopElement : list) {
                            if (startStopElement.type().equals("start")) {
                                MusicXMLWrapper.this.slurredNoteView.newSlur(note, startStopElement);
                                continue;
                            }
                            if (!startStopElement.type().equals("stop")) continue;
                            MusicXMLWrapper.this.slurredNoteView.endSlur(note, startStopElement);
                        }
                    }
                    MusicXMLWrapper.this.slurredNoteView.addNote(note);
                } else if (musicData instanceof Backup) {
                    MusicXMLWrapper.this.slurredNoteView.stopSlur();
                }
            }
        });
        this.slurredNoteView.postproc();
    }

    public List<? extends TreeView<Note>> getSlurredNoteViews(byte by) {
        return this.slurredNoteView.getSlurredNoteViews(by);
    }

    public List<? extends TreeView<Note>> getNoteViewsIncluding(Note note) {
        return this.slurredNoteView.getNoteViewsIncluding(note);
    }

    public List<? extends TreeView<Note>> getNoteViewsStartingWith(Note note) {
        return this.slurredNoteView.getNoteViewsStartingWith(note);
    }

    public List<? extends TreeView<Note>> getNoteViewsEndingWith(Note note) {
        return this.slurredNoteView.getNoteViewsEndingWith(note);
    }

    public class XPathView {
        private HashMap<Node, NodeInterface> n2ni = new HashMap();

        public XPathView() {
            Part[] partArray;
            for (Part part : partArray = MusicXMLWrapper.this.getPartList()) {
                Measure[] measureArray;
                this.n2ni.put(part.node(), part);
                for (Measure measure : measureArray = part.getMeasureList()) {
                    MusicData[] musicDataArray;
                    this.n2ni.put(measure.node(), measure);
                    for (MusicData musicData : musicDataArray = measure.getMusicDataList()) {
                        this.n2ni.put(musicData.node(), musicData);
                    }
                }
            }
        }

        public List get(String string) {
            ArrayList<NodeInterface> arrayList = new ArrayList<NodeInterface>();
            NodeList nodeList = MusicXMLWrapper.this.selectNodeList(string);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                NodeInterface nodeInterface = this.n2ni.get(nodeList.item(i));
                if (nodeInterface == null) continue;
                arrayList.add(nodeInterface);
            }
            return arrayList;
        }

        public List get(String string, Class ... classArray) {
            ArrayList<NodeInterface> arrayList = new ArrayList<NodeInterface>();
            NodeList nodeList = MusicXMLWrapper.this.selectNodeList(string);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                NodeInterface nodeInterface = this.n2ni.get(nodeList.item(i));
                Boolean bl = false;
                for (Class clazz : classArray) {
                    if (clazz != nodeInterface.getClass()) continue;
                    bl = true;
                    break;
                }
                if (!bl.booleanValue()) continue;
                arrayList.add(nodeInterface);
            }
            return arrayList;
        }
    }

    public class StartStopElement
    extends NodeInterface {
        private String type;
        private byte number;
        private NodeInterface parent;

        private StartStopElement(Node node, NodeInterface nodeInterface) {
            super(node);
            this.number = 1;
            this.parent = nodeInterface;
            this.type = StartStopElement.getAttribute(this.node(), "type");
            if (this.hasAttribute("number")) {
                this.number = (byte)this.getAttributeInt("number");
            }
        }

        protected final String getSupportedNodeName() {
            return "tied|slur|tuplet|glissando|slide";
        }

        public final NodeInterface getParentNodeInterface() {
            return this.parent;
        }

        public final String type() {
            return this.type;
        }

        public final byte number() {
            return this.number;
        }

        public String toString() {
            return this.getNodeName() + "[type=" + this.type() + ", number=" + this.number() + "]";
        }
    }

    public class DirectionType
    extends NodeInterface {
        private final Node child;
        private final String nodename;
        private final String text;

        private DirectionType(Node node) {
            super(node);
            this.child = this.getFirstChild();
            this.nodename = this.child.getNodeName();
            this.text = DirectionType.getText(this.child);
        }

        protected final String getSupportedNodeName() {
            return "direction-type";
        }

        public final String name() {
            return this.nodename;
        }

        public final String text() {
            return this.text;
        }

        public final String type() {
            return this.getAttribute("type");
        }

        public final int number() {
            return this.getAttributeInt("number");
        }

        public final String getAttribute(String string) {
            return DirectionType.getAttribute(this.child, string);
        }

        public final int getAttributeInt(String string) {
            return DirectionType.getAttributeInt(this.child, string);
        }

        public String dynamics() {
            if (this.nodename.equals("dynamics")) {
                return this.child.getFirstChild().getNodeName();
            }
            throw new InvalidElementException("not dynamics element");
        }
    }

    public class Direction
    extends MusicData {
        private DirectionType[] directType;
        private Node sound;

        private Direction(Node node, Measure measure) {
            super(node, measure);
            this.directType = null;
            this.sound = null;
            this.sound = this.getChildByTagName("sound");
        }

        protected final String getSupportedNodeName() {
            return "direction";
        }

        public DirectionType[] getDirectionTypeList() {
            if (this.directType == null) {
                NodeList nodeList = MusicXMLWrapper.this.selectNodeList(this.node(), "direction-type");
                int n = nodeList.getLength();
                this.directType = new DirectionType[n];
                for (int i = 0; i < n; ++i) {
                    this.directType[i] = new DirectionType(nodeList.item(i));
                }
            }
            return this.directType;
        }

        public final int voice() {
            return this.getChildTextInt("voice");
        }

        public final String getSoundAttribute(String string) {
            return Direction.getAttribute(this.sound, string);
        }

        public final int getSoundAttributeInt(String string) {
            return Direction.getAttributeInt(this.sound, string);
        }

        public final double getSoundAttributeDouble(String string) {
            return Direction.getAttributeDouble(this.sound, string);
        }

        public final boolean hasSound() {
            return this.sound != null;
        }

        public final double tempo() {
            return this.getSoundAttributeDouble("tempo");
        }
    }

    public class BarLine
    extends MusicData {
        private BarLine(Node node, Measure measure) {
            super(node, measure);
        }

        protected final String getSupportedNodeName() {
            return "barline";
        }

        public boolean repeat() {
            return this.getChildByTagName("repeat") != null;
        }

        public String repeatDirection() {
            return BarLine.getAttribute(this.getChildByTagName("repeat"), "direction");
        }

        public int repeatTimes() {
            return BarLine.getAttributeInt(this.getChildByTagName("repeat"), "times");
        }
    }

    public class Forward
    extends MusicData {
        private int duration;

        private Forward(Node node, Measure measure) {
            super(node, measure);
            this.duration = Forward.getTextInt(this.getChildByTagName("duration"));
        }

        protected final String getSupportedNodeName() {
            return "forward";
        }

        public final int duration() {
            return this.duration;
        }
    }

    public class Backup
    extends MusicData {
        private int duration;

        private Backup(Node node, Measure measure) {
            super(node, measure);
            this.duration = Backup.getTextInt(this.getChildByTagName("duration"));
        }

        protected final String getSupportedNodeName() {
            return "backup";
        }

        public final int duration() {
            return this.duration;
        }

        public double actualDuration() {
            return -super.actualDuration();
        }

        public int actualDuration(int n) {
            return -super.actualDuration(n);
        }

        public int subordinal() {
            return this.onset(10080) + this.actualDuration(10080);
        }
    }

    public class Attributes
    extends MusicData {
        private int fifths;
        private String mode;
        private int divisions;
        private int beats;
        private int beatType;
        private String timeSymbol;

        private Attributes(Node node, Measure measure) {
            Node node2;
            Node node3;
            super(node, measure);
            this.mode = null;
            this.divisions = 0;
            this.beats = 0;
            this.beatType = 0;
            this.timeSymbol = null;
            this.divisions = MusicXMLWrapper.this.lastDivisions;
            Node node4 = this.getChildByTagName("divisions");
            if (node4 != null) {
                this.divisions = Attributes.getTextInt(node4);
                MusicXMLWrapper.this.lastDivisions = this.divisions;
            }
            if ((node3 = this.getChildByTagName("key")) != null) {
                this.fifths = Attributes.getTextInt(Attributes.getChildByTagName("fifths", node3));
                this.mode = Attributes.getText(Attributes.getChildByTagName("mode", node3));
            }
            if ((node2 = this.getChildByTagName("time")) != null) {
                this.beats = Attributes.getTextInt(Attributes.getChildByTagName("beats", node2));
                this.beatType = Attributes.getTextInt(Attributes.getChildByTagName("beat-type", node2));
                if (Attributes.hasAttribute(node2, "symbol")) {
                    this.timeSymbol = Attributes.getAttribute(node2, "symbol");
                }
            }
        }

        protected final String getSupportedNodeName() {
            return "attributes";
        }

        public int divisions() {
            return this.divisions;
        }

        public int fifths() {
            return this.fifths;
        }

        public String mode() {
            return this.mode;
        }

        public int beats() {
            return this.beats;
        }

        public int beatType() {
            return this.beatType;
        }

        public String timeSymbol() {
            return this.timeSymbol;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Notations
    extends NodeInterface {
        private Note note;
        private List<StartStopElement> tielist;
        private List<StartStopElement> slurlist;
        private List<StartStopElement> tupletlist;
        private List<StartStopElement> glissandolist;
        private List<StartStopElement> slidelist;
        private Node articulations;
        private Node fermata;

        private Notations(Node node, Note note) {
            super(node);
            this.tielist = null;
            this.slurlist = null;
            this.tupletlist = null;
            this.glissandolist = null;
            this.slidelist = null;
            this.articulations = null;
            this.fermata = null;
            this.note = note;
            NodeList nodeList = this.getChildNodes();
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Node node2 = nodeList.item(i);
                String string = node2.getNodeName();
                if (string.equals("tied")) {
                    this.tielist = this.addStartStopElement(node2, this.tielist);
                    continue;
                }
                if (string.equals("slur")) {
                    this.slurlist = this.addStartStopElement(node2, this.slurlist);
                    continue;
                }
                if (string.equals("tuplet")) {
                    this.tupletlist = this.addStartStopElement(node2, this.tupletlist);
                    continue;
                }
                if (string.equals("glissando")) {
                    this.glissandolist = this.addStartStopElement(node2, this.glissandolist);
                    continue;
                }
                if (string.equals("slide")) {
                    this.slidelist = this.addStartStopElement(node2, this.slidelist);
                    continue;
                }
                if (string.equals("articulations")) {
                    if (this.articulations != null) continue;
                    this.articulations = node2;
                    continue;
                }
                if (!string.equals("fermata") || this.fermata != null) continue;
                this.fermata = node2;
            }
        }

        private List<StartStopElement> addStartStopElement(Node node, List<StartStopElement> list) {
            if (list == null) {
                list = new ArrayList<StartStopElement>();
            }
            list.add(new StartStopElement(node, this));
            return list;
        }

        @Override
        protected final String getSupportedNodeName() {
            return "notations";
        }

        public boolean hasArticulation(String string) {
            if (this.articulations == null) {
                return false;
            }
            return Notations.hasChild(string, this.articulations);
        }

        public String fermata() {
            if (this.fermata == null) {
                return null;
            }
            return Notations.getText(this.fermata);
        }

        public String fermataType() {
            if (this.fermata == null) {
                return null;
            }
            return Notations.getAttribute(this.fermata, "type");
        }

        public final List<StartStopElement> getTieList() {
            return this.tielist;
        }

        public final List<StartStopElement> getSlurList() {
            return this.slurlist;
        }

        public final List<StartStopElement> getTupletList() {
            return this.tupletlist;
        }

        public final List<StartStopElement> getGlissandoList() {
            return this.glissandolist;
        }

        public final List<StartStopElement> getSlideList() {
            return this.slidelist;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Note
    extends MusicData
    implements NoteCompatible {
        private String pitchStep;
        private int pitchOctave;
        private int pitchAlter;
        private int duration;
        private int notenum;
        private int staff;
        private boolean chord;
        private boolean rest;
        private boolean grace;
        private String type;
        private int voice;
        private String stem;
        private String notehead;
        private String ties;
        private Node timeModification;
        private Notations notations1st;
        private Note tiedNote;
        private String xpath;
        private Note topchordnote;
        private List<Note> chordnotes;

        private Note(Node node, Measure measure) {
            super(node, measure);
            this.pitchAlter = 0;
            this.notenum = -1;
            this.chord = false;
            this.rest = false;
            this.grace = false;
            this.type = null;
            this.voice = 0;
            this.stem = null;
            this.notehead = null;
            this.ties = "";
            this.timeModification = null;
            this.notations1st = null;
            this.tiedNote = null;
            this.xpath = null;
            this.topchordnote = this;
            this.chordnotes = null;
            NodeList nodeList = this.getChildNodes();
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Node node2 = nodeList.item(i);
                String string = node2.getNodeName();
                String string2 = Note.getText(node2);
                if (string.equals("rest")) {
                    this.rest = true;
                    continue;
                }
                if (string.equals("grace")) {
                    this.grace = true;
                    continue;
                }
                if (string.equals("chord")) {
                    this.chord = true;
                    continue;
                }
                if (string.equals("rest")) {
                    this.rest = true;
                    continue;
                }
                if (string.equals("type")) {
                    this.type = string2;
                    continue;
                }
                if (string.equals("duration")) {
                    this.duration = Integer.parseInt(string2);
                    continue;
                }
                if (string.equals("voice")) {
                    this.voice = Integer.parseInt(string2);
                    continue;
                }
                if (string.equals("stem")) {
                    this.stem = string2;
                    continue;
                }
                if (string.equals("time-modification")) {
                    this.timeModification = node2;
                    continue;
                }
                if (string.equals("notations")) {
                    if (this.notations1st != null) continue;
                    this.notations1st = new Notations(node2, this);
                    continue;
                }
                if (string.equals("pitch")) {
                    this.analyzePitch(node2);
                    continue;
                }
                if (string.equals("notehead")) {
                    this.notehead = string2;
                    continue;
                }
                if (!string.equals("tie")) continue;
                this.ties = this.ties + Note.getAttribute(node2, "type") + " ";
            }
        }

        private void analyzePitch(Node node) {
            NodeList nodeList = node.getChildNodes();
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Node node2 = nodeList.item(i);
                String string = node2.getNodeName();
                String string2 = Note.getText(node2);
                if (string.equals("step")) {
                    this.pitchStep = string2;
                    continue;
                }
                if (string.equals("octave")) {
                    this.pitchOctave = Integer.parseInt(string2);
                    continue;
                }
                if (!string.equals("alter")) continue;
                this.pitchAlter = Integer.parseInt(string2);
            }
        }

        @Override
        protected final String getSupportedNodeName() {
            return "note";
        }

        public final String pitchStep() {
            if (!this.rest) {
                return this.pitchStep;
            }
            throw new InvalidElementException("This is a rest note");
        }

        public final int pitchOctave() {
            if (!this.rest) {
                return this.pitchOctave;
            }
            throw new InvalidElementException("This is a rest note");
        }

        public final int pitchAlter() {
            if (!this.rest) {
                return this.pitchAlter;
            }
            throw new InvalidElementException("This is a rest note");
        }

        @Override
        public final int duration() {
            if (!this.grace) {
                return this.duration;
            }
            return 0;
        }

        public double tiedDuration() {
            if (this.tiedNote == null) {
                return this.actualDuration();
            }
            return this.actualDuration() + this.tiedNote.tiedDuration();
        }

        public int tiedDuration(int n) {
            if (this.tiedNote == null) {
                return this.actualDuration(n);
            }
            return this.actualDuration(n) + this.tiedNote.tiedDuration(n);
        }

        @Override
        public int offset(int n) {
            return this.onset(n) + this.tiedDuration(n);
        }

        public final boolean chord() {
            return this.chord;
        }

        public final boolean rest() {
            return this.rest;
        }

        public final boolean grace() {
            return this.grace;
        }

        public final String stem() {
            return this.stem;
        }

        public final String type() {
            return this.type;
        }

        public final boolean hasTimeModification() {
            return this.timeModification != null;
        }

        public int timeModificationActualNotes() {
            return Note.getTextInt(Note.getChildByTagName("actual-notes", this.timeModification));
        }

        public int timeModificationNormalNotes() {
            return Note.getTextInt(Note.getChildByTagName("normal-notes", this.timeModification));
        }

        public final int voice() {
            return this.voice;
        }

        public final int staff() {
            return this.staff;
        }

        public final boolean containsTieType(String string) {
            return this.ties.contains(string);
        }

        public final Note tiedTo() {
            return this.tiedNote;
        }

        public final String notehead() {
            return this.notehead;
        }

        public final String noteName() {
            if (this.rest()) {
                return "rest";
            }
            String string = this.pitchStep();
            if (this.pitchAlter() > 0) {
                string = string + "#";
            } else if (this.pitchAlter() < 0) {
                string = string + "b";
            }
            return string + this.pitchOctave();
        }

        @Override
        public int notenum() {
            if (!this.rest) {
                if (this.notenum < 0) {
                    int n;
                    if (this.pitchStep.equalsIgnoreCase("C")) {
                        n = 0;
                    } else if (this.pitchStep.equalsIgnoreCase("D")) {
                        n = 2;
                    } else if (this.pitchStep.equalsIgnoreCase("E")) {
                        n = 4;
                    } else if (this.pitchStep.equalsIgnoreCase("F")) {
                        n = 5;
                    } else if (this.pitchStep.equalsIgnoreCase("G")) {
                        n = 7;
                    } else if (this.pitchStep.equalsIgnoreCase("A")) {
                        n = 9;
                    } else if (this.pitchStep.equalsIgnoreCase("B")) {
                        n = 11;
                    } else {
                        throw new InvalidElementException("Pitch is wrong.");
                    }
                    this.notenum = n + (this.pitchOctave + 1) * 12 + this.pitchAlter;
                }
                return this.notenum;
            }
            throw new InvalidElementException("This is a rest note");
        }

        @Override
        public int velocity() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int onsetInMilliSec() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int onsetInMSec() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int offsetInMilliSec() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int offsetInMSec() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return "Note[" + this.measure().number() + ": " + this.onsetWithinMeasure() + "--" + (this.actualDuration() + this.onsetWithinMeasure()) + "  " + this.noteName() + "]";
        }

        public final Note topNoteOfChord() {
            return this.topchordnote;
        }

        public List<Note> chordNotes() {
            return this.topchordnote.chordnotes;
        }

        private void addToChordNoteList(Note note) {
            this.topchordnote = note;
            if (note.chordnotes == null) {
                note.chordnotes = new ArrayList<Note>();
            }
            note.chordnotes.add(this);
        }

        public String getXPathExpression() {
            return this.xpath;
        }

        public double beat() {
            return this.onsetWithinMeasure() + 1.0;
        }

        public Notations getFirstNotations() {
            return this.notations1st;
        }

        public boolean hasArticulation(String string) {
            if (this.notations1st == null) {
                return false;
            }
            return this.notations1st.hasArticulation(string);
        }
    }

    public class MusicData
    extends NodeInterface
    implements Ordered {
        private Measure measure;
        private int divisions;
        private int onset;
        private long measureTick;

        private MusicData(Node node, Measure measure) {
            super(node);
            this.measure = measure;
            this.divisions = MusicXMLWrapper.this.lastDivisions;
            this.measureTick = this.measure().startsWithX() ? MusicXMLWrapper.this.getCumulativeTicksLocal2(this.measure().numberX(), 10080) : MusicXMLWrapper.this.getCumulativeTicksLocal(this.measure().number(), 10080);
        }

        protected String getSupportedNodeName() {
            return "note|backup|forward|direction|attributes|harmony|figured-bass|print|sound|barline|grouping|link|bookmark";
        }

        public final Measure measure() {
            return this.measure;
        }

        public int duration() {
            return 0;
        }

        public int duration(int n) {
            return this.actualDuration(n);
        }

        public double actualDuration() {
            return (double)this.duration() / (double)this.divisions;
        }

        public int actualDuration(int n) {
            return Math.round((float)(this.duration() * n) / (float)this.divisions);
        }

        public double onsetWithinMeasure() {
            return (double)this.onset / 10080.0;
        }

        public int onset(int n) {
            return this.measure().cumulativeTicks(n) + Math.round((float)(this.onset * n) / 10080.0f);
        }

        public int offset(int n) {
            return this.onset(n) + this.duration(n);
        }

        public int ordinal() {
            return (int)this.measureTick;
        }

        public int subordinal() {
            return this.onset;
        }
    }

    public class Measure
    extends NodeInterface {
        private Part part;
        private int number;
        private int numberX;
        private String strNumber;
        private String xpath;
        private MusicData[] mdlist;
        private Node sound;
        private Attributes attr;
        private long cumulativeTicks;
        private int duration;
        private Measure prevMeasure;
        private Note[] tiedNotes;
        private double beat0;
        private boolean startsWithX;

        private Measure(Node node, Measure measure, Part part) {
            block3: {
                super(node);
                this.xpath = null;
                this.mdlist = null;
                this.attr = null;
                this.duration = -1;
                this.tiedNotes = null;
                this.beat0 = 1.0;
                this.startsWithX = false;
                this.part = part;
                this.prevMeasure = measure;
                this.tiedNotes = measure == null ? new Note[128] : measure.tiedNotes;
                this.strNumber = Measure.getAttribute(this.node(), "number");
                try {
                    this.number = Integer.parseInt(this.strNumber);
                }
                catch (NumberFormatException numberFormatException) {
                    if (!this.strNumber.startsWith("X")) break block3;
                    this.startsWithX = true;
                    this.numberX = Integer.parseInt(this.strNumber.substring(1));
                    if (measure != null) {
                        this.number = measure.number;
                        this.beat0 = measure.beat0 + (double)measure.duration(10080) / 10080.0;
                    }
                    this.number = 0;
                }
            }
            this.sound = this.getChildByTagName("sound");
        }

        protected final String getSupportedNodeName() {
            return "measure";
        }

        public void eachdata(Closure closure) throws TransformerException {
            MusicData[] musicDataArray;
            for (MusicData musicData : musicDataArray = this.getMusicDataList()) {
                closure.call(new Object[]{musicData});
            }
        }

        public void eachnote(Closure closure) throws TransformerException {
            MusicData[] musicDataArray;
            for (MusicData musicData : musicDataArray = this.getMusicDataList()) {
                Note note;
                if (!(musicData instanceof Note) || (note = (Note)musicData).rest()) continue;
                closure.call(new Object[]{note});
            }
        }

        private void setCumulativeTicks(long l) {
            if (!this.startsWithX) {
                if (MusicXMLWrapper.this.cumulativeTicksList.size() > this.number) {
                    if ((Long)MusicXMLWrapper.this.cumulativeTicksList.get(this.number) != l) {
                        throw new InvalidElementException();
                    }
                } else {
                    MusicXMLWrapper.this.cumulativeTicksList.set(this.number, l);
                }
            } else if (MusicXMLWrapper.this.cumulativeTicksList2.size() > this.numberX) {
                if ((Long)MusicXMLWrapper.this.cumulativeTicksList2.get(this.numberX) != l) {
                    throw new InvalidElementException();
                }
            } else {
                MusicXMLWrapper.this.cumulativeTicksList2.set(this.numberX, l);
            }
        }

        public final int cumulativeTicks(int n) {
            return MusicXMLWrapper.this.getCumulativeTicks(this.number, n);
        }

        public int duration(int n) {
            if (this.duration < 0) {
                MusicData[] musicDataArray = this.getMusicDataList();
                this.duration = 0;
                for (MusicData musicData : musicDataArray) {
                    this.duration += musicData instanceof Note && ((Note)musicData).chord() ? 0 : musicData.actualDuration(10080);
                }
            }
            if (n == 10080) {
                return this.duration;
            }
            return Math.round((float)(this.duration * n) / 10080.0f);
        }

        public MusicData[] getMusicDataList() {
            Note note = null;
            int n = 0;
            if (this.mdlist == null) {
                int n2 = 0;
                int n3 = 0;
                NodeList nodeList = this.node().getChildNodes();
                int n4 = nodeList.getLength();
                this.mdlist = new MusicData[n4];
                for (int i = 0; i < n4; ++i) {
                    MusicData musicData = this.getMusicDataNodeInterface(nodeList.item(i));
                    if (musicData instanceof Note) {
                        Note note2 = (Note)musicData;
                        if (note2.chord()) {
                            n2 -= n3;
                            note2.addToChordNoteList(note);
                        } else {
                            note = note2;
                        }
                        if (!note2.rest()) {
                            int n5 = note2.notenum();
                            if (note2.containsTieType("stop") && this.tiedNotes[n5] != null) {
                                this.tiedNotes[n5].tiedNote = note2;
                                this.tiedNotes[n5] = null;
                            }
                            if (note2.containsTieType("start")) {
                                this.tiedNotes[n5] = note2;
                            }
                        }
                        note2.xpath = this.getXPathExpression() + "/note[" + ++n + "]";
                    }
                    musicData.onset = n2;
                    n3 = musicData.actualDuration(10080);
                    n2 += n3;
                    this.mdlist[i] = musicData;
                    if (!(musicData instanceof Attributes)) continue;
                    this.attr = (Attributes)musicData;
                }
            }
            return this.mdlist;
        }

        public final int number() {
            return this.number;
        }

        public final boolean startsWithX() {
            return this.startsWithX;
        }

        public final int numberX() {
            return this.numberX;
        }

        public final String numberInString() {
            return this.strNumber;
        }

        public final double initialBeat() {
            return this.beat0;
        }

        private MusicData getMusicDataNodeInterface(Node node) {
            String string = node.getNodeName();
            if (string.equals("note")) {
                return new Note(node, this);
            }
            if (string.equals("attributes")) {
                return new Attributes(node, this);
            }
            if (string.equals("backup")) {
                return new Backup(node, this);
            }
            if (string.equals("forward")) {
                return new Forward(node, this);
            }
            if (string.equals("direction")) {
                return new Direction(node, this);
            }
            return new MusicData(node, this);
        }

        public final Part part() {
            return this.part;
        }

        public Attributes getAttributesNodeInterface() {
            this.getMusicDataList();
            return this.attr;
        }

        public String getXPathExpression() {
            if (this.xpath == null) {
                this.xpath = this.part.getXPathExpression() + "/measure[@number='" + this.strNumber + "']";
            }
            return this.xpath;
        }

        public int tempo() {
            if (this.sound != null) {
                return Measure.getAttributeInt(this.sound, "tempo");
            }
            return 120;
        }
    }

    public class Part
    extends NodeInterface {
        private String xpath;
        private String id;
        private Measure[] measurelist;
        private Node info;
        private Node midi;

        private Part(Node node, Node node2) {
            super(node);
            this.xpath = null;
            this.measurelist = null;
            this.midi = null;
            this.id = Part.getAttribute(this.node(), "id");
            this.info = MusicXMLWrapper.this.selectSingleNode(node2, "score-part[@id='" + this.id() + "']");
        }

        protected final String getSupportedNodeName() {
            return "part";
        }

        public void eachmeasure(Closure closure) throws TransformerException {
            Measure[] measureArray;
            for (Measure measure : measureArray = this.getMeasureList()) {
                closure.call(new Object[]{measure});
            }
        }

        public void eachnote(Closure closure) throws TransformerException {
            Measure[] measureArray;
            for (Measure measure : measureArray = this.getMeasureList()) {
                MusicData[] musicDataArray;
                for (MusicData musicData : musicDataArray = measure.getMusicDataList()) {
                    Note note;
                    if (!(musicData instanceof Note) || (note = (Note)musicData).rest()) continue;
                    closure.call(new Object[]{note});
                }
            }
        }

        public Measure[] getMeasureList() {
            if (this.measurelist == null) {
                long l = 0L;
                NodeList nodeList = MusicXMLWrapper.this.selectNodeList(this.node(), "measure");
                int n = nodeList.getLength();
                this.measurelist = new Measure[n];
                for (int i = 0; i < n; ++i) {
                    Measure measure = new Measure(nodeList.item(i), i > 0 ? this.measurelist[i - 1] : null, this);
                    measure.setCumulativeTicks(l);
                    l += (long)measure.duration(10080);
                    measure.getMusicDataList();
                    this.measurelist[i] = measure;
                }
            }
            return this.measurelist;
        }

        public int firstMeasureNumber() {
            Measure[] measureArray = this.getMeasureList();
            if (measureArray != null && measureArray.length > 0) {
                return measureArray[0].number();
            }
            return 0;
        }

        public final String id() {
            return this.id;
        }

        public String getXPathExpression() {
            if (this.xpath == null) {
                Node node = this.node().getParentNode();
                if (node.isSameNode(MusicXMLWrapper.this.getDocument().getDocumentElement())) {
                    this.xpath = "/" + node.getNodeName() + "/part[@id='" + this.id() + "']";
                } else {
                    throw new InvalidElementException();
                }
            }
            return this.xpath;
        }

        public int midiChannel() {
            if (this.midi == null) {
                this.midi = Part.getChildByTagName("midi-instrument", this.info);
            }
            return Part.getTextInt(Part.getChildByTagName("midi-channel", this.midi));
        }

        public int midiProgram() {
            if (this.midi == null) {
                this.midi = Part.getChildByTagName("midi-instrument", this.info);
            }
            return Part.getTextInt(Part.getChildByTagName("midi-program", this.midi));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SlurredNoteViewList {
        private MultiMap<Byte, SlurredNoteView> map = new MultiHashMap<Byte, SlurredNoteView>();
        private MultiMap<Note, SlurredNoteView> viewFrom;
        private MultiMap<Note, SlurredNoteView> viewIncluding;
        private MultiMap<Note, SlurredNoteView> viewUntil;
        private Map<Byte, SlurredNoteView> current = new HashMap<Byte, SlurredNoteView>();
        private int i = 0;
        private int nCurrent = 0;
        private List<StartStopElement> pendingSlursB;
        private List<StartStopElement> pendingSlursE;

        private SlurredNoteViewList() {
            this.viewFrom = new MultiHashMap<Note, SlurredNoteView>();
            this.viewIncluding = new MultiHashMap<Note, SlurredNoteView>();
            this.viewUntil = new MultiHashMap<Note, SlurredNoteView>();
            this.pendingSlursB = new ArrayList<StartStopElement>();
            this.pendingSlursE = new ArrayList<StartStopElement>();
        }

        private void newSlur(Note note, StartStopElement startStopElement) {
            byte by = startStopElement.number();
            SlurredNoteView slurredNoteView = new SlurredNoteView("slur:" + ++this.i);
            slurredNoteView.startslur = startStopElement;
            this.map.add(by, slurredNoteView);
            this.current.put(by, slurredNoteView);
            this.viewFrom.put(note, slurredNoteView);
            ++this.nCurrent;
        }

        private void addNote(Note note) {
            if (this.nCurrent > 0) {
                for (SlurredNoteView slurredNoteView : this.current.values()) {
                    slurredNoteView.add(note, "");
                    this.viewIncluding.put(note, slurredNoteView);
                }
            }
        }

        private void stopSlur() {
            if (this.nCurrent > 0) {
                this.current.clear();
                this.nCurrent = 0;
            }
        }

        private void endSlur(Note note, StartStopElement startStopElement) {
            byte by = startStopElement.number();
            SlurredNoteView slurredNoteView = this.current.get(by);
            if (slurredNoteView != null) {
                slurredNoteView.endslur = startStopElement;
                slurredNoteView.add(note, "");
                this.viewIncluding.put(note, slurredNoteView);
                this.viewUntil.put(note, slurredNoteView);
                this.current.remove(by);
                --this.nCurrent;
            } else {
                this.pendingSlursE.add(startStopElement);
            }
        }

        private void postproc() {
            this.invalidateImcompleteSlurs(this.map, true);
            this.invalidateImcompleteSlurs(this.viewFrom, false);
            this.invalidateImcompleteSlurs(this.viewIncluding, false);
            this.invalidateImcompleteSlurs(this.viewUntil, false);
        }

        private void invalidateImcompleteSlurs(MultiMap<?, SlurredNoteView> multiMap, boolean bl) {
            Collection<List<SlurredNoteView>> collection = multiMap.values();
            for (List<SlurredNoteView> list : collection) {
                Iterator<SlurredNoteView> iterator = list.iterator();
                while (iterator.hasNext()) {
                    SlurredNoteView slurredNoteView = iterator.next();
                    if (slurredNoteView.endslur != null) continue;
                    if (bl) {
                        this.pendingSlursB.add(slurredNoteView.startslur);
                    }
                    iterator.remove();
                }
            }
        }

        private List<? extends TreeView<Note>> getSlurredNoteViews(byte by) {
            return this.map.get(by);
        }

        private List<? extends TreeView<Note>> getNoteViewsIncluding(Note note) {
            return this.viewIncluding.get(note);
        }

        private List<? extends TreeView<Note>> getNoteViewsStartingWith(Note note) {
            return this.viewFrom.get(note);
        }

        private List<? extends TreeView<Note>> getNoteViewsEndingWith(Note note) {
            return this.viewUntil.get(note);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SlurredNoteView
    extends TreeView<Note> {
        private StartStopElement startslur;
        private StartStopElement endslur;

        private SlurredNoteView(String string) {
            super(string);
            this.startslur = null;
            this.endslur = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MyArrayList
    extends ArrayList<Long> {
        private MyArrayList() {
        }

        @Override
        public Long set(int n, Long l) {
            if (n > this.size()) {
                this.add(null);
                this.set(n, l);
                return null;
            }
            if (n == this.size()) {
                this.add(l);
                return null;
            }
            return super.set(n, l);
        }
    }
}

