/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.inference;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import jp.crestmuse.cmx.inference.MusicCalculator;
import jp.crestmuse.cmx.inference.MusicElement;
import jp.crestmuse.cmx.inference.MusicRepresentation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MusicRepresentationImpl
implements MusicRepresentation {
    private int measureNum;
    private int division;
    private HashMap<String, MusicLayer> name2layer;

    MusicRepresentationImpl(int n, int n2) {
        this.measureNum = n;
        this.division = n2;
        this.name2layer = new HashMap();
    }

    @Override
    public int getMeasureNum() {
        return this.measureNum;
    }

    @Override
    public int getDivision() {
        return this.division;
    }

    @Override
    public void addMusicLayer(String string, Object[] objectArray) {
        this.addMusicLayer(string, objectArray, 1);
    }

    @Override
    public void addMusicLayer(String string, Object[] objectArray, int n) {
        this.name2layer.put(string, new MusicLayer(string, objectArray));
        this.name2layer.get(string).setTiedLength(n);
    }

    @Override
    public void addMusicLayer(String string, List<Object> list) {
        this.addMusicLayer(string, list, 1);
    }

    @Override
    public void addMusicLayer(String string, List<Object> list, int n) {
        this.addMusicLayer(string, list.toArray(), n);
    }

    @Override
    public Object[] getLabels(String string) {
        return this.name2layer.get((Object)string).labels;
    }

    private MusicElement getMusicElement(String string, int n) {
        return this.name2layer.get(string).getElement(n);
    }

    @Override
    public MusicElement getMusicElement(String string, int n, int n2) {
        return this.getMusicElement(string, n * this.division + n2);
    }

    @Override
    public int getTiedLength(String string) {
        return this.name2layer.get(string).getTiedLength();
    }

    @Override
    public void addMusicCalculator(String string, MusicCalculator musicCalculator) {
        this.name2layer.get(string).addMusicCalculator(musicCalculator);
    }

    private class MusicLayer {
        String name;
        MusicElement[] elements;
        List<MusicCalculator> calculators;
        int tiedLength = 1;
        Object[] labels;

        MusicLayer(String string, Object[] objectArray) {
            this.name = string;
            this.elements = new MusicElement[MusicRepresentationImpl.this.division * MusicRepresentationImpl.this.measureNum];
            this.calculators = new LinkedList<MusicCalculator>();
            this.labels = objectArray;
        }

        MusicElement getElement(int n) {
            if (this.elements[n] == null) {
                this.addElement(n);
            }
            return this.elements[n];
        }

        int getTiedLength() {
            return this.tiedLength;
        }

        void setTiedLength(int n) {
            this.tiedLength = n;
            for (int i = 0; i < MusicRepresentationImpl.this.division * MusicRepresentationImpl.this.measureNum; i += this.tiedLength) {
                if (this.elements[i] == null) {
                    this.addElement(i);
                    continue;
                }
                MusicElement musicElement = this.elements[i];
                this.addElement(i);
                ((MusicElementImpl)this.elements[i]).copy(musicElement);
            }
        }

        void addMusicCalculator(MusicCalculator musicCalculator) {
            this.calculators.add(musicCalculator);
        }

        void addElement(int n) {
            int n2;
            MusicElementImpl musicElementImpl = new MusicElementImpl(this, n);
            for (int i = n2 = n / this.tiedLength * this.tiedLength; i < n2 + this.tiedLength && i < MusicRepresentationImpl.this.division * MusicRepresentationImpl.this.measureNum; ++i) {
                this.elements[i] = musicElementImpl;
            }
        }

        void update(int n) {
            for (MusicCalculator musicCalculator : this.calculators) {
                musicCalculator.updated(n / MusicRepresentationImpl.this.division, n % MusicRepresentationImpl.this.division, this.name, MusicRepresentationImpl.this);
            }
        }
    }

    class MusicElementImpl
    implements MusicElement {
        private double[] prob;
        private boolean isEvidence;
        private int evidence;
        private boolean set = false;
        private MusicLayer parent;
        private int index;

        MusicElementImpl(MusicLayer musicLayer, int n) {
            this.parent = musicLayer;
            this.index = n;
            this.prob = new double[musicLayer.labels.length];
        }

        public double getProb(int n) {
            if (this.isEvidence) {
                if (this.evidence == n) {
                    return 1.0;
                }
                return 0.0;
            }
            return this.prob[n];
        }

        public int getHighestProbIndex() {
            if (this.isEvidence) {
                return this.evidence;
            }
            double d = Double.MIN_VALUE;
            int n = 0;
            for (int i = 0; i < this.prob.length; ++i) {
                if (!(this.prob[i] > d)) continue;
                d = this.prob[i];
                n = i;
            }
            return n;
        }

        public int getProbLength() {
            return this.prob.length;
        }

        public void setEvidence(Object object) {
            this.setEvidence(this.indexOf(object));
        }

        public void setEvidence(int n) {
            this.set = true;
            this.isEvidence = true;
            this.evidence = n;
            System.err.println("UPDATE: " + this.parent.name + " " + this.index);
            this.parent.update(this.index);
        }

        public void setProb(int n, double d) {
            this.set = true;
            this.isEvidence = false;
            this.prob[n] = d;
            this.parent.update(this.index);
        }

        public Object getLabel(int n) {
            return this.parent.labels[n];
        }

        public int indexOf(Object object) {
            for (int i = 0; i < this.parent.labels.length; ++i) {
                if (!this.parent.labels[i].equals(object)) continue;
                return i;
            }
            return -1;
        }

        private void copy(MusicElement musicElement) {
            MusicElementImpl musicElementImpl = (MusicElementImpl)musicElement;
            this.prob = (double[])musicElementImpl.prob.clone();
            this.isEvidence = musicElementImpl.isEvidence;
            this.evidence = musicElementImpl.evidence;
            this.set = musicElementImpl.set;
            this.parent = musicElementImpl.parent;
            this.index = musicElementImpl.index;
        }

        public double getProb(Object object) {
            return this.getProb(this.indexOf(object));
        }

        public void setProb(Object object, double d) {
            this.setProb(this.indexOf(object), d);
        }

        public Object getMostLikely() {
            return this.getLabel(this.getHighestProbIndex());
        }

        public Object generate() {
            if (this.isEvidence) {
                return this.getLabel(this.evidence);
            }
            double d = 0.0;
            for (int i = 0; i < this.prob.length; ++i) {
                d += this.prob[i];
            }
            double d2 = Math.random();
            double d3 = 0.0;
            for (int i = 0; i < this.prob.length; ++i) {
                if (d3 / d <= d2 && d2 <= (d3 + this.prob[i]) / d) {
                    return this.getLabel(i);
                }
                d3 += this.prob[i];
            }
            return null;
        }
    }
}

