/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.math;

import java.util.Arrays;
import jp.crestmuse.cmx.math.AbstractDoubleMatrixImpl;
import jp.crestmuse.cmx.math.BooleanArray;
import jp.crestmuse.cmx.math.BooleanArrayFactory;
import jp.crestmuse.cmx.math.ComplexArray;
import jp.crestmuse.cmx.math.ComplexArrayFactory;
import jp.crestmuse.cmx.math.ComplexNumber;
import jp.crestmuse.cmx.math.DefaultDoubleArray;
import jp.crestmuse.cmx.math.DoubleArray;
import jp.crestmuse.cmx.math.DoubleArrayFactory;
import jp.crestmuse.cmx.math.DoubleMatrix;
import jp.crestmuse.cmx.math.DoubleMatrixFactory;
import jp.crestmuse.cmx.math.MathException;
import jp.crestmuse.cmx.math.Utils;
import org.apache.commons.math.linear.EigenDecompositionImpl;
import org.apache.commons.math.linear.LUDecompositionImpl;
import org.apache.commons.math.linear.QRDecompositionImpl;
import org.apache.commons.math.linear.SingularValueDecompositionImpl;
import org.apache.commons.math.stat.descriptive.rank.Median;

public class Operations {
    private static final DoubleArrayFactory factory = DoubleArrayFactory.getFactory();
    private static final BooleanArrayFactory bfactory = BooleanArrayFactory.getFactory();
    private static final ComplexArrayFactory cfactory = ComplexArrayFactory.getFactory();
    private static final DoubleMatrixFactory mfactory = DoubleMatrixFactory.getFactory();
    private static final Median median = new Median();

    public static DoubleArray subarray(DoubleArray doubleArray, int n, int n2) {
        int n3 = n2 - n;
        DoubleArray doubleArray2 = factory.createArray(n3);
        for (int i = 0; i < n3; ++i) {
            doubleArray2.set(i, doubleArray.get(n + i));
        }
        return doubleArray2;
    }

    public static ComplexArray subarray(ComplexArray complexArray, int n, int n2) {
        int n3 = n2 - n;
        ComplexArray complexArray2 = cfactory.createArray(n3);
        for (int i = 0; i < n3; ++i) {
            complexArray2.set(i, complexArray.getReal(n + i), complexArray.getImag(n + i));
        }
        return complexArray2;
    }

    public static void putAt(DoubleArray doubleArray, int n, double d) {
        doubleArray.set(n, d);
    }

    public static double getAt(DoubleArray doubleArray, int n) {
        return doubleArray.get(n);
    }

    public static DoubleArray add(DoubleArray doubleArray, DoubleArray doubleArray2) {
        int n = doubleArray.length();
        DoubleArray doubleArray3 = factory.createArray(n);
        for (int i = 0; i < n; ++i) {
            doubleArray3.set(i, doubleArray.get(i) + doubleArray2.get(i));
        }
        return doubleArray3;
    }

    public static DoubleArray plus(DoubleArray doubleArray, DoubleArray doubleArray2) {
        return Operations.add(doubleArray, doubleArray2);
    }

    public static void addX(DoubleArray doubleArray, DoubleArray doubleArray2) {
        int n = doubleArray.length();
        for (int i = 0; i < n; ++i) {
            doubleArray.set(i, doubleArray.get(i) + doubleArray2.get(i));
        }
    }

    public static DoubleArray add(DoubleArray doubleArray, double d) {
        int n = doubleArray.length();
        DoubleArray doubleArray2 = factory.createArray(n);
        for (int i = 0; i < n; ++i) {
            doubleArray2.set(i, doubleArray.get(i) + d);
        }
        return doubleArray2;
    }

    public static DoubleArray plus(DoubleArray doubleArray, double d) {
        return Operations.add(doubleArray, d);
    }

    public static void addX(DoubleArray doubleArray, double d) {
        int n = doubleArray.length();
        for (int i = 0; i < n; ++i) {
            doubleArray.set(i, doubleArray.get(i) + d);
        }
    }

    public static void addX(DoubleArray doubleArray, DoubleArray doubleArray2, int n) {
        int n2 = doubleArray2.length();
        for (int i = 0; i < n2; ++i) {
            doubleArray.set(i + n, doubleArray.get(i + n) + doubleArray2.get(i));
        }
    }

    public static void addX(DoubleArray doubleArray, int n, double d) {
        doubleArray.set(n, doubleArray.get(n) + d);
    }

    public static DoubleArray sub(DoubleArray doubleArray, DoubleArray doubleArray2) {
        int n = doubleArray.length();
        DoubleArray doubleArray3 = factory.createArray(n);
        for (int i = 0; i < n; ++i) {
            doubleArray3.set(i, doubleArray.get(i) - doubleArray2.get(i));
        }
        return doubleArray3;
    }

    public static DoubleArray minus(DoubleArray doubleArray, DoubleArray doubleArray2) {
        return Operations.sub(doubleArray, doubleArray2);
    }

    public static DoubleArray sub(DoubleArray doubleArray, double d) {
        int n = doubleArray.length();
        DoubleArray doubleArray2 = factory.createArray(n);
        for (int i = 0; i < n; ++i) {
            doubleArray2.set(i, doubleArray.get(i) - d);
        }
        return doubleArray2;
    }

    public static DoubleArray minus(DoubleArray doubleArray, double d) {
        return Operations.sub(doubleArray, d);
    }

    public static void subX(DoubleArray doubleArray, DoubleArray doubleArray2) {
        int n = doubleArray.length();
        for (int i = 0; i < n; ++i) {
            doubleArray.set(i, doubleArray.get(i) - doubleArray2.get(i));
        }
    }

    public static void subX(DoubleArray doubleArray, double d) {
        int n = doubleArray.length();
        for (int i = 0; i < n; ++i) {
            doubleArray.set(i, doubleArray.get(i) - d);
        }
    }

    public static DoubleArray mul(DoubleArray doubleArray, double d) {
        int n = doubleArray.length();
        DoubleArray doubleArray2 = factory.createArray(n);
        for (int i = 0; i < n; ++i) {
            doubleArray2.set(i, doubleArray.get(i) * d);
        }
        return doubleArray2;
    }

    public static DoubleArray multiply(DoubleArray doubleArray, double d) {
        return Operations.mul(doubleArray, d);
    }

    public static DoubleArray mul(DoubleArray doubleArray, DoubleArray doubleArray2) {
        int n = doubleArray.length();
        DoubleArray doubleArray3 = factory.createArray(n);
        for (int i = 0; i < n; ++i) {
            doubleArray3.set(i, doubleArray.get(i) * doubleArray2.get(i));
        }
        return doubleArray3;
    }

    public static DoubleArray multiply(DoubleArray doubleArray, DoubleArray doubleArray2) {
        return Operations.multiply(doubleArray, doubleArray2);
    }

    public static void mulX(DoubleArray doubleArray, DoubleArray doubleArray2) {
        int n = doubleArray.length();
        for (int i = 0; i < n; ++i) {
            doubleArray.set(i, doubleArray.get(i) * doubleArray2.get(i));
        }
    }

    public static void mulX(DoubleArray doubleArray, double d) {
        int n = doubleArray.length();
        for (int i = 0; i < n; ++i) {
            doubleArray.set(i, doubleArray.get(i) * d);
        }
    }

    public static void mulX(DoubleArray doubleArray, int n, double d) {
        doubleArray.set(n, doubleArray.get(n) * d);
    }

    public static DoubleArray div(DoubleArray doubleArray, double d) {
        int n = doubleArray.length();
        DoubleArray doubleArray2 = factory.createArray(n);
        for (int i = 0; i < n; ++i) {
            doubleArray2.set(i, doubleArray.get(i) / d);
        }
        return doubleArray2;
    }

    public static DoubleArray divide(DoubleArray doubleArray, double d) {
        return Operations.div(doubleArray, d);
    }

    public static DoubleArray div(DoubleArray doubleArray, DoubleArray doubleArray2) {
        int n = doubleArray.length();
        DoubleArray doubleArray3 = factory.createArray(n);
        for (int i = 0; i < n; ++i) {
            doubleArray3.set(i, doubleArray.get(i) / doubleArray2.get(i));
        }
        return doubleArray3;
    }

    public static DoubleArray divide(DoubleArray doubleArray, DoubleArray doubleArray2) {
        return Operations.div(doubleArray, doubleArray2);
    }

    public static void divX(DoubleArray doubleArray, DoubleArray doubleArray2) {
        int n = doubleArray.length();
        for (int i = 0; i < n; ++i) {
            doubleArray.set(i, doubleArray.get(i) / doubleArray2.get(i));
        }
    }

    public static void divX(DoubleArray doubleArray, double d) {
        int n = doubleArray.length();
        for (int i = 0; i < n; ++i) {
            doubleArray.set(i, doubleArray.get(i) / d);
        }
    }

    public static double sum(DoubleArray doubleArray, int n, int n2) {
        double d = 0.0;
        for (int i = n; i < n2; ++i) {
            d += doubleArray.get(i);
        }
        return d;
    }

    public static double sum(DoubleArray doubleArray) {
        return Operations.sum(doubleArray, 0, doubleArray.length());
    }

    public static double sumodd(DoubleArray doubleArray) {
        double d = 0.0;
        int n = doubleArray.length();
        for (int i = 1; i < n; i += 2) {
            d += doubleArray.get(i);
        }
        return d;
    }

    public static double sumeven(DoubleArray doubleArray) {
        double d = 0.0;
        int n = doubleArray.length();
        for (int i = 0; i < n; i += 2) {
            d += doubleArray.get(i);
        }
        return d;
    }

    public static double min(DoubleArray doubleArray) {
        return Operations.min(doubleArray, new MinResult());
    }

    public static int argmin(DoubleArray doubleArray) {
        MinResult minResult = new MinResult();
        Operations.min(doubleArray, minResult);
        return minResult.argmin;
    }

    public static double min(DoubleArray doubleArray, MinResult minResult) {
        minResult.min = Double.POSITIVE_INFINITY;
        int n = doubleArray.length();
        for (int i = 0; i < n; ++i) {
            double d;
            double d2 = doubleArray.get(i);
            if (!(d < minResult.min)) continue;
            minResult.min = d2;
            minResult.argmin = i;
        }
        return minResult.min;
    }

    public static double max(DoubleArray doubleArray) {
        return Operations.max(doubleArray, new MaxResult());
    }

    public static int argmax(DoubleArray doubleArray) {
        MaxResult maxResult = new MaxResult();
        Operations.max(doubleArray, maxResult);
        return maxResult.argmax;
    }

    public static double max(DoubleArray doubleArray, MaxResult maxResult) {
        maxResult.max = Double.NEGATIVE_INFINITY;
        maxResult.max2nd = Double.NEGATIVE_INFINITY;
        maxResult.max3rd = Double.NEGATIVE_INFINITY;
        int n = doubleArray.length();
        for (int i = 0; i < n; ++i) {
            double d;
            double d2 = doubleArray.get(i);
            if (d > maxResult.max) {
                maxResult.max3rd = maxResult.max2nd;
                maxResult.argmax3rd = maxResult.argmax3rd;
                maxResult.max2nd = maxResult.max;
                maxResult.argmax2nd = maxResult.argmax;
                maxResult.max = d2;
                maxResult.argmax = i;
                continue;
            }
            if (d2 > maxResult.max2nd) {
                maxResult.max3rd = maxResult.max2nd;
                maxResult.argmax3rd = maxResult.argmax3rd;
                maxResult.max2nd = d2;
                maxResult.argmax2nd = i;
                continue;
            }
            if (!(d2 > maxResult.max3rd)) continue;
            maxResult.max3rd = d2;
            maxResult.argmax3rd = i;
        }
        return maxResult.max;
    }

    public static double absmax(DoubleArray doubleArray) {
        double d = Double.NEGATIVE_INFINITY;
        int n = doubleArray.length();
        for (int i = 0; i < n; ++i) {
            double d2;
            double d3 = Math.abs(doubleArray.get(i));
            if (!(d2 > d)) continue;
            d = d3;
        }
        return d;
    }

    public static double median(DoubleArray doubleArray) {
        return median.evaluate(doubleArray.toArray());
    }

    public static boolean containsNaNInf(DoubleArray doubleArray) {
        int n = doubleArray.length();
        for (int i = 0; i < n; ++i) {
            if (!Double.isNaN(doubleArray.get(i)) && !Double.isInfinite(doubleArray.get(i))) continue;
            return true;
        }
        return false;
    }

    public static DoubleArray makeArithmeticSeries(double d, double d2, int n) {
        DoubleArray doubleArray = factory.createArray(n);
        for (int i = 0; i < n; ++i) {
            doubleArray.set(i, d + (double)i * d2);
        }
        return doubleArray;
    }

    public static DoubleArray makeArithmeticSeries(double d, int n) {
        return Operations.makeArithmeticSeries(d, 1.0, n);
    }

    public static DoubleArray makeArithmeticSeries(int n) {
        return Operations.makeArithmeticSeries(1.0, 1.0, n);
    }

    public static DoubleArray nn2cent(DoubleArray doubleArray) {
        int n = doubleArray.length();
        DoubleArray doubleArray2 = factory.createArray(n);
        for (int i = 0; i < n; ++i) {
            doubleArray2.set(i, doubleArray.get(i) * 100.0 - 1200.0);
        }
        return doubleArray2;
    }

    public static double nn2cent(double d) {
        return d * 100.0 - 1200.0;
    }

    public static void nn2centX(DoubleArray doubleArray) {
        int n = doubleArray.length();
        for (int i = 0; i < n; ++i) {
            doubleArray.set(i, doubleArray.get(i) * 100.0 - 1200.0);
        }
    }

    public static void Hz2centX(DoubleArray doubleArray) {
        int n = doubleArray.length();
        for (int i = 0; i < n; ++i) {
            doubleArray.set(i, 1200.0 * Operations.log2(doubleArray.get(i) / 440.0 / 0.037162722343835));
        }
    }

    public static double Hz2cent(double d) {
        return 1200.0 * Operations.log2(d / 440.0 / 0.037162722343835);
    }

    public static DoubleArray Hz2cent(DoubleArray doubleArray) {
        int n = doubleArray.length();
        DoubleArray doubleArray2 = factory.createArray(n);
        for (int i = 0; i < n; ++i) {
            doubleArray2.set(i, 1200.0 * Operations.log2(doubleArray.get(i) / 440.0 / 0.037162722343835));
        }
        return doubleArray2;
    }

    private static double log2(double d) {
        return Math.log(d) / Math.log(2.0);
    }

    public static BooleanArray lessThan(DoubleArray doubleArray, double d) {
        int n = doubleArray.length();
        BooleanArray booleanArray = bfactory.createArray(n);
        for (int i = 0; i < n; ++i) {
            booleanArray.set(i, doubleArray.get(i) < d);
        }
        return booleanArray;
    }

    public static BooleanArray greaterThan(DoubleArray doubleArray, double d) {
        int n = doubleArray.length();
        BooleanArray booleanArray = bfactory.createArray(n);
        for (int i = 0; i < n; ++i) {
            booleanArray.set(i, doubleArray.get(i) > d);
        }
        return booleanArray;
    }

    public static int nGreaterThan(DoubleArray doubleArray, double d) {
        int n = doubleArray.length();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (!(doubleArray.get(i) > d)) continue;
            ++n2;
        }
        return n2;
    }

    public static BooleanArray or(BooleanArray booleanArray, BooleanArray booleanArray2) {
        int n = booleanArray.length();
        BooleanArray booleanArray3 = bfactory.createArray(n);
        for (int i = 0; i < n; ++i) {
            booleanArray3.set(i, booleanArray.get(i) || booleanArray2.get(i));
        }
        return booleanArray3;
    }

    public static BooleanArray and(BooleanArray booleanArray, BooleanArray booleanArray2) {
        int n = booleanArray.length();
        BooleanArray booleanArray3 = bfactory.createArray(n);
        for (int i = 0; i < n; ++i) {
            booleanArray3.set(i, booleanArray.get(i) && booleanArray2.get(i));
        }
        return booleanArray3;
    }

    public static DoubleArray removeMask(DoubleArray doubleArray, BooleanArray booleanArray) {
        int n = doubleArray.length();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (booleanArray.get(i)) continue;
            ++n2;
        }
        DoubleArray doubleArray2 = factory.createArray(n2);
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            if (booleanArray.get(i)) continue;
            doubleArray2.set(n3, doubleArray.get(i));
            ++n3;
        }
        return doubleArray2;
    }

    public static DoubleArray mask(DoubleArray doubleArray, BooleanArray booleanArray, double d) {
        int n = doubleArray.length();
        DoubleArray doubleArray2 = factory.createArray(n);
        for (int i = 0; i < n; ++i) {
            if (booleanArray.get(i)) {
                doubleArray2.set(i, d);
                continue;
            }
            doubleArray2.set(i, doubleArray.get(i));
        }
        return doubleArray2;
    }

    public static final int Hz2nn(double d) {
        return 57 + (int)(12.0 * Math.log(d / 220.0) / Math.log(2.0));
    }

    public static final double nn2Hz(double d) {
        return 220.0 * Math.pow(2.0, (d - 57.0) / 12.0);
    }

    public static void logX(DoubleArray doubleArray, int n) {
        int n2 = doubleArray.length();
        double d = Math.log(n);
        for (int i = 0; i < n2; ++i) {
            doubleArray.set(i, Math.log(doubleArray.get(i)) / d);
        }
    }

    public static double ratioTrue(BooleanArray booleanArray) {
        int n = 0;
        int n2 = booleanArray.length();
        for (int i = 0; i < n2; ++i) {
            if (!booleanArray.get(i)) continue;
            ++n;
        }
        return (double)n / (double)n2;
    }

    public static DoubleArray diff(DoubleArray doubleArray) {
        int n = doubleArray.length();
        DoubleArray doubleArray2 = factory.createArray(n - 1);
        for (int i = 0; i < n - 1; ++i) {
            doubleArray2.set(i, doubleArray.get(i + 1) - doubleArray.get(i));
        }
        return doubleArray2;
    }

    public static DoubleArray sdiff(DoubleArray doubleArray, int n) {
        int n2 = n * (n + 1) * (2 * n + 1) / 3;
        DoubleArray doubleArray2 = factory.createArray(doubleArray.length());
        for (int i = 0; i < doubleArray.length(); ++i) {
            doubleArray2.set(i, 0.0);
            for (int j = 1; j <= n; ++j) {
                int n3 = Math.min(j, Math.min(Math.abs(i - 0), Math.abs(doubleArray.length() - 1 - i)));
                Operations.addX(doubleArray2, i, (doubleArray.get(i + n3) - doubleArray.get(i - n3)) * (double)j);
            }
        }
        Operations.divX(doubleArray2, n2);
        return doubleArray2;
    }

    public static int nZeroCross(DoubleArray doubleArray) {
        int n = 0;
        for (int i = 0; i < doubleArray.length() - 1; ++i) {
            if (!(doubleArray.get(i) * doubleArray.get(i + 1) < 0.0)) continue;
            ++n;
        }
        return n;
    }

    public static DoubleArray sort(DoubleArray doubleArray) {
        double[] dArray = (double[])doubleArray.toArray().clone();
        Arrays.sort(dArray);
        return factory.createArray(dArray);
    }

    public static double iqr(DoubleArray doubleArray) {
        DoubleArray doubleArray2 = Operations.sort(doubleArray);
        int n = (int)(0.25 * (double)doubleArray2.length());
        int n2 = (int)(0.75 * (double)doubleArray2.length());
        return doubleArray2.get(n2) - doubleArray2.get(n);
    }

    public static DoubleArray sgsmooth(DoubleArray doubleArray, int n) {
        int n2 = (4 * n * n - 1) * (2 * n + 3) / 3;
        DoubleArray doubleArray2 = factory.createArray(doubleArray.length());
        for (int i = 0; i < doubleArray.length(); ++i) {
            int n3 = 3 * n * (n + 1) - 1;
            doubleArray2.set(i, doubleArray.get(i) * (double)n3);
            for (int j = 1; j <= n; ++j) {
                n3 = 3 * n * (n + 1) - 1 - 5 * j * j;
                int n4 = Math.min(j, Math.min(Math.abs(i - 0), Math.abs(doubleArray.length() - 1 - i)));
                Operations.addX(doubleArray2, i, (doubleArray.get(i + n4) + doubleArray.get(i - n4)) * (double)n3);
            }
        }
        Operations.divX(doubleArray2, n2);
        return doubleArray2;
    }

    public static DoubleArray concat(DoubleArray[] doubleArrayArray) {
        int n = 0;
        for (int i = 0; i < doubleArrayArray.length; ++i) {
            n += doubleArrayArray[i].length();
        }
        double[] dArray = new double[n];
        int n2 = 0;
        for (int i = 0; i < doubleArrayArray.length; ++i) {
            int n3 = doubleArrayArray[i].length();
            System.arraycopy(doubleArrayArray[i].toArray(), 0, dArray, n2, n3);
            n2 += n3;
        }
        return factory.createArray(dArray);
    }

    public static DoubleArray sum(DoubleArray[] doubleArrayArray) {
        if (doubleArrayArray.length == 1) {
            return doubleArrayArray[0];
        }
        DoubleArray doubleArray = Operations.add(doubleArrayArray[0], doubleArrayArray[1]);
        for (int i = 2; i < doubleArrayArray.length; ++i) {
            Operations.addX(doubleArray, doubleArrayArray[i]);
        }
        return doubleArray;
    }

    public static DoubleArray sum(DoubleArray[] doubleArrayArray, int n, int n2) {
        if (doubleArrayArray.length == 1) {
            return doubleArrayArray[0].subarrayX(n, n2);
        }
        DoubleArray doubleArray = Operations.add(doubleArrayArray[0].subarrayX(n, n2), doubleArrayArray[1].subarrayX(n, n2));
        for (int i = 2; i < doubleArrayArray.length; ++i) {
            Operations.addX(doubleArray, doubleArrayArray[i].subarrayX(n, n2));
        }
        return doubleArray;
    }

    public static DoubleArray mean(DoubleArray[] doubleArrayArray) {
        DoubleArray doubleArray = Operations.sum(doubleArrayArray);
        Operations.divX(doubleArray, doubleArrayArray.length);
        return doubleArray;
    }

    public static DoubleArray mean(DoubleArray[] doubleArrayArray, int n, int n2) {
        DoubleArray doubleArray = Operations.sum(doubleArrayArray, n, n2);
        Operations.divX(doubleArray, doubleArrayArray.length);
        return doubleArray;
    }

    public static ComplexNumber getAt(ComplexArray complexArray, int n) {
        return complexArray.get(n);
    }

    public static void putAt(ComplexArray complexArray, int n, ComplexNumber complexNumber) {
        complexArray.set(n, complexNumber);
    }

    public static void putAt(ComplexArray complexArray, int n, double[] dArray) {
        complexArray.set(n, dArray[0], dArray[1]);
    }

    public static DoubleArray getReal(ComplexArray complexArray) {
        int n = complexArray.length();
        DoubleArray doubleArray = factory.createArray(n);
        for (int i = 0; i < n; ++i) {
            doubleArray.set(i, complexArray.getReal(i));
        }
        return doubleArray;
    }

    public static DoubleArray getImag(ComplexArray complexArray) {
        int n = complexArray.length();
        DoubleArray doubleArray = factory.createArray(n);
        for (int i = 0; i < n; ++i) {
            doubleArray.set(i, complexArray.getImag(i));
        }
        return doubleArray;
    }

    public static ComplexArray add(ComplexArray complexArray, ComplexArray complexArray2) {
        int n = complexArray.length();
        ComplexArray complexArray3 = cfactory.createArray(n);
        for (int i = 0; i < n; ++i) {
            complexArray3.setReal(i, complexArray.getReal(i) + complexArray2.getReal(i));
            complexArray3.setImag(i, complexArray.getImag(i) + complexArray2.getImag(i));
        }
        return complexArray3;
    }

    public static ComplexArray plus(ComplexArray complexArray, ComplexArray complexArray2) {
        return Operations.add(complexArray, complexArray2);
    }

    public static ComplexArray sub(ComplexArray complexArray, ComplexArray complexArray2) {
        int n = complexArray.length();
        ComplexArray complexArray3 = cfactory.createArray(n);
        for (int i = 0; i < n; ++i) {
            complexArray3.setReal(i, complexArray.getReal(i) - complexArray2.getReal(i));
            complexArray3.setImag(i, complexArray.getImag(i) - complexArray2.getImag(i));
        }
        return complexArray3;
    }

    public static ComplexArray minus(ComplexArray complexArray, ComplexArray complexArray2) {
        return Operations.sub(complexArray, complexArray2);
    }

    public static ComplexArray mul(ComplexArray complexArray, ComplexArray complexArray2) {
        int n = complexArray.length();
        ComplexArray complexArray3 = cfactory.createArray(n);
        for (int i = 0; i < n; ++i) {
            complexArray3.setReal(i, complexArray.getReal(i) * complexArray2.getReal(i) - complexArray.getImag(i) * complexArray2.getImag(i));
            complexArray3.setImag(i, complexArray.getImag(i) * complexArray2.getReal(i) + complexArray.getReal(i) * complexArray2.getImag(i));
        }
        return complexArray3;
    }

    public static ComplexArray multiply(ComplexArray complexArray, ComplexArray complexArray2) {
        return Operations.mul(complexArray, complexArray2);
    }

    public static ComplexArray div(ComplexArray complexArray, ComplexArray complexArray2) {
        int n = complexArray.length();
        ComplexArray complexArray3 = cfactory.createArray(n);
        for (int i = 0; i < n; ++i) {
            double d = complexArray.getReal(i);
            double d2 = complexArray.getImag(i);
            double d3 = complexArray2.getReal(i);
            double d4 = complexArray2.getImag(i);
            complexArray3.setReal(i, (d * d3 + d2 * d4) / (d3 * d3 + d4 * d4));
            complexArray3.setImag(i, (d2 * d3 - d * d4) / (d3 * d3 + d4 * d4));
        }
        return complexArray3;
    }

    public static double getAt(DoubleMatrix doubleMatrix, int[] nArray) {
        return doubleMatrix.get(nArray[0], nArray[1]);
    }

    public static void putAt(DoubleMatrix doubleMatrix, int[] nArray, double d) {
        doubleMatrix.set(nArray[0], nArray[1], d);
    }

    public static DoubleMatrix add(DoubleMatrix doubleMatrix, DoubleMatrix doubleMatrix2) {
        int n = doubleMatrix.nrows();
        int n2 = doubleMatrix.ncols();
        DoubleMatrix doubleMatrix3 = mfactory.createMatrix(n, n2);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                doubleMatrix3.set(i, j, doubleMatrix.get(i, j) + doubleMatrix2.get(i, j));
            }
        }
        return doubleMatrix3;
    }

    public static DoubleMatrix plus(DoubleMatrix doubleMatrix, DoubleMatrix doubleMatrix2) {
        return Operations.add(doubleMatrix, doubleMatrix2);
    }

    public static DoubleMatrix add(DoubleMatrix doubleMatrix, DoubleArray doubleArray) {
        int n = doubleMatrix.nrows();
        int n2 = doubleMatrix.ncols();
        DoubleMatrix doubleMatrix2 = mfactory.createMatrix(n, n2);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                doubleMatrix2.set(i, j, doubleMatrix.get(i, j) + doubleArray.get(j));
            }
        }
        return doubleMatrix2;
    }

    public static DoubleMatrix plus(DoubleMatrix doubleMatrix, DoubleArray doubleArray) {
        return Operations.add(doubleMatrix, doubleArray);
    }

    public static DoubleMatrix sub(DoubleMatrix doubleMatrix, DoubleMatrix doubleMatrix2) {
        int n = doubleMatrix.nrows();
        int n2 = doubleMatrix.ncols();
        DoubleMatrix doubleMatrix3 = mfactory.createMatrix(n, n2);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                doubleMatrix3.set(i, j, doubleMatrix.get(i, j) - doubleMatrix2.get(i, j));
            }
        }
        return doubleMatrix3;
    }

    public static DoubleMatrix minus(DoubleMatrix doubleMatrix, DoubleMatrix doubleMatrix2) {
        return Operations.sub(doubleMatrix, doubleMatrix2);
    }

    public static DoubleMatrix sub(DoubleMatrix doubleMatrix, DoubleArray doubleArray) {
        int n = doubleMatrix.nrows();
        int n2 = doubleMatrix.ncols();
        DoubleMatrix doubleMatrix2 = mfactory.createMatrix(n, n2);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                doubleMatrix2.set(i, j, doubleMatrix.get(i, j) - doubleArray.get(j));
            }
        }
        return doubleMatrix2;
    }

    public static DoubleMatrix minus(DoubleMatrix doubleMatrix, DoubleArray doubleArray) {
        return Operations.sub(doubleMatrix, doubleArray);
    }

    public static DoubleMatrix mul(DoubleMatrix doubleMatrix, double d) {
        int n = doubleMatrix.nrows();
        int n2 = doubleMatrix.ncols();
        DoubleMatrix doubleMatrix2 = mfactory.createMatrix(n, n2);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                doubleMatrix2.set(i, j, doubleMatrix.get(i, j) * d);
            }
        }
        return doubleMatrix2;
    }

    public static DoubleMatrix multiply(DoubleMatrix doubleMatrix, double d) {
        return Operations.mul(doubleMatrix, d);
    }

    public static DoubleMatrix mul(DoubleMatrix doubleMatrix, DoubleMatrix doubleMatrix2) {
        int n = doubleMatrix.nrows();
        int n2 = doubleMatrix.ncols();
        int n3 = doubleMatrix2.ncols();
        DoubleMatrix doubleMatrix3 = mfactory.createMatrix(n, n3);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n3; ++j) {
                double d = 0.0;
                for (int k = 0; k < n2; ++k) {
                    d += doubleMatrix.get(i, k) * doubleMatrix2.get(k, j);
                }
                doubleMatrix3.set(i, j, d);
            }
        }
        return doubleMatrix3;
    }

    public static DoubleMatrix multiply(DoubleMatrix doubleMatrix, DoubleMatrix doubleMatrix2) {
        return Operations.mul(doubleMatrix, doubleMatrix2);
    }

    public static DoubleMatrix div(DoubleMatrix doubleMatrix, DoubleArray doubleArray) {
        int n = doubleMatrix.nrows();
        int n2 = doubleMatrix.ncols();
        DoubleMatrix doubleMatrix2 = mfactory.createMatrix(n, n2);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                doubleMatrix2.set(i, j, doubleMatrix.get(i, j) / doubleArray.get(j));
            }
        }
        return doubleMatrix2;
    }

    public static DoubleMatrix divide(DoubleMatrix doubleMatrix, DoubleArray doubleArray) {
        return Operations.div(doubleMatrix, doubleArray);
    }

    public static DoubleMatrix div(DoubleMatrix doubleMatrix, double d) {
        int n = doubleMatrix.nrows();
        int n2 = doubleMatrix.ncols();
        DoubleMatrix doubleMatrix2 = mfactory.createMatrix(n, n2);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                doubleMatrix2.set(i, j, doubleMatrix.get(i, j) / d);
            }
        }
        return doubleMatrix2;
    }

    public static DoubleMatrix divide(DoubleMatrix doubleMatrix, double d) {
        return Operations.div(doubleMatrix, d);
    }

    public static DoubleMatrix transposeX(DoubleMatrix doubleMatrix) {
        return new TransposedDoubleMatrix(doubleMatrix);
    }

    public static DoubleArray getRow(DoubleMatrix doubleMatrix, int n) {
        int n2 = doubleMatrix.nrows();
        int n3 = doubleMatrix.ncols();
        DoubleArray doubleArray = factory.createArray(n3);
        for (int i = 0; i < n3; ++i) {
            doubleArray.set(i, doubleMatrix.get(n, i));
        }
        return doubleArray;
    }

    public static DoubleArray getColumn(DoubleMatrix doubleMatrix, int n) {
        int n2 = doubleMatrix.nrows();
        int n3 = doubleMatrix.ncols();
        DoubleArray doubleArray = factory.createArray(n2);
        for (int i = 0; i < n2; ++i) {
            doubleArray.set(i, doubleMatrix.get(i, n));
        }
        return doubleArray;
    }

    public static boolean containsNaNInf(DoubleMatrix doubleMatrix) {
        int n = doubleMatrix.nrows();
        int n2 = doubleMatrix.ncols();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                if (!Double.isNaN(doubleMatrix.get(i, j)) && !Double.isInfinite(doubleMatrix.get(i, j))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isNaNInf(DoubleMatrix doubleMatrix, int n, int n2) {
        double d = doubleMatrix.get(n, n2);
        return Double.isNaN(d) || Double.isInfinite(d);
    }

    public static boolean isNaN(DoubleMatrix doubleMatrix, int n, int n2) {
        return Double.isNaN(doubleMatrix.get(n, n2));
    }

    public static boolean isInf(DoubleMatrix doubleMatrix, int n, int n2) {
        return Double.isInfinite(doubleMatrix.get(n, n2));
    }

    public static DoubleArray sumrows(DoubleMatrix doubleMatrix) {
        int n = doubleMatrix.nrows();
        int n2 = doubleMatrix.ncols();
        DoubleArray doubleArray = factory.createArray(n2);
        for (int i = 0; i < n2; ++i) {
            double d = 0.0;
            for (int j = 0; j < n; ++j) {
                d += doubleMatrix.get(j, i);
            }
            doubleArray.set(i, d);
        }
        return doubleArray;
    }

    public static DoubleArray sumcols(DoubleMatrix doubleMatrix) {
        int n = doubleMatrix.ncols();
        int n2 = doubleMatrix.nrows();
        DoubleArray doubleArray = factory.createArray(n2);
        for (int i = 0; i < n2; ++i) {
            double d = 0.0;
            for (int j = 0; j < n; ++j) {
                d += doubleMatrix.get(i, j);
            }
            doubleArray.set(i, d);
        }
        return doubleArray;
    }

    public static DoubleArray meanrows(DoubleMatrix doubleMatrix) {
        int n = doubleMatrix.nrows();
        int n2 = doubleMatrix.ncols();
        DoubleArray doubleArray = factory.createArray(n2);
        for (int i = 0; i < n2; ++i) {
            double d = 0.0;
            for (int j = 0; j < n; ++j) {
                d += doubleMatrix.get(j, i);
            }
            doubleArray.set(i, d / (double)n);
        }
        return doubleArray;
    }

    public static DoubleArray meancols(DoubleMatrix doubleMatrix) {
        int n = doubleMatrix.ncols();
        int n2 = doubleMatrix.nrows();
        DoubleArray doubleArray = factory.createArray(n2);
        for (int i = 0; i < n2; ++i) {
            double d = 0.0;
            for (int j = 0; j < n; ++j) {
                d += doubleMatrix.get(i, j);
            }
            doubleArray.set(i, d / (double)n);
        }
        return doubleArray;
    }

    public static DoubleArray stdrows(DoubleMatrix doubleMatrix) {
        doubleMatrix = Operations.sub(doubleMatrix, Operations.meanrows(doubleMatrix));
        int n = doubleMatrix.nrows();
        int n2 = doubleMatrix.ncols();
        DoubleArray doubleArray = factory.createArray(n2);
        double d = n - 1;
        for (int i = 0; i < n2; ++i) {
            double d2 = 0.0;
            for (int j = 0; j < n; ++j) {
                double d3 = doubleMatrix.get(j, i);
                d2 += d3 * d3;
            }
            doubleArray.set(i, Math.sqrt(d2 / d));
        }
        return doubleArray;
    }

    public static DoubleArray stdcols(DoubleMatrix doubleMatrix) {
        doubleMatrix = Operations.sub(doubleMatrix, Operations.meancols(doubleMatrix));
        int n = doubleMatrix.nrows();
        int n2 = doubleMatrix.ncols();
        DoubleArray doubleArray = factory.createArray(n);
        double d = n2 - 1;
        for (int i = 0; i < n; ++i) {
            double d2 = 0.0;
            for (int j = 0; j < n2; ++j) {
                double d3 = doubleMatrix.get(i, j);
                d2 += d3 * d3;
            }
            doubleArray.set(i, Math.sqrt(d2 / d));
        }
        return doubleArray;
    }

    public static double max(DoubleMatrix doubleMatrix) {
        int n = doubleMatrix.nrows();
        int n2 = doubleMatrix.ncols();
        double d = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                double d2;
                double d3 = doubleMatrix.get(i, j);
                if (!(d2 > d)) continue;
                d = d3;
            }
        }
        return d;
    }

    public static double min(DoubleMatrix doubleMatrix) {
        int n = doubleMatrix.nrows();
        int n2 = doubleMatrix.ncols();
        double d = Double.POSITIVE_INFINITY;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                double d2;
                double d3 = doubleMatrix.get(i, j);
                if (!(d2 < d)) continue;
                d = d3;
            }
        }
        return d;
    }

    public static DoubleMatrix cov(DoubleMatrix doubleMatrix) {
        DoubleMatrix doubleMatrix2 = Operations.sub(doubleMatrix, Operations.meanrows(doubleMatrix));
        return Operations.mul(Operations.transposeX(doubleMatrix2), doubleMatrix2);
    }

    public static DoubleMatrix[] svd(DoubleMatrix doubleMatrix) {
        SingularValueDecompositionImpl singularValueDecompositionImpl = new SingularValueDecompositionImpl(Utils.toRealMatrix(doubleMatrix));
        DoubleMatrix[] doubleMatrixArray = new DoubleMatrix[]{Utils.toDoubleMatrix(singularValueDecompositionImpl.getU()), Utils.toDoubleMatrix(singularValueDecompositionImpl.getS()), Utils.toDoubleMatrix(singularValueDecompositionImpl.getV())};
        return doubleMatrixArray;
    }

    public static DoubleMatrix[] eig(DoubleMatrix doubleMatrix) {
        EigenDecompositionImpl eigenDecompositionImpl = new EigenDecompositionImpl(Utils.toRealMatrix(doubleMatrix), Double.MIN_NORMAL);
        DoubleMatrix[] doubleMatrixArray = new DoubleMatrix[]{Utils.toDoubleMatrix(eigenDecompositionImpl.getV()), Utils.toDoubleMatrix(eigenDecompositionImpl.getD())};
        return doubleMatrixArray;
    }

    public static DoubleMatrix[] lu(DoubleMatrix doubleMatrix) {
        LUDecompositionImpl lUDecompositionImpl = new LUDecompositionImpl(Utils.toRealMatrix(doubleMatrix));
        DoubleMatrix[] doubleMatrixArray = new DoubleMatrix[]{Utils.toDoubleMatrix(lUDecompositionImpl.getL()), Utils.toDoubleMatrix(lUDecompositionImpl.getU()), Utils.toDoubleMatrix(lUDecompositionImpl.getP())};
        return doubleMatrixArray;
    }

    public static double det(DoubleMatrix doubleMatrix) {
        LUDecompositionImpl lUDecompositionImpl = new LUDecompositionImpl(Utils.toRealMatrix(doubleMatrix));
        return lUDecompositionImpl.getDeterminant();
    }

    public static DoubleMatrix inv(DoubleMatrix doubleMatrix) {
        LUDecompositionImpl lUDecompositionImpl = new LUDecompositionImpl(Utils.toRealMatrix(doubleMatrix));
        return Utils.toDoubleMatrix(lUDecompositionImpl.getSolver().getInverse());
    }

    public static DoubleMatrix[] qr(DoubleMatrix doubleMatrix) {
        QRDecompositionImpl qRDecompositionImpl = new QRDecompositionImpl(Utils.toRealMatrix(doubleMatrix));
        DoubleMatrix[] doubleMatrixArray = new DoubleMatrix[]{Utils.toDoubleMatrix(qRDecompositionImpl.getQ()), Utils.toDoubleMatrix(qRDecompositionImpl.getR())};
        return doubleMatrixArray;
    }

    public static boolean isSquare(DoubleMatrix doubleMatrix) {
        return doubleMatrix.nrows() == doubleMatrix.ncols();
    }

    public static DoubleArray diag(DoubleMatrix doubleMatrix) {
        if (!Operations.isSquare(doubleMatrix)) {
            throw new MathException("Matrix should be square");
        }
        int n = doubleMatrix.nrows();
        DoubleArray doubleArray = factory.createArray(n);
        for (int i = 0; i < n; ++i) {
            doubleArray.set(i, doubleMatrix.get(i, i));
        }
        return doubleArray;
    }

    public static DoubleMatrix normalize(DoubleMatrix doubleMatrix) {
        DoubleArray doubleArray = Operations.meanrows(doubleMatrix);
        DoubleArray doubleArray2 = Operations.stdrows(doubleMatrix);
        for (int i = 0; i < doubleArray2.length(); ++i) {
            if (doubleArray2.get(i) != 0.0) continue;
            doubleArray2.set(i, 1.0);
        }
        return Operations.div(Operations.sub(doubleMatrix, doubleArray), doubleArray2);
    }

    public static double innerproduct(DoubleArray doubleArray, DoubleArray doubleArray2) {
        double d = 0.0;
        int n = doubleArray.length();
        for (int i = 0; i < n; ++i) {
            d += doubleArray.get(i) * doubleArray2.get(i);
        }
        return d;
    }

    public static double norm(DoubleArray doubleArray) {
        return Math.sqrt(Operations.innerproduct(doubleArray, doubleArray));
    }

    public static DoubleMatrix toMatrixV(DoubleArray doubleArray) {
        return new MyMatrixV(doubleArray);
    }

    public static DoubleMatrix toMatrixH(DoubleArray doubleArray) {
        return new MyMatrixH(doubleArray);
    }

    public static DoubleArray conv(DoubleArray doubleArray, DoubleArray doubleArray2) {
        int n = doubleArray.length();
        int n2 = doubleArray2.length();
        double[] dArray = new double[n];
        if (doubleArray instanceof DefaultDoubleArray && doubleArray2 instanceof DefaultDoubleArray) {
            double[] dArray2 = doubleArray.toArray();
            double[] dArray3 = doubleArray2.toArray();
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n2; ++j) {
                    if (i - j < 0) continue;
                    int n3 = i;
                    dArray[n3] = dArray[n3] + dArray2[i - j] * dArray3[j];
                }
            }
        } else {
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n2; ++j) {
                    if (i - j < 0) continue;
                    int n4 = i;
                    dArray[n4] = dArray[n4] + doubleArray.get(i - j) * doubleArray2.get(j);
                }
            }
        }
        return factory.createArray(dArray);
    }

    public static DoubleArray abs(DoubleArray doubleArray) {
        int n = doubleArray.length();
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = Math.abs(doubleArray.get(i));
        }
        return factory.createArray(dArray);
    }

    public static DoubleArray abs(ComplexArray complexArray) {
        int n = complexArray.length();
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            double d = complexArray.getReal(i);
            double d2 = complexArray.getReal(i);
            dArray[i] = Math.sqrt(d * d + d2 * d2);
        }
        return factory.createArray(dArray);
    }

    public static DoubleArray dB(DoubleArray doubleArray, double d) {
        int n = doubleArray.length();
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = 10.0 * (Math.log(doubleArray.get(i)) - Math.log(d)) / Math.log(10.0);
        }
        return factory.createArray(dArray);
    }

    public static DoubleArray sigmoid(DoubleArray doubleArray, double d) {
        int n = doubleArray.length();
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = 1.0 / (1.0 + Math.exp(-d * doubleArray.get(i)));
        }
        return factory.createArray(dArray);
    }

    private static class MyMatrixH
    extends AbstractDoubleMatrixImpl {
        private DoubleArray array;

        private MyMatrixH(DoubleArray doubleArray) {
            this.array = doubleArray;
        }

        public int nrows() {
            return 1;
        }

        public int ncols() {
            return this.array.length();
        }

        public double get(int n, int n2) {
            if (n == 0) {
                return this.array.get(n2);
            }
            throw new IllegalStateException();
        }

        public void set(int n, int n2, double d) {
            if (n != 0) {
                throw new IllegalStateException();
            }
            this.array.set(n2, d);
        }
    }

    private static class MyMatrixV
    extends AbstractDoubleMatrixImpl {
        private DoubleArray array;

        private MyMatrixV(DoubleArray doubleArray) {
            this.array = doubleArray;
        }

        public int nrows() {
            return this.array.length();
        }

        public int ncols() {
            return 1;
        }

        public double get(int n, int n2) {
            if (n2 == 0) {
                return this.array.get(n);
            }
            throw new IllegalStateException();
        }

        public void set(int n, int n2, double d) {
            if (n2 != 0) {
                throw new IllegalStateException();
            }
            this.array.set(n, d);
        }
    }

    private static class TransposedDoubleMatrix
    extends AbstractDoubleMatrixImpl {
        private DoubleMatrix x;

        private TransposedDoubleMatrix(DoubleMatrix doubleMatrix) {
            this.x = doubleMatrix;
        }

        public int nrows() {
            return this.x.ncols();
        }

        public int ncols() {
            return this.x.ncols();
        }

        public double get(int n, int n2) {
            return this.x.get(n2, n);
        }

        public void set(int n, int n2, double d) {
            this.x.set(n2, n, d);
        }
    }

    public static class MaxResult {
        public double max;
        public int argmax;
        public double max2nd;
        public int argmax2nd;
        public double max3rd;
        public int argmax3rd;
    }

    public static class MinResult {
        public double min;
        public int argmin;
    }
}

