/*
 * Decompiled with CFR 0.152.
 */
package coboled;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceMap {
    private Map<String, List<IFile>> map = new HashMap<String, List<IFile>>();
    private IProject project = null;

    public ResourceMap(IProject project) {
        this.project = project;
        try {
            this.init((IResource)project);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private void init(IResource resource) throws CoreException {
        switch (resource.getType()) {
            case 2: 
            case 4: {
                IResource[] resources = ((IContainer)resource).members();
                int i = 0;
                while (i < resources.length) {
                    this.init(resources[i]);
                    ++i;
                }
                break;
            }
            case 1: {
                if (resource.getFileExtension() == null || !resource.getFileExtension().equals("cbl") && !resource.getFileExtension().equals("pco") && !resource.getFileExtension().equals("cob")) break;
                String name = resource.getName().replace("." + resource.getFileExtension(), "");
                this.put(name, this.project.getFile(resource.getProjectRelativePath()));
            }
        }
    }

    private void put(String fileName, IFile path) {
        if (!this.map.containsKey(fileName)) {
            this.map.put(fileName, new ArrayList());
        }
        this.map.get(fileName).add(path);
    }

    public List<IFile> get(String fileName) {
        return this.map.get(fileName);
    }
}

