/*
 * Decompiled with CFR 0.152.
 */
package coboled.editors;

import coboled.editors.CobolElementType;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CobolElement {
    private String name = null;
    private CobolElement parent = null;
    private int offset = -1;
    private CobolElementType type;
    private List<CobolElement> children = new ArrayList<CobolElement>();

    public CobolElement(String name, CobolElementType type) {
        this.name = name;
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void appendChild(CobolElement element) {
        this.children.add(element);
    }

    public CobolElement[] getChildren() {
        return this.children.toArray(new CobolElement[this.children.size()]);
    }

    public CobolElement getParent() {
        return this.parent;
    }

    public void setParent(CobolElement parent) {
        this.parent = parent;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public CobolElementType getType() {
        return this.type;
    }

    public void setType(CobolElementType type) {
        this.type = type;
    }

    public CobolElement getElementByOffset(int offset) {
        List<CobolElement> results = this.toList();
        CobolElement element1 = null;
        CobolElement element22 = null;
        for (CobolElement element22 : results) {
            if (element1 != null && element1.getOffset() <= offset && element22.getOffset() > offset) {
                return element1;
            }
            element1 = element22;
        }
        return element22;
    }

    public List<CobolElement> toList() {
        ArrayList<CobolElement> results = new ArrayList<CobolElement>();
        results.add(this);
        for (CobolElement element : this.children) {
            results.addAll(element.toList());
        }
        return results;
    }

    public CobolElement find(String name) {
        if (name == null) {
            return null;
        }
        if (this.name.equals(name)) {
            return this;
        }
        for (CobolElement element : this.children) {
            CobolElement result = element.find(name);
            if (result == null) continue;
            return result;
        }
        return null;
    }
}

