/*
 * Decompiled with CFR 0.152.
 */
package coboled.editors;

import coboled.editors.CobolContentProvider;
import coboled.editors.CobolEditor;
import coboled.editors.CobolElement;
import coboled.editors.CobolLabelProvider;
import coboled.editors.CobolParser;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class CobolInformationControl
extends DefaultInformationControl {
    private CobolEditor editor;
    private Text search;
    private TreeViewer viewer;
    private RootModel root = new RootModel();
    private final Composite fContentComposite;

    public CobolInformationControl(Shell parent, CobolEditor editor, boolean isResizable) {
        super(parent, 0x4004 | (isResizable ? 16 : 0), null, null);
        this.editor = editor;
        this.fContentComposite = new Composite((Composite)parent, 0);
        this.fContentComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fContentComposite.setLayout((Layout)new FillLayout());
        this.createContent(this.fContentComposite);
        int width = 300;
        int height = 300;
        this.setSize(width, height);
    }

    protected void createContent(Composite parent) {
        Color foreground = parent.getShell().getDisplay().getSystemColor(28);
        Color background = parent.getShell().getDisplay().getSystemColor(29);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setForeground(foreground);
        composite.setBackground(background);
        this.search = new Text(composite, 0);
        this.search.setLayoutData((Object)new GridData(768));
        this.search.setForeground(foreground);
        this.search.setBackground(background);
        new Label(composite, 258).setLayoutData((Object)new GridData(768));
        Dialog.applyDialogFont((Control)this.search);
        this.search.setLayoutData((Object)new GridData(768));
        this.search.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
            }
        });
        this.search.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
            }
        });
        this.viewer = new TreeViewer(composite, 772);
        this.viewer.setContentProvider((IContentProvider)new CobolContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new CobolLabelProvider());
        this.viewer.setInput((Object)this.root);
        this.viewer.getControl().setLayoutData((Object)new GridData(1808));
        this.viewer.getControl().setForeground(foreground);
        this.viewer.getControl().setBackground(background);
        this.refresh();
    }

    public void refresh() {
        IDocumentProvider provider = this.editor.getDocumentProvider();
        IDocument document = provider.getDocument((Object)this.editor.getEditorInput());
        String source = document.get();
        this.root.documentElement = new CobolParser().parse(source);
        this.viewer.refresh();
    }

    private class RootModel {
        private CobolElement documentElement;

        private RootModel() {
        }
    }
}

