/*
 * Decompiled with CFR 0.152.
 */
package coboled.editors;

import coboled.editors.CobolElement;
import coboled.editors.CobolElementType;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CobolParser {
    public CobolElement parse(String source) {
        CobolElement root;
        CobolElement work = root = new CobolElement("root", CobolElementType.ROOT);
        Pattern outline = Pattern.compile("(^.{6})( )(.+)", 8);
        Matcher matcher = outline.matcher(source);
        while (matcher.find()) {
            CobolElement element;
            String[] strings;
            String abArea = matcher.group(3);
            if (!this.check(abArea) || (strings = abArea.trim().split(" +")).length < 2 || strings[0].indexOf("EXIT") != -1) continue;
            CobolElementType type = null;
            if (strings[1].startsWith("DIVISION")) {
                type = CobolElementType.DIVISION;
            } else if (strings[1].startsWith("SECTION")) {
                type = CobolElementType.SECTION;
            } else if (strings[0].matches("^[0-9][0-9]")) {
                type = CobolElementType.DATA;
            } else {
                strings[1] = null;
                type = CobolElementType.PARAGRAPH;
            }
            work = element = this.createCobolElement(work, strings[0], strings[1], type, matcher.start());
        }
        return root;
    }

    private boolean check(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        return !string.startsWith("    ");
    }

    private CobolElement createCobolElement(CobolElement work, String group1, String group2, CobolElementType type, int offset) {
        String name = this.format(group1, group2);
        CobolElement element = new CobolElement(name, type);
        CobolElement parent = this.getParentElement(work, element);
        element.setParent(parent);
        element.setOffset(offset);
        parent.appendChild(element);
        return element;
    }

    private String format(String ... args) {
        if (args == null || args.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < args.length) {
            if (args[i] != null) {
                builder.append(args[i].trim()).append(" ");
            }
            ++i;
        }
        String result = builder.toString().trim();
        if (result != null && result.endsWith(".")) {
            return result.substring(0, result.length() - 1);
        }
        return result;
    }

    private CobolElement getParentElement(CobolElement element, CobolElement element2) {
        CobolElementType type2;
        CobolElementType type = element.getType();
        if (type.compareTo(type2 = element2.getType()) > 0) {
            return element;
        }
        if (type.compareTo(type2) == 0) {
            return element.getParent();
        }
        return this.getParentElement(element.getParent(), element2);
    }
}

