/*
 * Decompiled with CFR 0.152.
 */
package coboled.editors;

import coboled.editors.CobolWhitespaceDetector;
import coboled.editors.CobolWordDetector;
import coboled.editors.ColorManager;
import coboled.editors.ICobolColorConstants;
import coboled.editors.ICobolKeyWordConstants;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CobolScanner
extends RuleBasedScanner {
    public CobolScanner(ColorManager manager) {
        ArrayList<IRule> rules = new ArrayList<IRule>();
        this.addQuotesRule(rules, manager);
        this.addWordRule(rules, manager);
        this.addWhitespaceRule(rules, manager);
        this.setRules(rules.toArray(new IRule[rules.size()]));
    }

    private void addQuotesRule(List<IRule> rules, ColorManager manager) {
        Token string = new Token((Object)new TextAttribute(manager.getColor(ICobolColorConstants.STRING)));
        rules.add((IRule)new SingleLineRule("\"", "\"", (IToken)string, '\\'));
        rules.add((IRule)new SingleLineRule("'", "'", (IToken)string, '\\'));
    }

    private void addWordRule(List<IRule> rules, ColorManager manager) {
        Token keyword = new Token((Object)new TextAttribute(manager.getColor(ICobolColorConstants.KEYWORD), null, 1));
        Token other = new Token((Object)new TextAttribute(manager.getColor(ICobolColorConstants.DEFAULT)));
        WordRule wordRule = new WordRule((IWordDetector)new CobolWordDetector(), (IToken)other, false);
        int i = 0;
        while (i < ICobolKeyWordConstants.KEYWORDS.length) {
            wordRule.addWord(ICobolKeyWordConstants.KEYWORDS[i], (IToken)keyword);
            ++i;
        }
        rules.add((IRule)wordRule);
    }

    private void addWhitespaceRule(List<IRule> rules, ColorManager manager) {
        rules.add((IRule)new WhitespaceRule((IWhitespaceDetector)new CobolWhitespaceDetector()));
    }
}

