/*
 * Decompiled with CFR 0.152.
 */
package coboled.editors;

import coboled.editors.CobolEditor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.texteditor.IDocumentProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentifierMap {
    private static final IdentifierPattern[] patterns = new IdentifierPattern[]{new IdentifierPattern(Pattern.compile("(^.{6})( )( {0,3})([^ \r\n\\.]+)( +)(SECTION)", 8), 4), new IdentifierPattern(Pattern.compile("(^.{6})( )( {0,3})([^ \r\n\\.]+-EXIT)", 8), 4), new IdentifierPattern(Pattern.compile("(^.{6})( )( *)([0-9][0-9])( +)([^ \r\n\\.]+)", 8), 6)};
    private Map<String, List<Integer>> map = new HashMap<String, List<Integer>>();
    private CobolEditor editor = null;

    public IdentifierMap(CobolEditor editor) {
        this.editor = editor;
        this.parse();
    }

    private void parse() {
        IDocumentProvider provider = this.editor.getDocumentProvider();
        IDocument document = provider.getDocument((Object)this.editor.getEditorInput());
        String source = document.get();
        int i = 0;
        while (i < patterns.length) {
            Pattern pattern = patterns[i].getPattern();
            int group = patterns[i].getGroup();
            Matcher matcher = pattern.matcher(source);
            while (matcher.find()) {
                this.add(matcher.group(group).trim(), matcher.start(group));
            }
            ++i;
        }
    }

    private void add(String id, int offset) {
        if (!this.map.containsKey(id)) {
            this.map.put(id, new ArrayList());
        }
        this.map.get(id).add(offset);
    }

    public List<Integer> get(String id) {
        return this.map.get(id);
    }

    public void refresh() {
        this.map.clear();
        this.parse();
    }

    public void dispose() {
        this.map.clear();
        this.editor = null;
    }

    private static class IdentifierPattern {
        private Pattern pattern;
        private int group;

        public IdentifierPattern(Pattern pattern, int group) {
            this.pattern = pattern;
            this.group = group;
        }

        public Pattern getPattern() {
            return this.pattern;
        }

        public void setPattern(Pattern pattern) {
            this.pattern = pattern;
        }

        public int getGroup() {
            return this.group;
        }

        public void setGroup(int group) {
            this.group = group;
        }
    }
}

