/*
 * Decompiled with CFR 0.152.
 */
package coboled.editors.command;

import coboled.Activator;
import coboled.editors.CobolEditor;
import coboled.editors.IdentifierMap;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class JumpHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        block4: {
            CobolEditor editor = (CobolEditor)HandlerUtil.getActiveEditor((ExecutionEvent)event);
            String selection = this.getSelection(editor);
            IdentifierMap identifierMap = editor.getIdentifierMap();
            List<Integer> list = identifierMap.get(selection);
            if (list != null && list.size() > 0) {
                editor.selectAndReveal(list.get(0), selection.length());
                return null;
            }
            try {
                IFile file = this.findResource(editor, selection);
                if (file == null) break block4;
                IWorkbench workbench = PlatformUI.getWorkbench();
                IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
                IWorkbenchPage page = window.getActivePage();
                IDE.openEditor((IWorkbenchPage)page, (IFile)file);
                return null;
            }
            catch (Exception e) {
                Status status = new Status(4, "CobolEditor", 0, "CobolEditor\u30a8\u30e9\u30fc", (Throwable)e);
                Activator.getDefault().getLog().log((IStatus)status);
                IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
                MessageDialog.openInformation((Shell)window.getShell(), (String)"CobolEditor\u30a8\u30e9\u30fc", (String)(String.valueOf(selection) + "\u306f\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f"));
                return null;
            }
        }
        throw new Exception();
    }

    private String getSelection(CobolEditor editor) {
        ISelectionProvider selectionProvider = editor.getSelectionProvider();
        ITextSelection selection = (ITextSelection)selectionProvider.getSelection();
        if (selection.getLength() != 0) {
            return selection.getText();
        }
        return this.getSelectWord(editor);
    }

    private String getSelectWord(CobolEditor editor) {
        IDocument doc = this.getDocument(editor);
        int caretPos = this.getCaretPos(editor);
        try {
            char c;
            int pos = caretPos;
            while (pos >= 0) {
                c = doc.getChar(pos);
                if (!Character.isJavaIdentifierPart(c)) break;
                --pos;
            }
            int startPos = pos;
            pos = caretPos;
            int length = doc.getLength();
            while (pos < length) {
                c = doc.getChar(pos);
                if (!Character.isJavaIdentifierPart(c)) break;
                ++pos;
            }
            int endPos = pos;
            int offset = startPos + 1;
            int wordLength = endPos - offset;
            return doc.get(offset, wordLength);
        }
        catch (BadLocationException badLocationException) {
            return "";
        }
    }

    private IDocument getDocument(CobolEditor editor) {
        IDocumentProvider provider = editor.getDocumentProvider();
        IDocument doc = provider.getDocument((Object)editor.getEditorInput());
        return doc;
    }

    private int getCaretPos(CobolEditor editor) {
        ISelectionProvider selectionProvider = editor.getSelectionProvider();
        ITextSelection selection = (ITextSelection)selectionProvider.getSelection();
        int caretPos = selection.getOffset();
        return caretPos;
    }

    private IFile findResource(CobolEditor editor, String selection) throws CoreException {
        IFile file = (IFile)editor.getSite().getPage().getActiveEditor().getEditorInput().getAdapter(IFile.class);
        IProject project = file.getProject();
        List<IFile> files = Activator.getDefault().getResourceMap(project).get(selection);
        if (files != null && files.size() != 0) {
            return files.get(0);
        }
        return null;
    }
}

