/*
 *  livedoor.c
 *      livedoor Blog č\z
 *      written by H.Tsujimura    27 Jan 2006 / 2 Oct 2006
 *
 * History:
 * $Log: /makeRSS/cocousagi/livedoor.c $
 * 
 * 3     07/02/14 16:46 Tsujimura543
 * httpʐM̃^CAEgԂ𒷂߂ɂĂ݂
 * 
 * 2     06/10/02 20:08 Tsujimura543
 * cocousagi.h CN[h悤ɂ
 * 
 * 1     06/10/02 18:11 Tsujimura543
 * cocousagi.c  livedoor Blog L̏𕪗
 */

#include "xmlRPC.h"
#include "cocousagi.h"

/*
 *  livedoor č\z
 */
int
loginLivedoor( const char *username,
               const char *password,
               char       *cookie )
{
    int     ret = 0;
    char    *request;
    char    *response;
    char    url[MAX_URLLENGTH];
    size_t  sz = MAX_CONTENT_SIZE * 2;

    if ( !cookie   ||
         !username || !(*username) ||
         !password || !(*password)    )
         return ( ret );

    request  = (char *)malloc( MAX_CONTENT_SIZE );
    if ( !request ) 
        return ( ret );
    response = (char *)malloc( sz );
    if ( !response ) {
        free( request );
        return ( ret );
    }

    memset( request,  0x00, MAX_CONTENT_SIZE );
    setUpReceiveBuffer( response, sz );
    http_getEx( "http://blog.livedoor.com/",
                response, cookie );

    strcpy( url, "http://member.livedoor.com/login/index" );
    setTargetURL( url );
    sprintf( request,
             ".next=%s&"
             ".sv=blog&"
             "livedoor_id=%s&"
             "password=%s&"
             "auto_login=on\r\n",
             encodeURL("http://cms.blog.livedoor.com/cms/"),
             username, password );
    setUpReceiveBuffer( response, sz );
    http_postEx( url, "application/x-www-form-urlencoded",
                 request, response, cookie );

    if ( *response ) {
        if ( strstr( response,
                     "<input type=\"hidden\" name=\"blog_id\"" ) != NULL )
            ret = 1;    /* OC */
        else
            ret = 0;    /* OCs */
    }
    else
        ret = 0;        /* OCs */

    free( response );
    free( request  );

    return ( ret );
}

void
rebuildOnLivedoor(
        const char *username,
        const char *password,
        const char *blogID
    )
{
    char    *request;
    char    *response;
    char    *cookie;
    char    url[MAX_URLLENGTH * 16];
    int     ret;
    size_t  sz = MAX_CONTENT_SIZE * 32;

    cookie = (char *)malloc( MAX_COOKIE_LEN );
    if ( !cookie )
        return;
    request = (char *)malloc( MAX_COOKIE_LEN );
    if ( !request ) {
        free( cookie );
        return;
    }
    response = (char *)malloc( sz );
    if ( !response ) {
        free( request );
        free( cookie );
        return;
    }

    // livedoor Blog  login
    memset( cookie, 0x00, MAX_COOKIE_LEN );
    ret = loginLivedoor( username, password, cookie );
    if ( ret ) {
        // uSy[Wv̍č\zs
        setTimeoutTime( DEFAULT_HTTP_TIMEOUT * 4 );
        strcpy( url, "http://cms.blog.livedoor.com/cms/rebuild/index" );
        sprintf( request,
                 "blog_id=%s&"
                 "command=css,index,rss,atom,monthly,category,articles:all&"
                 ".popup=0",
                 blogID );
        setUpReceiveBuffer( response, sz );
        http_postEx( url, "application/x-www-form-urlencoded",
                     request, response, cookie );
        while ( *response ) {
            char    *p = strstr(response,
                                "<body onLoad=\"JavaScript: location.href='");
            char    *q;

            if ( p ) {
                 p += 41;
                 q = strchr( p, '\'' );
                 if ( q ) {
                    int    len;

                    strcpy(url, "http://cms.blog.livedoor.com/cms/rebuild/");
                    len = strlen( url );
                    strncat( url, p, q - p );
                    url[len + (q - p)] = NUL;

                    setTargetURL( url );
                    fprintf( stderr, "č\z %s ...", url );
                    setUpReceiveBuffer( response, sz );
                    http_getEx( url, response, cookie );
                    fputs( "\n", stderr );
                 }
            }
            else
                break;
        }
        setTimeoutTime( DEFAULT_HTTP_TIMEOUT );
    }

    free( response );
    free( request );
    free( cookie );
}
