/*
 *  atom API
 *
 * History:
 * $Log: /makeRSS/xmlRPC/atomApi.h $
 * 
 * 14    09/03/16 15:04 Tsujimura543
 * MAX_CATEGORIES ̒` xmlRPC.h ֈڂ
 * 
 * 13    06/01/23 14:38 Tsujimura543
 * listPostsOnAtomAPI() ̒(6)ǉ
 * 
 * 12    05/08/17 15:09 Tsujimura543
 * postEntryOnAtomAPI()  editEntryOnAtomAPI() ɈǉA
 * e\Ƃ (Ώۂ blogger.com ̂)
 * 
 * 11    05/07/01 11:16 Tsujimura543
 * ({t@C)Rgɍ킹ďC
 * 
 * 10    05/06/28 21:58 Tsujimura543
 * editEntryOnAtomAPI() ǉ
 * 
 * 9     04/10/15 11:55 Tsujimura543
 * Rg̏C
 * 
 * 8     04/10/15 11:52 Tsujimura543
 * getEndpointURLbyAutoDiscoveryOnAtomAPI() ǉ
 * 
 * 7     04/08/13 14:28 Tsujimura543
 * getRecentPostTitlesOnAtomAPI() ǉ
 * 
 * 6     04/08/12 21:17 Tsujimura543
 * getBlogIDsOnAtomAPI() ǉ
 * 
 * 5     04/07/16 19:19 Tsujimura543
 * postEntryOnAtomAPI() ɈǉATvwł悤ɂ
 * 
 * 4     04/07/16 13:57 Tsujimura543
 * Atom API ֘AASʌBXML-RPC API ֘A֐Ƃ̐}B
 * 
 * 3     04/07/09 20:30 Tsujimura543
 * livedoor Blog  Atom API Ή
 * 
 * 2     04/07/07 11:43 Tsujimura543
 * RCS ɂŐǗ VSS ɂŐǗɈڍs
 */

#ifndef __ATOM_API_H__
#define __ATOM_API_H__

#include "xmlRPC.h"

#define MAX_TYPELENGTH  80

/*
 *  Atom authentication uses WSSE, and is represented as an "X-WSSE" HTTP
 *  header.
 *      X-WSSE: UsernameToken Username="name", PasswordDigest="digest", 
 *      Created="timestamp", Nonce="nonce"
 *          Username
 *              The username that the user enters (the TypePad username).
 *          Nonce
 *              A secure token generated anew for each HTTP request.
 *          Created
 *              The ISO-8601 timestamp marking when Nonce was created.
 *          PasswordDigest
 *              A SHA-1 digest of the Nonce, Created timestamp, and the
 *              password that the user supplies, base64-encoded. In other
 *              words, this should be calculated as:
 *                  base64(sha1(Nonce . Created . Password))
 */

/* PasswordDigest ̐ */
char    *makePasswordDigest(
            const char *nonce,
            const char *created,
            const char *password,
            int        blogKind );

char    *makeCreated( time_t t );
char    *makeNonce( const char *preNonce, int blogKind );

/* WSSE ̐ */
char    *makeWSSE( const char *username, const char *password, char *buffer,
                   int blogKind );


/* Atom API Gh|Cg URL  */
typedef struct atomApiUrlInfo   {
    char    urlType[MAX_TYPELENGTH];    /* URL ̎ */
    char    url[MAX_URLLENGTH];         /* URL        */
    char    mimeType[MAX_TYPELENGTH];   /* MIME   */
    char    title[MAX_LOGICALLINELEN];  /* O       */
}   ATOM_URL_INFO, *ATOM_URL_INFO_t;

/* category  */
typedef struct categoryListInfoEx {
    long    numberOfCategories;         /* JeS̐ */
    char    categoryName[MAX_CATEGORIES][MAX_CATNAMELENGTH];
                                        /* JeS̖O ( OK) */
}   CATLISTINFEX, *CATLISTINFEX_t;


/*
 *  Atom API
 *    ȉ Atom API ֘A֐ł́AƂĕR[h UTF-8 (
 *    US-ASCII)ł邱ƂOɂĂ
 */

/* Listing the User's Weblogs
 * w茏URL̎擾
 *    listWeblogsOnAtomAPI
 *      :
 *          char          *userName   (I) [U
 *          char          *password   (I) pX[h
 *          int           *numOfUrls  (I) 擾URL
 *                                    (O) ۂɎ擾URL
 *          ATOM_URL_INFO *urlInfo    (O) 擾URL
 *      ߂l:
 *          0       擾sAMsȂ̃G[
 *          1 ȏ  擾ɐURL̐
 *      l:
 *          (1) userName  password  NULL ̏ꍇA setUserInfo() Ő
 *              肵[UApX[hgp
 *          (2) *numOfUrls Ŏw肵̕AURL擾
 *          (3) ۂɎ擾ɐURL̐ *numOfUrls ɐݒ肷
 */
int
listWeblogsOnAtomAPI( const char      *username,
                      const char      *password,
                      long            *numOfUrls,
                      ATOM_URL_INFO_t urlInfo );


/* Listing the Posts in a Weblog
 * w茏̋L̎擾
 *    listPostsOnAtomAPI
 *      :
 *          char         *userName      (I) [U
 *          char         *password      (I) pX[h
 *          char         *blogID        (I) blog ID
 *          int          *numOfEntries  (I) 擾L
 *                                      (O) ۂɎ擾L
 *          CONTENTINFEX *contentInfo   (O) 擾L
 *          CATLISTINFEX *categoryInfo  (O) 擾JeS
 *      ߂l:
 *          0       L݂ȂA擾sAMsȂ̃G[
 *          1 ȏ  擾ɐURL̐
 *      l:
 *          (1) userName  password  NULL ̏ꍇA setUserInfo() Ő
 *              肵[UApX[hgp
 *          (2) *numOfEntries Ŏw肵̕AŐV̋Lߋ
 *              kċL擾
 *          (3) contentInfo  categoryInfo ̔z̑傫́AɁA
 *              *numOfEntries Ŏw肵lȏłKv
 *          (4) ۂɎ擾ɐL̐ *numOfEntries ɐݒ肷
 *          (5) Atom API ł̓JeŚuJeSvŎ舵BuJeS
 *              IDvƂTO͂Ȃ̂Œ(ȉA Atom API ֘A֐
 *              l)
 *          (6) Bloggers.com ̓ƎgƂāAconvertLineBreaks(sI
 *              <br />ɕϊ邩ۂ)̒l擾ł悤ɂȂĂB
 *              ̒l͖{AeLƂɓƗɐݒ\łׂł邪A
 *              ́ALe_(Ǘʂł)ݒlɓKpB
 *              {APIŎ擾ł convertLineBreaks ̒ĺA{APIs_̊
 *              ʂ̐ݒlłAeL̓e_̊Ǘʂ̐ݒl
 *              ͂ȂƂɒӁB
 *              ȂApostEntryOnAtomAPI()  editEntryOnAtomAPI() ł
 *              convertLineBreaks ̒l𐧌łȂ [ł悤ɂȂ?])
 *                http://code.blogger.com/archives/atom-docs.html#extensions
 *              * MovableType/TypaPad, libedoor Blog ABloggers.com ̊g
 *                ͗l
 */
int
listPostsOnAtomAPI( const char   *username,
                    const char   *password,
                    const char   *blogID,
                    int          *numOfEntries,
                    CONTENTINFEX *contentInfo,
                    CATLISTINFEX *categoryInfo );


/* Retrieving a list of categories
 * wblogŎgp\ȃJeSꗗ̎擾
 *    listCategoriesOnAtomAPI
 *      :
 *          char       *userName         (I) [U
 *          char       *password         (I) pX[h
 *          char       *blogID           (I) blog ID
 *          long       *numOfCategories  (I) 擾JeS
 *                                       (O) ۂɎ擾JeS
 *          CATLISTINF *categories       (O) 擾JeS
 *      ߂l:
 *          0       JeS݂ȂA擾sAMsȂ̃G[
 *                  
 *          1 ȏ  擾ɐJeS̐
 *      l:
 *          (1) userName  password  NULL ̏ꍇA setUserInfo() Ő
 *              肵[UApX[hgp
 *          (2) *numOfCategoriesŎw肵̕AJeS擾
 *          (3) ۂɎ擾ɐJeS̐ *numOfCategories ɐ
 *              肷
 */
int
listCategoriesOnAtomAPI(
        const char   *username,
        const char   *password,
        const char   *blogID,
        long         *numOfCategories, /* JeS̐ */
        CATLISTINF_t categories        /* JeS     */
    );


/* Posting an entry
 * L̓e
 *    postEntryOnAtomAPI
 *      :
 *          char       *userName    (I) [U
 *          char       *password    (I) pX[h
 *          char       *blogID      (I) blog ID
 *          char       *title       (I) 薼
 *          char       *summary     (I) Tv
 *          char       *content     (I) {
 *          CATLISTINF *categories  (I) ݒ肷JeS
 *          BOOL       publish      (I) e (FALSE: , TRUE: J)
 *                                      -- _ł́Ablogger.com ł̂ݗL
 *          char       *postID      (O) e̋LID
 *      ߂l:
 *          TRUE    e
 *          FALSE   esAMsȂ̃G[
 *      l:
 *          (1) userName  password  NULL ̏ꍇA setUserInfo() Ő
 *              肵[UApX[hgp
 *          (2) LẽTCY SND_BUFFER_SIZE ̒l (mɂ 
 *              SND_BUFFER_SIZE uhttp wb_̃TCYvl)  
 *              ȂƁBT[oɂẮA܂傫ȋL󂯕t
 *              ƂłȂƂ\ẑŁAT64KBł邱Ƃ
 *              ]܂
 *          (3) Le  URL GR[hׂ܂܂ꍇ́A{֐
 *               URL GR[hsȂ̂ŁA炩 URL GR[h
 *              ĂKv͂ȂBȂAURL GR[hsȂʁAL
 *              ẽTCY SND_BUFFER_SIZE 傫ȂĂ܂ꍇ́A
 *              eɎs
 *          (4) Tvw肵ĂAblog c[ɂĂ͖B
 *          (5) L̓eɐꍇApostID  ̎ẅɋLID (
 *              ) i[
 *          (6) ɁuJvԂœe
 *          (7) TypePad nł́Arebuild s܂ŁAJeS͔f
 *              Ȃ(ݒ͂邪f͂Ȃ)
 */
int
postEntryOnAtomAPI(
        const char         *username,
        const char         *password,
        const char         *blogID,
        const char         *title,          /* 薼           */
        const char         *summary,        /* Tv           */
        const char         *content,        /* {           */
        const CATLISTINFEX *categoryInfo,   /* JeS       */
        BOOL               publish,         /* e       */
        char               *postID          /* e̋LID */
    );

/* Editing an entry
 * L̕ҏW (L̏㏑e)
 *    editEntryOnAtomAPI
 *      :
 *          char       *userName    (I) [U
 *          char       *password    (I) pX[h
 *          char       *blogID      (I) blog ID
 *          char       *title       (I) 薼
 *          char       *summary     (I) Tv
 *          char       *content     (I) {
 *          CATLISTINF *categories  (I) ݒ肷JeS
 *          BOOL       publish      (I) e (FALSE: , TRUE: J)
 *                                      -- _ł́Ablogger.com ł̂ݗL
 *          char       *postID      (I) ҏWΏۂ̋LID
 *      ߂l:
 *          TRUE    ㏑e
 *          FALSE   ㏑esAMsȂ̃G[
 */
int
editEntryOnAtomAPI(
        const char         *username,       // (I) [UID
        const char         *password,       // (I) pX[h
        const char         *blogID,         // (I) blog ID
        const char         *title,          // (I) 薼
        const char         *summary,        // (I) Tv
        const char         *content,        // (I) {
        const CATLISTINFEX *categoryInfo,   // (I) ݒ肷JeS
        BOOL               publish,         // (I) e
        const char         *postID          // (I) ҏWΏۂ̋LID
    );

/* Retrieving a Post
 * wL̎擾
 *    getRecentPostOnAtomAPI
 *      :
 *          char         *userName      (I) [U
 *          char         *password      (I) pX[h
 *          char         *blogID        (I) blog ID
 *          char         *entryID       (I) LID
 *          CONTENTINFEX *contentInfo   (O) 擾L
 *          CATLISTINFEX *categoryInfo  (O) 擾JeS
 *      ߂l:
 *          TRUE    擾
 *          FALSE   擾sAMsȂ̃G[
 *      l:
 *          (1) userName  password  NULL ̏ꍇA setUserInfo() Ő
 *              肵[UApX[hgp
 */
BOOL
getRecentPostOnAtomAPI(
        const char   *username,
        const char   *password,
        const char   *blogID,
        const char   *entryID,
        CONTENTINFEX *contentInfo,  /* L     */
        CATLISTINFEX *categoryInfo  /* JeS */
    );


/* Deleting a Post
 * wL̍폜
 *    deletePostOnAtomAPI
 *      :
 *          char         *userName      (I) [U
 *          char         *password      (I) pX[h
 *          char         *blogID        (I) blog ID
 *          char         *entryID       (I) LID
 *      ߂l:
 *          TRUE    폜
 *          FALSE   폜sAMsȂ̃G[
 *      l:
 *          (1) userName  password  NULL ̏ꍇA setUserInfo() Ő
 *              肵[UApX[hgp
 */
BOOL
deletePostOnAtomAPI( const char *username,
                     const char *password,
                     const char *blogID,
                     const char *entryID );

/*
 *  [eBeB֐Q
 */

/*
 * blog ID ̎擾
 *    :   [U, pX[h, 擾 blog i[ꏊ
 *    ߂l: VXeɑ݂ blog ̐
 *    l:   getBlogIDs()  Atom API o[W
 */
int
getBlogIDsOnAtomAPI(
        const char *userName,       // (I) [U
        const char *password,       // (I) pX[h
        int        *numberOfBlogs,  // (I/O) blog 
        BLOGINF    *blogInfo );     // (O) blog 

/*
 * w茏̋L̎擾
 *    :   blog ID, [U, pX[h, 擾L,
 *            擾Li[ꏊ
 *    ߂l: 擾L
 *    l:   getRecentPostTitles()  Atom API o[W
 */
int
getRecentPostTitlesOnAtomAPI(
        const char *blogID,         // (I) blog ID
        const char *userName,       // (I) [U
        const char *password,       // (I) pX[h
        int        *numberOfPosts,  // (I/O) L
        POSTINF    *postinf         // (O) L
    );

/*
 * Gh|CgURL̎擾
 *    :   gbvy[WURL, 擾 blog ID ̊i[ꏊ
 *    ߂l: 擾Gh|CgURL
 *    l:   getEndpointURLbyAutoDiscovery()  Atom API o[W
 *            gbvy[W html head 
 *               <link rel="alternate" type="application/atom+xml" cc
 *            Ƃs΁AYsŎw肳Ă Atom Feed t@C
 *            ɁAGh|CgURL߂B
 *            Ys݂Ȃꍇ́Agbvy[W atom.xml Ƃ
 *            Atom Feed t@Ĉ݂Ɖ肵Aatom.xml t@C
 *            AGh|CgURL߂B
 *            A Atom Feed t@C
 *                <link rel="service.post" type="application/x.atom+xml" cc
 *            Ƃs݂Ȃꍇ́AGh|CgURL̎擾͂łȂB
 */
char    *
getEndpointURLbyAutoDiscoveryOnAtomAPI(
        const char *topPageURL, // (I) gbvy[W URL
        char       *blogID      // (O) blog ID
    );


/*
 * ۑE_:
 *   (1) Atom API gēeꍇAu{vƁuTvvȊO̗vfA
 *       uǋLvAuL[[hv̎舵܂ĂȂ͗lB
 *       āAuǋLvuL[[hvgēeꍇ́A
 *       ʁAXML-RPC API gƂƂB
 *   (2) Atom API ł́uJeSv̎舵܂ɂ͌܂Ă
 *       ȂBbI TypePad ł̎ɏ]ƂɂB(livedoor Blog
 *        TypePad ł̎Ă̗pĂ͗l)
 *   (3) X-WSSE: ɊւāATypaPad ł̎ƁA(BASICF + SSL ̗pȑO
 *       ) Blogger ł̎HĂ( Nonce ̐@AG
 *       R[h@ɈႢ)BTypePad 1.5 ŁA] TypePad  WSSE
 *        livedoor Blog  WSSE (= BASICF + SSL ̗pȑO Blogger
 *        WSSE)̗ɑΉ߁AȌA{CułA҂
 *       WSSE œꂷ邱Ƃɂ(2005N6)
 *   (4) RROł Atom API ̎͒r[ȏԂł(L̓eA
 *       L̍폜AJeSꗗ̎擾AL̎擾AL̕ҏW͈ꉞA
 *       ʂł邪AT[oԂĂ XML rŐK؂
 *       g{ɂȂ邱ƂȂǁA肪cĂB݁AT[o
 *       Ώ҂B
 *   (5) {CúAƂāARRO livedoor Blog œmF
 *       sȂĂB blog c[ł͓얢؂łB
 *   (6) Blogger  WSSE F؂߁ABASICF + SSL ̗pB{C
 *       u2005N6 BASICF + SSL ɂ Atom API ̎s
 *       ΉBBlogger œmFς݁B
 *   (7) VȔFؕ@̗p\邽߁AKXA{C
 *       ũAbvf[gsȂ\B
 */

#endif  /* __ATOM_API_H__ */
