//  $Header: /makeRSS/xmlRPC/encryptRSA.h 5     05/09/21 22:39 Tsujimura543 $
/*! @file
 *  @brief RSA ɂÍAs
 *  @author tsujimura543
 *  @date $Date: 05/09/21 22:39 $
 *  @version $Revision: 5 $
 *  @attention
 *      \li Copyright (c) 2005 by H.Tsujimura
 *      \li written by H.Tsujimura
 *      \li mailto: tsupo@na.rim.or.jp
 *
 *  @note
 * History:
 * $Log: /makeRSS/xmlRPC/encryptRSA.h $
 * 
 * 5     05/09/21 22:39 Tsujimura543
 * freeRSAkey()  freeRSAbuffer() ǉ
 * 
 * 4     05/09/21 18:39 Tsujimura543
 * encodeByRSA() ̑2 in ݂̂ in,out ɕύX
 * 
 * 3     05/09/20 21:51 Tsujimura543
 * Rg𐮗
 * 
 * 2     05/09/20 21:50 Tsujimura543
 * generateRSAkey()  recoveryRSAkey() ̃vg^Cv錾{Cu
 * ̂݌悤ɂ
 * 
 * 1     05/09/20 21:42 Tsujimura543
 * ŏ̔
 */

#ifndef __ENCRYPT_RSA_H__
#define __ENCRYPT_RSA_H__

/** \defgroup encryptRSA RSAɂÍE֘A */
/*@{*/
#ifdef  XMLRPC_EXPORTS
//! ̐
/**
 *  RSA𐶐܂
 *  \param[out] rsaString   Ή
 *  \return     RSA
 *  \note   {֐́A{CuO͒ڎQƂ邱Ƃ͂ł܂B
 */
RSA *
generateRSAkey( unsigned char **rsaString );
#endif  /* XMLRPC_EXPORTS */

//! RSA ɂÍ
/**
 *  RSAÍs܂
 *  \param[in]      targetString    ÍΏە()
 *  \param[in,out]  rsaString       Ή
 *  \param[out]     cryptedBuffer   ÍꂽoCi
 *  \return     ÍꂽoCĩTCY(P: oCg)
 *  \note     
 *      \li *rsaString  NULL  **rsaString  NUL ̏ꍇA
 *         uΉvсuÍꂽoCiv
 *          (Ís)
 *          i[邽߂̗͖̈{֐Ŋmۂ܂B
 *          ̈̉́A{֐̌ĂяoōsȂĂB
 *          ȂAuΉv͕Ɏgp܂B
 *      \li **rsaString  NUL ̏ꍇA*rsaString 
 *          RSA𕜌AÍɎgp܂B
 *          Ěŕ̕ʂɈÍꍇ̋@\łB
 */
int
encodeByRSA( const char    *targetString,
             unsigned char **rsaString,
             unsigned char **cryptedBuffer );

#ifdef  XMLRPC_EXPORTS
//! ̕
/**
 *  uΉvɁARSA𕜌܂
 *  \param[in]  rsaString   Ή
 *  \return     RSA
 *  \note   {֐́A{CuO͒ڎQƂ邱Ƃ͂ł܂B
 */
RSA *
recoveryRSAkey( const unsigned char *rsaString );
#endif  /* XMLRPC_EXPORTS */

//! RSA ɂ镜
/**
 *  RSAs܂
 *  \param[out] targetString    ʕ()
 *  \param[in]  rsaString       Ή
 *  \param[in]  cryptedBuffer   Íς݃oCg(Ώ)
 *  \param[in]  crypted_len     Íς݃oCg̃TCY
 *  \return     ʕ̃TCY(P: oCg)
 *  \note     uʕv(s)
 *            i[邽߂̗͖̈{֐Ŋmۂ܂B
 *            ̈̉́A{֐̌ĂяoōsȂĂB
 */
int
decodeByRSA( char                **targetString,
             const unsigned char *rsaString,
             const unsigned char *cryptedBuffer,
             int                 crypted_len );

//! uΉv̉
/**
 *  uΉvi[̈܂
 *  \param[in]  rsaString   uΉvi[̈̃AhX
 *  \note   generateRSAkey() Ŋmۂ̈邽߂̊֐łB
 */
void
freeRSAkey( unsigned char *rsaString );

//! uÍʁv́uʁv̉
/**
 *  uÍʁv́uʁvi[̈܂
 *  \param[in]  rsaString   uΉvi[̈̃AhX
 *  \note   recoveryRSAkey()  decodeByRSA()
 *          Ŋmۂ̈邽߂̊֐łB
 */
void
freeRSAbuffer( char *buffer );
/*@}*/

#endif  /* __ENCRYPT_RSA_H__ */
