/*
 * AddBlogPetDlg.cpp : EBU[h carot
 *      uOݒ(ǉEҏW)_CAO Cve[V t@C
 *          written by H.Tsujimura  18 Mar 2005
 *
 * $Log: /makeRSS/carot/AddBlogPetDlg.cpp $
 * 
 * 10    07/10/18 0:01 Tsujimura543
 * o[WǗpRgAID悤ɂ
 */

#include "carot.h"
#include "AddBlogPetDlg.h"

#ifndef	lint
static char	*rcs_id =
"$Header: /makeRSS/carot/AddBlogPetDlg.cpp 10    07/10/18 0:01 Tsujimura543 $";
#endif

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAddBlogPetDlg _CAO

CAddBlogPetDlg::CAddBlogPetDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CAddBlogPetDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CAddBlogPetDlg)
	m_blogPetID = _T("");
	m_blogPetName = _T("");
	m_blogPetPassword = _T("");
	m_blogPetUserName = _T("");
	m_blogPetTypeString = _T("");
	//}}AFX_DATA_INIT

    m_mode = true;
}

void CAddBlogPetDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAddBlogPetDlg)
	DDX_Control(pDX, IDC_COMBO_BLOGPETTYPE, m_blogPetList);
	DDX_Text(pDX, IDC_EDIT_BLOGPET_ID, m_blogPetID);
	DDV_MaxChars(pDX, m_blogPetID, 64);
	DDX_Text(pDX, IDC_EDIT_BLOGPET_NAME, m_blogPetName);
	DDV_MaxChars(pDX, m_blogPetName, 32);
	DDX_Text(pDX, IDC_EDIT_BLOGPET_PASSWORD, m_blogPetPassword);
	DDV_MaxChars(pDX, m_blogPetPassword, 16);
	DDX_Text(pDX, IDC_EDIT_BLOGPET_USERNAME, m_blogPetUserName);
	DDV_MaxChars(pDX, m_blogPetUserName, 32);
	DDX_CBString(pDX, IDC_COMBO_BLOGPETTYPE, m_blogPetTypeString);
	DDV_MaxChars(pDX, m_blogPetTypeString, 16);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAddBlogPetDlg, CDialog)
	//{{AFX_MSG_MAP(CAddBlogPetDlg)
	ON_WM_SHOWWINDOW()
	ON_CBN_SELCHANGE(IDC_COMBO_BLOGPETTYPE, OnSelchangeComboBlogPetType)
	ON_BN_CLICKED(IDC_BUTTON_GET_BLOGPET_ID, OnButtonGetBlogPetID)
	ON_EN_UPDATE(IDC_EDIT_BLOGPET_USERNAME, OnUpdateEditBlogpetUsername)
	ON_EN_UPDATE(IDC_EDIT_BLOGPET_PASSWORD, OnUpdateEditBlogpetPassword)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAddBlogPetDlg ƎǉR[h

void    CAddBlogPetDlg::initialize()
{
    if ( m_mode == false ) {
        long    location = BPTYPE_UNKNOWN;

        if ( !m_blogPetTypeString.Compare( "" ) )
            location = BPTYPE_COUSAGI;
        else if ( !m_blogPetTypeString.Compare( "˂" ) )
            location = BPTYPE_CONEKO;
        else if ( !m_blogPetTypeString.Compare( "" ) )
            location = BPTYPE_COINU;
        else if ( !m_blogPetTypeString.Compare( "ς" ) )
            location = BPTYPE_COPANDA;
        else if ( !m_blogPetTypeString.Compare( "˂" ) )
            location = BPTYPE_CONEZUMI;

        SetWindowText( "o^C" );
        m_blogPetList.SetCurSel( location );
    }
    else {
        m_blogPetID         = "";
        m_blogPetName       = "";
        m_blogPetTypeString = "";
        m_blogPetUserName   = "";
        m_blogPetPassword   = "";
    }

    SwitchButtonGetBlogPetID();
}

void    CAddBlogPetDlg::SwitchButtonGetBlogPetID()
{
    CButton *p = (CButton *)GetDlgItem( IDC_BUTTON_GET_BLOGPET_ID );

    if ( (m_blogPetUserName.GetLength() == 0) ||
         (m_blogPetPassword.GetLength() == 0)    )
        p->EnableWindow( FALSE );
    else
        p->EnableWindow( TRUE );
}

/////////////////////////////////////////////////////////////////////////////
// CAddBlogPetDlg bZ[W nh

void CAddBlogPetDlg::OnShowWindow(BOOL bShow, UINT nStatus) 
{
	CDialog::OnShowWindow(bShow, nStatus);
	
    if ( bShow )
        initialize();
}

void CAddBlogPetDlg::OnSelchangeComboBlogPetType() 
{
    CString     blogPetTypeString;
    int         location = m_blogPetList.GetCurSel();

	m_blogPetList.GetLBText( location, blogPetTypeString );

    if ( !blogPetTypeString.Compare( "" ) )
        m_blogPetTypeString = "usagi";
    else if ( !blogPetTypeString.Compare( "˂" ) )
        m_blogPetTypeString = "neko";
    else if ( !blogPetTypeString.Compare( "" ) )
        m_blogPetTypeString = "inu";
    else if ( !blogPetTypeString.Compare( "ς" ) )
        m_blogPetTypeString = "panda";
    else if ( !blogPetTypeString.Compare( "˂" ) )
        m_blogPetTypeString = "nezumi";
    else
        m_blogPetTypeString = "blogPet";
}

void CAddBlogPetDlg::OnOK() 
{
    CEdit   *p = (CEdit *)GetDlgItem( IDC_EDIT_BLOGPET_NAME );
    p->GetWindowText( m_blogPetName );
    if ( m_blogPetName.GetLength() == 0 ) {
        MessageBox( "uBlogPet ̖Ovݒ肵Ă    ",
                    "ݒmF", MB_OK|MB_ICONWARNING );
        return;
    }

    if ( m_blogPetTypeString.GetLength() == 0 ) {
        MessageBox( "uBlogPet ̎ށvݒ肵Ă    ",
                    "ݒmF", MB_OK|MB_ICONWARNING );
        return;
    }

    p = (CEdit *)GetDlgItem( IDC_EDIT_BLOGPET_USERNAME );
    p->GetWindowText( m_blogPetUserName );
    if ( m_blogPetUserName.GetLength() == 0 ) {
        MessageBox( "uBlogPetT[oɃOCƂ̃[Uv"
                    "ݒ肵Ă    ",
                    "ݒmF", MB_OK|MB_ICONWARNING );
        return;
    }

    p = (CEdit *)GetDlgItem( IDC_EDIT_BLOGPET_PASSWORD );
    p->GetWindowText( m_blogPetPassword );
    if ( m_blogPetPassword.GetLength() == 0 ) {
        MessageBox( "uBlogPetT[oɃOCƂ̃pX[hv"
                    "ݒ肵Ă    ",
                    "ݒmF", MB_OK|MB_ICONWARNING );
        return;
    }

    p = (CEdit *)GetDlgItem( IDC_EDIT_BLOGPET_ID );
    p->GetWindowText( m_blogPetID );
    if ( m_blogPetID.GetLength() == 0 ) {
        OnButtonGetBlogPetID();
        if ( m_blogPetID.GetLength() == 0 ) {
            MessageBox( "uBlogPet  IDv擾ł܂!!\r\n"
                        "uBlogPetT[oɃOCƂ̃[Uv"
                        "upX[hv    \r\n"
                        "ԈĂȂAmFĂ",
                        "ݒmF", MB_OK|MB_ICONWARNING );
            return;
        }
    }

	CDialog::OnOK();
}

void CAddBlogPetDlg::OnButtonGetBlogPetID() 
{
    char        blogPetID[BUFSIZ];
    CCarotApp   *cp = (CCarotApp *)AfxGetApp();

    blogPetID[0] = NUL;
    cp->GetBlogPetID( (const char *)m_blogPetUserName,
                      (const char *)m_blogPetPassword,
                      blogPetID );
    m_blogPetID = blogPetID;

    CEdit   *p;
    p = (CEdit *)GetDlgItem( IDC_EDIT_BLOGPET_ID );
    p->SetWindowText( m_blogPetID );
}

void CAddBlogPetDlg::OnUpdateEditBlogpetUsername() 
{
    CEdit   *p;
    CString str;

    p = (CEdit *)GetDlgItem( IDC_EDIT_BLOGPET_USERNAME );
    p->GetWindowText( str );

    if ( str.GetLength() > 0 ) {
        m_blogPetUserName = str;
        SwitchButtonGetBlogPetID();
    }
}

void CAddBlogPetDlg::OnUpdateEditBlogpetPassword() 
{
    CEdit   *p;
    CString str;

    p = (CEdit *)GetDlgItem( IDC_EDIT_BLOGPET_PASSWORD );
    p->GetWindowText( str );

    if ( str.GetLength() > 0 ) {
        m_blogPetPassword = str;
        SwitchButtonGetBlogPetID();
    }
}
