/*
 * SelectBlogPet.cpp : EBU[h carot
 *      uOybgI_CAO Cve[V t@C
 *          written by H.Tsujimura  23 Feb 2005
 *
 * $Log: /makeRSS/carot/SelectBlogPet.cpp $
 * 
 * 7     07/10/18 0:04 Tsujimura543
 * ]ȃRg폜
 * 
 * 6     07/10/17 23:59 Tsujimura543
 * o[WǗpRgAID悤ɂ
 */

#include "carot.h"
#include "SelectBlogPet.h"
#include "AddBlogPetDlg.h"

#ifndef	lint
static char	*rcs_id =
"$Header: /makeRSS/carot/SelectBlogPet.cpp 7     07/10/18 0:04 Tsujimura543 $";
#endif

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSelectBlogPet _CAO

CSelectBlogPet::CSelectBlogPet(CWnd* pParent /*=NULL*/)
	: CDialog(CSelectBlogPet::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSelectBlogPet)
	m_blogPetInfoString = _T("");
	//}}AFX_DATA_INIT
}

void CSelectBlogPet::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSelectBlogPet)
	DDX_Control(pDX, IDC_LIST_BLOGPET, m_blogPetList);
	DDX_LBString(pDX, IDC_LIST_BLOGPET, m_blogPetInfoString);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CSelectBlogPet, CDialog)
	//{{AFX_MSG_MAP(CSelectBlogPet)
	ON_BN_CLICKED(IDC_BUTTON_ADD_NEWPET, OnButtonAddNewPet)
	ON_BN_CLICKED(IDC_BUTTON_DELETE_PET, OnButtonDeletePet)
	ON_LBN_SELCHANGE(IDC_LIST_BLOGPET, OnSelchangeListBlogPet)
	ON_WM_SHOWWINDOW()
	ON_LBN_DBLCLK(IDC_LIST_BLOGPET, OnDblclkListBlogPet)
	ON_BN_CLICKED(IDC_BUTTON_MODIFY_PET, OnButtonModifyPet)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSelectBlogPet bZ[W nh

void CSelectBlogPet::OnButtonAddNewPet() 
{
	CAddBlogPetDlg  dialog;
    int             res;

    dialog.m_mode = true;
    res = dialog.DoModal();
    if ( res == IDOK ) {
        CCarotApp   *cp = (CCarotApp *)AfxGetApp();
        long        n   = cp->m_numOfBlogPets;

        // BlogPet  ID
        if ( dialog.m_blogPetID.GetLength() > 0 )
            strcpy( cp->m_blogPetList[n].blogPetID, (const char *)dialog.m_blogPetID );
        else
            cp->m_blogPetList[n].blogPetID[0] = NUL;

        // BlogPet ̖O
        if ( dialog.m_blogPetName.GetLength() > 0 )
            strcpy( cp->m_blogPetList[n].blogPetName, (const char *)dialog.m_blogPetName );
        else
            cp->m_blogPetList[n].blogPetName[0] = NUL;

        // BlogPet ̎
        if ( !dialog.m_blogPetTypeString.Compare( "" ) )
            cp->m_blogPetList[n].blogPetType = BPTYPE_COUSAGI;
        else if ( !dialog.m_blogPetTypeString.Compare( "˂" ) )
            cp->m_blogPetList[n].blogPetType = BPTYPE_CONEKO;
        else if ( !dialog.m_blogPetTypeString.Compare( "" ) )
            cp->m_blogPetList[n].blogPetType = BPTYPE_COINU;
        else if ( !dialog.m_blogPetTypeString.Compare( "ς" ) )
            cp->m_blogPetList[n].blogPetType = BPTYPE_COPANDA;
        else if ( !dialog.m_blogPetTypeString.Compare( "˂" ) )
            cp->m_blogPetList[n].blogPetType = BPTYPE_CONEZUMI;
        else
            cp->m_blogPetList[n].blogPetType = BPTYPE_UNKNOWN;

        // BlogPet T[o [U
        if ( dialog.m_blogPetUserName.GetLength() > 0 )
            strcpy( cp->m_blogPetList[n].blogPetUsername, (const char *)dialog.m_blogPetUserName );
        else
            cp->m_blogPetList[n].blogPetUsername[0] = NUL;

        // BlogPet T[o pX[h
        if ( dialog.m_blogPetPassword.GetLength() > 0 )
            strcpy( cp->m_blogPetList[n].blogPetPassword, (const char *)dialog.m_blogPetPassword );
        else
            cp->m_blogPetList[n].blogPetPassword[0] = NUL;

        // ǉ BlogPet uBloPet Ivɒǉ
        CString str = cp->m_blogPetList[n].blogPetName;
        str += " (";
        str += cp->m_blogPetList[n].blogPetType == BPTYPE_COUSAGI
                   ? "" :
               cp->m_blogPetList[n].blogPetType == BPTYPE_CONEKO
                   ? "˂" :
               cp->m_blogPetList[n].blogPetType == BPTYPE_COINU
                   ? "" :
               cp->m_blogPetList[n].blogPetType == BPTYPE_COPANDA
                   ? "ς" :
               cp->m_blogPetList[n].blogPetType == BPTYPE_CONEZUMI
                   ? "˂" :
                     "Blog Pet";
        str += ")";
        if ( cp->m_blogPetList[n].blogPetID[0] ) {
            str += " [";
            str += cp->m_blogPetList[n].blogPetID;
            str += "]";
        }
        m_blogPetList.AddString( str );
        m_blogPetList.SetCurSel( n );
        m_currentPetID = n;

        (cp->m_numOfBlogPets)++;

        // uBlogPet 폜v{^ ebable ɂ
        CButton *p = (CButton *)GetDlgItem( IDC_BUTTON_DELETE_PET );
        p->EnableWindow( TRUE );

        if ( cp->m_numOfBlogPets >= MAX_NUM_OF_BLOGPETS ) {
            // uBlogPet ǉv{^ disable ɂ
            CButton *p = (CButton *)GetDlgItem( IDC_BUTTON_ADD_NEWPET );
            p->EnableWindow( FALSE );
        }

        // uo^Cv{^ ebable ɂ
        p = (CButton *)GetDlgItem( IDC_BUTTON_MODIFY_PET );
        p->EnableWindow( TRUE );
    }

    OnSelchangeListBlogPet();   /* {@@} */
}

void CSelectBlogPet::OnButtonDeletePet() 
{
    int     location = m_blogPetList.GetCurSel();

    if ( location == LB_ERR )
        return;

    CCarotApp   *cp = (CCarotApp *)AfxGetApp();
    if ( cp->m_numOfBlogPets <= 1 )
        return;

    int res = MessageBox( "{ɍ폜Ă\܂?    ",
                          "폜mF", MB_YESNO|MB_ICONWARNING );
    if ( res != IDYES )
        return;

    for ( long i = location; i < cp->m_numOfBlogPets - 1; i++ ) {
        strcpy( cp->m_blogPetList[i].blogPetID,
                cp->m_blogPetList[i + 1].blogPetID );
        strcpy( cp->m_blogPetList[i].blogPetName,
                cp->m_blogPetList[i + 1].blogPetName );
        cp->m_blogPetList[i].blogPetType = 
                cp->m_blogPetList[i + 1].blogPetType;
        strcpy( cp->m_blogPetList[i].blogPetUsername,
                cp->m_blogPetList[i + 1].blogPetUsername );
        strcpy( cp->m_blogPetList[i].blogPetPassword,
                cp->m_blogPetList[i + 1].blogPetPassword );
    }

    (cp->m_numOfBlogPets)--;
    cp->m_blogPetList[cp->m_numOfBlogPets].blogPetID[0]       = NUL;
    cp->m_blogPetList[cp->m_numOfBlogPets].blogPetName[0]     = NUL;
    cp->m_blogPetList[cp->m_numOfBlogPets].blogPetType        = BPTYPE_UNKNOWN;
    cp->m_blogPetList[cp->m_numOfBlogPets].blogPetUsername[0] = NUL;
    cp->m_blogPetList[cp->m_numOfBlogPets].blogPetPassword[0] = NUL;

    m_blogPetList.DeleteString( location );

    if ( location > 0 )
        location--;
    m_blogPetList.SetCurSel( location );
    m_currentPetID = location;

    if ( cp->m_numOfBlogPets <= 1 ) {
        // uBlogPet 폜v{^ disable ɂ
        CButton *p = (CButton *)GetDlgItem( IDC_BUTTON_DELETE_PET );
        p->EnableWindow( FALSE );
    }

    if ( cp->m_numOfBlogPets > 0 )  /* {@@} */
        OnSelchangeListBlogPet();   /* {@@} */
}

void CSelectBlogPet::OnSelchangeListBlogPet() 
{
    CString str;
    char    *p, *q;
    int     location = m_blogPetList.GetCurSel();
    char    temp[BUFSIZ];

    if ( location == LB_ERR ) {
        OnCancel();
        return;
    }

    m_currentPetID = location;
	m_blogPetList.GetText( location, str );
    if ( str.GetLength() > 0 ) {
        m_blogPetName = str;
        m_blogPetType = "blogPet";
        m_blogPetID   = "";

        strcpy( temp, (const char *)str );
        p = strstr( temp, " (" );
        if ( p ) {
            p += 2;
            q = strchr( p, ')' );
            if ( q ) {
                char    blogPetString[64];

                strncpy( blogPetString, p, q - p );
                blogPetString[q - p] = NUL;
                if ( !strcmp( blogPetString, "" ) )
                    m_blogPetType = "usagi";
                else if ( !strcmp( blogPetString, "˂" ) )
                    m_blogPetType = "neko";
                else if ( !strcmp( blogPetString, "" ) )
                    m_blogPetType = "inu";
                else if ( !strcmp( blogPetString, "ς" ) )
                    m_blogPetType = "panda";
                else if ( !strcmp( blogPetString, "˂" ) )
                    m_blogPetType = "nezumi";
                else
                    m_blogPetType = "blogPet";
            }
        }

        p = strstr( temp, " [" );
        if ( p ) {
            p += 2;
            q = strchr( p, ']' );
            if ( q ) {
                char    blogPetID[64];

                strncpy( blogPetID, p, q - p );
                blogPetID[q - p] = NUL;
                m_blogPetID = blogPetID;
            }
        }

        p = strstr( temp, " (" );
        if ( !p )
            p = strstr( temp, " [" );
        if ( p ) {
            *p = NUL;
            m_blogPetName = temp;
        }

        CCarotApp   *cp = (CCarotApp *)AfxGetApp();
        long        n   = m_currentPetID;
        m_blogPetUsername = cp->m_blogPetList[n].blogPetUsername;
        m_blogPetPassword = cp->m_blogPetList[n].blogPetPassword;
    }
}

void CSelectBlogPet::OnShowWindow(BOOL bShow, UINT nStatus) 
{
	CDialog::OnShowWindow(bShow, nStatus);
	
    if ( bShow ) {
        CString str;

        m_blogPetName = "";

        CCarotApp   *cp = (CCarotApp *)AfxGetApp();
        if ( cp->m_numOfBlogPets > 0 ) {
            for ( long i = 0; i < cp->m_numOfBlogPets; i++ ) {
                str = cp->m_blogPetList[i].blogPetName;
                str += " (";
                str += cp->m_blogPetList[i].blogPetType == BPTYPE_COUSAGI
                           ? "" :
                       cp->m_blogPetList[i].blogPetType == BPTYPE_CONEKO
                           ? "˂" :
                       cp->m_blogPetList[i].blogPetType == BPTYPE_COINU
                           ? "" :
                       cp->m_blogPetList[i].blogPetType == BPTYPE_COPANDA
                           ? "ς" :
                       cp->m_blogPetList[i].blogPetType == BPTYPE_CONEZUMI
                           ? "˂" :
                             "Blog Pet";
                str += ")";
                if ( cp->m_blogPetList[i].blogPetID[0] ) {
                    str += " [";
                    str += cp->m_blogPetList[i].blogPetID;
                    str += "]";
                }
                m_blogPetList.AddString( str );
            }

            if ( cp->m_numOfBlogPets <= 1 ) {
                // uBlogPet 폜v{^ disable ɂ
                CButton *p = (CButton *)GetDlgItem( IDC_BUTTON_DELETE_PET );
                p->EnableWindow( FALSE );
            }

            m_blogPetList.SetCurSel( m_currentPetID );

            long    n = m_currentPetID;
            m_blogPetUsername = cp->m_blogPetList[n].blogPetUsername;
            m_blogPetPassword = cp->m_blogPetList[n].blogPetPassword;
        }
        else {
            SetWindowText( "BlogPeto^" );

            // uBlogPet 폜v{^ disable ɂ
            CButton *p = (CButton *)GetDlgItem( IDC_BUTTON_DELETE_PET );
            p->EnableWindow( FALSE );

            // uo^Cv{^ disable ɂ
            p = (CButton *)GetDlgItem( IDC_BUTTON_MODIFY_PET );
            p->EnableWindow( FALSE );
        }

        if ( cp->m_numOfBlogPets >= MAX_NUM_OF_BLOGPETS ) {
            // uBlogPet ǉv{^ disable ɂ
            CButton *p = (CButton *)GetDlgItem( IDC_BUTTON_ADD_NEWPET );
            p->EnableWindow( FALSE );
        }
    }	
}

void CSelectBlogPet::OnDblclkListBlogPet() 
{
    OnOK();
}

void CSelectBlogPet::OnOK() 
{
	OnSelchangeListBlogPet();
    if ( m_blogPetName.GetLength() > 0 )
    	CDialog::OnOK();
}

void CSelectBlogPet::OnButtonModifyPet() 
{
	CAddBlogPetDlg  dialog;
    int             res;

    OnSelchangeListBlogPet();

    dialog.m_mode              = false;
    dialog.m_blogPetID         = m_blogPetID;
    dialog.m_blogPetName       = m_blogPetName;

    if ( !m_blogPetType.Compare( "usagi" ) )
        dialog.m_blogPetTypeString = "";
    else if ( !m_blogPetType.Compare( "neko" ) )
        dialog.m_blogPetTypeString = "˂";
    else if ( !m_blogPetType.Compare( "inu" ) )
        dialog.m_blogPetTypeString = "";
    else if ( !m_blogPetType.Compare( "panda" ) )
        dialog.m_blogPetTypeString = "ς";
    else if ( !m_blogPetType.Compare( "nezumi" ) )
        dialog.m_blogPetTypeString = "˂";
    else
        dialog.m_blogPetTypeString = "Blpg Pet";

    dialog.m_blogPetUserName   = m_blogPetUsername;
    dialog.m_blogPetPassword   = m_blogPetPassword;

    res = dialog.DoModal();
    if ( res == IDOK ) {
        long        n   = m_currentPetID;
        CCarotApp   *cp = (CCarotApp *)AfxGetApp();

        // BlogPet  ID
        m_blogPetID   = dialog.m_blogPetID;
        if ( m_blogPetID.GetLength() > 0 )
            strcpy( cp->m_blogPetList[n].blogPetID, (const char *)m_blogPetID );
        else
            cp->m_blogPetList[n].blogPetID[0] = NUL;

        // BlogPet ̖O
        m_blogPetName = dialog.m_blogPetName;
        if ( m_blogPetName.GetLength() > 0 )
            strcpy( cp->m_blogPetList[n].blogPetName, (const char *)m_blogPetName );
        else
            cp->m_blogPetList[n].blogPetName[0] = NUL;

        // BlogPet ̎
        if ( !dialog.m_blogPetTypeString.Compare( "" ) ) {
            m_blogPetType = "usagi";
            cp->m_blogPetList[n].blogPetType = BPTYPE_COUSAGI;
        }
        else if ( !dialog.m_blogPetTypeString.Compare( "˂" ) ) {
            m_blogPetType = "neko";
            cp->m_blogPetList[n].blogPetType = BPTYPE_CONEKO;
        }
        else if ( !dialog.m_blogPetTypeString.Compare( "" ) ) {
            m_blogPetType = "inu";
            cp->m_blogPetList[n].blogPetType = BPTYPE_COINU;
        }
        else if ( !dialog.m_blogPetTypeString.Compare( "ς" ) ) {
            m_blogPetType = "panda";
            cp->m_blogPetList[n].blogPetType = BPTYPE_COPANDA;
        }
        else if ( !dialog.m_blogPetTypeString.Compare( "˂" ) ) {
            m_blogPetType = "nezumi";
            cp->m_blogPetList[n].blogPetType = BPTYPE_CONEZUMI;
        }
        else {
            m_blogPetType = "blogPet";
            cp->m_blogPetList[n].blogPetType = BPTYPE_UNKNOWN;
        }

        // BlogPet T[o [U
        m_blogPetUsername = dialog.m_blogPetUserName;
        if ( m_blogPetUsername.GetLength() > 0 )
            strcpy( cp->m_blogPetList[n].blogPetUsername, (const char *)m_blogPetUsername );
        else
            cp->m_blogPetList[n].blogPetUsername[0] = NUL;

        // BlogPet T[o pX[h
        m_blogPetPassword = dialog.m_blogPetPassword;
        if ( m_blogPetPassword.GetLength() > 0 )
            strcpy( cp->m_blogPetList[n].blogPetPassword, (const char *)m_blogPetPassword );
        else
            cp->m_blogPetList[n].blogPetPassword[0] = NUL;

        // XVꂽf[^ɁuBlogPet Ivĕ`
        m_blogPetList.ResetContent();

        CString     str;
        for ( long i = 0; i < cp->m_numOfBlogPets; i++ ) {
            str = cp->m_blogPetList[i].blogPetName;
            str += " (";
            str += cp->m_blogPetList[i].blogPetType == BPTYPE_COUSAGI
                       ? "" :
                   cp->m_blogPetList[i].blogPetType == BPTYPE_CONEKO
                       ? "˂" :
                   cp->m_blogPetList[i].blogPetType == BPTYPE_COINU
                       ? "" :
                   cp->m_blogPetList[i].blogPetType == BPTYPE_COPANDA
                       ? "ς" :
                   cp->m_blogPetList[i].blogPetType == BPTYPE_CONEZUMI
                       ? "˂" :
                         "Blog Pet";
            str += ")";
            if ( cp->m_blogPetList[i].blogPetID[0] ) {
                str += " [";
                str += cp->m_blogPetList[i].blogPetID;
                str += "]";
            }
            m_blogPetList.AddString( str );
        }
        m_blogPetList.SetCurSel( m_currentPetID );
    }

    OnSelchangeListBlogPet();   /* {@@} */
}
