/*
 *  echoo.c
 *      GRO֘A[eBeB֐Q
 *
 *      written by H.Tsujimura    24 Nov 2004 / 10 Sep 2008
 *
 *      Copyright (c) 2004, 2005, 2006, 2007, 2008 by H.Tsujimura (tsupo@na.rim.or.jp)
 *      All Rights Reserved.
 *
 *  XAxmlRPC.dll ɗpӂĂ֐𒊏o
 *
 * History:
 * $Log: /makeRSS/carot/echoo.c $
 * 
 * 1     08/09/10 22:18 Tsujimura543
 * loginEchoo(), getCategoryListEchoo(), getBlogIDsEchoo()
 *  xmlRPC.dll ڊ
 */

#ifdef  WIN32
#include <time.h>
#else
#include <sys/time.h>
#endif

#include "xmlRPC.h"
#include "echoo.h"
#include "utility.h"

#ifndef	lint
static char	*rcs_id =
"$Header: /makeRSS/carot/echoo.c 1     08/09/10 22:18 Tsujimura543 $";
#endif

/*
 * GRO[eBeB֐Q
 */

/* w蕶10i񂩔ۂ */
int
isDecString( const char *p )
{
    int ret = 1;

    while ( *p ) {
        if ( (*p >= '0') && (*p <= '9') ) {
            p++;
            continue;
        }

        ret = 0;
        break;
    }

    return ( ret );
}

int
selectOpenClassification()
{
    int     openClass = 0, i = 6;
    int     numOfOpenClasses = 6;
    BOOL    done = FALSE;

    do {
        fputs( "\nJ敪: \n", stderr );
        fputs( "\t[1] \n", stderr );
        fputs( "\t[2] Echoo!FB̂݌J\n", stderr );
        fputs( "\t[3] тƂ܂FB̂݌J\n", stderr );
        fputs( "\t[4] Echoo!̂݌J\n", stderr );
        fputs( "\t[5] тƂܓ̂݌J\n", stderr );
        fputs( "\t[6] OJ\n", stderr );
        done = inputNumeric( &i, 1, numOfOpenClasses );
    } while ( !done );

    switch ( i ) {
    case 1:
        openClass = 0;
        break;
    case 2:
        openClass = 1;
        break;
    case 3:
        openClass = 2;
        break;
    case 4:
        openClass = 3;
        break;
    case 5:
        openClass = 6;
        break;
    case 6:
    default:
        openClass = 4;
        break;
    }

    return ( openClass );
}

int
loginEchoo( const char *username,   // (I) Echoo! ID ([AhX)
            const char *password,   // (I) pX[h
            char       *cookie,     // (O) NbL[
            char       *myBlogURL ) // (O) bloggbvy[WURL
{
    int     ret = 0;
    char    *request;
    char    *response;
    char    url[MAX_URLLENGTH];
    size_t  sz = MAX_CONTENT_SIZE * 2;

    if ( !username || !(*username) ||
         !password || !(*password) ||
         !cookie )
         return ( ret );

 // if ( !username )
 //     username = xmlrpc_p->userName;
 // if ( !password )
 //     password = xmlrpc_p->password;

    request  = (char *)malloc( MAX_CONTENT_SIZE );
    if ( !request ) 
        return ( ret );
    response = (char *)malloc( sz );
    if ( !response ) {
        free( request );
        return ( ret );
    }
    memset( request,  0x00, MAX_CONTENT_SIZE );

    strcpy( url, "https://echoo.yubitoma.or.jp/index.htm" );
    setTargetURL( url );
    sprintf( request,
             "loginid=%s&"
             "pw=%s"     /*
             "&submit=%s"*/,
             username, password /* ,
             encodeURL(sjis2euc("OC")) */ );
    setUpReceiveBuffer( response, sz );
 // ret = httpPostWithSession( xmlrpc_p->webServer, xmlrpc_p->webPage,
 //                            "application/x-www-form-urlencoded",
 //                            request, response, cookie,
 //                            NULL, NULL );
    http_postEx( url, "application/x-www-form-urlencoded",
                 request, response, cookie );

 // if ( ret == -1 )
 //     ret = 0;        /* T[oƂ̒ʐMs */
 // else
    if ( *response ) {
        if ( strstr( response, sjis2euc("̃}Cz[ł") ) != NULL ) {
            char    *p, *q;
            ret = 1;    /* OC */

            /* blog URL擾 */
            p = strstr( response, sjis2euc( "}CGRO\" ) );
            if ( p ) {
                while ( *p ) {
                    p--;
                    if ( (*p == ':') && !strncmp( p - 4, "http", 4 ) ) {
                        p -= 4;
                        q = strchr( p, '"' );
                        if ( q ) {
                            strncpy( myBlogURL, p, q - p );
                            myBlogURL[q - p] = NUL;
                            break;
                        }
                    }
                }
            }
        }
        else
            ret = 0;    /* OCs */
    }

    free( response );
    free( request  );

    return ( ret );
}


int
getCategoryListEchoo(
    const char   *userName,         // (I) [U
    const char   *password,         // (I) pX[h
    long         *numOfCategories,  // (I) 擾JeS̐
                                    // (O) 擾JeS̐
    CATLISTINF_t categories )       // (O) 擾JeS
{
    char    *cookie = (char *)malloc( MAX_COOKIE_LEN );
    char    *request;
    char    *response;
    char    url[MAX_URLLENGTH];
    int     numOfCats = 0;
    size_t  sz = MAX_CONTENT_SIZE * 2;

    if ( !numOfCategories                      ||
         (*numOfCategories <= 0)               ||
         !categories                              )
        return ( numOfCats );

    if ( cookie ) {
        memset( cookie, 0x00, MAX_COOKIE_LEN );
        if ( loginEchoo( userName, password, cookie, url ) ) {
            request  = (char *)malloc( MAX_CONTENT_SIZE );
            if ( !request ) {
                free( cookie );
                return ( numOfCats );
            }
            response = (char *)malloc( sz );
            if ( !response ) {
                free( request );
                free( cookie );
                return ( numOfCats );
            }
            memset( request,  0x00, MAX_CONTENT_SIZE );

            /* JeSꗗ̎擾 */
            setUpReceiveBuffer( response, sz );
         // httpGetBufferWithSession(
         //     "http://echoo.yubitoma.or.jp/blog/entry.htm",
         //     response, TRUE, NULL, NULL, cookie,
         //     NULL, NULL );
            http_getEx( "http://echoo.yubitoma.or.jp/blog/entry.htm",
                        response, cookie );

            /* JeS̒o */
            numOfCats = getCategoryIDs( numOfCategories, categories,
                                        response,
                                        "<option value=\"\">--",
                           "</select>&nbsp;&nbsp;<a href=\"./category.htm\">",
                                        "<option value=\"", "\">",
                                        CHARSET_EUCJP );

            free( response );
            free( request  );
        }

        free( cookie );
    }

    *numOfCategories = numOfCats;

    return ( numOfCats );
}

int
getBlogIDsEchoo(
    const char *userName,       // (I) [U
    const char *password,       // (I) pX[h
    int        *numberOfBlogs,  // (I) 擾/擾 blog ̐
    BLOGINF    *blogInfo )      // (O) 擾 blog 
{
    char    cookie[MAX_COOKIE_LEN];
    char    url[MAX_URLLENGTH];
    int     numOfBlogs = 0;

    cookie[0] = NUL;
    url[0]    = NUL;
    loginEchoo( userName, password, cookie, url );
    if ( url[0] ) {
        size_t  sz = MAX_CONTENT_SIZE;
        char    *response;

        strcpy( blogInfo[0].url, url );
        blogInfo[0].blogName[0] = NUL;
        blogInfo[0].blogID[0]   = NUL;

        response = (char *)malloc( sz );
        if ( response ) {
            setUpReceiveBuffer( response, sz );
            http_get( url, response );
            if ( *response ) {
                char        target[BUFSIZ];
                const char  *p, *q;

                target[0] = NUL;
                p = strstr( response, "<title>" );
                if ( p ) {
                    p += 7;
                    q = strstr( p, " - Echoo!" );
                    if ( q ) {
                        strncpy( target, p, q - p );
                        target[q - p] = NUL;
                    }
                }
                else {
                    p = strstr( response, "<h1><a href=\"" );
                    if ( p ) {
                        p = strchr( p + 13, '>' );
                        if ( p ) {
                            p++;
                            q = strstr( p, "</a>" );
                            if ( q ) {
                                strncpy( target, p, q - p );
                                target[q - p] = NUL;
                            }
                        }
                    }
                }

                if ( target[0] ) {
                    p = euc2sjis( target );
                    strcpy( blogInfo[0].blogName, p ? p : target );
                }
            }

            free( response );
        }

        numOfBlogs = 1;
    }

    *numberOfBlogs = numOfBlogs;

    return ( numOfBlogs );
}
