/*
 *  rakuten.c
 *      yVuOe
 *      written by H.Tsujimura    21 Apr 2005 / 2 Oct 2006 / 10 Sep 2008
 *
 *      Copyright (c) 2005, 2006, 2007, 2008 by H.Tsujimura (tsupo@na.rim.or.jp)
 *      All Rights Reserved.
 *
 *  XAxmlRPC.dll ɗpӂĂ֐𒊏o
 *
 * History:
 * $Log: /makeRSS/carot/rakuten.c $
 * 
 * 2     08/09/10 22:17 Tsujimura543
 * \[X𐮗
 * 
 * 1     08/09/10 18:17 Tsujimura543
 * loginRakuten(), getCategoryListRakuten(), getBlogIDsRakuten()
 *  xmlRPC.dll ڊ
 */

#ifdef  WIN32
#include <time.h>
#else
#include <sys/time.h>
#endif

#include "xmlRPC.h"
#include "rakuten.h"
#include "utility.h"

#ifndef	lint
static char	*rcs_id =
"$Header: /makeRSS/carot/rakuten.c 2     08/09/10 22:17 Tsujimura543 $";
#endif

/*
 * uyVLv߁uyVuOve
 */

/*  blog URL 擾 */
static char *
getBlogURL( char *url, const char *htmlSrc )
{
    const char  *p, *q;

    p = strstr( htmlSrc, sjis2euc("Myy[W̊mF") );
    if ( p ) {
        while ( p > htmlSrc ) {
            if ( *--p != 'h' )
                continue;
            if ( !strncmp( p, "href=\"http://plaza.rakuten.co.jp/", 33 ) ) {
                p += 6;
                q = strchr( p, '"' );
                if ( q ) {
                    strncpy( url, p, q - p );
                    url[q - p] = NUL;
                }
                break;
            }
        }
    }

    return ( url );
}

int
loginRakuten( const char *username,
              const char *password,
              char       *cookie,
              char       *myBlogURL )
{
    int     ret = 0;
    char    *request;
    char    *response;
    size_t  sz = MAX_CONTENT_SIZE;
    char    url[MAX_URLLENGTH];

    if ( !username || !(*username) ||
         !password || !(*password) ||
         !cookie )
         return ( ret );

    request  = (char *)malloc( MAX_CONTENT_SIZE );
    if ( !request ) 
        return ( ret );
    response = (char *)malloc( sz );
    if ( !response ) {
        free( request );
        return ( ret );
    }

    memset( request, 0x00, MAX_CONTENT_SIZE );
    strcpy( url,
     "https://grp02.id.rakuten.co.jp/rms/nid/vc?__event=login&service_id=59");
    sprintf( request,
             "u=%s&"
             "p=%s&"
             "autologin=true",
             username, password );
    setUpReceiveBuffer( response, sz );
    http_postEx( url, "application/x-www-form-urlencoded",
                 request, response, cookie );

    if ( *response ) {
        if ( strstr( response, "class=\"loginUser\"" ) &&
             strstr( response, "class=\"blogData\"" )     ) {
            ret = 1;    /* OC */
            getBlogURL( myBlogURL, response );
        }
        else
            ret = 0;    /* OCs */
    }

    free( response );
    free( request  );

    return ( ret );
}


int
getBlogIDsRakuten(
    const char *userName,       // (I) [U
    const char *password,       // (I) pX[h
    int        *numberOfBlogs,  // (I) 擾/擾 blog ̐
    BLOGINF    *blogInfo )      // (O) 擾 blog 
{
    char    cookie[MAX_COOKIE_LEN];
    char    url[MAX_URLLENGTH];
    int     numOfBlogs = 0;

    cookie[0] = NUL;
    url[0]    = NUL;
    loginRakuten( userName, password, cookie, url );
    if ( url[0] ) {
        size_t  sz = MAX_CONTENT_SIZE;
        char    *response;

        strcpy( blogInfo[0].url, url );
        blogInfo[0].blogName[0] = NUL;
        blogInfo[0].blogID[0]   = NUL;

        response = (char *)malloc( sz );
        if ( response ) {
            setUpReceiveBuffer( response, sz );
            http_get( url, response );
            if ( *response ) {
                char        target[BUFSIZ];
                const char  *p, *q;

                target[0] = NUL;
                p = strstr( response,
                            "<td class=\"title_text\" id=\"title\">" );
                if ( p ) {
                    p += 34;
                    while ( (*p == ' ')  || (*p == '\t') ||
                            (*p == '\r') || (*p == '\n')    )
                        p++;
                    q = strstr( p, "</td>" );
                    if ( q ) {
                        while ( (q > p)                   &&
                                ( (*(q - 1) == ' ')  ||
                                  (*(q - 1) == '\t') ||
                                  (*(q - 1) == '\r') ||
                                  (*(q - 1) == '\n')    )    )
                            q--;
                        strncpy( target, p, q - p );
                        target[q - p] = NUL;
                    }
                }
                else {
                    p = strstr( response, "<title>" );
                    if ( p ) {
                        p += 7;
                        q = strstr( p, sjis2euc(" - yV") );
                        if ( q ) {
                            strncpy( target, p, q - p );
                            target[q - p] = NUL;
                        }
                    }
                    else {
                        p = strstr( response, " id=\"counter\">" );
                        if ( p ) {
                            p += 14;
                            p = strstr( p, "<font color=\"" );
                            if ( p ) {
                                p = strchr( p + 13, '>' );
                                if ( p ) {
                                    p++;
                                    q = strstr( p, sjis2euc("&nbsp;  yV") );
                                    if ( q ) {
                                        strncpy( target, p, q - p );
                                        target[q - p] = NUL;
                                    }
                                }
                            }
                        }
                    }
                }

                if ( target[0] ) {
                    p = euc2sjis( target );
                    strcpy( blogInfo[0].blogName, p ? p : target );
                }
            }

            free( response );
        }

        numOfBlogs = 1;
    }

    *numberOfBlogs = numOfBlogs;

    return ( numOfBlogs );
}


int
getCategoryListRakuten(
    const char   *userName,         // (I) [U
    const char   *password,         // (I) pX[h
    long         *numOfCategories,  // (I) 擾JeS̐
                                    // (O) 擾JeS̐
    CATLISTINF_t categories )       // (O) 擾JeS
{
    char    *cookie = (char *)malloc( MAX_COOKIE_LEN );
    char    *request;
    char    *response;
    char    url[MAX_URLLENGTH];
    int     numOfCats = 0;
    size_t  sz = MAX_CONTENT_SIZE * 2;

    if ( !numOfCategories                      ||
         (*numOfCategories <= 0)               ||
         !categories                              )
        return ( numOfCats );

    if ( cookie ) {
        memset( cookie, 0x00, MAX_COOKIE_LEN );
        if ( loginRakuten( userName, password, cookie, url ) ) {
            request  = (char *)malloc( MAX_CONTENT_SIZE );
            if ( !request ) {
                free( cookie );
                return ( numOfCats );
            }
            response = (char *)malloc( sz );
            if ( !response ) {
                free( request );
                free( cookie );
                return ( numOfCats );
            }
            memset( request,  0x00, MAX_CONTENT_SIZE );

            /* JeSꗗ̎擾 */
            strcpy( url,
                    "http://my.plaza.rakuten.co.jp/?func=diary&act=write" );
            setUpReceiveBuffer( response, sz );
            http_getEx( url, response, cookie );

            /* JeS̒o */
            numOfCats = getCategoryIDs( numOfCategories, categories,
                                        response,
                                        "<select name=\"cate_id\">",
                                        "</select>",
                                        "<option value=\"", "\">",
                                        CHARSET_EUCJP );

            free( response );
            free( request  );
        }

        free( cookie );
    }

    *numOfCategories = numOfCats;

    return ( numOfCats );
}
