/*
 *  cocousagi.h
 *      API gĐL blog ɓevO
 *
 *      written by H.Tsujimura      2 Jul 2004
 *
 * History:
 * $Log: /makeRSS/cocousagi/cocousagi.h $
 * 
 * 23    09/05/28 18:31 Tsujimura543
 * amazonSubscriptionID ǉ
 * 
 * 22    09/03/23 16:23 Tsujimura543
 * EFuuO XML-RPC API oRł͂Ȃ̏X폜
 * 
 * 21    09/03/20 22:26 Tsujimura543
 * ͂Ăȃ_CA[ Atom API ł̓eɑΉ
 * 
 * 20    09/03/20 17:43 Tsujimura543
 * EFuuO XML-RPC API ł̓eɑΉ
 * 
 * 19    08/09/10 23:17 Tsujimura543
 * \[X𐮗
 * 
 * 18    08/09/10 23:12 Tsujimura543
 * loginExciteBlog(), postExciteBlog()  xmlRPC.dll ڊ
 * 
 * 17    08/09/10 21:57 Tsujimura543
 * loginEchoo(), postEchoo()  xmlRPC.dll ڊ
 * 
 * 16    08/09/10 18:04 Tsujimura543
 * loginRakuten(), postRakuten()  xmlRPC.dll ڊ
 * 
 * 15    08/09/09 23:56 Tsujimura543
 * loginWebry(), postWebry()  xmlRPC.dll ڊ
 * 
 * 14    08/09/09 22:49 Tsujimura543
 * loginMixi()  postMixi()  xmlRPC.dll ڊ
 * 
 * 13    08/09/09 22:19 Tsujimura543
 * loginFC2NETWORK()  postFC2NETWORK()  xmlRPC.dll ڊ
 * 
 * 12    08/09/09 21:42 Tsujimura543
 * loginKinugasa()  postKinugasa()  xmlRPC.dll ڊ
 * 
 * 11    08/09/09 19:58 Tsujimura543
 * loginColors()  postColors()  xmlRPC.dll ڊ
 * 
 * 10    07/11/30 2:30 Tsujimura543
 * JugemAvO!AhRuOA܂ɂĂL̐pp~
 * 
 * 9     07/10/29 20:06 Tsujimura543
 * XML-RPC API oRł vO! ւ̓eɑΉ
 * 
 * 8     07/09/04 22:02 Tsujimura543
 * setVerbose() ̑2ǉɔύX
 * 
 * 7     07/02/24 2:05 Tsujimura543
 * JUGEM  hRuO  XML-RPC API oRł̓eɑΉ
 * 
 * 6     07/01/23 15:45 Tsujimura543
 * yVuOɃJeSw肵ēeł悤ɂ
 * 
 * 5     06/10/13 17:21 Tsujimura543
 * RgC
 * 
 * 4     06/10/13 17:20 Tsujimura543
 * EFuuOɓeꍇAuvÑp[^Ńev
 * [gIDw肵Ă̓eł悤ɂ
 * 
 * 3     06/10/02 20:06 Tsujimura543
 * ̑Aʒ` cocousagi.h ֏W
 * 
 * 2     06/10/02 20:01 Tsujimura543
 * COUSAGI_INFO ̒` cocousagi.h ֈړ
 * 
 * 1     06/10/02 20:00 Tsujimura543
 * \̂̐錾Avg^Cv錾Ȃǂ cocousagi.c 番A
 * cocousagi.h 쐬
 */

#ifndef __COCOUSAGI_H__
#define __COCOUSAGI_H__

#define YES     TRUE
#define NO      FALSE

/*
 *  blog
 */
#define BLOGKIND_NEWPOSTONLY    0xFE    /* metaWeblog.newPost ̂݃T|[g */
                                        /* Ă blog                   */
#define BLOGKIND_NOSUPPORT      0xFF    /* uvT|[g blog   */

typedef enum blogKind {
    typepad      = BLOGKIND_TYPEPAD,        // Typepad, Typepad France,
                                            //   TypePad Germany
    typepadJapan = BLOGKIND_TYPEPADJAPAN,   // Typepad Japan
    cocolog      = BLOGKIND_COCOLOG,        // RRO
    cocologFree  = BLOGKIND_COCOLOGFREE,    // RROt[
    blogzine     = BLOGKIND_BLOGZINE,       // uOl
    newsHandler  = BLOGKIND_NEWSHANDLER,    // News-Handler
    seesaa       = BLOGKIND_SEESAABLOG,     // Seesaa BLOG
    netLaputa    = BLOGKIND_NETLAPUTA,      // NetLaputa
    blogG        = BLOGKIND_269G,           // 269g
    livedoor     = BLOGKIND_LIVEDOOR,       // livedoor Blog
    lovelog      = BLOGKIND_LOVELOG,        // LOVELOG
    sonet        = BLOGKIND_SONET,          // So-net blog
    blogger      = BLOGKIND_BLOGGER,        // Blogger
    vox          = BLOGKIND_VOX,            // Vox
    hatena       = BLOGKIND_HATENADIARY,    // ͂Ăȃ_CA[ (Atom API)
    msnSpaces    = BLOGKIND_MSNSPACES,      // Windows Live Spaces (MSN Spaces)
    movableType  = BLOGKIND_MOVABLETYPE,    // Movable Type ܂ BOXERBLOG
    bloggerAPI   = BLOGKIND_BLOGGERAPI,     // blogger API T|[g blog
    metaWeblog   = BLOGKIND_METAWEBLOG,     // metaWeblog API T|[g blog
    mtAPI        = BLOGKIND_MTAPI,          // MovableType API
                                            //   (+ g metaWeblog API)
                                            //   T|[g blog
    atomAPI      = BLOGKIND_ATOMAPI,        // Atom API T|[g blog
    newPostOnly  = BLOGKIND_NEWPOSTONLY,    // metaWeblog.newPost ̂݃T|[g
                                            //   Ă blog
    jugemX       = BLOGKIND_JUGEM_X,        // JUGEM (XML-RPC API)
    exciteBlog   = BLOGKIND_EXCITEBLOG,     // exciteuO
    yaplogX      = BLOGKIND_YAPLOG_X,       // vO! (XML-RPC API)
    drecomX      = BLOGKIND_DRECOMBLOG_X,   // hRuO (XML-RPC API)
    webryX       = BLOGKIND_WEBRY_X,        // EFuuO (XML-RPC API)
    mixi         = BLOGKIND_MIXI,           // mixiL
    ameblo       = BLOGKIND_AMEBLO,         // A[ouO
    kinugasa     = BLOGKIND_KINUGASA,       // LkKTL
    echoo        = BLOGKIND_ECHOO,          // GRO (Echoo!L)
    fc2network   = BLOGKIND_FC2NETWORK,     // FC2NETWORKL
    fc2blog      = BLOGKIND_FC2BLOG,        // FC2BLOG
    rakuten      = BLOGKIND_RAKUTEN,        // yVuO (yVL)
    gooBlog      = BLOGKIND_GOOBLOG,        // goo Blog
    colors       = BLOGKIND_COLORS,         // COLORS_CA[
    openPne      = BLOGKIND_OPENPNE,        // OpenPNE
    unsupported  = BLOGKIND_NOSUPPORT       // uvT|[g blog
}   BLOGKIND;


void
rebuildOnLivedoor(
        const char *username,
        const char *password,
        const char *blogID
    );

int
loginExciteBlog( const char *username,      /* excite ID             */
                 const char *password,      /* pX[h            */
                 char       *cookie,        /* NbL[              */
                 char       *myBlogURL,     /* bloggbvy[WURL */
                 char       *eid       );   /* EID (blog ID )    */

int
loginEchoo( const char *username,   /* Echoo! ID ([AhX) */
            const char *password,   /* pX[h                 */
            char       *cookie,     /* NbL[                   */
            char       *myBlogURL );/* bloggbvy[WURL      */

int
loginRakuten( const char *username,     /* [U              */
              const char *password,     /* pX[h            */
              char       *cookie,       /* NbL[              */
              char       *myBlogURL );  /* bloggbvy[WURL */

int
postArticleOnExcite( const char *username,          /* [U     */
                     const char *password,          /* pX[h   */
                     char       *title,             /* eL薼 */
                     char       *body,              /* eL{ */
                     const char *categoryName,      /* JeS   */
                     int        forceWritingForPet );   /* M */

int
postArticleOnMixi( const char *username,        /* mixi ID ([AhX) */
                   const char *password,        /* pX[h               */
                   char       *title,           /* eL薼             */
                   char       *body,            /* eL{             */
                   int  forceWritingForPet );   /* M                 */

int
postArticleOnKinugasa(
        const char *username,           /* LkKT ID ([AhX) */
        const char *password,           /* pX[h                   */
        char       *title,              /* eL薼                 */
        char       *body,               /* eL{                 */
        int        forceWritingForPet );/* M                     */

int
postArticleOnFC2NETWORK( const char *username,      /* [AhX */
                         const char *password,      /* pX[h     */
                         char       *title,         /* eL薼   */
                         char       *body,          /* eL{   */
                         int  forceWritingForPet ); /* M       */

int
postArticleOnEchoo( const char *username,     /* Echoo! ID ([AhX) */
                    const char *password,     /* pX[h                 */
                    char       *title,        /* eL薼               */
                    char       *body,         /* eL{               */
                    const char *categoryName, /* JeS                 */
                    int        forceWritingForPet );/* M             */

int
postArticleOnRakuten( const char *username,       /* [U     */
                      const char *password,       /* pX[h   */
                      char       *title,          /* eL薼 */
                      char       *body,           /* eL{ */
                      const char *categoryName,   /* JeS   */
                      int        forceWritingForPet );/* M */

int
postArticleOnColors(
        const char *username,       /* [U([AhX) */
        const char *password,       /* pX[h               */
        char *title,                /* eL薼             */
        char *body,                 /* eL{             */
        int  forceWritingForPet );  /* 㗝e             */

int
postArticleOnOpenPNE(
        const char *username,           /* [U([AhX) */
        const char *password,           /* pX[h               */
        char       *title,              /* eL薼             */
        char       *body,               /* eL{             */
        int        forceWritingForPet   /* 㗝e             */
    );

char    *
editForMixi( char *text );

char    *
editForColors( char *text );

int
getCategoryIDwithName(
        int        *categoryID,     /* (I/O) JeSID             */
        char       *categoryName,   /* (O)   JeS             */
        const char *htmlSrcCode,    /* (I) Ǘhtml\[XR[h */
        int        minimumID,       /* (I) JeSIDŏl         */
        const char *beginSelect,    /* (I) <select>                 */
        const char *endSelect,      /* (I) </select>                */
        const char *beginOption,    /* (I) <option>                 */
        const char *endOption,      /* (I) </option>                */
        int        charSet          /* (I) R[h               */
    );

char    *
getCategoryIDstring( 
        char       *catID,          /* (O) JeSID ()      */
        const char *htmlSrcCode,    /* (I) Ǘhtml\[XR[h */
        const char *beginSelect,    /* (I) <select>                 */
        const char *endSelect,      /* (I) </select>                */
        const char *beginOption,    /* (I) <option>                 */
        const char *endOption,      /* (I) </option>                */
        int        charSet          /* (I) R[h               */
    );

char    *
getCategoryIDbyName(
        char       *catID,          /* (O) JeSID ()      */
        const char *categoryName,   /* (I) JeS               */
        const char *htmlSrcCode,    /* (I) Ǘhtml\[XR[h */
        const char *beginSelect,    /* (I) <select>                 */
        const char *endSelect,      /* (I) </select>                */
        const char *beginOption,    /* (I) <option>                 */
        const char *endOption,      /* (I) </option>                */
        int        charSet          /* (I) R[h               */
    );

/*
 *  blog 
 */
typedef struct blog_info    {
    char        *blogToolName;  // blogc[
    char        *blogTypeName;  // blogType ɑΉ镶
    BLOGINFOTBL blogInfoTbl;    // bloge[u
}   BLOG_INFO;


/*
 *   ݒ
 */
typedef struct cousagiInfo  {
    int         blogPetType;                       /* BlogPet           */
    char        cousagiName[MAX_NAMELEN + 1];      /* BlogPet ̖O        */
    char        settingFilename[MAX_PATH];         /* ݒt@C        */
    char        cousagiUserName[MAX_USERIDLEN + 1];/* T[o login    */
    char        cousagiPassword[MAX_PASSWDLEN + 1];/* T[o pX[h */
    char        blogUserName[MAX_USERIDLEN + 1];   /* blog login          */
    char        blogPassword[MAX_PASSWDLEN + 1];   /* blog pX[h       */
    char        userNickName[MAX_USERIDLEN + 1];   /* Lɏo郆[U  */
    char        blogID[MAX_BLOGIDLENGTH + 1];      /* blogID                */
    BLOGKIND    blogType;                          /* blog              */
    char        endpointURL[MAX_URLLENGTH + 1];    /* Gh|CgURL     */
    int         charSet;                           /* R[h        */
    int         promptLevel;       /* 0: SL[{[h,
                                      1: pX[ĥ݃L[{[h,
                                      2: Sݒt@C擾           */
#ifdef  USE_HAIKU
    int         useHaikuWords;                /* or̗v             */
#endif
    int         useHatenaLink;                /* L[[hN݂̗v */
    int         useProxy;                     /* proxyoRŒʐM邩ۂ  */
    int         allowFreePost;                /* eOۂ       */
    int         pause;                        /* I pause 邩ۂ  */
    int         useSimilarity;         /* BlogPet̂߂gۂ */
    int         useWritingForPet;                   /* M@\gۂ */
    int         forceWritingForPet;             /* Ms邩ۂ */
    char        amazonAssociateID[MAX_NAMELEN + 1]; /* AmazonA\VGCgID */
    char        amazonSubscriptionID[MAX_KEYLENGTH + 1]; /* AmazonJID  */
    char        categoryName[MAX_CATIDLENGTH + 1];  /* eΏۂ̃JeS */
    char        templateID[MAX_CATIDLENGTH + 1];    /* ev[gID       */
    char        editorPath[MAX_PATH];           /* MpGfB^̃pX   */
    FILE        *verboseFp;                                     /* p   */
}   COUSAGI_INFO;


#define EID_LENGTH      32  /* excite ID ő咷 */

#endif  /* __COCOUSAGI_H__ */
